/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.WorkItemClient;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.internal.model.ConfigurationItem;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedRadioGroup;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedRadioGroupUpdaterJob;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.AttributePart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.RequiredPropertyLabel;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormUtil;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.AbstractPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

public class RadioGroupAttributePart
extends AttributePart {
    private WorkItemWorkingCopy fWorkingCopy;
    private ResourceManager fResourceManager;
    private RequiredPropertyLabel fAttributeName;
    private DecoratedRadioGroup fRadioGroup;
    private DecoratedRadioGroupUpdaterJob fUpdater;
    private boolean fTeamAreaUnchanged = true;
    private IPresentationUpdater fPresentationUpdater = new AbstractPresentationUpdater(){

        @Override
        public void setVisible(boolean visible) {
            ArrayList<Control> changedControls = new ArrayList<Control>();
            if (RadioGroupAttributePart.this.fAttributeName != null && !RadioGroupAttributePart.this.fAttributeName.isDisposed()) {
                TeamFormUtil.setVisible(RadioGroupAttributePart.this.fAttributeName.getLayoutControl(), visible);
                changedControls.add(RadioGroupAttributePart.this.fAttributeName.getLayoutControl());
            }
            if (RadioGroupAttributePart.this.fRadioGroup != null && !RadioGroupAttributePart.this.fRadioGroup.getLayoutControl().isDisposed()) {
                TeamFormUtil.setVisible(RadioGroupAttributePart.this.fRadioGroup.getLayoutControl(), visible);
                changedControls.add(RadioGroupAttributePart.this.fRadioGroup.getLayoutControl());
            }
            Util.updateFormLayout(changedControls.toArray(new Control[changedControls.size()]));
        }

        @Override
        public void setRequired(boolean required) {
            if (RadioGroupAttributePart.this.fAttributeName != null && !RadioGroupAttributePart.this.fAttributeName.isDisposed()) {
                RadioGroupAttributePart.this.fAttributeName.setRequired(required);
            }
        }

        @Override
        public void dependencyChanged(List<String> dependencies) {
            if (RadioGroupAttributePart.this.fUpdater != null) {
                RadioGroupAttributePart.this.fUpdater.schedule();
            }
        }

        @Override
        public void setStatus(IStatus status) {
            if (status.getSeverity() != 4 && WorkItemAttributes.TYPE.equals((Object)RadioGroupAttributePart.this.getDescriptor().getAttributeId())) {
                RadioGroupAttributePart.this.updateWarningDecoration();
            } else {
                RadioGroupAttributePart.this.fRadioGroup.setStatus(status);
            }
        }

        @Override
        public void attributeChanged(WorkItemChangeEvent event) {
            RadioGroupAttributePart.this.readValue();
        }
    };

    public void createContent(ITeamFormLayout formLayout) {
        IEnumeration enumeration;
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        Composite parent = formLayout.getContainer();
        if (this.isLabelVisible()) {
            this.fAttributeName = new RequiredPropertyLabel(parent, toolkit, this.getBackgroundStyle());
            formLayout.add(this.fAttributeName.getLayoutControl(), "label");
        }
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), this.fAttributeName.getLayoutControl());
        this.fRadioGroup = new DecoratedRadioGroup(parent, 8);
        Util.addWidthHint(this.fRadioGroup.getLayoutControl());
        formLayout.add(this.fRadioGroup.getLayoutControl(), "content");
        this.fRadioGroup.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (RadioGroupAttributePart.this.fWorkingCopy != null) {
                    RadioGroupAttributePart.this.writeValue();
                }
            }
        });
        this.fRadioGroup.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ConfigurationItem) {
                    return ((ConfigurationItem)element).getDisplayName();
                }
                if (element instanceof String) {
                    return (String)element;
                }
                if (element instanceof Identifier) {
                    return ((Identifier)element).getStringIdentifier();
                }
                return "";
            }

            public Image getImage(Object element) {
                ImageDescriptor desc = ImagePool.EMPTY;
                if (element instanceof ConfigurationItem && ((ConfigurationItem)element).getIconURL() != null) {
                    desc = WorkItemUI.getImageDescriptor((URL)((ConfigurationItem)element).getIconURL());
                }
                return JazzResources.getImageWithDefault((ResourceManager)RadioGroupAttributePart.this.fResourceManager, (ImageDescriptor)desc);
            }
        });
        this.fUpdater = new DecoratedRadioGroupUpdaterJob(NLS.bind((String)Messages.EnumerationRadioGroupPart_ATTRIBUTE_UPDATE, (Object)this.getAttribute().getDisplayName(), (Object[])new Object[0]), this.fRadioGroup, this.getAttribute().getIdentifier()){

            public IStatus runInBackground(IProgressMonitor monitor) {
                RadioGroupAttributePart.this.fTeamAreaUnchanged = true;
                WorkItemWorkingCopyImpl workingCopy = (WorkItemWorkingCopyImpl)this.getWorkingCopy();
                if (workingCopy != null) {
                    try {
                        RadioGroupAttributePart.this.fTeamAreaUnchanged = this.teamAreaUnchanged(monitor);
                    }
                    catch (TeamRepositoryException x) {
                        WorkItemIDEUIPlugin.getDefault().log(Messages.EnumerationRadioGroupPart_EXCEPTION_DETERMINING_TEAM_AREA, x);
                    }
                }
                return super.runInBackground(monitor);
            }

            protected Object resolve(Object value, IProgressMonitor monitor) throws TeamRepositoryException {
                if (RadioGroupAttributePart.this.fWorkingCopy == null) {
                    return value;
                }
                WorkItemClient workItemClient = (WorkItemClient)RadioGroupAttributePart.this.fWorkingCopy.getTeamRepository().getClientLibrary(IWorkItemClient.class);
                if (RadioGroupAttributePart.this.getAttribute().getIdentifier().equals(IWorkItem.TYPE_PROPERTY)) {
                    return workItemClient.findWorkItemType(RadioGroupAttributePart.this.fWorkingCopy.getWorkItem().getProjectArea(), (String)value, monitor);
                }
                IEnumeration enumeration = workItemClient.resolveEnumeration((IAttributeHandle)RadioGroupAttributePart.this.getAttribute(), monitor);
                ILiteral item = enumeration.findEnumerationLiteral((Identifier)value);
                if (item == null) {
                    return value;
                }
                return item;
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                if (RadioGroupAttributePart.this.fRadioGroup.getRadioGroup().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                boolean reflow = this.fValueSet.length != RadioGroupAttributePart.this.fRadioGroup.getValueSet().length;
                IStatus status = super.runInUI(monitor);
                if (status.getSeverity() != 4 && status.getSeverity() != 8) {
                    RadioGroupAttributePart.this.updateWarningDecoration();
                }
                if (reflow) {
                    this.refreshLayout();
                }
                return status;
            }

            private void refreshLayout() {
                SharedScrolledComposite form = this.getScrolledComposite();
                if (form != null) {
                    form.reflow(true);
                    form.layout(true, true);
                }
            }

            private SharedScrolledComposite getScrolledComposite() {
                Composite parent = RadioGroupAttributePart.this.fRadioGroup.getLayoutControl().getParent();
                while (parent != null) {
                    if (parent instanceof SharedScrolledComposite) {
                        return (SharedScrolledComposite)parent;
                    }
                    parent = parent.getParent();
                }
                return null;
            }

            protected WorkItemWorkingCopy getWorkingCopy() {
                return RadioGroupAttributePart.this.fWorkingCopy;
            }

            private boolean teamAreaUnchanged(IProgressMonitor monitor) throws TeamRepositoryException {
                IProcessAreaHandle oldProcessArea;
                WorkItemWorkingCopyImpl workingCopy = (WorkItemWorkingCopyImpl)this.getWorkingCopy();
                if (workingCopy == null) {
                    return true;
                }
                if (workingCopy.getBaseState() == null) {
                    return false;
                }
                ITeamRepository teamRepository = workingCopy.getTeamRepository();
                IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                IProcessAreaHandle newProcessArea = workItemClient.findProcessArea((IWorkItemHandle)workingCopy.getWorkItem(), monitor);
                return newProcessArea == (oldProcessArea = workItemClient.findProcessArea((IWorkItemHandle)workingCopy.getBaseState(), monitor)) || newProcessArea != null && newProcessArea.sameItemId((IItemHandle)oldProcessArea);
            }
        };
        WorkItemClient workItemClient = (WorkItemClient)((ITeamRepository)this.getAttribute().getOrigin()).getClientLibrary(IWorkItemClient.class);
        if (!this.getAttribute().getIdentifier().equals(IWorkItem.TYPE_PROPERTY) && (enumeration = workItemClient.findCachedEnumeration(this.getAttribute())) != null) {
            this.fRadioGroup.setValueSet(enumeration.getEnumerationLiterals().toArray());
        }
    }

    public void setInput(Object input) {
        this.removeListeners();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)((Object)input)).isResolved() && this.getAttribute() != null) {
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)((Object)input);
            this.fWorkingCopy = workItemEditorInput.getWorkingCopy();
            this.addListeners();
            if (this.fAttributeName != null && !this.fAttributeName.isDisposed()) {
                this.fAttributeName.setText(NLS.bind((String)ATTRNAME_COLON, (Object)this.getLabel(), (Object[])new Object[0]));
                this.fAttributeName.layout();
                if (this.fRadioGroup.getValueSet() == null || this.fRadioGroup.getValueSet().length == 0) {
                    this.fUpdater.scheduleJob();
                }
                this.readValue();
            }
        } else {
            this.fWorkingCopy = null;
        }
    }

    public void setFocus() {
        if (this.fRadioGroup != null && !this.fRadioGroup.getRadioGroup().isDisposed()) {
            this.fRadioGroup.getRadioGroup().setFocus();
        }
    }

    public IAttribute getAttribute() {
        return this.getAttribute(this.fWorkingCopy);
    }

    public void dispose() {
        this.removeListeners();
        this.fWorkingCopy = null;
        super.dispose();
    }

    private void readValue() {
        Object value = null;
        if (this.fWorkingCopy != null && this.getAttribute() != null && this.fWorkingCopy.getWorkItem().hasAttribute(this.getAttribute())) {
            try {
                IWorkItemType v;
                WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
                ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
                value = workItem.getValue(this.getAttribute());
                ITeamRepository teamRepository = this.fWorkingCopy.getTeamRepository();
                IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                if (this.getAttribute().getIdentifier().equals(IWorkItem.TYPE_PROPERTY) && (v = workItemClient.findWorkItemType(this.fWorkingCopy.getWorkItem().getProjectArea(), (String)value, null)) != null) {
                    value = v;
                }
            }
            catch (TeamRepositoryException e) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.EnumerationRadioGroupPart_EXCEPTION_RETRIEVING_VALUE, e);
            }
        }
        this.fRadioGroup.setValue(value);
    }

    private void writeValue() {
        if (this.fWorkingCopy != null && this.fWorkingCopy.getWorkItem().hasAttribute(this.getAttribute())) {
            Object val = this.getIdentifier(this.fRadioGroup.getValue());
            if (DecoratedRadioGroupUpdaterJob.RETRIEVEENTRY.equals(val)) {
                this.readValue();
                return;
            }
            WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
            ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
            Object currentValue = this.getIdentifier(workItem.getValue(this.getAttribute()));
            if (val == null && currentValue != null || val != null && !val.equals(currentValue)) {
                this.fWorkingCopy.getWorkItem().setValue(this.getAttribute(), val);
            }
        }
    }

    private void addListeners() {
        PresentationHandlerManager mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class);
        if (mgr != null) {
            PresentationDescriptor desc = this.getDescriptor();
            if (this.getAttribute().getIdentifier().equals(IWorkItem.TYPE_PROPERTY)) {
                desc = Util.addDependencies(desc, IWorkItem.PROJECT_AREA_PROPERTY, IWorkItem.PROJECT_AREA_PROPERTY, IWorkItem.TARGET_PROPERTY);
            }
            mgr.addPresentationUpdater(this.fPresentationUpdater, desc);
        }
    }

    private void removeListeners() {
        PresentationHandlerManager mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class);
        if (mgr != null) {
            mgr.removePresentationUpdater(this.fPresentationUpdater);
        }
    }

    private void updateWarningDecoration() {
        if (!WorkItemAttributes.TYPE.equals((Object)this.getDescriptor().getAttributeId())) {
            return;
        }
        if (this.typeUnchanged() && this.fTeamAreaUnchanged) {
            this.fRadioGroup.setStatus(Status.OK_STATUS);
            return;
        }
        List<Object> elements = Arrays.asList(this.fRadioGroup.getValueSet());
        Object candidate = this.fRadioGroup.getValue();
        if (!elements.contains(DecoratedRadioGroupUpdaterJob.RETRIEVEENTRY) && !elements.contains(candidate) && this.getWarnMessage() != null) {
            this.fRadioGroup.setStatus((IStatus)new Status(2, "com.ibm.team.workitem.ide.ui", this.getWarnMessage()));
        } else {
            this.fRadioGroup.setStatus(Status.OK_STATUS);
        }
    }

    private boolean typeUnchanged() {
        String oldType;
        WorkItemWorkingCopyImpl workingCopy = (WorkItemWorkingCopyImpl)this.fWorkingCopy;
        if (workingCopy == null) {
            return true;
        }
        if (workingCopy.getBaseState() == null) {
            return false;
        }
        String newType = workingCopy.getWorkItem().getWorkItemType();
        return newType == (oldType = workingCopy.getBaseState().getWorkItemType()) || newType != null && newType.equals(oldType);
    }

    private String getWarnMessage() {
        WorkItemWorkingCopy workingCopy = this.fWorkingCopy;
        if (workingCopy != null && workingCopy.getWorkItem().isNewItem()) {
            return Messages.EnumerationRadioGroupPart_NO_PERMISSION_CREATE_TYPE;
        }
        if (!this.typeUnchanged()) {
            return Messages.EnumerationRadioGroupPart_NO_PERMISSION_CHANGE_TYPE;
        }
        return Messages.EnumerationRadioGroupPart_NO_PERMISSION_REASSIGNING;
    }

    private Object getIdentifier(Object value) {
        if (value instanceof ILiteral) {
            value = ((ILiteral)value).getIdentifier2();
        }
        if (value instanceof Identifier && IWorkItemType.class.isAssignableFrom(((Identifier)value).getType())) {
            value = ((Identifier)value).getStringIdentifier();
        }
        return value;
    }
}

