/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations;

import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.AttributePart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationPart;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresentationsManager {
    private static final String PRESENTATION_POINT = "com.ibm.team.workitem.ide.ui.editorPresentations";
    private static final String ELEMENT_NAME = "editorPresentation";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String ID_ATTRIBUTE = "id";
    private static final String DISPLAY_NAME_ATTRIBUTE = "displayName";
    private static final String NEEDS_ATTRIBUTE_ATTRIBUTE = "needsAttribute";
    private static final String SUPPORTED_ATTRIBUTE_TYPE = "attributeType";
    public static final String ENUMERATION_TYPES = "com.ibm.team.workitem.attributeType.enumerationTypes";
    private static Map<String, IConfigurationElement> fgPresentations;

    public static PresentationPart getAttributePresentation(IAttribute attribute, String name) {
        IConfigurationElement element;
        if (fgPresentations == null) {
            PresentationsManager.initializePresentations();
        }
        if ((element = fgPresentations.get(name)) == null) {
            WorkItemIDEUIPlugin.getDefault().log((IStatus)new Status(2, "com.ibm.team.workitem.ide.ui", NLS.bind((String)Messages.PresentationsManager_NO_CLASS_FOUND_FOR_KIND, (Object)name, (Object[])new Object[0])));
            return null;
        }
        List<IConfigurationElement> attributeTypes = Arrays.asList(element.getChildren(SUPPORTED_ATTRIBUTE_TYPE));
        if (!attributeTypes.isEmpty()) {
            IConfigurationElement typeElement = null;
            for (IConfigurationElement t : attributeTypes) {
                String type = t.getAttribute(ID_ATTRIBUTE);
                if (type == null) continue;
                if (type.equals(ENUMERATION_TYPES) && AttributeTypes.isEnumerationAttributeType((String)attribute.getAttributeType())) {
                    typeElement = t;
                    break;
                }
                if (!type.equals(attribute.getAttributeType())) continue;
                typeElement = t;
                break;
            }
            if (typeElement == null) {
                String attributeTypeNames = "";
                for (IConfigurationElement e : attributeTypes) {
                    attributeTypeNames = NLS.bind((String)Messages.PresentationsManager_ATTRIBUTETYPENAME_LIST, (Object)attributeTypeNames, (Object[])new Object[]{e.getAttribute(ID_ATTRIBUTE)});
                }
                if (attributeTypeNames.length() > 2) {
                    attributeTypeNames = attributeTypeNames.substring(2);
                }
                String message = NLS.bind((String)Messages.PresentationsManager_KIND_DOES_NOT_SUPPORT_ATTRIBUTE_TYPE, (Object)name, (Object[])new Object[]{attribute.getDisplayName(), attribute.getAttributeType(), attributeTypeNames});
                WorkItemIDEUIPlugin.getDefault().log((IStatus)new Status(2, "com.ibm.team.workitem.ide.ui", message));
                return null;
            }
        }
        return PresentationsManager.getPresentation(name);
    }

    public static PresentationPart getPresentation(String name) {
        IConfigurationElement element;
        if (fgPresentations == null) {
            PresentationsManager.initializePresentations();
        }
        if ((element = fgPresentations.get(name)) != null) {
            Object o;
            try {
                o = element.createExecutableExtension(CLASS_ATTRIBUTE);
            }
            catch (CoreException e) {
                WorkItemIDEUIPlugin.getDefault().log(NLS.bind((String)Messages.PresentationsManager_COULD_NOT_INITIALIZE_PRESENTATION, (Object)name, (Object[])new Object[]{element.getAttribute(CLASS_ATTRIBUTE)}), e);
                return null;
            }
            if (PresentationsManager.needsAttribute(name)) {
                if (!(o instanceof AttributePart)) {
                    WorkItemIDEUIPlugin.getDefault().log((IStatus)new Status(4, "com.ibm.team.workitem.ide.ui", NLS.bind((String)Messages.PresentationsManager_CONTRIBUTION_DOES_NOT_EXTEND_ATTRIBUTE_PART, (Object)name, (Object[])new Object[]{element.getAttribute(CLASS_ATTRIBUTE)})));
                    return null;
                }
            } else if (!(o instanceof PresentationPart)) {
                WorkItemIDEUIPlugin.getDefault().log((IStatus)new Status(4, "com.ibm.team.workitem.ide.ui", NLS.bind((String)Messages.PresentationsManager_CONTRIBUTION_DOES_NOT_EXTEND_PRESENTATION_PART, (Object)name, (Object[])new Object[]{element.getAttribute(CLASS_ATTRIBUTE)})));
                return null;
            }
            return (PresentationPart)((Object)o);
        }
        WorkItemIDEUIPlugin.getDefault().log((IStatus)new Status(2, "com.ibm.team.workitem.ide.ui", NLS.bind((String)Messages.PresentationsManager_NO_CLASS_FOUND_FOR_KIND, (Object)name, (Object[])new Object[0])));
        return null;
    }

    public static boolean needsAttribute(String name) {
        String needsAttribute;
        IConfigurationElement element;
        if (fgPresentations == null) {
            PresentationsManager.initializePresentations();
        }
        if ((element = fgPresentations.get(name)) != null && (needsAttribute = element.getAttribute(NEEDS_ATTRIBUTE_ATTRIBUTE)) != null) {
            return Boolean.parseBoolean(needsAttribute);
        }
        return false;
    }

    public static String getDisplayName(String id) {
        String displayName;
        IConfigurationElement element;
        if ("com.ibm.team.workitem.kind.special.doNotShow".equals(id)) {
            return Messages.PresentationsManager_DO_NOT_SHOW_KIND_DISPLAY_NAME;
        }
        if (fgPresentations == null) {
            PresentationsManager.initializePresentations();
        }
        if ((element = fgPresentations.get(id)) != null && (displayName = element.getAttribute(DISPLAY_NAME_ATTRIBUTE)) != null) {
            return displayName;
        }
        return id;
    }

    public static List<String> getAttributeTypes(String id) {
        if (fgPresentations == null) {
            PresentationsManager.initializePresentations();
        }
        ArrayList<String> attributeTypes = new ArrayList<String>();
        IConfigurationElement element = fgPresentations.get(id);
        if (element != null) {
            List<IConfigurationElement> types = Arrays.asList(element.getChildren(SUPPORTED_ATTRIBUTE_TYPE));
            for (IConfigurationElement type : types) {
                String aType = type.getAttribute(ID_ATTRIBUTE);
                if (aType == null) continue;
                attributeTypes.add(aType);
            }
        }
        return attributeTypes;
    }

    public static Set<String> getPossibleKinds(String attributeType) {
        if (fgPresentations == null) {
            PresentationsManager.initializePresentations();
        }
        HashSet<String> kinds = new HashSet<String>();
        for (IConfigurationElement element : fgPresentations.values()) {
            List<IConfigurationElement> types = Arrays.asList(element.getChildren(SUPPORTED_ATTRIBUTE_TYPE));
            for (IConfigurationElement type : types) {
                String kind;
                if (attributeType.equals(type.getAttribute(ID_ATTRIBUTE))) {
                    kind = element.getAttribute(ID_ATTRIBUTE);
                    if (kind == null) continue;
                    kinds.add(kind);
                    continue;
                }
                if (!ENUMERATION_TYPES.equals(type.getAttribute(ID_ATTRIBUTE)) || !AttributeTypes.isEnumerationAttributeType((String)attributeType) || (kind = element.getAttribute(ID_ATTRIBUTE)) == null) continue;
                kinds.add(kind);
            }
        }
        return kinds;
    }

    public static Set<String> getPresentations() {
        if (fgPresentations == null) {
            PresentationsManager.initializePresentations();
        }
        return fgPresentations.keySet();
    }

    private static void initializePresentations() {
        fgPresentations = new HashMap<String, IConfigurationElement>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(PRESENTATION_POINT);
        int i = 0;
        while (i < elements.length) {
            String name;
            IConfigurationElement element = elements[i];
            if (ELEMENT_NAME.equals(element.getName()) && (name = element.getAttribute(ID_ATTRIBUTE)) != null) {
                fgPresentations.put(name, element);
            }
            ++i;
        }
    }
}

