/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.WorkItemClient;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.internal.model.ConfigurationItem;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedList;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedListUpdaterJob;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.AttributePart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.RequiredPropertyLabel;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormUtil;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.AbstractPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

public class ListAttributePart
extends AttributePart {
    public static final String ENUMERATION = "enumeration";
    protected WorkItemWorkingCopy fWorkingCopy;
    private DecoratedList fList;
    protected DecoratedListUpdaterJob fUpdater;
    protected RequiredPropertyLabel fAttributeName;
    protected boolean fTeamAreaUnchanged = true;
    protected ResourceManager fResourceManager;
    protected String fEnumTypeId;
    protected Text fText;
    private IPresentationUpdater fPresentationUpdater = new AbstractPresentationUpdater(){

        @Override
        public void setVisible(boolean visible) {
            ArrayList<Control> changedControls = new ArrayList<Control>();
            if (ListAttributePart.this.fAttributeName != null && !ListAttributePart.this.fAttributeName.isDisposed()) {
                TeamFormUtil.setVisible(ListAttributePart.this.fAttributeName.getLayoutControl(), visible);
                changedControls.add(ListAttributePart.this.fAttributeName.getLayoutControl());
            }
            if (ListAttributePart.this.getLayoutControl() != null && !ListAttributePart.this.getLayoutControl().isDisposed()) {
                TeamFormUtil.setVisible(ListAttributePart.this.getLayoutControl(), visible);
                changedControls.add(ListAttributePart.this.getLayoutControl());
            }
            Util.updateFormLayout(changedControls.toArray(new Control[changedControls.size()]));
        }

        @Override
        public void setRequired(boolean required) {
            if (ListAttributePart.this.fAttributeName != null && !ListAttributePart.this.fAttributeName.isDisposed()) {
                ListAttributePart.this.fAttributeName.setRequired(required);
            }
        }

        @Override
        public void dependencyChanged(List<String> dependencies) {
            if (ListAttributePart.this.fUpdater != null) {
                ListAttributePart.this.fUpdater.schedule();
            }
        }

        @Override
        public void setStatus(IStatus status) {
            if (status.getSeverity() != 4 && WorkItemAttributes.TYPE.equals((Object)ListAttributePart.this.getDescriptor().getAttributeId())) {
                ListAttributePart.this.updateWarningDecoration();
            } else if (ListAttributePart.this.getDecoratedList() != null) {
                ListAttributePart.this.getDecoratedList().setStatus(status);
            }
        }

        @Override
        public void attributeChanged(WorkItemChangeEvent event) {
            ListAttributePart.this.readValue();
        }
    };

    public void createContent(ITeamFormLayout formLayout) {
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        Composite parent = formLayout.getContainer();
        if (this.isLabelVisible()) {
            this.fAttributeName = new RequiredPropertyLabel(parent, toolkit, this.getBackgroundStyle());
            formLayout.add(this.fAttributeName.getLayoutControl(), "label");
        }
        if (!this.hasValidEnumeration()) {
            this.fText = toolkit.createReadOnlyText(parent, "", 0, this.getBackgroundStyle());
            TeamFormLayouts.setLayoutData((Control)this.fText, (ITeamFormData)ITeamFormData.SINGLE_LINE_READONLY_TEXT);
            Util.addWidthHint((Control)this.fText);
            formLayout.add((Control)this.fText, "content");
        } else {
            WorkItemClient workItemClient;
            IEnumeration enumeration;
            this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
            this.fList = new DecoratedList(parent, 2562, 1, this.fResourceManager);
            TeamFormLayouts.setLayoutData((Control)this.fList.getLayoutControl(), (ITeamFormData)ITeamFormData.FIXED_BORDERED_LIST);
            formLayout.add(this.fList.getLayoutControl(), "content");
            toolkit.adapt(this.fList.getDecoratedControl(), true, false, this.getBackgroundStyle());
            this.fList.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (ListAttributePart.this.fWorkingCopy != null) {
                        ListAttributePart.this.writeValue();
                    }
                }
            });
            this.fList.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof ConfigurationItem) {
                        return ((ConfigurationItem)element).getDisplayName();
                    }
                    if (element instanceof String) {
                        return (String)element;
                    }
                    if (element instanceof Identifier) {
                        return ((Identifier)element).getStringIdentifier();
                    }
                    return "";
                }

                public Image getImage(Object element) {
                    ImageDescriptor desc = ImagePool.EMPTY;
                    if (element instanceof ConfigurationItem && ((ConfigurationItem)element).getIconURL() != null) {
                        desc = WorkItemUI.getImageDescriptor((URL)((ConfigurationItem)element).getIconURL());
                    }
                    return JazzResources.getImageWithDefault((ResourceManager)ListAttributePart.this.fResourceManager, (ImageDescriptor)desc);
                }
            });
            this.fUpdater = new DecoratedListUpdaterJob(NLS.bind((String)Messages.ListAttributePart_ATTRIBUTE_UPDATE, (Object)this.getAttribute().getDisplayName(), (Object[])new Object[0]), this.fList, this.getAttribute().getIdentifier(), this.fEnumTypeId, this.getValueSetProviderId()){

                public IStatus runInBackground(IProgressMonitor monitor) {
                    ListAttributePart.this.fTeamAreaUnchanged = true;
                    WorkItemWorkingCopyImpl workingCopy = (WorkItemWorkingCopyImpl)this.getWorkingCopy();
                    if (workingCopy != null) {
                        try {
                            ListAttributePart.this.fTeamAreaUnchanged = this.teamAreaUnchanged(monitor);
                        }
                        catch (TeamRepositoryException x) {
                            WorkItemIDEUIPlugin.getDefault().log(Messages.ListAttributePart_EXCEPTION_DETERMINING_TEAM_AREA, x);
                        }
                    }
                    return super.runInBackground(monitor);
                }

                private boolean teamAreaUnchanged(IProgressMonitor monitor) throws TeamRepositoryException {
                    IProcessAreaHandle oldProcessArea;
                    WorkItemWorkingCopyImpl workingCopy = (WorkItemWorkingCopyImpl)this.getWorkingCopy();
                    if (workingCopy == null) {
                        return true;
                    }
                    if (workingCopy.getBaseState() == null) {
                        return false;
                    }
                    ITeamRepository teamRepository = workingCopy.getTeamRepository();
                    IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                    IProcessAreaHandle newProcessArea = workItemClient.findProcessArea((IWorkItemHandle)workingCopy.getWorkItem(), monitor);
                    return newProcessArea == (oldProcessArea = workItemClient.findProcessArea((IWorkItemHandle)workingCopy.getBaseState(), monitor)) || newProcessArea != null && newProcessArea.sameItemId((IItemHandle)oldProcessArea);
                }

                protected Object resolve(Object value, IProgressMonitor monitor) throws TeamRepositoryException {
                    if (ListAttributePart.this.fWorkingCopy == null) {
                        return value;
                    }
                    ITeamRepository teamRepository = ListAttributePart.this.fWorkingCopy.getTeamRepository();
                    IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                    if (ListAttributePart.this.getAttribute().getIdentifier().equals(IWorkItem.TYPE_PROPERTY)) {
                        return workItemClient.findWorkItemType(ListAttributePart.this.fWorkingCopy.getWorkItem().getProjectArea(), (String)value, monitor);
                    }
                    return ListAttributePart.this.fWorkingCopy.getWorkItem().getValue(ListAttributePart.this.getAttribute());
                }

                public IStatus runInUI(IProgressMonitor monitor) {
                    if (ListAttributePart.this.fList.getDecoratedControl().isDisposed()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (this.fValueSet.length == 0) {
                        ListAttributePart.this.fList.getDecoratedControl().setEnabled(false);
                    } else {
                        ListAttributePart.this.fList.getDecoratedControl().setEnabled(true);
                    }
                    boolean reflow = ListAttributePart.this.fList.getValueSet().length != this.fValueSet.length;
                    IStatus status = super.runInUI(monitor);
                    if (status.getSeverity() != 4 && status.getSeverity() != 8) {
                        ListAttributePart.this.updateWarningDecoration();
                    }
                    if (reflow) {
                        this.refreshLayout();
                    }
                    return status;
                }

                protected WorkItemWorkingCopy getWorkingCopy() {
                    return ListAttributePart.this.fWorkingCopy;
                }

                private void refreshLayout() {
                    SharedScrolledComposite form = this.getScrolledComposite();
                    if (form != null) {
                        form.reflow(true);
                        form.layout(true, true);
                    }
                }

                private SharedScrolledComposite getScrolledComposite() {
                    Composite parent = ListAttributePart.this.fList.getLayoutControl().getParent();
                    while (parent != null) {
                        if (parent instanceof SharedScrolledComposite) {
                            return (SharedScrolledComposite)parent;
                        }
                        parent = parent.getParent();
                    }
                    return null;
                }
            };
            if (!this.fEnumTypeId.equals(IWorkItem.TYPE_PROPERTY) && (enumeration = (workItemClient = (WorkItemClient)((ITeamRepository)this.getAttribute().getOrigin()).getClientLibrary(IWorkItemClient.class)).findCachedEnumeration(this.getAttribute().getProjectArea(), this.fEnumTypeId)) != null) {
                this.fList.setValueSet(enumeration.getEnumerationLiterals().toArray());
                if (this.fList.getValueSet().length > 10) {
                    this.fList.setVisibleLines(7);
                }
            }
        }
    }

    protected boolean hasValidEnumeration() {
        IEnumeration enumeration;
        WorkItemClient workItemClient = (WorkItemClient)((ITeamRepository)this.getAttribute().getOrigin()).getClientLibrary(IWorkItemClient.class);
        return this.fEnumTypeId != null && (enumeration = workItemClient.findCachedEnumeration(this.getAttribute().getProjectArea(), this.fEnumTypeId)) != null && enumeration.getEnumerationLiterals().size() > 0;
    }

    protected Object getIdentifier(Object value) {
        if (value instanceof ILiteral) {
            value = ((ILiteral)value).getIdentifier2().getStringIdentifier();
        }
        if (value instanceof Identifier && IWorkItemType.class.isAssignableFrom(((Identifier)value).getType())) {
            value = ((Identifier)value).getStringIdentifier();
        }
        return value;
    }

    protected Object[] getSelectedValues() {
        return this.fList.getValue();
    }

    protected void setSelectedValue(Object value) {
        if (this.fList != null) {
            this.fList.setValue(value);
        } else if (this.fText != null) {
            this.fText.setText(this.getText(value));
        }
    }

    protected String getText(Object element) {
        if (element instanceof String) {
            return (String)element;
        }
        return "";
    }

    protected Object[] getValueSet() {
        return this.fList.getValueSet();
    }

    protected Control getDecoratedControl() {
        return this.fList == null ? (this.fText == null ? null : this.fText) : this.fList.getDecoratedControl();
    }

    protected Control getLayoutControl() {
        return this.fList == null ? (this.fText == null ? null : this.fText) : this.fList.getLayoutControl();
    }

    protected DecoratedList getDecoratedList() {
        return this.fList;
    }

    protected void writeValue() {
        if (this.fWorkingCopy != null && this.fWorkingCopy.getWorkItem().hasAttribute(this.getAttribute())) {
            Object val = this.getIdentifier(this.getSelectedValues());
            WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
            ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
            Object currentValue = this.getIdentifier(workItem.getValue(this.getAttribute()));
            String[] currentValues = null;
            if (currentValue != null && currentValue instanceof String) {
                currentValues = DecoratedList.splitValues((String)((String)currentValue));
            }
            if (val == null && currentValues != null || val != null && !val.equals(currentValues)) {
                Object joinedVal = val;
                if (val instanceof Object[]) {
                    joinedVal = DecoratedList.joinValues((Object[])((Object[])val));
                }
                this.fWorkingCopy.getWorkItem().setValue(this.getAttribute(), joinedVal);
            }
        }
    }

    protected void readValue() {
        Object value = null;
        if (this.fWorkingCopy != null && this.getAttribute() != null && this.fWorkingCopy.getWorkItem().hasAttribute(this.getAttribute())) {
            try {
                IWorkItemType v;
                WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
                ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
                value = workItem.getValue(this.getAttribute());
                ITeamRepository teamRepository = this.fWorkingCopy.getTeamRepository();
                IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                if (this.getAttribute().getIdentifier().equals(IWorkItem.TYPE_PROPERTY) && (v = workItemClient.findWorkItemType(this.fWorkingCopy.getWorkItem().getProjectArea(), (String)value, null)) != null) {
                    value = v;
                }
            }
            catch (TeamRepositoryException e) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.ListAttributePart_EXCEPTION_RETRIEVING_ATTRIBUTEVALUE, e);
            }
        }
        this.setSelectedValue(value);
        this.updateWarningDecoration();
    }

    public void setFocus() {
        if (this.getDecoratedControl() != null && !this.getDecoratedControl().isDisposed()) {
            this.getDecoratedControl().setFocus();
        }
    }

    public void setInput(Object input) {
        this.removeListeners();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)((Object)input)).isResolved() && this.getAttribute() != null) {
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)((Object)input);
            this.fWorkingCopy = workItemEditorInput.getWorkingCopy();
            this.addListeners();
            if (this.fAttributeName != null && !this.fAttributeName.isDisposed()) {
                this.fAttributeName.setText(NLS.bind((String)ATTRNAME_COLON, (Object)this.getLabel(), (Object[])new Object[0]));
                this.fAttributeName.layout();
            }
            if (this.fUpdater != null && (this.getValueSet() == null || this.getValueSet().length == 0)) {
                this.fUpdater.scheduleJob();
            }
            if (this.getDecoratedControl() != null && !this.getDecoratedControl().isDisposed()) {
                this.readValue();
            }
        } else {
            this.fWorkingCopy = null;
        }
    }

    protected void addListeners() {
        PresentationHandlerManager mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class);
        if (mgr != null) {
            PresentationDescriptor desc = this.getDescriptor();
            if (this.getAttribute().getIdentifier().equals(IWorkItem.TYPE_PROPERTY)) {
                desc = Util.addDependencies(desc, IWorkItem.PROJECT_AREA_PROPERTY, IWorkItem.PROJECT_AREA_PROPERTY, IWorkItem.TARGET_PROPERTY);
            }
            mgr.addPresentationUpdater(this.fPresentationUpdater, desc);
        }
    }

    public void dispose() {
        this.removeListeners();
        this.fWorkingCopy = null;
        super.dispose();
    }

    protected void removeListeners() {
        PresentationHandlerManager mgr;
        if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            mgr.removePresentationUpdater(this.fPresentationUpdater);
        }
    }

    public IAttribute getAttribute() {
        return this.getAttribute(this.fWorkingCopy);
    }

    protected void updateWarningDecoration() {
        if (!WorkItemAttributes.TYPE.equals((Object)this.getDescriptor().getAttributeId())) {
            return;
        }
        if (this.typeUnchanged() && this.fTeamAreaUnchanged) {
            this.getDecoratedList().setStatus(Status.OK_STATUS);
            return;
        }
        List<Object> elements = Arrays.asList(this.getDecoratedList().getValueSet());
        Object[] candidate = this.getDecoratedList().getValue();
        if (!this.getDecoratedList().isRetrieving() && !elements.contains(candidate) && this.getWarnMessage() != null) {
            this.getDecoratedList().setStatus((IStatus)new Status(2, "com.ibm.team.workitem.ide.ui", this.getWarnMessage()));
        } else {
            this.getDecoratedList().setStatus(Status.OK_STATUS);
        }
    }

    protected boolean typeUnchanged() {
        String oldType;
        WorkItemWorkingCopyImpl workingCopy = (WorkItemWorkingCopyImpl)this.fWorkingCopy;
        if (workingCopy == null) {
            return true;
        }
        if (workingCopy.getBaseState() == null) {
            return false;
        }
        String newType = workingCopy.getWorkItem().getWorkItemType();
        return newType == (oldType = workingCopy.getBaseState().getWorkItemType()) || newType != null && newType.equals(oldType);
    }

    protected String getWarnMessage() {
        WorkItemWorkingCopy workingCopy = this.fWorkingCopy;
        if (workingCopy != null && workingCopy.getWorkItem().isNewItem()) {
            return Messages.ListAttributePart_NO_PERMISSIONS_CREATE;
        }
        if (!this.typeUnchanged()) {
            return Messages.ListAttributePart_NO_PERMISSIONS_CHANGE;
        }
        return Messages.ListAttributePart_NO_PERMISSION_REASSIGN;
    }

    public void initialize(IAttribute attribute, PresentationDescriptor descriptor) {
        super.initialize(attribute, descriptor);
        this.initValueSetConstraint(descriptor);
    }

    public void initialize(PresentationDescriptor descriptor) {
        super.initialize(descriptor);
        this.initValueSetConstraint(descriptor);
    }

    protected void initValueSetConstraint(PresentationDescriptor descriptor) {
        String enumeration = (String)descriptor.getProperties().get(ENUMERATION);
        if (enumeration != null && enumeration.length() > 0) {
            this.fEnumTypeId = enumeration;
        }
    }
}

