/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations;

import com.ibm.icu.text.Collator;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.jface.StandardControlLabelProvider;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.internal.common.ProcessPackage;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.util.IterationsHelper;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedControl;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedFormsText;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.part.DecoratedHistoryCombo;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.AttributePart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.RequiredPropertyLabel;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormUtil;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.AbstractPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.internal.viewer.ItemComparer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class IterationAttributePart
extends AttributePart {
    private static final boolean IS_WIN32 = "win32".equals(SWT.getPlatform());
    private WorkItemWorkingCopy fWorkingCopy;
    private DecoratedHistoryCombo fTargetCombo;
    private RequiredPropertyLabel fTarget;
    private Composite fContainer;
    private StandardControlLabelProvider fLabeledHyperlink;
    private DecoratedFormsText fReadOnlyText;
    private IPresentationUpdater fPresentationUpdater = new AbstractPresentationUpdater(){

        @Override
        public void setVisible(boolean visible) {
            ArrayList<Object> changedControls = new ArrayList<Object>();
            if (IterationAttributePart.this.fContainer != null && !IterationAttributePart.this.fContainer.isDisposed()) {
                TeamFormUtil.setVisible((Control)IterationAttributePart.this.fContainer, visible);
                changedControls.add(IterationAttributePart.this.fContainer);
            }
            if (IterationAttributePart.this.fTargetCombo != null && !IterationAttributePart.this.fTargetCombo.getLayoutControl().isDisposed()) {
                TeamFormUtil.setVisible(IterationAttributePart.this.fTargetCombo.getLayoutControl(), visible);
                changedControls.add(IterationAttributePart.this.fTargetCombo.getLayoutControl());
            }
            if (IterationAttributePart.this.fReadOnlyText != null && !IterationAttributePart.this.fReadOnlyText.getLayoutControl().isDisposed()) {
                TeamFormUtil.setVisible(IterationAttributePart.this.fReadOnlyText.getLayoutControl(), visible);
                changedControls.add(IterationAttributePart.this.fReadOnlyText.getLayoutControl());
            }
            Util.updateFormLayout(changedControls.toArray(new Control[changedControls.size()]));
        }

        @Override
        public void setRequired(boolean required) {
            if (IterationAttributePart.this.fTarget != null && !IterationAttributePart.this.fTarget.isDisposed()) {
                IterationAttributePart.this.fTarget.setRequired(required);
            }
        }

        @Override
        public void dependencyChanged(List<String> dependencies) {
            if (IterationAttributePart.this.fTargetCombo != null && !IterationAttributePart.this.fTargetCombo.getLayoutControl().isDisposed()) {
                IterationAttributePart.this.fTargetCombo.scheduleJob();
            }
        }

        @Override
        public void attributeChanged(WorkItemChangeEvent event) {
            IterationAttributePart.this.readTarget();
        }

        @Override
        public void setStatus(IStatus status) {
            if (IterationAttributePart.this.fTargetCombo != null && !IterationAttributePart.this.fTargetCombo.getLayoutControl().isDisposed()) {
                IterationAttributePart.this.fTargetCombo.setStatus(status);
            }
        }
    };

    public void createContent(ITeamFormLayout formLayout) {
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        Composite parent = formLayout.getContainer();
        if (this.isLabelVisible()) {
            this.fContainer = toolkit.createComposite(parent, 0, this.getBackgroundStyle());
            GridLayout gl = new GridLayout();
            gl.numColumns = 2;
            gl.horizontalSpacing = 0;
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            this.fContainer.setLayout((Layout)gl);
            this.fLabeledHyperlink = toolkit.createDecoratedHyperlink((TeamFormPart)this, this.fContainer, new ContextProvider(null){

                public URIReference getContext() {
                    if (IterationAttributePart.this.fWorkingCopy == null) {
                        return null;
                    }
                    String id = IterationAttributePart.this.fWorkingCopy.getWorkItem().getId() > 0 ? String.valueOf(IterationAttributePart.this.fWorkingCopy.getWorkItem().getId()) : "";
                    URIReference ref = new URIReference(Messages.IterationAttributePart_WORK_ITEM, NLS.bind((String)Messages.IterationAttributePart_WORK_ITEM_ID, (Object)id, (Object[])new Object[0]), Location.itemLocation((IItemHandle)IterationAttributePart.this.fWorkingCopy.getWorkItem(), (String)IterationAttributePart.this.fWorkingCopy.getTeamRepository().getRepositoryURI()).toAbsoluteUri());
                    return ref;
                }
            }, this.getBackgroundStyle());
            this.fLabeledHyperlink.setTextAware(false);
            this.fLabeledHyperlink.setForegroundAware(false);
            Hyperlink link = (Hyperlink)this.fLabeledHyperlink.getControl();
            formLayout.add((Control)this.fContainer, "label", ITeamFormData.HYPERLINK);
            link.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            this.fTarget = new RequiredPropertyLabel(this.fContainer, toolkit, this.getBackgroundStyle());
            this.fTarget.setText(NLS.bind((String)ATTRNAME_COLON, (Object)"", (Object[])new Object[0]));
            GridData gd = new GridData(4, 0x1000000, true, false, 1, 1);
            this.fTarget.getLayoutControl().setLayoutData((Object)gd);
        }
        TargetLabelProvider labelProvider = new TargetLabelProvider();
        if (this.isReadOnly()) {
            this.fReadOnlyText = new DecoratedFormsText(parent, this.getSite(), 8, 4, this.getBackgroundStyle());
            Util.addWidthHint(this.fReadOnlyText.getLayoutControl());
            formLayout.add(this.fReadOnlyText.getLayoutControl(), "content");
            this.fReadOnlyText.setLabelProvider((ILabelProvider)labelProvider);
        } else {
            this.fTargetCombo = new DecoratedHistoryCombo(parent, 8, 0, this.getAttribute(), this.getValueSetProviderId()){

                protected Object getDefaultValue(IProgressMonitor monitor) {
                    if (IterationAttributePart.this.fWorkingCopy != null) {
                        IDevelopmentLine devLine;
                        IAuditableClient auditableClient;
                        block7: {
                            auditableClient = (IAuditableClient)IterationAttributePart.this.fWorkingCopy.getTeamRepository().getClientLibrary(IAuditableClient.class);
                            devLine = auditableClient.findDefaultDevelopmentLine(IterationAttributePart.this.fWorkingCopy.getWorkItem().getProjectArea(), monitor);
                            if (devLine != null) break block7;
                            IProjectArea area = (IProjectArea)auditableClient.resolveAuditable((IAuditableHandle)IterationAttributePart.this.fWorkingCopy.getWorkItem().getProjectArea(), ItemProfile.PROJECT_AREA_DEFAULT.createExtension(new String[]{ProcessPackage.eINSTANCE.getProjectArea_InternalProjectDevelopmentLine().getName()}), monitor);
                            IDevelopmentLineHandle devLineHandle = area.getProjectDevelopmentLine();
                            if (devLineHandle != null) {
                                devLine = (IDevelopmentLine)auditableClient.resolveAuditable((IAuditableHandle)devLineHandle, ItemProfile.DEVELOPMENT_LINE_DEFAULT, monitor);
                            }
                            if (devLine != null) break block7;
                            return null;
                        }
                        try {
                            IIterationHandle currentHandle = IterationsHelper.findCurrentMilestone((IAuditableCommon)auditableClient, (IDevelopmentLineHandle)devLine, (IProgressMonitor)monitor);
                            Object[] objectArray = IterationAttributePart.this.fTargetCombo.getFullValueSet();
                            int n = objectArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object o = objectArray[n2];
                                if (o instanceof IIteration && ((IIteration)o).sameItemId((IItemHandle)currentHandle)) {
                                    return o;
                                }
                                ++n2;
                            }
                        }
                        catch (TeamRepositoryException teamRepositoryException) {}
                    }
                    return null;
                }
            };
            toolkit.adapt((DecoratedControl)this.fTargetCombo, true, false, this.getBackgroundStyle());
            if (this.getAttribute().getIdentifier().equals(IWorkItem.TARGET_PROPERTY)) {
                int comboSize = WorkItemIDEUIPlugin.getDefault().getPreferenceStore().getInt("com.ibm.team.workitem.ide.ui.IntervalSelectionHistory.size");
                comboSize = Math.min(comboSize, 30);
                this.fTargetCombo.getCombo().setVisibleItemCount(comboSize);
            }
            Util.addWidthHint(this.fTargetCombo.getLayoutControl());
            formLayout.add(this.fTargetCombo.getLayoutControl(), "content");
            this.fTargetCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (IterationAttributePart.this.fWorkingCopy != null) {
                        IterationAttributePart.this.writeTarget();
                    }
                }
            });
            new TooltipSupport((Control)this.fTargetCombo.getCombo(), true, false){

                protected Object mapElement(int x, int y) {
                    return IterationAttributePart.this.fTargetCombo.getValue();
                }
            };
            this.fTargetCombo.setElementComparer((IElementComparer)new ItemComparer());
            this.fTargetCombo.setSorter(new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (o1 instanceof String && o2 instanceof String) {
                        return Collator.getInstance().compare((String)o1, (String)o2);
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    if (!(o1 instanceof IIteration)) {
                        return 1;
                    }
                    if (!(o2 instanceof IIteration)) {
                        return -1;
                    }
                    if (IterationAttributePart.this.fTargetCombo.getFullValueSet() == null) {
                        return -1;
                    }
                    List<Object> allValues = Arrays.asList(IterationAttributePart.this.fTargetCombo.getFullValueSet());
                    return allValues.indexOf(o1) - allValues.indexOf(o2);
                }
            });
            this.fTargetCombo.setLabelProvider((ILabelProvider)labelProvider);
        }
    }

    private void writeTarget() {
        Object value = this.fTargetCombo.getValue();
        if (value != null && ("DecoratedHistoryCombo.dialog_canceled".equals(value) || DecoratedHistoryCombo.RETRIEVEENTRY.equals(value) || !(value instanceof IIteration))) {
            this.readTarget();
            return;
        }
        IIteration target = (IIteration)value;
        WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
        ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
        if (!this.equalItems((IItemHandle)target, (IItemHandle)((IIteration)workItem.getValue(this.getAttribute())))) {
            this.fWorkingCopy.getWorkItem().setValue(this.getAttribute(), (Object)target);
        }
    }

    private void readTarget() {
        if (this.fWorkingCopy != null && this.getAttribute() != null && this.fWorkingCopy.getWorkItem().hasAttribute(this.getAttribute())) {
            WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
            ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
            Object value = workItem.getValue(this.getAttribute());
            if (this.fTargetCombo != null && !this.fTargetCombo.getLayoutControl().isDisposed()) {
                this.fTargetCombo.setValue(value);
            }
            if (this.fReadOnlyText != null && !this.fReadOnlyText.getLayoutControl().isDisposed()) {
                this.fReadOnlyText.setValue(value);
            }
            if (this.fLabeledHyperlink != null && !this.fLabeledHyperlink.getControl().isDisposed()) {
                this.fLabeledHyperlink.setElement(value);
            }
        }
    }

    private boolean equalItems(IItemHandle first, IItemHandle second) {
        if (first == second) {
            return true;
        }
        return first != null && first.sameItemId(second);
    }

    public void setFocus() {
        if (this.fTargetCombo != null && !this.fTargetCombo.getCombo().isDisposed()) {
            this.fTargetCombo.getCombo().setFocus();
        }
        if (this.fReadOnlyText != null && !this.fReadOnlyText.getLayoutControl().isDisposed()) {
            this.fReadOnlyText.getText().setFocus();
        }
    }

    public void setInput(Object input) {
        this.removeListeners();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)((Object)input)).isResolved() && this.getAttribute() != null) {
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)((Object)input);
            this.fWorkingCopy = workItemEditorInput.getWorkingCopy();
            this.addListeners();
            if (this.fTargetCombo != null && !this.fTargetCombo.getLayoutControl().isDisposed()) {
                this.fTargetCombo.setWorkItem(this.fWorkingCopy.getWorkItem());
                this.fTargetCombo.scheduleJob();
            }
            if (this.fLabeledHyperlink != null && !this.fLabeledHyperlink.getControl().isDisposed()) {
                ((Hyperlink)this.fLabeledHyperlink.getControl()).setText(this.getLabel());
                this.fContainer.getParent().layout(new Control[]{this.fLabeledHyperlink.getControl()});
            }
            this.readTarget();
        } else {
            this.fWorkingCopy = null;
        }
    }

    private void addListeners() {
        PresentationHandlerManager mgr;
        if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            mgr.addPresentationUpdater(this.fPresentationUpdater, this.getDescriptor());
        }
    }

    private void removeListeners() {
        PresentationHandlerManager mgr;
        if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            mgr.removePresentationUpdater(this.fPresentationUpdater);
        }
    }

    public void dispose() {
        this.removeListeners();
        this.fWorkingCopy = null;
        super.dispose();
    }

    public IAttribute getAttribute() {
        return this.getAttribute(this.fWorkingCopy);
    }

    private final class TargetLabelProvider
    extends LabelProvider {
        private TargetLabelProvider() {
        }

        public String getText(Object element) {
            if (element == null) {
                return IWorkItem.UNASSIGNED_TARGET_NAME;
            }
            if (element instanceof String) {
                return (String)element;
            }
            if (element instanceof IIteration) {
                IIteration interval = (IIteration)element;
                String name = interval.getLabel();
                Object o = null;
                if (IterationAttributePart.this.fTargetCombo != null && (o = IterationAttributePart.this.fTargetCombo.getCachedDefaultValue()) != null && o instanceof IIteration && interval.sameItemId((IItemHandle)((IIteration)o))) {
                    name = IS_WIN32 ? "-> " + name : "\u25b8 " + name;
                }
                return name;
            }
            return IWorkItem.UNASSIGNED_TARGET_NAME;
        }
    }
}

