/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.ViewerPane;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.ViewerPart;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.ui.dnd.ViewerDragSupport;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.ui.utils.ItemHandleComparer;
import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.internal.presentations.AbstractPresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.EditorPresentation;
import com.ibm.team.workitem.common.internal.presentations.SectionDescriptor;
import com.ibm.team.workitem.common.internal.presentations.TabDescriptor;
import com.ibm.team.workitem.common.internal.util.CollectionUtils;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ListChangeDetails;
import com.ibm.team.workitem.ide.ui.internal.editor.LinkHelper;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorTabs;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.itempicker.IItemPicker;
import com.ibm.team.workitem.ide.ui.internal.editor.itempicker.ItemPickerRegistry;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.AttributePart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.RequiredPropertyLabel;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormUtil;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.AbstractPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.internal.ConstrainedTableViewer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class ItemListPart
extends AttributePart {
    private WorkItemWorkingCopy fWorkingCopy;
    private TableViewer fViewer;
    private ViewerPart fViewerPart;
    private RequiredPropertyLabel fAttributeName;
    private IPresentationUpdater fPresentationUpdater = new AbstractPresentationUpdater(){

        public void setVisible(boolean visible) {
            ArrayList<Object> changedControls = new ArrayList<Object>();
            if (ItemListPart.this.fAttributeName != null && !ItemListPart.this.fAttributeName.isDisposed()) {
                TeamFormUtil.setVisible(ItemListPart.this.fAttributeName.getLayoutControl(), visible);
                changedControls.add(ItemListPart.this.fAttributeName.getLayoutControl());
            }
            if (ItemListPart.this.fViewer != null && !ItemListPart.this.fViewer.getTable().isDisposed()) {
                TeamFormUtil.setVisible((Control)ItemListPart.this.fViewer.getControl().getParent(), visible);
                changedControls.add(ItemListPart.this.fViewer.getControl().getParent());
            }
            Util.updateFormLayout(changedControls.toArray(new Control[changedControls.size()]));
        }

        public void setRequired(boolean required) {
            if (ItemListPart.this.fAttributeName != null && !ItemListPart.this.fAttributeName.isDisposed()) {
                ItemListPart.this.fAttributeName.setRequired(required);
            }
        }

        public void attributeChanged(WorkItemChangeEvent event) {
            ListChangeDetails changes = (ListChangeDetails)event.getAttributeChangeDetails(ItemListPart.this.getAttribute().getIdentifier(), ListChangeDetails.class);
            if (changes != null) {
                for (IItem item : changes.getRemoved()) {
                    ItemListPart.this.fViewer.remove((Object)item);
                }
                for (IItem item : changes.getAdded()) {
                    ItemListPart.this.fViewer.add((Object)item);
                }
            }
        }
    };

    public void createContent(ITeamFormLayout formLayout) {
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        Composite parent = formLayout.getContainer();
        if (this.isLabelVisible()) {
            this.fAttributeName = new RequiredPropertyLabel(parent, toolkit, this.getBackgroundStyle());
            formLayout.add(this.fAttributeName.getLayoutControl(), "label");
        }
        boolean small = this.isSmallSectionLayout();
        Composite content = toolkit.createComposite(parent, 0, this.getBackgroundStyle());
        GridLayout layout = new GridLayout(small ? 1 : 2, false);
        layout.marginHeight = 2;
        layout.marginWidth = 1;
        content.setLayout((Layout)layout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        toolkit.paintBordersFor(content);
        TeamFormLayouts.setLayoutData((Control)content, (ITeamFormData)ITeamFormData.BORDERED_LIST);
        formLayout.add((Control)content, small ? "content" : "wideContent");
        this.fViewer = this.createViewer(toolkit, content);
        this.addDropTarget(this.fViewer);
        this.addDragSource(this.fViewer);
        ViewerPane viewerPane = (ViewerPane)this.getSite().getAdapter(ViewerPane.class);
        if (viewerPane != null) {
            this.fViewerPart = new ViewerPart((Viewer)this.fViewer, this.getAttribute().getIdentifier());
            viewerPane.addViewerPart(this.fViewerPart);
        }
        this.createActionControls(toolkit, content, small);
    }

    private boolean isSmallSectionLayout() {
        List elements;
        String sectionId;
        if (this.getDescriptor() != null && this.getDescriptor().getProperties() != null && this.getDescriptor().getProperties().get("small") != null) {
            return "true".equals(this.getDescriptor().getProperties().get("small"));
        }
        EditorPresentation presentation = (EditorPresentation)this.getSite().getAdapter(EditorPresentation.class);
        String string = sectionId = this.getDescriptor() != null ? this.getDescriptor().getParentSectionId() : null;
        if (presentation != null && sectionId != null && (elements = (List)presentation.getPresentationsMap().get(presentation.getPresentationId())) != null) {
            for (AbstractPresentationDescriptor element : elements) {
                List presentations;
                SectionDescriptor section;
                if (element instanceof TabDescriptor) {
                    List sections = (List)presentation.getPresentationsMap().get(element.getElementId());
                    if (sections == null) continue;
                    for (AbstractPresentationDescriptor section2 : sections) {
                        List presentations2;
                        if (!sectionId.equals(section2.getElementId()) || !(section2 instanceof SectionDescriptor) || (presentations2 = (List)presentation.getPresentationsMap().get(sectionId)) == null) continue;
                        for (AbstractPresentationDescriptor pres : presentations2) {
                            if (!this.getDescriptor().getElementId().equals(pres.getElementId())) continue;
                            String slot = ((SectionDescriptor)section2).getSlot();
                            return WorkItemEditorTabs.SMALL_SLOTS.contains(slot);
                        }
                    }
                    continue;
                }
                if (!(element instanceof SectionDescriptor) || !sectionId.equals((section = (SectionDescriptor)element).getElementId()) || (presentations = (List)presentation.getPresentationsMap().get(sectionId)) == null) continue;
                for (AbstractPresentationDescriptor pres : presentations) {
                    if (!this.getDescriptor().getElementId().equals(pres.getElementId())) continue;
                    String slot = section.getSlot();
                    return WorkItemEditorTabs.SMALL_SLOTS.contains(slot);
                }
            }
        }
        return false;
    }

    private TableViewer createViewer(WorkItemEditorToolkit toolkit, Composite parent) {
        ConstrainedTableViewer viewer = new ConstrainedTableViewer((FormToolkit)toolkit, parent, 770, false);
        toolkit.adapt(viewer.getControl(), true, false, this.getBackgroundStyle());
        viewer.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        viewer.setContentProvider((IContentProvider)new ItemViewerContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl()));
        viewer.setComparer((IElementComparer)new ItemHandleComparer());
        viewer.setSorter(new ViewerSorter());
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 240;
        viewer.getControl().setLayoutData((Object)data);
        new TooltipSupport((Control)viewer.getTable(), true, true){

            protected void openRequested(final Object element) {
                FoundationJob job = new FoundationJob(Messages.ItemListPart_OPENING_LINK){

                    protected IStatus runProtected(IProgressMonitor monitor) {
                        if (element == null) {
                            return Status.CANCEL_STATUS;
                        }
                        URIReference reference = Hyperlinks.create((Object)element, (IProgressMonitor)monitor);
                        if (reference == null) {
                            return Status.CANCEL_STATUS;
                        }
                        Hyperlinks.open((URI)reference.getURI(), ItemListPart.this.fWorkingCopy != null ? Util.getWorkItemContextProvider(ItemListPart.this.fWorkingCopy.getWorkItem()) : null, (IProgressMonitor)monitor);
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(true);
                job.schedule();
            }
        };
        this.getSite().registerSelectionProvider((ISelectionProvider)viewer, viewer.getControl());
        this.registerContextMenu((Control)viewer.getTable(), (ISelectionProvider)viewer);
        viewer.addOpenListener(new IOpenListener(){

            public void open(final OpenEvent event) {
                FoundationJob job = new FoundationJob(Messages.ItemListPart_Open){

                    protected IStatus runProtected(IProgressMonitor monitor) {
                        ISelection selection = event.getSelection();
                        if (selection instanceof IStructuredSelection) {
                            IStructuredSelection extended = (IStructuredSelection)selection;
                            List items = extended.toList();
                            ArrayList<URI> uris = new ArrayList<URI>();
                            for (Object item : items) {
                                URIReference reference = Hyperlinks.create(item, (IProgressMonitor)monitor);
                                if (reference == null) continue;
                                uris.add(reference.getURI());
                            }
                            return Hyperlinks.open(uris, null, (IProgressMonitor)monitor);
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        });
        return viewer;
    }

    private void addDragSource(TableViewer viewer) {
        new ViewerDragSupport((Viewer)viewer, 4);
    }

    private void addDropTarget(TableViewer viewer) {
        DropTarget target = new DropTarget((Control)viewer.getTable(), 5);
        target.setTransfer(new Transfer[]{LocalSelectionTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new ItemDropListener());
    }

    private void createActionControls(WorkItemEditorToolkit toolkit, Composite parent, boolean small) {
        Composite buttons = toolkit.createComposite(parent, 0, this.getBackgroundStyle());
        GridLayout layout = new GridLayout(small ? 2 : 1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        buttons.setLayoutData((Object)new GridData(131072, 4, false, false));
        Button button = toolkit.createButton(buttons, Messages.ItemListPart_ADD, 0, this.getBackgroundStyle());
        button.setLayoutData((Object)new GridData(4, 1, true, false));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ItemListPart.this.addItem();
            }
        });
        final Button remove = toolkit.createButton(buttons, Messages.ItemListPart_REMOVE, 0, this.getBackgroundStyle());
        remove.setLayoutData((Object)new GridData(4, 1, true, false));
        remove.setEnabled(!this.fViewer.getSelection().isEmpty());
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ItemListPart.this.removeItem();
            }
        });
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                remove.setEnabled(!event.getSelection().isEmpty());
            }
        });
    }

    private void registerContextMenu(Control control, ISelectionProvider selectionProvider) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        Action removeAction = new Action(Messages.ItemListPart_REMOVE){

            public void run() {
                ItemListPart.this.removeItem();
            }
        };
        Action addAction = new Action(Messages.ItemListPart_ADD){

            public void run() {
                ItemListPart.this.addItem();
            }
        };
        menuMgr.addMenuListener(new IMenuListener((IAction)addAction, (IAction)removeAction){
            private final /* synthetic */ IAction val$addAction;
            private final /* synthetic */ IAction val$removeAction;
            {
                this.val$addAction = iAction;
                this.val$removeAction = iAction2;
            }

            public void menuAboutToShow(IMenuManager manager) {
                manager.add(this.val$addAction);
                if (!ItemListPart.this.fViewer.getSelection().isEmpty()) {
                    manager.add(this.val$removeAction);
                }
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.getSite().registerContextMenu(String.valueOf(this.getSite().getId((TeamFormPart)this)) + ".processAreaList." + this.getAttribute().getIdentifier(), menuMgr, selectionProvider);
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
    }

    private void removeItem() {
        ISelection selection = this.fViewer.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            ITeamRepository teamRepository = this.fWorkingCopy.getTeamRepository();
            IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
            IWorkItem workItem = this.fWorkingCopy.getWorkItem();
            try {
                workItemClient.getWorkItemWorkingCopyManager().beginCompoundWorkItemChange((IWorkItemHandle)workItem);
                Object[] objectArray = ((IStructuredSelection)selection).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof IItemHandle) {
                        ((List)workItem.getValue(this.getAttribute())).remove(element);
                    }
                    ++n2;
                }
            }
            finally {
                workItemClient.getWorkItemWorkingCopyManager().endCompoundWorkItemChange((IWorkItemHandle)workItem);
            }
        }
    }

    private void addItem() {
        IWorkItem workItem = this.fWorkingCopy.getWorkItem();
        ITeamRepository teamRepository = (ITeamRepository)workItem.getOrigin();
        ArrayList<IItemHandle> filtered = new ArrayList<IItemHandle>();
        List existing = (List)this.fWorkingCopy.getWorkItem().getValue(this.getAttribute());
        for (Object o : existing) {
            if (!(o instanceof IItemHandle) || !((IItemHandle)o).getItemType().equals(this.getContainedItemType())) continue;
            filtered.add((IItemHandle)o);
        }
        IItemPicker picker = ItemPickerRegistry.getItemPicker(this.getContainedItemType());
        if (picker != null) {
            List<? extends IItemHandle> results = picker.getItemResults(null, this.getAttribute().getAttributeType(), this.fWorkingCopy.getTeamRepository(), null, null, filtered, Collections.emptyList(), true);
            if (picker.getStatus().isOK()) {
                IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                try {
                    workItemClient.getWorkItemWorkingCopyManager().beginCompoundWorkItemChange((IWorkItemHandle)workItem);
                    List value = (List)workItem.getValue(this.getAttribute());
                    for (IItemHandle iItemHandle : results) {
                        value.add(iItemHandle);
                    }
                }
                finally {
                    workItemClient.getWorkItemWorkingCopyManager().endCompoundWorkItemChange((IWorkItemHandle)workItem);
                }
            }
        }
    }

    private IItemType getContainedItemType() {
        return AttributeTypes.getItemType((String)AttributeTypes.getContainedType((String)this.getAttribute().getAttributeType()));
    }

    public void setFocus() {
        if (this.fViewer != null && !this.fViewer.getTable().isDisposed()) {
            this.fViewer.getTable().setFocus();
        }
    }

    public void setInput(Object input) {
        this.removeListener();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)((Object)input)).isResolved() && this.getAttribute() != null) {
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)((Object)input);
            this.fWorkingCopy = workItemEditorInput.getWorkingCopy();
            this.addListener();
            if (this.fAttributeName != null && !this.fAttributeName.isDisposed()) {
                this.fAttributeName.setText(NLS.bind((String)ATTRNAME_COLON, (Object)this.getLabel(), (Object[])new Object[0]));
                this.fAttributeName.layout();
            }
            this.fViewer.setInput((Object)this.fWorkingCopy);
        } else {
            this.fWorkingCopy = null;
        }
    }

    public void dispose() {
        this.removeListener();
        this.fWorkingCopy = null;
        super.dispose();
    }

    private void addListener() {
        PresentationHandlerManager mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class);
        if (mgr != null) {
            mgr.addPresentationUpdater(this.fPresentationUpdater, this.getDescriptor());
        }
    }

    private void removeListener() {
        PresentationHandlerManager mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class);
        if (mgr != null) {
            mgr.removePresentationUpdater(this.fPresentationUpdater);
        }
    }

    public boolean stretchVertically() {
        return true;
    }

    public IAttribute getAttribute() {
        return this.getAttribute(this.fWorkingCopy);
    }

    private class ItemDropListener
    extends DropTargetAdapter {
        private ItemDropListener() {
        }

        public void dragEnter(DropTargetEvent event) {
            this.validateDrop(event);
        }

        public void dragOperationChanged(DropTargetEvent event) {
            this.validateDrop(event);
        }

        public void dropAccept(DropTargetEvent event) {
            this.validateDrop(event);
        }

        public void drop(DropTargetEvent event) {
            ISelection selection = LocalSelectionTransfer.getInstance().getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection sel = (IStructuredSelection)selection;
                ArrayList<IItemHandle> itemList = new ArrayList<IItemHandle>();
                if (sel != null) {
                    for (Object e : sel.toList()) {
                        if ((e = LinkHelper.convertURIReferenceToItemHandle(e, ItemListPart.this.fWorkingCopy.getTeamRepository())) instanceof IItemHandle) {
                            itemList.add((IItemHandle)e);
                            continue;
                        }
                        if (!(e instanceof IReference) || !((IReference)e).isItemReference()) continue;
                        itemList.add(((IItemReference)e).getReferencedItem());
                    }
                }
                IWorkItemClient workItemClient = (IWorkItemClient)ItemListPart.this.fWorkingCopy.getTeamRepository().getClientLibrary(IWorkItemClient.class);
                try {
                    workItemClient.getWorkItemWorkingCopyManager().beginCompoundWorkItemChange((IWorkItemHandle)ItemListPart.this.fWorkingCopy.getWorkItem());
                    List areas = (List)ItemListPart.this.fWorkingCopy.getWorkItem().getValue(ItemListPart.this.getAttribute());
                    for (IItemHandle handle : itemList) {
                        if (!handle.getItemType().equals(ItemListPart.this.getContainedItemType())) continue;
                        areas.add(handle);
                    }
                }
                finally {
                    workItemClient.getWorkItemWorkingCopyManager().endCompoundWorkItemChange((IWorkItemHandle)ItemListPart.this.fWorkingCopy.getWorkItem());
                }
            }
        }

        private void validateDrop(DropTargetEvent event) {
            event.detail = 0;
            if (!LocalSelectionTransfer.getInstance().isSupportedType(event.currentDataType)) {
                return;
            }
            ISelection selection = LocalSelectionTransfer.getInstance().getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                for (Object e : structuredSelection.toList()) {
                    if (this.isAssigneableItemType(e)) continue;
                    event.detail = 0;
                    return;
                }
                if ((event.operations & 4) != 0) {
                    event.detail = 4;
                } else if ((event.operations & 1) != 0) {
                    event.detail = 1;
                }
            }
        }

        private boolean isAssigneableItemType(Object e) {
            IItemHandle handle = null;
            if (e instanceof IItemHandle) {
                handle = (IItemHandle)e;
            } else if (e instanceof IReference && ((IReference)e).isItemReference()) {
                handle = ((IItemReference)e).getReferencedItem();
            }
            if (handle != null && handle.getItemType().equals(ItemListPart.this.getContainedItemType())) {
                return handle.getOrigin().equals(ItemListPart.this.fWorkingCopy.getTeamRepository());
            }
            return false;
        }
    }

    private class ItemViewerContentProvider
    implements IStructuredContentProvider {
        private ItemViewerContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof WorkItemWorkingCopy) {
                WorkItemWorkingCopy workingCopy = (WorkItemWorkingCopy)inputElement;
                WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)workingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
                ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
                List elements = (List)workItem.getValue(ItemListPart.this.getAttribute().getIdentifier());
                return CollectionUtils.removeNulls((List)elements).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

