/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations;

import com.ibm.team.feed.ui.internal.itemview.DefaultItemViewLabelProvider;
import com.ibm.team.feed.ui.internal.itemview.DefaultTimelineContentProvider;
import com.ibm.team.feed.ui.internal.itemview.ItemViewerContentProvider;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.jface.internal.ItemViewAdvisorManager;
import com.ibm.team.jface.itemview.FullTextSearchFilter;
import com.ibm.team.jface.itemview.IItemViewListener;
import com.ibm.team.jface.itemview.IItemViewerLabelProvider;
import com.ibm.team.jface.itemview.ItemViewControl;
import com.ibm.team.jface.itemview.ItemViewUIConfigurer;
import com.ibm.team.jface.itemview.ItemViewer;
import com.ibm.team.jface.itemview.ItemViewerFilter;
import com.ibm.team.jface.itemview.ItemViewerSorter;
import com.ibm.team.jface.itemview.TimelineFilter;
import com.ibm.team.jface.timeline.ITimelineContentProvider;
import com.ibm.team.jface.timeline.Range;
import com.ibm.team.jface.timeline.TimelineUtils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.Auditable;
import com.ibm.team.ui.editor.ITeamFormPartSite;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.IWorkingCopyListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkingCopyEvent;
import com.ibm.team.workitem.client.internal.WorkItemClient;
import com.ibm.team.workitem.common.internal.rcp.dto.ChangeLogDTO;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.HistoryLogItem;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationPart;
import com.ibm.team.workitem.rcp.ui.UIWorkItemListener;
import com.ibm.team.workitem.rcp.ui.UIWorkItemWorkingCopyListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.progress.UIJob;

public class HistoryPart
extends PresentationPart {
    private static final int QUICKSEARCH_DELAY = 500;
    private static final int TIMELINE_FILTER_DELAY = 500;
    protected static final long ONE_WEEK = 604800000L;
    private UIJob fFilterJob;
    private UIJob fTimelineFilterJob;
    private TimelineFilter fTimelineFilter;
    private WorkItemEditorInput fEditorInput;
    private ItemViewer fViewer;
    private ItemViewerContentProvider fContentProvider;
    private IProgressMonitor fComputeMonitor;
    private FullTextSearchFilter fItemViewFilter;
    private ItemViewControl fItemViewControl;
    private ItemViewUIConfigurer fUIConfigurer;
    private WorkItemListener fWorkItemListener = new WorkItemListener();
    private UUID fPredecessor = null;

    public void init(ITeamFormPartSite site) {
        this.loadContributions();
        super.init(site);
    }

    public void createContent(Composite parent) {
        UIWorkItemWorkingCopyListener uiCopyListener;
        UIWorkItemListener uiListener;
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        parent.setLayout((Layout)layout);
        DefaultTimelineContentProvider timelineContentProvider = new DefaultTimelineContentProvider();
        this.fItemViewControl = new ItemViewControl(this.fUIConfigurer, (ITimelineContentProvider)timelineContentProvider);
        this.fItemViewControl.setSidebarHidden(true);
        this.fItemViewControl.create(parent, (FormToolkit)toolkit);
        this.fItemViewControl.addItemViewListener(new IItemViewListener(){

            public void quickSearched(String search) {
                HistoryPart.this.performQuicksearch(search, 500);
            }

            public void quickSearchCanceld() {
                HistoryPart.this.performQuicksearch("", 0);
            }

            public void expandedAll() {
                HistoryPart.this.fViewer.expandAll();
            }

            public void collapsedAll() {
                HistoryPart.this.fViewer.collapseAll();
            }

            public void sideBarToggled(boolean visible) {
            }

            public void sorted(String id) {
                for (ItemViewerSorter sorter : HistoryPart.this.fUIConfigurer.getSorters()) {
                    if (!id.equals(sorter.getId())) continue;
                    if (sorter.equals((Object)HistoryPart.this.fViewer.getSorter())) break;
                    HistoryPart.this.fViewer.setSorter(sorter.getViewerSorter());
                    HistoryPart.this.fViewer.getControl().setFocus();
                    break;
                }
            }

            public void filtered(String id, boolean enabled) {
                for (ItemViewerFilter filter : HistoryPart.this.fUIConfigurer.getFilters()) {
                    if (!id.equals(filter.getId())) continue;
                    if (enabled) {
                        HistoryPart.this.fViewer.addFilter(filter.getViewerFilter());
                    } else {
                        HistoryPart.this.fViewer.removeFilter(filter.getViewerFilter());
                    }
                    HistoryPart.this.fViewer.getControl().setFocus();
                }
            }
        });
        this.fItemViewControl.getTimelineViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Range range = (Range)selection.getFirstElement();
                HistoryPart.this.performTimelineFilter(range, 500);
            }
        });
        ContextProvider contextProvider = (ContextProvider)this.getSite().getAdapter(ContextProvider.class);
        this.fViewer = new ItemViewer(this.fItemViewControl.getBrowserContainer(), contextProvider, 0, 1);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 64;
        data.heightHint = 64;
        this.fViewer.getControl().setLayoutData((Object)data);
        this.fContentProvider = new ItemViewerContentProvider();
        this.fViewer.setContentProvider((IStructuredContentProvider)this.fContentProvider);
        this.fViewer.setLabelProvider((IItemViewerLabelProvider)new DefaultItemViewLabelProvider());
        this.fViewer.setInput((Object)new Object[]{new HistoryLogItem(new Date(System.currentTimeMillis()), Messages.HistoryPart_COMPUTING_HISTORY, "", false)});
        this.fItemViewFilter = new FullTextSearchFilter();
        this.fViewer.addFilter((ViewerFilter)this.fItemViewFilter, false);
        this.fTimelineFilter = new TimelineFilter(timelineContentProvider.getDefaultRange());
        this.fViewer.addFilter((ViewerFilter)this.fTimelineFilter, false);
        if (this.fUIConfigurer.getDefaultSorter() != null) {
            this.fViewer.setSorter(this.fUIConfigurer.getDefaultSorter().getViewerSorter());
        }
        if ((uiListener = (UIWorkItemListener)this.getSite().getAdapter(UIWorkItemListener.class)) != null) {
            uiListener.addListener((IWorkItemListener)this.fWorkItemListener);
        }
        if ((uiCopyListener = (UIWorkItemWorkingCopyListener)this.getSite().getAdapter(UIWorkItemWorkingCopyListener.class)) != null) {
            uiCopyListener.addListener((IWorkingCopyListener)this.fWorkItemListener);
        }
    }

    private void computeHistory() {
        if (this.fEditorInput == null) {
            return;
        }
        this.fPredecessor = ((Auditable)this.fEditorInput.getWorkingCopy().getWorkItem()).getWorkingCopyPredecessor();
        FoundationJob job = new FoundationJob(Messages.HistoryPart_COMPUTING_HISTORY_JOB){

            protected IStatus runProtected(IProgressMonitor monitor) {
                Object[] input;
                HistoryPart.this.fComputeMonitor = monitor;
                Range newrange = null;
                if (HistoryPart.this.fEditorInput != null && HistoryPart.this.fEditorInput.getWorkingCopy() != null && HistoryPart.this.fEditorInput.getWorkingCopy().getWorkItem().isNewItem()) {
                    input = new Object[]{new HistoryLogItem(new Date(System.currentTimeMillis()), Messages.HistoryPart_WORKITEM_NOT_YET_SAVED, "", false)};
                } else {
                    input = HistoryPart.this.getHistory(monitor);
                    newrange = this.computeNewRange((HistoryLogItem[])input);
                }
                final Range visibleRange = newrange;
                FoundationUIJob uijob = new FoundationUIJob(Messages.HistoryPart_DISPLAYING_HISTORY){

                    public IStatus runProtectedInUI(IProgressMonitor uimonitor) {
                        if (HistoryPart.this.fViewer != null && !HistoryPart.this.fViewer.getControl().isDisposed()) {
                            HistoryPart.this.fViewer.setInput(input);
                            HistoryPart.this.fViewer.expandAll();
                            HistoryPart.this.fItemViewControl.getTimelineViewer().setInput(input);
                            if (visibleRange != null) {
                                HistoryPart.this.fItemViewControl.getTimelineViewer().setVisibleRange(visibleRange);
                                boolean refreshed = HistoryPart.this.performTimelineFilter(visibleRange, 0);
                                if (!refreshed) {
                                    HistoryPart.this.fViewer.refresh();
                                }
                            } else {
                                HistoryPart.this.fViewer.refresh();
                                HistoryPart.this.fViewer.getControl().setFocus();
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
                uijob.setSystem(true);
                uijob.schedule();
                HistoryPart.this.fComputeMonitor = null;
                return Status.OK_STATUS;
            }

            private Range computeNewRange(HistoryLogItem[] items) {
                Calendar end = Calendar.getInstance();
                end.set(10, 0);
                end.set(12, 0);
                end.set(13, 0);
                end.set(14, 0);
                Calendar start = Calendar.getInstance();
                start.setTimeInMillis(end.getTimeInMillis());
                end.add(6, 2);
                start.add(3, -1);
                long starttime = start.getTimeInMillis();
                int i = 0;
                while (i < items.length) {
                    long current = items[i].getDate().getTime();
                    if (current < starttime) {
                        starttime = current;
                    }
                    ++i;
                }
                start.setTimeInMillis(starttime);
                start.set(10, 0);
                start.set(12, 0);
                start.set(13, 0);
                start.set(14, 0);
                start.add(6, -1);
                Range range = new Range(start.getTimeInMillis(), end.getTimeInMillis());
                return range;
            }
        };
        job.schedule();
    }

    private HistoryLogItem[] getHistory(IProgressMonitor monitor) {
        IWorkItem workitem = this.fEditorInput.getWorkItem();
        ITeamRepository repository = (ITeamRepository)workitem.getOrigin();
        WorkItemClient workItemClient = (WorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
        try {
            ArrayList<HistoryLogItem> logItems = new ArrayList<HistoryLogItem>();
            List changeLogEntries = workItemClient.computeWorkItemHistory((IWorkItemHandle)workitem, monitor);
            int i = 0;
            for (ChangeLogDTO changeLogDTO : changeLogEntries) {
                IContributor modifiedBy = (IContributor)workItemClient.getAuditableCommon().resolveAuditable((IAuditableHandle)changeLogDTO.getModifiedBy(), ItemProfile.CONTRIBUTOR_DEFAULT, monitor);
                logItems.add(new HistoryLogItem(changeLogDTO.getModifiedDate(), XMLString.createFromPlainText((String)modifiedBy.getName()).getXMLText(), changeLogDTO.getHtmlContent(), i == 0));
                ++i;
            }
            return logItems.toArray(new HistoryLogItem[logItems.size()]);
        }
        catch (PermissionDeniedException p) {
            WorkItemIDEUIPlugin.getDefault().log(Messages.HistoryPart_PERMISSION_DENIED_MSG, p);
            return new HistoryLogItem[]{new HistoryLogItem(new Timestamp(System.currentTimeMillis()), Messages.HistoryPart_NO_PERMISSION, "", false)};
        }
        catch (Exception e) {
            WorkItemIDEUIPlugin.getDefault().log(Messages.HistoryPart_ERROR_COMPUTING_HISTORY, e);
            return new HistoryLogItem[]{new HistoryLogItem(new Timestamp(System.currentTimeMillis()), Messages.HistoryPart_ERROR_COMPUTING_HISTORY_MSG, "", false)};
        }
    }

    public static HistoryLogItem[] getPartialHistory(IWorkItemHandle workitem, UUID from, IProgressMonitor monitor) {
        ITeamRepository repository = (ITeamRepository)workitem.getOrigin();
        WorkItemClient workItemClient = (WorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
        try {
            ArrayList<HistoryLogItem> logItems = new ArrayList<HistoryLogItem>();
            List changeLogEntries = workItemClient.computePartialWorkItemHistory(workitem, from, monitor);
            for (ChangeLogDTO changeLogDTO : changeLogEntries) {
                IContributor modifiedBy = (IContributor)workItemClient.getAuditableCommon().resolveAuditable((IAuditableHandle)changeLogDTO.getModifiedBy(), ItemProfile.CONTRIBUTOR_DEFAULT, monitor);
                logItems.add(new HistoryLogItem(changeLogDTO.getModifiedDate(), XMLString.createFromPlainText((String)modifiedBy.getName()).getXMLText(), changeLogDTO.getHtmlContent(), false));
            }
            return logItems.toArray(new HistoryLogItem[logItems.size()]);
        }
        catch (Exception e) {
            WorkItemIDEUIPlugin.getDefault().log(Messages.HistoryPart_ERROR_COMPUTING_HISTORY, e);
            return new HistoryLogItem[]{new HistoryLogItem(new Timestamp(System.currentTimeMillis()), Messages.HistoryPart_ERROR_COMPUTING_HISTORY_MSG, "", false)};
        }
    }

    public boolean stretchVertically() {
        return true;
    }

    public void setInput(Object input) {
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)((Object)input)).isResolved()) {
            this.fEditorInput = (WorkItemEditorInput)((Object)input);
            this.computeHistory();
        } else {
            this.fEditorInput = null;
        }
    }

    public void dispose() {
        UIWorkItemWorkingCopyListener uiCopyListener;
        UIWorkItemListener uiListener = (UIWorkItemListener)this.getSite().getAdapter(UIWorkItemListener.class);
        if (uiListener != null) {
            uiListener.removeListener((IWorkItemListener)this.fWorkItemListener);
        }
        if ((uiCopyListener = (UIWorkItemWorkingCopyListener)this.getSite().getAdapter(UIWorkItemWorkingCopyListener.class)) != null) {
            uiCopyListener.removeListener((IWorkingCopyListener)this.fWorkItemListener);
        }
        if (this.fComputeMonitor != null) {
            this.fComputeMonitor.setCanceled(true);
        }
        this.fViewer = null;
        this.fContentProvider.dispose();
        super.dispose();
    }

    void performQuicksearch(final String search, int delay) {
        if (this.fFilterJob != null) {
            this.fFilterJob.cancel();
        }
        this.fFilterJob = new FoundationUIJob(Messages.HistoryPart_FILTER_ITEMS){

            public IStatus runProtectedInUI(IProgressMonitor monitor) {
                if (!monitor.isCanceled() && HistoryPart.this.fViewer != null) {
                    HistoryPart.this.fItemViewFilter.setSearchFilter(search);
                    HistoryPart.this.fViewer.refresh();
                }
                return Status.OK_STATUS;
            }
        };
        this.fFilterJob.setSystem(true);
        this.fFilterJob.schedule((long)delay);
    }

    boolean performTimelineFilter(final Range range, int delay) {
        if (this.fTimelineFilterJob != null) {
            this.fTimelineFilterJob.cancel();
        }
        if (this.fTimelineFilter.getSelectedRange() != null) {
            Range oldRange = this.fTimelineFilter.getSelectedRange();
            Range newRange = range;
            Date oldDateFrom = new Date(TimelineUtils.trimToDay((long)oldRange.getStart()));
            Date oldDateTo = new Date(TimelineUtils.trimToDay((long)oldRange.getEnd()));
            Date newDateFrom = new Date(TimelineUtils.trimToDay((long)newRange.getStart()));
            Date newDateTo = new Date(TimelineUtils.trimToDay((long)newRange.getEnd()));
            if (oldDateFrom.equals(newDateFrom) && oldDateTo.equals(newDateTo)) {
                return false;
            }
        }
        this.fTimelineFilterJob = new FoundationUIJob(Messages.HistoryPart_FILTER_TIMELINE_ITEMS){

            public IStatus runProtectedInUI(IProgressMonitor monitor) {
                if (!monitor.isCanceled() && HistoryPart.this.fViewer != null) {
                    HistoryPart.this.fTimelineFilter.setSelectedRange(range);
                    HistoryPart.this.fViewer.refresh();
                    HistoryPart.this.fViewer.getControl().setFocus();
                }
                return Status.OK_STATUS;
            }
        };
        this.fTimelineFilterJob.setSystem(true);
        this.fTimelineFilterJob.schedule((long)delay);
        return true;
    }

    private void loadContributions() {
        this.fUIConfigurer = ItemViewAdvisorManager.getConfigurer();
    }

    private class WorkItemListener
    implements IWorkItemListener,
    IWorkingCopyListener {
        private WorkItemListener() {
        }

        public void workItemAttributeChanged(WorkItemChangeEvent event) {
            if (HistoryPart.this.fEditorInput == null || !event.affects(HistoryPart.this.fEditorInput.getWorkItemHandle())) {
                return;
            }
            this.updateHistory();
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }

        public void workingCopyEvent(WorkingCopyEvent event) {
            if (HistoryPart.this.fEditorInput == null || !event.hasType("saved")) {
                return;
            }
            this.updateHistory();
        }

        private void updateHistory() {
            UUID predecessor = ((Auditable)HistoryPart.this.fEditorInput.getWorkingCopy().getWorkItem()).getWorkingCopyPredecessor();
            if (predecessor == HistoryPart.this.fPredecessor || predecessor != null && predecessor.equals((Object)HistoryPart.this.fPredecessor)) {
                return;
            }
            HistoryPart.this.computeHistory();
        }
    }
}

