/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations;

import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.workitem.client.IWorkingCopyListener;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkingCopyEvent;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedFormsText;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedText;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.AttributePart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.RequiredPropertyLabel;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormUtil;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.AbstractPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.UIJob;

public class ESigAttributePart
extends AttributePart {
    private WorkItemWorkingCopy fWorkingCopy;
    private RequiredPropertyLabel fAttributeName;
    private DecoratedText fAttributeContent;
    private Text fText;
    private String fSignature;
    private IWorkingCopyListener fCopyListener = new IWorkingCopyListener(){

        public void workingCopyEvent(WorkingCopyEvent event) {
            if ("aboutToBeSaved".equals(event.getType())) {
                if (ESigAttributePart.this.fSignature != null && !"".equals(ESigAttributePart.this.fSignature)) {
                    ESigAttributePart.this.fWorkingCopy.getWorkItem().setValue(ESigAttributePart.this.getAttribute(), (Object)ESigAttributePart.this.fSignature);
                }
            } else if ("saved".equals(event.getType()) || "reverted".equals(event.getType())) {
                ESigAttributePart.this.fSignature = null;
                new UIJob(Messages.ESigAttributePart_UPDATING_PASSWORD){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (ESigAttributePart.this.fText != null && !ESigAttributePart.this.fText.isDisposed()) {
                            ESigAttributePart.this.fText.setText("");
                        }
                        ESigAttributePart.this.fClearPasswordJob.cancel();
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }
    };
    private UIJob fClearPasswordJob = new UIJob(Messages.ESigAttributePart_CLEAR_PASSWORD){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            ESigAttributePart.this.fSignature = null;
            if (ESigAttributePart.this.fText != null && !ESigAttributePart.this.fText.isDisposed()) {
                ESigAttributePart.this.fText.setText("");
            }
            return Status.OK_STATUS;
        }
    };
    private IPresentationUpdater fPresentationUpdater = new AbstractPresentationUpdater(){

        public void setVisible(boolean visible) {
            ArrayList<Object> changedControls = new ArrayList<Object>();
            if (ESigAttributePart.this.fAttributeName != null && !ESigAttributePart.this.fAttributeName.isDisposed()) {
                TeamFormUtil.setVisible(ESigAttributePart.this.fAttributeName.getLayoutControl(), visible);
                changedControls.add(ESigAttributePart.this.fAttributeName.getLayoutControl());
            }
            if (ESigAttributePart.this.fAttributeContent != null && !ESigAttributePart.this.fAttributeContent.getLayoutControl().isDisposed()) {
                TeamFormUtil.setVisible(ESigAttributePart.this.fAttributeContent.getLayoutControl(), visible);
                changedControls.add(ESigAttributePart.this.fAttributeContent.getLayoutControl());
            } else if (ESigAttributePart.this.fText != null && !ESigAttributePart.this.fText.isDisposed()) {
                TeamFormUtil.setVisible((Control)ESigAttributePart.this.fText, visible);
                changedControls.add(ESigAttributePart.this.fText);
            }
            Util.updateFormLayout(changedControls.toArray(new Control[changedControls.size()]));
        }

        public void setRequired(boolean required) {
            if (ESigAttributePart.this.fAttributeName != null && !ESigAttributePart.this.fAttributeName.isDisposed()) {
                ESigAttributePart.this.fAttributeName.setRequired(required);
            }
        }

        public void setStatus(IStatus status) {
            if (ESigAttributePart.this.fAttributeContent != null && !ESigAttributePart.this.fAttributeContent.getLayoutControl().isDisposed()) {
                ESigAttributePart.this.fAttributeContent.setStatus(status);
            }
        }
    };

    public void createContent(ITeamFormLayout formLayout) {
        String time;
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        Composite parent = formLayout.getContainer();
        if (this.isLabelVisible()) {
            this.fAttributeName = new RequiredPropertyLabel(parent, toolkit, this.getBackgroundStyle());
            formLayout.add(this.fAttributeName.getLayoutControl(), "label");
        }
        this.fAttributeContent = new DecoratedFormsText(parent, this.getSite(), 0x400000, 0, this.getBackgroundStyle());
        this.fText = this.fAttributeContent.getText();
        Util.addWidthHint(this.fAttributeContent.getLayoutControl());
        formLayout.add(this.fAttributeContent.getLayoutControl(), "content");
        int t = 120;
        if (this.getDescriptor() != null && this.getDescriptor().getProperties() != null && (time = (String)this.getDescriptor().getProperties().get("timeout")) != null) {
            try {
                int parsed = Integer.parseInt(time);
                if (parsed >= 5) {
                    t = parsed;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        final int timeOut = t * 1000;
        this.fText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ESigAttributePart.this.fSignature = ESigAttributePart.this.fText.getText();
                ESigAttributePart.this.fClearPasswordJob.schedule((long)timeOut);
            }
        });
    }

    public void setFocus() {
        if (this.fText != null && !this.fText.isDisposed()) {
            this.fText.setFocus();
        }
    }

    public void setInput(Object input) {
        this.removeListeners();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)((Object)input)).isResolved() && this.getAttribute() != null) {
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)((Object)input);
            this.fWorkingCopy = workItemEditorInput.getWorkingCopy();
            this.addListeners();
            if (this.fAttributeName != null && !this.fAttributeName.isDisposed()) {
                this.fAttributeName.setText(NLS.bind((String)ATTRNAME_COLON, (Object)this.getLabel(), (Object[])new Object[0]));
                this.fAttributeName.layout();
            }
            if (this.fText != null && !this.fText.isDisposed()) {
                this.fText.setText("");
            }
        } else {
            this.fWorkingCopy = null;
        }
    }

    private void addListeners() {
        PresentationHandlerManager mgr;
        if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            mgr.addPresentationUpdater(this.fPresentationUpdater, this.getDescriptor());
        }
        if (this.fWorkingCopy != null) {
            this.fWorkingCopy.addWorkingCopyListener(this.fCopyListener);
        }
    }

    private void removeListeners() {
        PresentationHandlerManager mgr;
        if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            mgr.removePresentationUpdater(this.fPresentationUpdater);
        }
        if (this.fWorkingCopy != null) {
            this.fWorkingCopy.removeWorkingCopyListener(this.fCopyListener);
        }
    }

    public void dispose() {
        this.removeListeners();
        this.fWorkingCopy = null;
        super.dispose();
    }

    public IAttribute getAttribute() {
        return this.getAttribute(this.fWorkingCopy);
    }
}

