/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.ui.editor.TeamFormToolkit;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.WorkItemClient;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.common.internal.model.ConfigurationItem;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedCheckedList;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedList;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedListUpdaterJob;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.ListAttributePart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.RequiredPropertyLabel;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

public class CheckedListAttributePart
extends ListAttributePart {
    private DecoratedCheckedList fCheckboxList;

    public void createContent(ITeamFormLayout formLayout) {
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        Composite parent = formLayout.getContainer();
        if (this.isLabelVisible()) {
            this.fAttributeName = new RequiredPropertyLabel(parent, toolkit, this.getBackgroundStyle());
            formLayout.add(this.fAttributeName.getLayoutControl(), "label");
        }
        if (!this.hasValidEnumeration()) {
            this.fText = toolkit.createReadOnlyText(parent, "", 0, this.getBackgroundStyle());
            TeamFormLayouts.setLayoutData((Control)this.fText, (ITeamFormData)ITeamFormData.SINGLE_LINE_READONLY_TEXT);
            Util.addWidthHint((Control)this.fText);
            formLayout.add((Control)this.fText, "content");
        } else {
            WorkItemClient workItemClient;
            IEnumeration enumeration;
            this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
            this.fCheckboxList = new DecoratedCheckedList((TeamFormToolkit)toolkit, parent, 2048, 1, this.fResourceManager);
            Util.addWidthHint(this.fCheckboxList.getLayoutControl());
            formLayout.add(this.fCheckboxList.getLayoutControl(), "content");
            this.fCheckboxList.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (CheckedListAttributePart.this.fWorkingCopy != null) {
                        CheckedListAttributePart.this.writeValue();
                    }
                }
            });
            this.fCheckboxList.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof ILiteral) {
                        return ((ILiteral)element).getIdentifier2().getStringIdentifier();
                    }
                    if (element instanceof String) {
                        return (String)element;
                    }
                    if (element instanceof Identifier) {
                        return ((Identifier)element).getStringIdentifier();
                    }
                    return "";
                }

                public Image getImage(Object element) {
                    ImageDescriptor desc = ImagePool.EMPTY;
                    if (element instanceof ConfigurationItem && ((ConfigurationItem)element).getIconURL() != null) {
                        desc = WorkItemUI.getImageDescriptor((URL)((ConfigurationItem)element).getIconURL());
                    }
                    return JazzResources.getImageWithDefault((ResourceManager)CheckedListAttributePart.this.fResourceManager, (ImageDescriptor)desc);
                }
            });
            this.fUpdater = new DecoratedListUpdaterJob(NLS.bind((String)Messages.CheckedListAttributePart_ATTRIBUTE_UPDATE, (Object)this.getAttribute().getDisplayName(), (Object[])new Object[0]), (DecoratedList)this.fCheckboxList, this.getAttribute().getIdentifier(), this.fEnumTypeId, this.getValueSetProviderId()){

                public IStatus runInBackground(IProgressMonitor monitor) {
                    CheckedListAttributePart.this.fTeamAreaUnchanged = true;
                    WorkItemWorkingCopyImpl workingCopy = (WorkItemWorkingCopyImpl)this.getWorkingCopy();
                    if (workingCopy != null) {
                        try {
                            CheckedListAttributePart.this.fTeamAreaUnchanged = this.teamAreaUnchanged(monitor);
                        }
                        catch (TeamRepositoryException x) {
                            WorkItemIDEUIPlugin.getDefault().log(Messages.CheckedListAttributePart_EXCEPTION_DETERMINING_TEAMAREA, x);
                        }
                    }
                    return super.runInBackground(monitor);
                }

                private boolean teamAreaUnchanged(IProgressMonitor monitor) throws TeamRepositoryException {
                    IProcessAreaHandle oldProcessArea;
                    WorkItemWorkingCopyImpl workingCopy = (WorkItemWorkingCopyImpl)this.getWorkingCopy();
                    if (workingCopy == null) {
                        return true;
                    }
                    if (workingCopy.getBaseState() == null) {
                        return false;
                    }
                    ITeamRepository teamRepository = workingCopy.getTeamRepository();
                    IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                    IProcessAreaHandle newProcessArea = workItemClient.findProcessArea((IWorkItemHandle)workingCopy.getWorkItem(), monitor);
                    return newProcessArea == (oldProcessArea = workItemClient.findProcessArea((IWorkItemHandle)workingCopy.getBaseState(), monitor)) || newProcessArea != null && newProcessArea.sameItemId((IItemHandle)oldProcessArea);
                }

                protected Object resolve(Object value, IProgressMonitor monitor) throws TeamRepositoryException {
                    if (CheckedListAttributePart.this.fWorkingCopy == null) {
                        return value;
                    }
                    ITeamRepository teamRepository = CheckedListAttributePart.this.fWorkingCopy.getTeamRepository();
                    IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                    if (CheckedListAttributePart.this.getAttribute().getIdentifier().equals(IWorkItem.TYPE_PROPERTY)) {
                        return workItemClient.findWorkItemType(CheckedListAttributePart.this.fWorkingCopy.getWorkItem().getProjectArea(), (String)value, monitor);
                    }
                    return CheckedListAttributePart.this.fWorkingCopy.getWorkItem().getValue(CheckedListAttributePart.this.getAttribute());
                }

                public IStatus runInUI(IProgressMonitor monitor) {
                    if (CheckedListAttributePart.this.fCheckboxList.getDecoratedControl().isDisposed()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (this.fValueSet.length == 0) {
                        CheckedListAttributePart.this.fCheckboxList.getDecoratedControl().setEnabled(false);
                    } else {
                        CheckedListAttributePart.this.fCheckboxList.getDecoratedControl().setEnabled(true);
                    }
                    boolean reflow = CheckedListAttributePart.this.fCheckboxList.getValueSet().length != this.fValueSet.length;
                    IStatus status = super.runInUI(monitor);
                    if (status.getSeverity() != 4 && status.getSeverity() != 8) {
                        CheckedListAttributePart.this.updateWarningDecoration();
                    }
                    if (reflow) {
                        this.refreshLayout();
                    }
                    return status;
                }

                private void refreshLayout() {
                    SharedScrolledComposite form = this.getScrolledComposite();
                    if (form != null) {
                        form.reflow(true);
                        form.layout(true, true);
                    }
                }

                private SharedScrolledComposite getScrolledComposite() {
                    Composite parent = CheckedListAttributePart.this.fCheckboxList.getLayoutControl().getParent();
                    while (parent != null) {
                        if (parent instanceof SharedScrolledComposite) {
                            return (SharedScrolledComposite)parent;
                        }
                        parent = parent.getParent();
                    }
                    return null;
                }

                protected WorkItemWorkingCopy getWorkingCopy() {
                    return CheckedListAttributePart.this.fWorkingCopy;
                }
            };
            if (!this.fEnumTypeId.equals(IWorkItem.TYPE_PROPERTY) && (enumeration = (workItemClient = (WorkItemClient)((ITeamRepository)this.getAttribute().getOrigin()).getClientLibrary(IWorkItemClient.class)).findCachedEnumeration(this.getAttribute().getProjectArea(), this.fEnumTypeId)) != null) {
                this.fCheckboxList.setValueSet(enumeration.getEnumerationLiterals().toArray());
            }
        }
    }

    protected Object[] getSelectedValues() {
        return this.fCheckboxList.getValue();
    }

    protected void setSelectedValue(Object value) {
        if (this.fCheckboxList != null) {
            this.fCheckboxList.setValue(value);
        } else if (this.fText != null) {
            this.fText.setText(this.getText(value));
        }
    }

    protected Object[] getValueSet() {
        return this.fCheckboxList.getValueSet();
    }

    protected Control getDecoratedControl() {
        return this.fCheckboxList == null ? (this.fText == null ? null : this.fText) : this.fCheckboxList.getDecoratedControl();
    }

    protected Control getLayoutControl() {
        return this.fCheckboxList == null ? (this.fText == null ? null : this.fText) : this.fCheckboxList.getLayoutControl();
    }

    protected DecoratedList getDecoratedList() {
        return this.fCheckboxList;
    }
}

