/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations;

import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInputFuture;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.AttributePart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.RequiredPropertyLabel;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormUtil;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.AbstractPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class BooleanAttributePart
extends AttributePart {
    private WorkItemWorkingCopy fWorkingCopy;
    private RequiredPropertyLabel fAttributeName;
    private Button fCheck;
    private IPresentationUpdater fPresentationUpdater = new AbstractPresentationUpdater(){

        public void setVisible(boolean visible) {
            ArrayList<Object> changedControls = new ArrayList<Object>();
            if (BooleanAttributePart.this.fAttributeName != null && !BooleanAttributePart.this.fAttributeName.isDisposed()) {
                TeamFormUtil.setVisible(BooleanAttributePart.this.fAttributeName.getLayoutControl(), visible);
                changedControls.add(BooleanAttributePart.this.fAttributeName.getLayoutControl());
            }
            if (BooleanAttributePart.this.fCheck != null && !BooleanAttributePart.this.fCheck.isDisposed()) {
                TeamFormUtil.setVisible((Control)BooleanAttributePart.this.fCheck, visible);
                changedControls.add(BooleanAttributePart.this.fCheck);
            }
            Util.updateFormLayout(changedControls.toArray(new Control[changedControls.size()]));
        }

        public void setRequired(boolean required) {
            if (BooleanAttributePart.this.fAttributeName != null && !BooleanAttributePart.this.fAttributeName.isDisposed()) {
                BooleanAttributePart.this.fAttributeName.setRequired(required);
            }
        }

        public void attributeChanged(WorkItemChangeEvent event) {
            if (BooleanAttributePart.this.fCheck != null && !BooleanAttributePart.this.fCheck.isDisposed()) {
                BooleanAttributePart.this.handleValueChanged();
            }
        }
    };

    public void createContent(ITeamFormLayout formLayout) {
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        Composite parent = formLayout.getContainer();
        if (this.isLabelVisible()) {
            this.fAttributeName = new RequiredPropertyLabel(parent, toolkit, this.getBackgroundStyle());
            formLayout.add(this.fAttributeName.getLayoutControl(), "label");
        }
        this.fCheck = toolkit.createButton(parent, "", 32, this.getBackgroundStyle());
        formLayout.add((Control)this.fCheck, "content");
        if (this.isReadOnly()) {
            this.fCheck.setEnabled(false);
        } else {
            this.fCheck.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    if (BooleanAttributePart.this.fWorkingCopy != null) {
                        if (!BooleanAttributePart.this.fWorkingCopy.isDirty()) {
                            ((WorkItemWorkingCopyImpl)BooleanAttributePart.this.fWorkingCopy).setDirty(true);
                        }
                        BooleanAttributePart.this.fWorkingCopy.getWorkItem().setValue(BooleanAttributePart.this.getAttribute(), (Object)BooleanAttributePart.this.fCheck.getSelection());
                    }
                }
            });
        }
    }

    private boolean getNonNullValue() {
        Boolean value = null;
        if (this.fWorkingCopy != null && this.getAttribute() != null && this.fWorkingCopy.getWorkItem().hasAttribute(this.getAttribute())) {
            WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
            ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
            value = (Boolean)workItem.getValue(this.getAttribute());
        }
        if (value == null) {
            value = Boolean.FALSE;
        }
        return value;
    }

    private void handleValueChanged() {
        if (!this.fCheck.isDisposed()) {
            boolean value = this.getNonNullValue();
            if (this.fCheck.getSelection() != value) {
                this.fCheck.setSelection(value);
            }
        }
    }

    public void setFocus() {
        if (this.fCheck != null && !this.fCheck.isDisposed()) {
            this.fCheck.setFocus();
        }
    }

    public void setInput(Object input) {
        this.removeListeners();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)((Object)input)).isResolved() && this.getAttribute() != null) {
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)((Object)input);
            this.fWorkingCopy = workItemEditorInput.getWorkingCopy();
            this.addListeners();
            if (this.fAttributeName != null && this.fCheck != null && !this.fAttributeName.isDisposed() && !this.fCheck.isDisposed()) {
                this.fAttributeName.setText(NLS.bind((String)ATTRNAME_COLON, (Object)this.getLabel(), (Object[])new Object[0]));
                this.fAttributeName.layout();
                this.handleValueChanged();
            }
        } else if (input instanceof WorkItemEditorInputFuture) {
            this.fWorkingCopy = null;
        }
    }

    private void addListeners() {
        PresentationHandlerManager mgr;
        if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            mgr.addPresentationUpdater(this.fPresentationUpdater, this.getDescriptor());
        }
    }

    private void removeListeners() {
        PresentationHandlerManager mgr;
        if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            mgr.removePresentationUpdater(this.fPresentationUpdater);
        }
    }

    public void dispose() {
        this.removeListeners();
        this.fWorkingCopy = null;
        super.dispose();
    }

    public IAttribute getAttribute() {
        return this.getAttribute(this.fWorkingCopy);
    }
}

