/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.part;

import com.ibm.icu.text.Collator;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.common.internal.util.ExceptionDescription;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.ui.dnd.URIReferenceTransfer;
import com.ibm.team.foundation.rcp.ui.internal.util.ExceptionDescriptionUI;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.IProcessReport;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.process.rcp.ui.ProcessAreaSelectionDialog;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.DetailedStatus;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IDetailedStatus;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.IWorkingCopyListener;
import com.ibm.team.workitem.client.URIService;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkingCopyEvent;
import com.ibm.team.workitem.common.calm.CALMLinkType;
import com.ibm.team.workitem.common.internal.RequiredPropertiesAdvisor;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.internal.util.WorkItemProcessUtils;
import com.ibm.team.workitem.common.model.CommentsChangeDetails;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.ISubscriptions;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.actions.ExtractWorkItemAction;
import com.ibm.team.workitem.ide.ui.internal.editor.AbstractWorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.LinkHelper;
import com.ibm.team.workitem.ide.ui.internal.editor.SimpleAction;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditor;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.calm.CALMBackLinkProblemDialog;
import com.ibm.team.workitem.ide.ui.internal.editor.part.FindDuplicatesAction;
import com.ibm.team.workitem.ide.ui.internal.editor.part.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.part.RemoteChangesTooltipSupport;
import com.ibm.team.workitem.rcp.ui.UIWorkItemListener;
import com.ibm.team.workitem.rcp.ui.UIWorkItemWorkingCopyListener;
import com.ibm.team.workitem.rcp.ui.internal.PendingNotificationsDecorator;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemLabelProvider;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import com.ibm.team.workitem.rcp.ui.workitempicker.WorkItemSelectionDialog;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TitlePart {
    private static final String SUBSCRIBE_ME_TEXT = Messages.TitlePart_SUBSCRIBE_ME;
    private static final String UNSUBSCRIBE_ME_TEXT = Messages.TitlePart_UNSUBSCRIBE_ME;
    private static final ImageDescriptor ADD_SELF_DESCRIPTOR = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.team.workitem.ide.ui", (String)"icons/elcl16/addself_co.gif");
    private static final ImageDescriptor REMOVE_SELF_DESCRIPTOR = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.team.workitem.ide.ui", (String)"icons/elcl16/removeself_co.gif");
    private static final ImageDescriptor DISABLED_SELF_DESCRIPTOR = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.team.workitem.ide.ui", (String)"icons/dlcl16/addself_co.gif");
    private static final ImageDescriptor REFRESH_DESCRIPTOR = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.team.workitem.ide.ui", (String)"icons/elcl16/refresh.gif");
    private static final String REFRESH_TEXT = Messages.TitlePart_REFRESH;
    private static final String DISCARD_TEXT = Messages.TitlePart_REFRESH_AND_MERGE;
    private static final String REFRESH_MESSAGE = Messages.TitlePart_REFRESH_TO_GET;
    private static final String DISCARD_MESSAGE = Messages.TitlePart_REFRESH_TO_MERGE;
    private static final String COMMENT_ADDED_MESSAGE = Messages.TitlePart_COMMENT_ADDED;
    private ILabelProvider fLabelProvider = new DecoratingLabelProvider((ILabelProvider)new WorkItemLabelProvider(), (ILabelDecorator)new PendingNotificationsDecorator());
    private ILabelProviderListener fLabelProviderListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            if (TitlePart.this.fWorkingCopy != null && this.isAffected((IWorkItemHandle)TitlePart.this.fWorkingCopy.getWorkItem(), event.getElements())) {
                TitlePart.this.updateTitle(false);
            }
        }

        private boolean isAffected(IWorkItemHandle workItem, Object[] objects) {
            if (objects == null) {
                return false;
            }
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof IItemHandle && workItem.sameItemId((IItemHandle)objects[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    };
    private SharedHeaderFormEditor fEditor;
    private Form fTitleForm;
    private SimpleAction fSubscribeUserAction;
    private FindDuplicatesAction fFindDuplicatesAction;
    private ExtractWorkItemAction fExtractWorkItemAction;
    private SimpleAction fRefreshAction;
    private WorkItemListener fWorkItemListener = new WorkItemListener();
    private IHyperlinkListener fHyperlinkListener;
    private WorkItemWorkingCopy fWorkingCopy;
    private IWorkItem fPartialWorkItem;
    private boolean fSuppressDialog;
    private TooltipSupport fTooltipSupport;
    private IDetailedStatus fStatus;

    public void init(SharedHeaderFormEditor editor) {
        this.fEditor = editor;
        this.addWorkItemListener();
        this.fLabelProvider.addListener(this.fLabelProviderListener);
        this.fTitleForm = this.fEditor.getHeaderForm().getForm().getForm();
        this.updateTitle(false);
        this.createContextMenu(this.fTitleForm);
        this.addDragSupport(this.fTitleForm);
        this.createActionArea(this.fTitleForm);
    }

    private void createContextMenu(Form form) {
        IMenuManager menuMgr = form.getMenuManager();
        menuMgr.add((IContributionItem)new Separator("additions"));
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        if (menuMgr instanceof MenuManager) {
            this.fEditor.getSite().registerContextMenu(this.fEditor.getSite().getId(), (MenuManager)menuMgr, (ISelectionProvider)new TitleSelectionProvider());
        }
    }

    private void addDragSupport(Form proxy) {
        DragSourceAdapter dragSourcelistener = new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                IWorkItem element = TitlePart.this.getElement();
                if (!(element instanceof IWorkItem) || element.isNewItem()) {
                    event.doit = false;
                } else {
                    LocalSelectionTransfer.getTransfer().setSelection((ISelection)new StructuredSelection((Object)element));
                }
            }

            public void dragSetData(DragSourceEvent event) {
                if (URIReferenceTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = new URIReference[]{this.getURIReference()};
                } else if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                    event.data = LocalSelectionTransfer.getTransfer().getSelection();
                } else if (HTMLTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = com.ibm.team.foundation.rcp.ui.internal.util.Utils.escapeForHTMLTransfer((String)TitlePart.this.getHTML());
                }
            }

            public void dragFinished(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(null);
            }

            private URIReference getURIReference() {
                IWorkItem item = TitlePart.this.getElement();
                if (item == null) {
                    return null;
                }
                return Hyperlinks.createHyperlink((Object)item);
            }
        };
        proxy.addTitleDragSupport(4, new Transfer[]{URIReferenceTransfer.getInstance(), LocalSelectionTransfer.getTransfer(), HTMLTransfer.getInstance()}, (DragSourceListener)dragSourcelistener);
    }

    private void createActionArea(Form titleForm) {
        IToolBarManager toolBarManager = titleForm.getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator("additions"));
        this.fFindDuplicatesAction = new FindDuplicatesAction(this.fEditor.getSite().getPage());
        toolBarManager.add((IAction)this.fFindDuplicatesAction);
        this.fSubscribeUserAction = new SimpleAction(SUBSCRIBE_ME_TEXT, ADD_SELF_DESCRIPTOR, 1){

            public void runWithEvent(Event event) {
                TitlePart.this.toggleSubscribeUser();
            }
        };
        this.fSubscribeUserAction.setDisabledImageDescriptor(DISABLED_SELF_DESCRIPTOR);
        toolBarManager.add((IAction)this.fSubscribeUserAction);
        this.fExtractWorkItemAction = new ExtractWorkItemAction((IWorkbenchPart)this.fEditor);
        toolBarManager.add((IAction)this.fExtractWorkItemAction);
        this.fRefreshAction = new SimpleAction(REFRESH_TEXT, REFRESH_DESCRIPTOR, 1){

            public void runWithEvent(Event event) {
                TitlePart.this.refreshFromRepository();
            }
        };
        toolBarManager.add((IAction)this.fRefreshAction);
        ControlContribution save = new ControlContribution("save"){

            protected Control createControl(Composite parent) {
                final Button button = TitlePart.this.fEditor.getToolkit().createButton(parent, Messages.TitlePart_SAVE, 8);
                button.setBackground(null);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TitlePart.this.fEditor.getSite().getPage().saveEditor((IEditorPart)TitlePart.this.fEditor, false);
                    }
                });
                TitlePart.this.fEditor.addPropertyListener(new IPropertyListener(){

                    public void propertyChanged(Object source, int propId) {
                        if (source instanceof IEditorPart && propId == 257) {
                            button.setEnabled(TitlePart.this.fEditor.isDirty());
                        }
                    }
                });
                button.setEnabled(TitlePart.this.fEditor.isDirty());
                return button;
            }
        };
        toolBarManager.add((IContributionItem)save);
        titleForm.updateToolBar();
    }

    private void updateTitle(boolean error) {
        String text;
        boolean busy;
        IWorkItem workItem = this.getElement();
        boolean bl = busy = this.fWorkingCopy == null && !error;
        if (!busy) {
            Image image;
            Image image2 = image = workItem != null ? this.fLabelProvider.getImage((Object)workItem) : null;
            if (image != this.fTitleForm.getImage()) {
                this.fTitleForm.setImage(image);
            }
        }
        if (busy != this.fTitleForm.isBusy()) {
            this.fTitleForm.setBusy(busy);
        }
        String string = text = workItem != null ? this.getText(workItem) : "";
        if (text == null || !text.equals(this.fTitleForm.getText())) {
            this.fTitleForm.setText(text);
        }
    }

    private String getHTML() {
        IWorkItem item;
        if (this.fWorkingCopy != null) {
            item = this.fWorkingCopy.getWorkItem();
        } else if (this.fPartialWorkItem != null) {
            item = this.fPartialWorkItem;
        } else {
            return "";
        }
        ITeamRepository teamRepository = (ITeamRepository)item.getOrigin();
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        URI uri = URIService.createAuditableURI((ITeamRepository)teamRepository, (IItemHandle)item);
        IWorkItemType type = workItemClient.findCachedWorkItemType(item.getProjectArea(), item.getWorkItemType());
        String display = type != null ? NLS.bind((String)"{0} {1}", (Object)type.getDisplayName().toLowerCase(), (Object[])new Object[]{WorkItemTextUtilities.getWorkItemId((IWorkItem)item)}) : Messages.TitlePart_WORKITEM;
        String html = "<a href=\"" + uri + "\" title=\"" + item.getHTMLSummary().getPlainText() + "\">" + display + "</a>";
        return html;
    }

    private String getText(IWorkItem item) {
        ITeamRepository teamRepository = (ITeamRepository)item.getOrigin();
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        IWorkItemType type = workItemClient.findCachedWorkItemType(item.getProjectArea(), item.getWorkItemType());
        String id = WorkItemTextUtilities.getWorkItemId((IWorkItem)item);
        String typeName = type != null ? type.getDisplayName() : item.getWorkItemType();
        return String.valueOf(typeName) + " " + id;
    }

    private void updateSubscribeUserAction() {
        if (this.fWorkingCopy == null) {
            this.fSubscribeUserAction.setEnabled(false);
            return;
        }
        IContributor user = this.fWorkingCopy.getTeamRepository().loggedInContributor();
        if (user == null) {
            this.fSubscribeUserAction.setEnabled(false);
            return;
        }
        this.fSubscribeUserAction.setEnabled(true);
        boolean subscribed = this.fWorkingCopy.getWorkItem().getSubscriptions().contains((IContributorHandle)user);
        if (!subscribed && !ADD_SELF_DESCRIPTOR.equals(this.fSubscribeUserAction.getImageDescriptor())) {
            this.fSubscribeUserAction.setText(SUBSCRIBE_ME_TEXT);
            this.fSubscribeUserAction.setToolTipText(SUBSCRIBE_ME_TEXT);
            this.fSubscribeUserAction.setImageDescriptor(ADD_SELF_DESCRIPTOR);
        } else if (subscribed && !REMOVE_SELF_DESCRIPTOR.equals(this.fSubscribeUserAction.getImageDescriptor())) {
            this.fSubscribeUserAction.setText(UNSUBSCRIBE_ME_TEXT);
            this.fSubscribeUserAction.setToolTipText(UNSUBSCRIBE_ME_TEXT);
            this.fSubscribeUserAction.setImageDescriptor(REMOVE_SELF_DESCRIPTOR);
        }
    }

    private void toggleSubscribeUser() {
        if (this.fWorkingCopy == null) {
            return;
        }
        FoundationUIUtils.validateRepository((ITeamRepository)this.fWorkingCopy.getTeamRepository(), (boolean)true, null);
        IContributor user = this.fWorkingCopy.getTeamRepository().loggedInContributor();
        if (user == null) {
            return;
        }
        ISubscriptions subscriptions = this.fWorkingCopy.getWorkItem().getSubscriptions();
        if (!subscriptions.contains((IContributorHandle)user)) {
            subscriptions.add((IContributorHandle)user);
        } else {
            subscriptions.remove((IContributorHandle)user);
        }
    }

    private void refreshFromRepository() {
        IEditorPart editor;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window != null ? window.getActivePage() : null;
        IEditorPart iEditorPart = editor = page != null ? page.getActiveEditor() : null;
        if (editor instanceof WorkItemEditor) {
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            try {
                progressService.runInUI((IRunnableContext)window, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        if (TitlePart.this.fWorkingCopy != null) {
                            FoundationUIUtils.validateRepository((ITeamRepository)TitlePart.this.fWorkingCopy.getTeamRepository(), (boolean)true, (IProgressMonitor)monitor);
                        }
                        ((WorkItemEditor)editor).doRefresh(monitor);
                    }
                }, null);
            }
            catch (InvocationTargetException x) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.TitlePart_ERROR_REFRESHING_EDITOR, x);
            }
            catch (InterruptedException x) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.TitlePart_ERROR_REFRESHING_EDITOR, x);
            }
        }
    }

    public void setInput(Object input) {
        this.fWorkingCopy = null;
        this.fPartialWorkItem = null;
        this.fSuppressDialog = false;
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)((Object)input)).isResolved()) {
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)((Object)input);
            this.fWorkingCopy = workItemEditorInput.getWorkingCopy();
        } else if (input instanceof AbstractWorkItemEditorInput) {
            IWorkItemHandle handle = ((AbstractWorkItemEditorInput)((Object)input)).getWorkItemHandle();
            IAuditableClient auditableClient = (IAuditableClient)((ITeamRepository)handle.getOrigin()).getClientLibrary(IAuditableClient.class);
            this.fPartialWorkItem = (IWorkItem)auditableClient.findCachedAuditable((IAuditableHandle)handle, IWorkItem.SMALL_PROFILE);
            if (this.fPartialWorkItem == null && handle instanceof IWorkItem && IWorkItem.SMALL_PROFILE.isMatched((IAuditable)((IWorkItem)handle))) {
                this.fPartialWorkItem = (IWorkItem)handle;
            }
            if (input instanceof WorkItemEditor.WorkItemEditorInputError) {
                this.fSuppressDialog = ((WorkItemEditor.WorkItemEditorInputError)((Object)input)).isSuppressDialog();
            }
        }
        this.updateTitle(input instanceof WorkItemEditor.WorkItemEditorInputError);
        this.updateSubscribeUserAction();
        this.fFindDuplicatesAction.setInput(this.fWorkingCopy);
        this.fExtractWorkItemAction.update();
        this.updateChangeIndication();
    }

    private void updateChangeIndication() {
        String text;
        boolean isStale = this.fWorkingCopy != null ? this.fWorkingCopy.isStale() : false;
        boolean isDirty = this.fWorkingCopy != null ? this.fWorkingCopy.isDirty() : false;
        String string = text = isDirty ? DISCARD_TEXT : REFRESH_TEXT;
        if (isStale) {
            text = NLS.bind((String)Messages.TitlePart_UPDATE_AVAILABLE, (Object)text, (Object[])new Object[0]);
        }
        this.fRefreshAction.setToolTipText(text);
        if (isStale) {
            if (this.fHyperlinkListener == null || this.fHyperlinkListener instanceof RefreshListener || this.fHyperlinkListener instanceof ShowCommentListener) {
                this.setStatus("", (IDetailedStatus)new DetailedStatus(2, "com.ibm.team.workitem.ide.ui", 70002, isDirty ? DISCARD_MESSAGE : REFRESH_MESSAGE, null));
            }
        } else if (this.fHyperlinkListener instanceof RefreshListener) {
            this.clearStatus();
        }
    }

    private void handleRemoteChange(WorkItemChangeEvent event) {
        if (this.fHyperlinkListener != null) {
            return;
        }
        if (event.getAttributeChangeType(IWorkItem.COMMENTS_PROPERTY) == 2) {
            ITeamRepository teamRepository = (ITeamRepository)event.getWorkItem().getOrigin();
            CommentsChangeDetails details = (CommentsChangeDetails)event.getAttributeChangeDetails(IWorkItem.COMMENTS_PROPERTY, CommentsChangeDetails.class);
            IContributor user = teamRepository.loggedInContributor();
            if (details == null || user == null || !user.sameItemId((IItemHandle)details.getComment().getCreator())) {
                DetailedStatus status = new DetailedStatus(1, "com.ibm.team.workitem.ide.ui", 70003, COMMENT_ADDED_MESSAGE, null);
                if (details != null) {
                    status.setData((Object)details.getComment());
                }
                this.setStatus("", (IDetailedStatus)status);
            }
        }
    }

    public void setStatus(String operationName, IDetailedStatus status) {
        this.fStatus = status;
        this.disposeTooltip();
        IMessageManager messageManager = this.fEditor.getHeaderForm().getMessageManager();
        messageManager.removeAllMessages();
        if (this.fHyperlinkListener != null) {
            this.fTitleForm.removeMessageHyperlinkListener(this.fHyperlinkListener);
            this.fHyperlinkListener = null;
        }
        if (status != null) {
            if (status.getException() instanceof TeamOperationCanceledException) {
                TeamOperationCanceledException x = (TeamOperationCanceledException)status.getException();
                this.showParticipantInfos(messageManager, operationName, x.getReport(), (IStatus)status);
            } else if (status.getOperationReport() != null) {
                this.showParticipantInfos(messageManager, operationName, status.getOperationReport(), (IStatus)status);
            } else {
                this.showStatus(messageManager, operationName, (IStatus)status);
            }
        }
    }

    public IDetailedStatus getStatus() {
        return this.fStatus;
    }

    public void clearStatus() {
        this.setStatus("", null);
    }

    private void showParticipantInfos(IMessageManager messageManager, String operationName, IOperationReport report, IStatus status) {
        List infos = WorkItemProcessUtils.getAllReportInfos((IProcessReport)report);
        if (!infos.isEmpty()) {
            this.showParticipantInfos(messageManager, infos);
        } else {
            this.showStatus(messageManager, operationName, status);
        }
    }

    private void showParticipantInfos(IMessageManager messageManager, List<IReportInfo> infos) {
        this.fHyperlinkListener = new ShowAdvisorListener(this.fEditor.getSite().getPage());
        this.fTitleForm.addMessageHyperlinkListener(this.fHyperlinkListener);
        infos = new ArrayList<IReportInfo>(infos);
        Collections.sort(infos, new Comparator<IReportInfo>(){

            @Override
            public int compare(IReportInfo o1, IReportInfo o2) {
                int result = o2.getSeverity() - o1.getSeverity();
                if (result == 0) {
                    result = Collator.getInstance().compare(o1.getSummary(), o2.getSummary());
                }
                return result;
            }
        });
        for (IReportInfo info : infos) {
            messageManager.addMessage((Object)info, this.getInfoSummary(info), null, this.getMessageType(info));
        }
    }

    private String getInfoSummary(IReportInfo info) {
        if (info instanceof IAdvisorInfo && "com.ibm.team.workitem.advisor.requiredProperties".equals(info.getIdentifier())) {
            try {
                if (this.fWorkingCopy.getWorkItem().isNewItem() && RequiredPropertiesAdvisor.isNewItem((IReportInfo)info) || this.fWorkingCopy.getWorkItem().getItemId().equals((Object)RequiredPropertiesAdvisor.getWorkItemItemId((IReportInfo)info))) {
                    return info.getSummary();
                }
                return NLS.bind((String)Messages.TitlePart_SAVING_AFFECTS, (Object)(RequiredPropertiesAdvisor.isNewItem((IReportInfo)info) ? Messages.TitlePart_UNSAVED_ITEM : Integer.valueOf(RequiredPropertiesAdvisor.getWorkItemId((IReportInfo)info))), (Object[])new Object[]{info.getSummary()});
            }
            catch (Exception exception) {}
        }
        return info.getSummary();
    }

    private int getMessageType(IReportInfo info) {
        int type;
        switch (info.getSeverity()) {
            case 4: {
                type = 3;
                break;
            }
            case 2: {
                type = 2;
                break;
            }
            case 0: {
                type = 1;
                break;
            }
            default: {
                type = 0;
            }
        }
        return type;
    }

    private void showStatus(IMessageManager messageManager, String operationName, IStatus status) {
        if (status.isOK()) {
            return;
        }
        if (status.getCode() == 70000) {
            this.fHyperlinkListener = new AddDuplicateListener(this.fEditor.getSite().getShell(), this.fWorkingCopy);
            this.fTitleForm.addMessageHyperlinkListener(this.fHyperlinkListener);
            messageManager.addMessage((Object)status, status.getMessage(), null, Utils.getMessageProviderType((IStatus)status));
        } else if (status.getCode() == 70001) {
            this.fHyperlinkListener = new SetDefaultTeamAreaListener(this.fEditor.getSite().getShell(), this.fWorkingCopy);
            this.fTitleForm.addMessageHyperlinkListener(this.fHyperlinkListener);
            messageManager.addMessage((Object)status, status.getMessage(), null, Utils.getMessageProviderType((IStatus)status));
        } else if (status.getCode() == 70002) {
            this.fHyperlinkListener = new RefreshListener();
            this.fTitleForm.addMessageHyperlinkListener(this.fHyperlinkListener);
            messageManager.addMessage((Object)status, status.getMessage(), null, Utils.getMessageProviderType((IStatus)status));
            this.addHistoryTooltip();
        } else if (status.getCode() == 70004) {
            this.fHyperlinkListener = new ShowCalmBackLinkProblem((IEditorPart)this.fEditor, operationName, status, this.fWorkingCopy);
            this.fTitleForm.addMessageHyperlinkListener(this.fHyperlinkListener);
            messageManager.addMessage((Object)status, ExceptionDescription.getContextSummary((int)status.getSeverity(), (String)operationName), null, Utils.getMessageProviderType((IStatus)status));
        } else if (status.getCode() == 70003) {
            if (status instanceof DetailedStatus && ((DetailedStatus)status).getData() instanceof IComment) {
                this.fHyperlinkListener = new ShowCommentListener((IComment)((DetailedStatus)status).getData());
                this.fTitleForm.addMessageHyperlinkListener(this.fHyperlinkListener);
            }
            messageManager.addMessage((Object)status, status.getMessage(), null, Utils.getMessageProviderType((IStatus)status));
        } else if (status.getCode() == 70005) {
            this.fHyperlinkListener = new UpdateEditorLayoutListener();
            this.fTitleForm.addMessageHyperlinkListener(this.fHyperlinkListener);
            messageManager.addMessage((Object)status, status.getMessage(), null, Utils.getMessageProviderType((IStatus)status));
        } else if (status.getException() instanceof PermissionDeniedException) {
            this.fHyperlinkListener = new ShowStatusListener(this.fEditor.getSite().getWorkbenchWindow(), operationName, status);
            this.fTitleForm.addMessageHyperlinkListener(this.fHyperlinkListener);
            messageManager.addMessage((Object)status, status.getMessage(), null, Utils.getMessageProviderType((IStatus)status));
        } else {
            this.fHyperlinkListener = new ShowStatusListener(this.fEditor.getSite().getWorkbenchWindow(), operationName, status);
            this.fTitleForm.addMessageHyperlinkListener(this.fHyperlinkListener);
            messageManager.addMessage((Object)status, ExceptionDescription.getContextSummary((int)status.getSeverity(), (String)operationName), null, Utils.getMessageProviderType((IStatus)status));
            if (!this.fSuppressDialog && status.getSeverity() == 4) {
                ((ShowStatusListener)this.fHyperlinkListener).openDialog();
            }
        }
    }

    private void addHistoryTooltip() {
        Composite control = this.fEditor.getHeaderForm().getForm().getForm().getHead();
        Control messageControl = this.findMessageControl((Control)control);
        if (messageControl != null) {
            this.fTooltipSupport = new RemoteChangesTooltipSupport(messageControl){

                protected Object mapElement(int x, int y) {
                    return TitlePart.this.fWorkingCopy != null ? TitlePart.this.fWorkingCopy.getWorkItem() : null;
                }
            };
        }
    }

    private Control findMessageControl(Control control) {
        if (control instanceof Hyperlink) {
            return control;
        }
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                Control message = this.findMessageControl(child);
                if (message != null) {
                    return message;
                }
                ++n2;
            }
        }
        return null;
    }

    private void disposeTooltip() {
        if (this.fTooltipSupport != null) {
            this.fTooltipSupport.dispose();
            this.fTooltipSupport = null;
        }
    }

    public void dispose() {
        if (this.fEditor != null) {
            this.removeWorkItemListener();
            this.fEditor = null;
        }
        if (this.fLabelProviderListener != null) {
            this.fLabelProvider.removeListener(this.fLabelProviderListener);
            this.fLabelProviderListener = null;
        }
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
            this.fLabelProvider = null;
        }
        if (this.fHyperlinkListener != null) {
            this.fHyperlinkListener = null;
        }
        if (this.fFindDuplicatesAction != null) {
            this.fFindDuplicatesAction.dispose();
            this.fFindDuplicatesAction = null;
        }
        this.fExtractWorkItemAction = null;
        this.fTitleForm = null;
        this.fWorkingCopy = null;
    }

    private void addWorkItemListener() {
        UIWorkItemWorkingCopyListener uiCopyListener;
        UIWorkItemListener uiListener = (UIWorkItemListener)this.fEditor.getAdapter(UIWorkItemListener.class);
        if (uiListener != null) {
            uiListener.addListener((IWorkItemListener)this.fWorkItemListener, IWorkItem.ID_PROPERTY);
            uiListener.addListener((IWorkItemListener)this.fWorkItemListener, IWorkItem.TYPE_PROPERTY);
            uiListener.addListener((IWorkItemListener)this.fWorkItemListener, IWorkItem.SUBSCRIPTIONS_PROPERTY);
            uiListener.addListener((IWorkItemListener)this.fWorkItemListener, IWorkItem.COMMENTS_PROPERTY);
        }
        if ((uiCopyListener = (UIWorkItemWorkingCopyListener)this.fEditor.getAdapter(UIWorkItemWorkingCopyListener.class)) != null) {
            uiCopyListener.addListener((IWorkingCopyListener)this.fWorkItemListener);
        }
    }

    private void removeWorkItemListener() {
        UIWorkItemWorkingCopyListener uiCopyListener;
        UIWorkItemListener uiListener = (UIWorkItemListener)this.fEditor.getAdapter(UIWorkItemListener.class);
        if (uiListener != null) {
            uiListener.removeListener((IWorkItemListener)this.fWorkItemListener, IWorkItem.ID_PROPERTY);
            uiListener.removeListener((IWorkItemListener)this.fWorkItemListener, IWorkItem.TYPE_PROPERTY);
            uiListener.removeListener((IWorkItemListener)this.fWorkItemListener, IWorkItem.SUBSCRIPTIONS_PROPERTY);
            uiListener.removeListener((IWorkItemListener)this.fWorkItemListener, IWorkItem.COMMENTS_PROPERTY);
        }
        if ((uiCopyListener = (UIWorkItemWorkingCopyListener)this.fEditor.getAdapter(UIWorkItemWorkingCopyListener.class)) != null) {
            uiCopyListener.removeListener((IWorkingCopyListener)this.fWorkItemListener);
        }
    }

    private IWorkItem getElement() {
        if (this.fWorkingCopy != null) {
            return this.fWorkingCopy.getWorkItem();
        }
        if (this.fPartialWorkItem != null) {
            return this.fPartialWorkItem;
        }
        return null;
    }

    private static class AddDuplicateListener
    extends HyperlinkAdapter {
        private Shell fParentShell;
        private WorkItemWorkingCopy fWorkingCopy;

        public AddDuplicateListener(Shell parentShell, WorkItemWorkingCopy workingCopy) {
            this.fParentShell = parentShell;
            this.fWorkingCopy = workingCopy;
        }

        public void linkActivated(HyperlinkEvent e) {
            try {
                IEndPointDescriptor duplicateOfType = WorkItemEndPoints.DUPLICATE_OF_WORK_ITEM;
                IWorkItemReferences references = this.fWorkingCopy.getReferences();
                WorkItemSelectionDialog dialog = new WorkItemSelectionDialog(this.fParentShell, this.fWorkingCopy.getWorkItem().getProjectArea(), false);
                dialog.setExcluded(new IWorkItemHandle[]{this.fWorkingCopy.getWorkItem()});
                IWorkItemHandle handle = dialog.getSingleWorkItem();
                if (handle == null) {
                    return;
                }
                List contents = references.getReferences(duplicateOfType);
                for (IReference reference : contents) {
                    references.remove(reference);
                }
                references.add(duplicateOfType, LinkHelper.createReference((IAuditableHandle)handle));
            }
            catch (TeamRepositoryException x) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.TitlePart_EXCEPTION_CREATING_LINK, x);
            }
        }
    }

    private class RefreshListener
    extends HyperlinkAdapter {
        private RefreshListener() {
        }

        public void linkActivated(HyperlinkEvent e) {
            TitlePart.this.refreshFromRepository();
        }
    }

    private static class SetDefaultTeamAreaListener
    extends HyperlinkAdapter {
        private Shell fParentShell;
        private WorkItemWorkingCopy fWorkingCopy;

        public SetDefaultTeamAreaListener(Shell parentShell, WorkItemWorkingCopy workingCopy) {
            this.fParentShell = parentShell;
            this.fWorkingCopy = workingCopy;
        }

        public void linkActivated(HyperlinkEvent e) {
            ProcessAreaSelectionDialog dialog = new ProcessAreaSelectionDialog(this.fParentShell, true){

                protected Label createMessageArea(Composite composite) {
                    Composite container = new Composite(composite, 0){

                        public Point computeSize(int hint, int hint2, boolean changed) {
                            Point size = super.computeSize(hint, hint2, changed);
                            size.x = 100;
                            return size;
                        }
                    };
                    container.setLayout((Layout)new FillLayout());
                    container.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                    Label label = new Label(container, 64);
                    if (this.getMessage() != null) {
                        label.setText(this.getMessage());
                    }
                    label.setFont(composite.getFont());
                    return label;
                }
            };
            dialog.setMessage(String.valueOf(Messages.TitlePart_NO_TEAM_AREA_ASSOCIATED) + Messages.TitlePart_MORE_FINE_GRADE_ASSOCIATIONS_AVAILABLE + Messages.TitlePart_SELECT_TEAM_AREA);
            dialog.setInput((Object)this.fWorkingCopy.getWorkItem().getProjectArea());
            if (dialog.open() == 0 && dialog.getSelectedProcessArea() != null) {
                final ITeamArea teamArea = (ITeamArea)dialog.getSelectedProcessArea();
                FoundationJob job = new FoundationJob(Messages.TitlePart_SETTING_TEAM_AREA){

                    protected IStatus runProtected(IProgressMonitor monitor) {
                        try {
                            IWorkItemClient workItemClient = (IWorkItemClient)SetDefaultTeamAreaListener.this.fWorkingCopy.getTeamRepository().getClientLibrary(IWorkItemClient.class);
                            workItemClient.setDefaultTeamArea((ITeamAreaHandle)teamArea, monitor);
                        }
                        catch (TeamRepositoryException x) {
                            return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.TitlePart_ERROR_SETTING_TEAM_AREA, (Throwable)x);
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(true);
                job.schedule();
            }
        }
    }

    private static class ShowAdvisorListener
    extends HyperlinkAdapter {
        private static final String OPERATION_ADVICE_VIEW_ID = "com.ibm.team.process.operationAdviceView";
        private IWorkbenchPage fPage;

        public ShowAdvisorListener(IWorkbenchPage page) {
            this.fPage = page;
        }

        public void linkActivated(HyperlinkEvent e) {
            try {
                this.fPage.showView(OPERATION_ADVICE_VIEW_ID);
            }
            catch (PartInitException x) {
                String message = Messages.TitlePart_EXCEPTION_ACTIVATING_VIEW;
                WorkItemIDEUIPlugin.getDefault().log(message, x);
                ErrorDialog.openError((Shell)this.fPage.getWorkbenchWindow().getShell(), (String)Messages.TitlePart_PROBLEM_ACTIVATING_VIEW, (String)message, (IStatus)new Status(4, "com.ibm.team.workitem.ide.ui", message));
            }
        }
    }

    private static class ShowCalmBackLinkProblem
    extends HyperlinkAdapter {
        private final IEditorPart fEditor;
        private final String fOperationName;
        private final IStatus fStatus;
        private final WorkItemWorkingCopy fWorkingCopy;

        public ShowCalmBackLinkProblem(IEditorPart editor, String operationName, IStatus status, WorkItemWorkingCopy workingCopy) {
            this.fEditor = editor;
            this.fOperationName = operationName;
            this.fStatus = status;
            this.fWorkingCopy = workingCopy;
        }

        public void linkActivated(HyperlinkEvent e) {
            this.openDialog();
        }

        public void openDialog() {
            CALMBackLinkProblemDialog dialog = new CALMBackLinkProblemDialog(this.fEditor.getSite().getShell(), this.fOperationName, this.fStatus);
            if (dialog.open() == 0) {
                if (dialog.getSaveStrategy() == CALMBackLinkProblemDialog.SaveStrategy.IGNORE_BACKLINKS) {
                    this.fWorkingCopy.getAdditionalSaveParameters().add("com.ibm.team.workitem.common.internal.util.ignoreBacklinkProblems");
                } else if (dialog.getSaveStrategy() == CALMBackLinkProblemDialog.SaveStrategy.REVERT_LINKS) {
                    IWorkItemReferences references = this.fWorkingCopy.getReferences();
                    List endPointDescriptors = CALMLinkType.getCALMEndPointDescriptors();
                    for (IEndPointDescriptor desc : endPointDescriptors) {
                        for (IReference ref : references.getCreatedReferences(desc)) {
                            references.remove(ref);
                        }
                        for (IReference ref : references.getDeletedReferences(desc)) {
                            references.add(desc, ref);
                        }
                    }
                }
                this.fEditor.getSite().getPage().saveEditor(this.fEditor, false);
            }
        }
    }

    private class ShowCommentListener
    extends HyperlinkAdapter {
        private IComment fComment;

        public ShowCommentListener(IComment comment) {
            this.fComment = comment;
        }

        public void linkActivated(HyperlinkEvent e) {
            WorkItem workItem;
            int index;
            if (TitlePart.this.fHyperlinkListener == this) {
                TitlePart.this.clearStatus();
            }
            if (((EObject)this.fComment).eContainer() instanceof IWorkItem && (index = (workItem = (WorkItem)((EObject)this.fComment).eContainer()).getInternalComments().indexOf(this.fComment)) != -1) {
                URI uri = URIService.createWorkItemCommentURI((IWorkItemHandle)workItem, (int)index);
                Hyperlinks.open((URI)uri, null);
            }
        }
    }

    private static class ShowStatusListener
    extends HyperlinkAdapter {
        private IWorkbenchWindow fWindow;
        private String fOperationName;
        private IStatus fStatus;

        public ShowStatusListener(IWorkbenchWindow window, String operationName, IStatus status) {
            this.fWindow = window;
            this.fOperationName = operationName;
            this.fStatus = status;
        }

        public void linkActivated(HyperlinkEvent e) {
            this.openDialog();
        }

        public void openDialog() {
            IStatus status = this.fStatus;
            if (status.getChildren().length > 0 && (status.getChildren()[0].getSeverity() == 4 || status.getChildren()[0].getSeverity() == 8)) {
                IStatus mainStatus = status.getChildren()[0];
                status = new MultiStatus(mainStatus.getPlugin(), mainStatus.getCode(), status.getChildren(), mainStatus.getMessage(), mainStatus.getException());
            }
            ExceptionDescriptionUI.handleStatus((IWorkbenchWindow)this.fWindow, (String)this.fOperationName, (IStatus)status);
        }
    }

    private class TitleSelectionProvider
    implements ISelectionProvider {
        private TitleSelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            IWorkItem workItem = TitlePart.this.getElement();
            if (workItem != null) {
                return new StructuredSelection((Object)workItem);
            }
            return StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }
    }

    private class UpdateEditorLayoutListener
    extends HyperlinkAdapter {
        private UpdateEditorLayoutListener() {
        }

        public void linkActivated(HyperlinkEvent e) {
            if (TitlePart.this.fEditor instanceof WorkItemEditor) {
                ((WorkItemEditor)TitlePart.this.fEditor).synchronizeWorkItem();
            }
            if (TitlePart.this.fHyperlinkListener == this) {
                TitlePart.this.clearStatus();
            }
        }
    }

    private class WorkItemListener
    implements IWorkItemListener,
    IWorkingCopyListener {
        private WorkItemListener() {
        }

        public void workItemAttributeChanged(WorkItemChangeEvent event) {
            if (!event.affects((IWorkItemHandle)TitlePart.this.fWorkingCopy.getWorkItem())) {
                return;
            }
            if (event.affects(IWorkItem.TYPE_PROPERTY) || event.affects(IWorkItem.ID_PROPERTY)) {
                TitlePart.this.updateTitle(false);
            }
            if (event.affects(IWorkItem.SUBSCRIPTIONS_PROPERTY)) {
                TitlePart.this.updateSubscribeUserAction();
            }
            TitlePart.this.handleRemoteChange(event);
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }

        public void workingCopyEvent(WorkingCopyEvent event) {
            if (event.getSource() != TitlePart.this.fWorkingCopy) {
                return;
            }
            if (event.hasType("staleState") || event.hasType("dirtyState")) {
                TitlePart.this.updateChangeIndication();
            }
        }
    }
}

