/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.part;

import com.ibm.icu.text.Collator;
import com.ibm.team.collaboration.core.CollaborationCore;
import com.ibm.team.collaboration.core.session.CollaborationPresenceEvent;
import com.ibm.team.collaboration.core.session.CollaborationPresenceStatus;
import com.ibm.team.collaboration.core.session.ICollaborationPresenceListener;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.jface.viewerutilities.SelectionProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.URIService;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.part.ItemizedQuickInformationEntry;
import com.ibm.team.workitem.ide.ui.internal.editor.part.LinksSummaryPart;
import com.ibm.team.workitem.ide.ui.internal.editor.part.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.SubscriberUtil;
import com.ibm.team.workitem.rcp.ui.UIWorkItemListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriberQuickInformationEntry
extends ItemizedQuickInformationEntry<IContributor> {
    private HashMap<UUID, IContributor> fSubscribers = new HashMap();
    private HashMap<UUID, CollaborationPresenceStatus> fPresenceStatus = new HashMap();
    private IHyperlinkListener fURILinks;
    private SubscriberJob fSubscriberJob;
    private final Object fSLock = new Object();
    private WorkItemListener fWorkItemListener = new WorkItemListener();
    private UIWorkItemListener fUIListener;

    public SubscriberQuickInformationEntry(LinksSummaryPart part) {
        super(part);
        this.fURILinks = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (e.getHref() instanceof URI) {
                    Hyperlinks.openHyperlink((URI)((URI)e.getHref()));
                }
            }
        };
    }

    @Override
    public void initialize(WorkItemWorkingCopy workingCopy) {
        super.initialize(workingCopy);
        this.fUIListener = (UIWorkItemListener)this.getPart().getSite().getAdapter(UIWorkItemListener.class);
        if (this.fUIListener != null) {
            this.fUIListener.addListener((IWorkItemListener)this.fWorkItemListener, IWorkItem.SUBSCRIPTIONS_PROPERTY);
        }
        CollaborationCore.getCollaborationService().addPresenceListener((ICollaborationPresenceListener)this.fWorkItemListener);
        this.updateSubscriptions();
    }

    @Override
    public void dispose() {
        if (this.fUIListener != null) {
            this.fUIListener.removeListener((IWorkItemListener)this.fWorkItemListener, IWorkItem.SUBSCRIPTIONS_PROPERTY);
            this.fUIListener = null;
        }
        CollaborationCore.getCollaborationService().removePresenceListener((ICollaborationPresenceListener)this.fWorkItemListener);
    }

    @Override
    public void adaptElementLink(Hyperlink link, final IContributor element) {
        CollaborationPresenceStatus status = this.fPresenceStatus.get(element.getItemId());
        if (status != null && status.isActive()) {
            this.getPart().getPresentGroup().add(link);
        } else {
            this.getPart().getLinkGroup().add(link);
        }
        URI uri = URIService.createAuditableURI((ITeamRepository)this.getWorkingCopy().getTeamRepository(), (IItemHandle)element);
        link.setHref((Object)uri);
        link.addHyperlinkListener(this.fURILinks);
        new TooltipSupport((Control)link, true, false){

            protected Object mapElement(int x, int y) {
                return element;
            }
        };
        SelectionProvider selectionProvider = new SelectionProvider(){

            public ISelection getSelection() {
                return element == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)element);
            }
        };
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        Action removeSubscriberAction = new Action(Messages.SubscriberQuickInformationEntry_REMOVE){

            public void run() {
                SubscriberQuickInformationEntry.this.getWorkingCopy().getWorkItem().getSubscriptions().remove((IContributorHandle)element);
            }
        };
        menuMgr.addMenuListener(new IMenuListener((IAction)removeSubscriberAction){
            private final /* synthetic */ IAction val$removeSubscriberAction;
            {
                this.val$removeSubscriberAction = iAction;
            }

            public void menuAboutToShow(IMenuManager manager) {
                manager.add(this.val$removeSubscriberAction);
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.getPart().getSite().registerContextMenu(this.getPart().getId(), menuMgr, (ISelectionProvider)selectionProvider);
        Menu menu = menuMgr.createContextMenu((Control)link);
        link.setMenu(menu);
        new ItemizedQuickInformationEntry.ItemDragSupport((Control)link, (IItemHandle)element);
    }

    @Override
    public void adaptTitleLink(Hyperlink titleLink, Label imageLabel) {
        this.getPart().getLinkGroup().add(titleLink);
        titleLink.addHyperlinkListener(this.getLinksPageActivator());
        this.addSubscriberDropTarget((Control)titleLink);
        this.addSubscriberDropTarget((Control)imageLabel);
        new SubscriberSummaryTooltipSupport((Control)titleLink, this.getTitle(), this.getElements(), this.getWorkingCopy(), this.fPresenceStatus);
        new SubscriberSummaryTooltipSupport((Control)imageLabel, this.getTitle(), this.getElements(), this.getWorkingCopy(), this.fPresenceStatus);
        this.createSubscriberContextMenu((Control)titleLink);
        this.createSubscriberContextMenu((Control)imageLabel);
    }

    @Override
    public void adaptLDotsLink(Hyperlink link) {
        this.getPart().getLinkGroup().add(link);
        link.addHyperlinkListener(this.getLinksPageActivator());
        new SubscriberSummaryTooltipSupport((Control)link, Messages.SubscriberQuickInformationEntry_SUBSCRIBERS, this.getElements(), this.getWorkingCopy(), this.fPresenceStatus);
    }

    @Override
    public List<IContributor> getElements() {
        IContributorHandle[] contribs = this.getWorkingCopy().getWorkItem().getSubscriptions().getContents();
        ArrayList<IContributor> contributors = new ArrayList<IContributor>();
        IContributorHandle[] iContributorHandleArray = contribs;
        int n = contribs.length;
        int n2 = 0;
        while (n2 < n) {
            IContributorHandle contrib = iContributorHandleArray[n2];
            IContributor c = this.fSubscribers.get(contrib.getItemId());
            if (c != null) {
                contributors.add(c);
            }
            ++n2;
        }
        Collections.sort(contributors, new Comparator<IContributor>(){

            @Override
            public int compare(IContributor o1, IContributor o2) {
                return Collator.getInstance().compare(o1.getName(), o2.getName());
            }
        });
        return contributors;
    }

    @Override
    public Image getImage() {
        return WorkItemIDEUIPlugin.getImage(ImagePool.SUBSCRIPTION);
    }

    @Override
    public String getShortIdentifier(IContributor element) {
        String name = element.getName();
        String[] initials = name.split("[ \\-_\\.]");
        StringBuffer linkText = new StringBuffer();
        int i = 0;
        while (i < initials.length) {
            if (initials[i].length() > 0) {
                linkText.append(initials[i].charAt(0));
            }
            ++i;
        }
        return linkText.toString();
    }

    @Override
    public String getTitle() {
        return Messages.SubscriberQuickInformationEntry_SUBSCRIBERS;
    }

    private void updateSubscriptions() {
        if (this.fSubscriberJob == null) {
            this.fSubscriberJob = new SubscriberJob(Messages.SubscriberQuickInformationEntry_RESOLVING_SUBSCRIBERS);
        }
        this.fSubscriberJob.schedule();
    }

    private void addSubscriberDropTarget(final Control control) {
        DropTarget target = new DropTarget(control, 5);
        target.setTransfer(new Transfer[]{LocalSelectionTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new SubscriberUtil.SubscriberDropListener(){

            public void dragEnter(DropTargetEvent event) {
                super.dragEnter(event);
                if (control instanceof Hyperlink && event.detail != 0) {
                    ((Hyperlink)control).setUnderlined(true);
                }
            }

            public void dragLeave(DropTargetEvent event) {
                super.dragLeave(event);
                if (control instanceof Hyperlink) {
                    ((Hyperlink)control).setUnderlined(false);
                }
            }

            protected WorkItemWorkingCopy getWorkingCopy() {
                return SubscriberQuickInformationEntry.this.getWorkingCopy();
            }
        });
    }

    private void createSubscriberContextMenu(Control control) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        SelectionProvider selectionProvider = new SelectionProvider(){

            public ISelection getSelection() {
                return StructuredSelection.EMPTY;
            }
        };
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)new SubscriberUtil.AddSubscriberAction(SubscriberQuickInformationEntry.this.getWorkingCopy(), Messages.SubscriberQuickInformationEntry_ADD));
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.getPart().getSite().registerContextMenu(this.getPart().getId(), menuMgr, (ISelectionProvider)selectionProvider);
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
    }

    private class SubscriberJob
    extends UIUpdaterJob {
        public SubscriberJob(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInBackground(IProgressMonitor monitor) {
            if (SubscriberQuickInformationEntry.this.getWorkingCopy() != null) {
                IAuditableClient auditableClient = (IAuditableClient)((ITeamRepository)SubscriberQuickInformationEntry.this.getWorkingCopy().getWorkItem().getOrigin()).getClientLibrary(IAuditableClient.class);
                try {
                    ArrayList<IContributorHandle> toResolve = new ArrayList<IContributorHandle>(Arrays.asList(SubscriberQuickInformationEntry.this.getWorkingCopy().getWorkItem().getSubscriptions().getContents()));
                    List resolved = auditableClient.resolveAuditables(toResolve, ItemProfile.CONTRIBUTOR_DEFAULT, monitor);
                    Object object = SubscriberQuickInformationEntry.this.fSLock;
                    synchronized (object) {
                        SubscriberQuickInformationEntry.this.fSubscribers = new HashMap();
                        for (IContributor contrib : resolved) {
                            if (contrib == null) continue;
                            SubscriberQuickInformationEntry.this.fSubscribers.put(contrib.getItemId(), contrib);
                            CollaborationPresenceStatus status = CollaborationCore.getCollaborationService().getPresenceStatus((IContributorHandle)contrib, monitor);
                            if (status == null) continue;
                            SubscriberQuickInformationEntry.this.fPresenceStatus.put(contrib.getItemId(), status);
                        }
                    }
                }
                catch (TeamRepositoryException e) {
                    WorkItemIDEUIPlugin.getDefault().log(Messages.SubscriberQuickInformationEntry_ERROR_RESOLVING_SUBSCRIBERS, e);
                }
            }
            return super.runInBackground(monitor);
        }

        public IStatus runInUI(IProgressMonitor monitor) {
            SubscriberQuickInformationEntry.this.getPart().updateItems();
            return super.runInUI(monitor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SubscriberSummaryTooltipSupport
    extends TooltipSupport {
        private List<IContributor> fReferences;
        private String fTitle;
        private WorkItemWorkingCopy fWorkingCopy;
        private StandardLabelProvider fStandardLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        private HashMap<UUID, CollaborationPresenceStatus> fPresenceStatus = new HashMap();

        public SubscriberSummaryTooltipSupport(Control control, String title, List<IContributor> references, WorkItemWorkingCopy workingCopy, HashMap<UUID, CollaborationPresenceStatus> presenceStatus) {
            super(control, true, false);
            control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    if (SubscriberSummaryTooltipSupport.this.fStandardLabelProvider != null) {
                        SubscriberSummaryTooltipSupport.this.fStandardLabelProvider.dispose();
                        SubscriberSummaryTooltipSupport.this.fStandardLabelProvider = null;
                    }
                }
            });
            this.fTitle = title;
            this.fWorkingCopy = workingCopy;
            this.fReferences = references;
            this.fPresenceStatus = presenceStatus;
        }

        protected Object mapElement(int x, int y) {
            return this.fReferences;
        }

        protected String getMarkup(Object element, boolean isFocus) {
            StringBuffer result = new StringBuffer();
            result.append("<ul>");
            for (IContributor r : this.fReferences) {
                if (!(r instanceof IContributor)) continue;
                if (isFocus && this.fWorkingCopy != null) {
                    String uri = URIService.createAuditableURI((ITeamRepository)((ITeamRepository)this.fWorkingCopy.getWorkItem().getOrigin()), (Object)r).toString();
                    CollaborationPresenceStatus status = this.fPresenceStatus.get(r.getItemId());
                    String color = "";
                    if (status != null && status.isActive()) {
                        color = "style='color:#008000'";
                    }
                    result.append("<li><a " + color + " href='" + uri + "'>" + this.fStandardLabelProvider.getText((Object)r) + "</a></li>");
                    continue;
                }
                result.append("<li>" + this.fStandardLabelProvider.getText((Object)r) + "</li>");
            }
            result.append("</ul>");
            StringBuffer title = new StringBuffer();
            title.append("<b>" + this.fTitle + ": " + this.fReferences.size() + "</b><br />");
            return String.valueOf(title.toString()) + result.toString();
        }
    }

    private class WorkItemListener
    implements IWorkItemListener,
    ICollaborationPresenceListener {
        private WorkItemListener() {
        }

        public void presenceNotification(CollaborationPresenceEvent event) {
            if (SubscriberQuickInformationEntry.this.fSubscribers.keySet().contains(event.getUser().getUUID())) {
                SubscriberQuickInformationEntry.this.updateSubscriptions();
            }
        }

        public void workItemAttributeChanged(WorkItemChangeEvent event) {
            if (!event.affects((IWorkItemHandle)SubscriberQuickInformationEntry.this.getWorkingCopy().getWorkItem())) {
                return;
            }
            if (event.affects(IWorkItem.SUBSCRIPTIONS_PROPERTY)) {
                SubscriberQuickInformationEntry.this.updateSubscriptions();
            }
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }
    }
}

