/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.part;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.workitem.client.IWorkingCopyListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkingCopyEvent;
import com.ibm.team.workitem.client.internal.util.WorkItemEventResolver;
import com.ibm.team.workitem.common.internal.WorkflowUtil;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedCombo;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedControl;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.part.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationPart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.AbstractPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.UIWorkItemWorkingCopyListener;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class StatePart
extends PresentationPart {
    public static final String PART_ID = "com.ibm.team.workitem.ide.ui.editor.part.state";
    private static final String UNINITIALIZED = Messages.StatePart_UNINITIALIZED;
    private WorkItemWorkingCopy fWorkingCopy;
    private WorkItemListener fWorkItemListener = new WorkItemListener();
    private ResourceManager fResourceManager;
    private DecoratedCombo fCombo;
    private StateAction[] fStates;
    private IPresentationUpdater fPresentationUpdater = new AbstractPresentationUpdater(){

        @Override
        public void attributeChanged(WorkItemChangeEvent event) {
            StatePart.this.updateStateValueSet();
            StatePart.this.readState();
        }

        @Override
        public void dependencyChanged(List<String> dependencies) {
            StatePart.this.updateStateValueSet();
            StatePart.this.readState();
        }
    };

    public void createContent(ITeamFormLayout formLayout) {
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        Composite parent = formLayout.getContainer();
        if (this.isLabelVisible()) {
            String label = this.getLabel();
            if (label == null) {
                label = Messages.StatePart_STATE;
            }
            Label name = toolkit.createLabel(parent, NLS.bind((String)ATTRNAME_COLON, (Object)label, (Object[])new Object[0]), 0, this.getBackgroundStyle());
            formLayout.add((Control)name, "label");
        }
        this.fCombo = new DecoratedCombo(parent, 8, 1);
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.fCombo.getCombo());
        toolkit.adapt((DecoratedControl)this.fCombo, true, false, this.getBackgroundStyle());
        Util.addWidthHint(this.fCombo.getLayoutControl());
        formLayout.add(this.fCombo.getLayoutControl(), "content");
        this.fCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (StatePart.this.fWorkingCopy != null) {
                    StatePart.this.writeState();
                }
            }
        });
        this.fCombo.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof StateAction) {
                    String name = ((StateAction)element).getName();
                    if (name == null) {
                        name = ((StateAction)element).getId();
                    }
                    return name;
                }
                if (element instanceof String) {
                    return (String)element;
                }
                return "";
            }

            public Image getImage(Object element) {
                ImageDescriptor desc = ImagePool.EMPTY_ICON;
                if (element instanceof StateAction && ((StateAction)element).getImage() != null) {
                    return ((StateAction)element).getImage();
                }
                return JazzResources.getImageWithDefault((ResourceManager)StatePart.this.fResourceManager, (ImageDescriptor)desc);
            }
        });
        this.updateStateValueSet();
        this.readState();
    }

    public void setInput(Object input) {
        this.removeWorkItemListener();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)((Object)input)).isResolved()) {
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)((Object)input);
            this.fWorkingCopy = workItemEditorInput.getWorkingCopy();
            this.addWorkItemListener();
        } else {
            this.fWorkingCopy = null;
        }
        this.updateStateValueSet();
        this.readState();
    }

    public void dispose() {
        this.removeWorkItemListener();
        this.fWorkingCopy = null;
        super.dispose();
    }

    private void addWorkItemListener() {
        PresentationHandlerManager mgr;
        UIWorkItemWorkingCopyListener uiWorkingCopyListener = (UIWorkItemWorkingCopyListener)this.getSite().getAdapter(UIWorkItemWorkingCopyListener.class);
        if (uiWorkingCopyListener != null) {
            uiWorkingCopyListener.addListener((IWorkingCopyListener)this.fWorkItemListener);
        }
        if ((mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            PresentationDescriptor desc = Util.addDependencies(this.getDescriptor(), WorkItemEventResolver.WORKFLOW_INFO_PROPERTY, IWorkItem.PROJECT_AREA_PROPERTY);
            desc.setAttributeId(WorkItemAttributes.STATE);
            mgr.addPresentationUpdater(this.fPresentationUpdater, desc);
        }
    }

    private void removeWorkItemListener() {
        if (this.getSite() != null) {
            PresentationHandlerManager mgr;
            UIWorkItemWorkingCopyListener uiWorkingCopyListener = (UIWorkItemWorkingCopyListener)this.getSite().getAdapter(UIWorkItemWorkingCopyListener.class);
            if (uiWorkingCopyListener != null) {
                uiWorkingCopyListener.removeListener((IWorkingCopyListener)this.fWorkItemListener);
            }
            if ((mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
                mgr.removePresentationUpdater(this.fPresentationUpdater);
            }
        }
    }

    private void updateStateValueSet() {
        if (this.fWorkingCopy != null) {
            this.createStateValueSet(this.fWorkingCopy.getWorkItem());
        } else {
            this.fStates = new StateAction[0];
            this.fCombo.setValueSet(new Object[0]);
        }
    }

    private void createStateValueSet(IWorkItem workItem) {
        WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
        IWorkflowInfo workflow = uiCopy.getResolvedWorkItem().getWorkflowInfo();
        Identifier state = workItem.getState2();
        if (workflow != null && !WorkflowUtil.validState((IWorkflowInfo)workflow, (IWorkItem)workItem, (String)this.fWorkingCopy.getWorkflowAction())) {
            state = null;
        }
        Identifier[] actionIds = null;
        actionIds = workflow != null && state != null ? workflow.getActionIds(state) : new Identifier[]{};
        ArrayList<StateAction> actions = new ArrayList<StateAction>(actionIds.length + 1);
        String name = null;
        if (workflow != null && state != null && (name = workflow.getStateName(state)) == null) {
            name = state.getStringIdentifier();
            this.fCombo.getCombo().setEnabled(false);
        }
        if (name == null) {
            name = UNINITIALIZED;
        }
        ImageDescriptor desc = null;
        if (workflow != null && state != null) {
            desc = WorkItemUI.getImageDescriptor((URL)workflow.getStateIconName(state));
        }
        Image image = JazzResources.getImage((ResourceManager)this.fResourceManager, desc, null);
        actions.add(new StateAction(null, name, image));
        if (actionIds != null && actionIds.length > 0) {
            int i = 0;
            while (i < actionIds.length) {
                Identifier actionId = actionIds[i];
                name = workflow.getActionName(actionId);
                desc = WorkItemUI.getImageDescriptor((URL)workflow.getActionIconName(actionId));
                image = JazzResources.getImage((ResourceManager)this.fResourceManager, (ImageDescriptor)desc, null);
                actions.add(new StateAction(actionId.getStringIdentifier(), name, image));
                ++i;
            }
        }
        this.fStates = actions.toArray(new StateAction[actions.size()]);
        this.fCombo.setValueSet((Object[])this.fStates);
        this.fCombo.getLayoutControl().getParent().getParent().layout();
    }

    private void readState() {
        if (this.fWorkingCopy != null) {
            this.selectState(this.fWorkingCopy.getWorkflowAction());
            this.setEnabled(this.fStates.length > 1);
        } else {
            this.setEnabled(false);
        }
    }

    private void selectState(String actionCode) {
        StateAction[] stateActionArray = this.fStates;
        int n = this.fStates.length;
        int n2 = 0;
        while (n2 < n) {
            StateAction s = stateActionArray[n2];
            if (this.equals(actionCode, s.getId())) {
                this.fCombo.setValue((Object)s);
                if (this.fStates.length == 1 && !UNINITIALIZED.equals(s.getName())) {
                    this.fCombo.getCombo().setToolTipText(s.getName());
                } else {
                    this.fCombo.getCombo().setToolTipText(null);
                }
                return;
            }
            ++n2;
        }
        this.fCombo.setValue((Object)UNINITIALIZED);
        this.fCombo.getCombo().setToolTipText(null);
    }

    private void setEnabled(boolean enabled) {
        this.fCombo.getCombo().setEnabled(enabled);
    }

    private boolean equals(String left, String right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        return left.equals(right);
    }

    public boolean stretchHorizontally() {
        return false;
    }

    private void writeState() {
        Object val = this.fCombo.getValue();
        if (val instanceof StateAction) {
            this.fWorkingCopy.setWorkflowAction(((StateAction)val).getId());
        }
    }

    private static class StateAction {
        private String fId;
        private String fName;
        private Image fImage;

        public StateAction(String id, String name, Image image) {
            this.fId = id;
            this.fName = name;
            this.fImage = image;
        }

        public String getId() {
            return this.fId;
        }

        public String getName() {
            return this.fName;
        }

        public Image getImage() {
            return this.fImage;
        }
    }

    private class WorkItemListener
    implements IWorkingCopyListener {
        private WorkItemListener() {
        }

        public void workingCopyEvent(WorkingCopyEvent event) {
            if (event.hasType("workflowAction")) {
                StatePart.this.readState();
            } else if (event.hasType("dirtyState") && StatePart.this.fWorkingCopy != null && !StatePart.this.fWorkingCopy.isDirty()) {
                StatePart.this.updateStateValueSet();
                StatePart.this.readState();
            }
        }
    }
}

