/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.part;

import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.URIService;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ReferencesChangeDetails;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import com.ibm.team.workitem.ide.ui.internal.LinkLabelProvider;
import com.ibm.team.workitem.ide.ui.internal.editor.links.LinkContentProvider;
import com.ibm.team.workitem.ide.ui.internal.editor.part.ItemizedQuickInformationEntry;
import com.ibm.team.workitem.ide.ui.internal.editor.part.LinksSummaryPart;
import com.ibm.team.workitem.rcp.ui.UIWorkItemListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.Hyperlink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceQuickInformationEntry
extends ItemizedQuickInformationEntry<IReference> {
    private IEndPointDescriptor fEndPoint;
    private LinkContentProvider fLinkContentProvider = new LinkContentProvider(true);
    private LinkLabelProvider fLinkLabelProvider = new LinkLabelProvider();
    private WorkItemListener fWorkItemListener = new WorkItemListener();
    private UIWorkItemListener fUIListener;

    public ReferenceQuickInformationEntry(LinksSummaryPart part, IEndPointDescriptor endPoint) {
        super(part);
        this.fEndPoint = endPoint;
    }

    @Override
    public void adaptElementLink(Hyperlink link, IReference element) {
    }

    @Override
    public void adaptLDotsLink(Hyperlink link) {
    }

    @Override
    public void adaptTitleLink(Hyperlink titleLink, Label imageLabel) {
        this.getPart().getLinkGroup().add(titleLink);
        titleLink.addHyperlinkListener(this.getLinksPageActivator());
        new ReferenceToolTipSupport((Control)titleLink, this.getTitle(), this.getElements());
        new ReferenceToolTipSupport((Control)imageLabel, this.getTitle(), this.getElements());
        this.getPart().addInvalidDropTarget((Control)titleLink);
        this.getPart().addInvalidDropTarget((Control)imageLabel);
    }

    @Override
    public void dispose() {
        if (this.fLinkContentProvider != null) {
            this.fLinkContentProvider.dispose();
            this.fLinkContentProvider = null;
        }
        if (this.fLinkLabelProvider != null) {
            this.fLinkLabelProvider.dispose();
            this.fLinkLabelProvider = null;
        }
        if (this.fUIListener != null) {
            this.fUIListener.removeListener((IWorkItemListener)this.fWorkItemListener, "references");
            this.fUIListener = null;
        }
    }

    @Override
    public List<IReference> getElements() {
        ArrayList<IReference> references = new ArrayList<IReference>();
        Object[] objectArray = this.fLinkContentProvider.getChildren(this.fEndPoint);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof IReference) {
                references.add((IReference)o);
            }
            ++n2;
        }
        return references;
    }

    @Override
    public Image getImage() {
        return this.fLinkLabelProvider.getColumnImage(this.fEndPoint, 0);
    }

    @Override
    public String getShortIdentifier(IReference element) {
        return null;
    }

    @Override
    public String getTitle() {
        return this.fEndPoint.getDisplayName();
    }

    @Override
    public void initialize(WorkItemWorkingCopy workingCopy) {
        super.initialize(workingCopy);
        this.fLinkContentProvider.inputChanged(null, null, workingCopy);
        this.fUIListener = (UIWorkItemListener)this.getPart().getSite().getAdapter(UIWorkItemListener.class);
        if (this.fUIListener != null) {
            this.fUIListener.addListener((IWorkItemListener)this.fWorkItemListener, "references");
        }
        this.getPart().updateItems();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReferenceToolTipSupport
    extends TooltipSupport {
        private List<IReference> fReferences;
        private String fTitle;

        public ReferenceToolTipSupport(Control control, String title, List<IReference> references) {
            super(control, true, false);
            this.fTitle = title;
            this.fReferences = references;
        }

        protected Object mapElement(int x, int y) {
            return this.fReferences;
        }

        protected String getMarkup(Object element, boolean isFocus) {
            StringBuffer result = new StringBuffer();
            result.append("<ul>");
            for (IReference r : this.fReferences) {
                String uri = null;
                if (isFocus && ReferenceQuickInformationEntry.this.getWorkingCopy() != null) {
                    if (r.isItemReference()) {
                        if (((IItemReference)r).getReferencedItem() != null) {
                            uri = URIService.createAuditableURI((ITeamRepository)((ITeamRepository)ReferenceQuickInformationEntry.this.getWorkingCopy().getWorkItem().getOrigin()), (IItemHandle)((IItemReference)r).getReferencedItem()).toString();
                        }
                    } else if (r.isURIReference() && r.getLink() != null && r.getLink().getOrigin() != null) {
                        URI context = Location.itemLocation((IItemHandle)r.getLink(), (String)((ITeamRepository)r.getLink().getOrigin()).getRepositoryURI()).toAbsoluteUri();
                        uri = Hyperlinks.resolveURI((URI)((IURIReference)r).getURI(), (URI)context).toString();
                    }
                }
                String text = ReferenceQuickInformationEntry.this.fLinkLabelProvider.getText(r);
                if (uri == null) {
                    result.append(NLS.bind((String)"<li>{0}</li>", (Object)text, (Object[])new Object[0]));
                    continue;
                }
                result.append(NLS.bind((String)"<li><a href=''{0}''>{1}</a></li>", uri, (Object[])new Object[]{text}));
            }
            result.append("</ul>");
            String title = NLS.bind((String)"<b>{0}: {1}</b><br />", (Object)this.fTitle, (Object[])new Object[]{this.fReferences.size()});
            return String.valueOf(title) + result.toString();
        }
    }

    private class WorkItemListener
    implements IWorkItemListener {
        private WorkItemListener() {
        }

        public void workItemAttributeChanged(WorkItemChangeEvent event) {
            if (!event.affects((IWorkItemHandle)ReferenceQuickInformationEntry.this.getWorkingCopy().getWorkItem())) {
                return;
            }
            if (event.affects("references")) {
                IEndPointDescriptor desc;
                IAdaptable details = event.getAttributeChangeDetails("references");
                if (details == null) {
                    return;
                }
                ReferencesChangeDetails change = (ReferencesChangeDetails)details.getAdapter(ReferencesChangeDetails.class);
                if (change == null) {
                    return;
                }
                for (IReference ref : change.getAdded()) {
                    desc = WorkItemLinkTypes.getEndPointDescriptor((IReference)ref);
                    if (!desc.equals(ReferenceQuickInformationEntry.this.fEndPoint)) continue;
                    ReferenceQuickInformationEntry.this.getPart().updateItems();
                    return;
                }
                for (IReference ref : change.getRemoved()) {
                    desc = WorkItemLinkTypes.getEndPointDescriptor((IReference)ref);
                    if (!desc.equals(ReferenceQuickInformationEntry.this.fEndPoint)) continue;
                    ReferenceQuickInformationEntry.this.getPart().updateItems();
                    return;
                }
            }
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }
    }
}

