/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.part;

import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.editor.SimpleAction;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.part.Messages;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.QueriesUI;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class FindDuplicatesAction
extends SimpleAction {
    private IWorkbenchPage fPage;
    private WorkItemWorkingCopy fWorkingCopy;
    private IDocumentListener fDocumentListener = new InternalDocumentListener();

    public FindDuplicatesAction(IWorkbenchPage page) {
        super(Messages.FindDuplicatesAction_FIND_DUPLICATES, ImagePool.FIND_DUPLICATES_ENABLED, 1);
        this.setDisabledImageDescriptor(ImagePool.FIND_DUPLICATES_DISABLED);
        this.fPage = page;
    }

    public void runWithEvent(Event event) {
        if (this.fWorkingCopy == null) {
            return;
        }
        QueriesUI.showRelatedWorkItems((IWorkbenchWindow)this.fPage.getWorkbenchWindow(), (WorkItemWorkingCopy)this.fWorkingCopy);
    }

    public void setInput(WorkItemWorkingCopy workingCopy) {
        if (this.fWorkingCopy != null) {
            this.removeDocumentListener(this.fWorkingCopy);
        }
        this.fWorkingCopy = workingCopy;
        this.update();
        if (this.fWorkingCopy != null) {
            this.addDocumentListener(this.fWorkingCopy);
        }
    }

    private void update() {
        if (this.fWorkingCopy == null) {
            this.setEnabled(false);
            return;
        }
        IWorkItemUIWorkingCopy uiWorkingCopy = (IWorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
        boolean hasSummary = uiWorkingCopy.getSummary().getLength() > 0;
        boolean hasDescription = ((WorkItemUIWorkingCopy)uiWorkingCopy).getDescription().getLength() > 0;
        boolean hasNewComment = uiWorkingCopy.getNewComment().getLength() > 0;
        this.setEnabled(hasSummary || hasDescription || hasNewComment);
    }

    public void dispose() {
        if (this.fDocumentListener != null) {
            if (this.fWorkingCopy != null) {
                this.removeDocumentListener(this.fWorkingCopy);
            }
            this.fDocumentListener = null;
        }
    }

    private void addDocumentListener(WorkItemWorkingCopy workingCopy) {
        IWorkItemUIWorkingCopy uiWorkingCopy = (IWorkItemUIWorkingCopy)workingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
        uiWorkingCopy.getSummary().addDocumentListener(this.fDocumentListener);
        ((WorkItemUIWorkingCopy)uiWorkingCopy).getDescription().addDocumentListener(this.fDocumentListener);
        uiWorkingCopy.getNewComment().addDocumentListener(this.fDocumentListener);
    }

    private void removeDocumentListener(WorkItemWorkingCopy workingCopy) {
        WorkItemUIWorkingCopy uiWorkingCopy = (WorkItemUIWorkingCopy)workingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
        if (uiWorkingCopy.isResolvedWorkItemSet()) {
            uiWorkingCopy.getSummary().removeDocumentListener(this.fDocumentListener);
            uiWorkingCopy.getDescription().removeDocumentListener(this.fDocumentListener);
            uiWorkingCopy.getNewComment().removeDocumentListener(this.fDocumentListener);
        }
    }

    private class InternalDocumentListener
    implements IDocumentListener {
        private InternalDocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            if (event.getDocument().getLength() == 0 && FindDuplicatesAction.this.isEnabled() || event.getDocument().getLength() > 0 && !FindDuplicatesAction.this.isEnabled()) {
                FindDuplicatesAction.this.update();
            }
        }
    }
}

