/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.part;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.ActiveControlTracker;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.HandlerUpdater;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.ViewerPane;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.ViewerPart;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.ui.dnd.ViewerDragSupport;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.ArtifactLink;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashMap;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.IAttachmentHandle;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.ItemURI;
import com.ibm.team.workitem.common.model.ReferencesChangeDetails;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.LinkLabelProvider;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.capture.ScreenCaptureUtils;
import com.ibm.team.workitem.ide.ui.internal.editor.FileHelper;
import com.ibm.team.workitem.ide.ui.internal.editor.LinkHelper;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.part.LinksPart;
import com.ibm.team.workitem.ide.ui.internal.editor.part.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationPart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.AbstractPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import com.ibm.team.workitem.ide.ui.internal.preview.AttachmentHTMLGenerator;
import com.ibm.team.workitem.rcp.ui.internal.ConstrainedTableViewer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentsPart
extends PresentationPart {
    public static final String ATTACHMENTS_SAVE_LOCATION = "com.ibm.team.workitem.ide.ui.editor.attachments.dialogfilterpath";
    private static final String ATTACHMENTS_ADD_LOCATION = "com.ibm.team.workitem.ide.ui.editor.addfile.dialogfilterpath";
    private WorkItemWorkingCopy fWorkItemWorkingCopy;
    private IEndPointDescriptor fEndPoint = WorkItemEndPoints.ATTACHMENT;
    private TableViewer fLinksViewer;
    private Object lastEditedElement;
    private IPresentationUpdater fPresentationUpdater = new AbstractPresentationUpdater(){

        public void attributeChanged(WorkItemChangeEvent event) {
            ReferencesChangeDetails change;
            IAdaptable details = event.getAttributeChangeDetails("references");
            if (details != null && (change = (ReferencesChangeDetails)details.getAdapter(ReferencesChangeDetails.class)) != null) {
                boolean changed = false;
                for (IReference reference : change.getRemoved()) {
                    if (!AttachmentsPart.this.fEndPoint.equals(WorkItemLinkTypes.getEndPointDescriptor((IReference)reference))) continue;
                    changed = true;
                    break;
                }
                if (!changed) {
                    for (IReference reference : change.getAdded()) {
                        if (!AttachmentsPart.this.fEndPoint.equals(WorkItemLinkTypes.getEndPointDescriptor((IReference)reference))) continue;
                        changed = true;
                        break;
                    }
                }
                if (changed) {
                    AttachmentsPart.this.fLinksViewer.refresh();
                }
            }
        }
    };
    private ArtifactLinksLabelProvider fArtifactLabelProvider = new ArtifactLinksLabelProvider(){

        protected ITeamRepository getTeamRepository() {
            if (AttachmentsPart.this.fWorkItemWorkingCopy != null) {
                return AttachmentsPart.this.fWorkItemWorkingCopy.getTeamRepository();
            }
            return null;
        }
    };
    private ViewerPart fViewerPart;
    private Button fSaveas;
    private HandlerUpdater fHandlerUpdater;

    public void createContent(Composite parent) {
        FormToolkit toolkit = this.getSite().getToolkit();
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 2;
        layout.marginWidth = 1;
        parent.setLayout((Layout)layout);
        toolkit.paintBordersFor(parent);
        this.fLinksViewer = new ConstrainedTableViewer(toolkit, parent, 66306, false){

            public void refresh() {
                Object r = null;
                if (AttachmentsPart.this.fLinksViewer.isCellEditorActive()) {
                    r = AttachmentsPart.this.lastEditedElement;
                }
                super.refresh();
                AttachmentsPart.this.packColumns();
                if (r != null) {
                    AttachmentsPart.this.fLinksViewer.editElement(r, 1);
                }
            }
        };
        toolkit.adapt(this.fLinksViewer.getControl(), true, false);
        this.fLinksViewer.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.fLinksViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fLinksViewer.getTable().setHeaderVisible(true);
        this.fLinksViewer.setContentProvider((IContentProvider)new ArtifactLinksViewerContentProvider());
        this.fLinksViewer.setLabelProvider((IBaseLabelProvider)this.fArtifactLabelProvider);
        this.fLinksViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    Object[] elements = selection.toArray();
                    int i = 0;
                    while (i < elements.length) {
                        Object element = elements[i];
                        if (element instanceof ArtifactLink) {
                            ArtifactLink link = (ArtifactLink)element;
                            if (link.isReplaced() && link.getReference().isItemReference() && ((IItemReference)link.getReference()).getReferencedItem() instanceof IAttachment && ((IAttachment)((IItemReference)link.getReference()).getReferencedItem()).isComplete()) {
                                final IAttachment att = (IAttachment)((IItemReference)link.getReference()).getReferencedItem();
                                new FoundationJob(Messages.AttachmentsPart_OPENING_ATTACHMENT){

                                    protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                                        FileHelper.open(att, null);
                                        return Status.OK_STATUS;
                                    }
                                }.schedule();
                                return;
                            }
                            LinkHelper.openArtifact((ArtifactLink)element);
                        }
                        ++i;
                    }
                }
            }
        });
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        TriggerSequence[] activeBindings = bindingService.getActiveBindingsFor("org.eclipse.ui.edit.rename");
        final KeyStroke keyStroke = activeBindings.length != 0 && activeBindings[0].getTriggers().length > 0 && activeBindings[0].getTriggers()[0] instanceof KeyStroke ? (KeyStroke)activeBindings[0].getTriggers()[0] : KeyStroke.getInstance((int)0x100000B);
        this.fLinksViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (keyStroke.equals((Object)KeyStroke.getInstance((int)e.keyCode)) && AttachmentsPart.getRenameables(AttachmentsPart.this.fLinksViewer.getSelection()).size() == 1) {
                    AttachmentsPart.this.renameSelectedLink();
                }
            }
        });
        final ArtifactSorter sorter = new ArtifactSorter(this.fArtifactLabelProvider.getLimitedTableLabelProvider());
        this.fLinksViewer.setSorter((ViewerSorter)sorter);
        Table table = this.fLinksViewer.getTable();
        TableColumn id = new TableColumn(table, 16384);
        id.setResizable(true);
        id.setText(Messages.AttachmentsPart_ID);
        id.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                sorter.setSortColumn(0);
                AttachmentsPart.this.fLinksViewer.refresh();
            }
        });
        TableColumn name = new TableColumn(table, 16384);
        name.setResizable(true);
        name.setText(Messages.AttachmentsPart_NAME);
        name.setWidth(160);
        name.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                sorter.setSortColumn(1);
                AttachmentsPart.this.fLinksViewer.refresh();
            }
        });
        TableColumn creationDate = new TableColumn(table, 16384);
        creationDate.setResizable(true);
        creationDate.setText(Messages.AttachmentsPart_CREATED);
        TableColumn creator = new TableColumn(table, 16384);
        creator.setResizable(true);
        creator.setText(Messages.AttachmentsPart_CREATED_BY);
        TableColumn size = new TableColumn(table, 16384);
        size.setResizable(true);
        size.setText(Messages.AttachmentsPart_SIZE);
        size.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                sorter.setSortColumn(4);
                AttachmentsPart.this.fLinksViewer.refresh();
            }
        });
        TableColumn type = new TableColumn(table, 16384);
        type.setResizable(true);
        type.setText(Messages.AttachmentsPart_TYPE);
        type.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                sorter.setSortColumn(5);
                AttachmentsPart.this.fLinksViewer.refresh();
            }
        });
        CellEditor[] cellEditorArray = new CellEditor[6];
        cellEditorArray[1] = new TextCellEditor((Composite)table);
        this.fLinksViewer.setCellEditors(cellEditorArray);
        this.fLinksViewer.setColumnProperties(new String[]{Messages.AttachmentsPart_ID, Messages.AttachmentsPart_NAME, Messages.AttachmentsPart_CREATED, Messages.AttachmentsPart_CREATED_BY, Messages.AttachmentsPart_SIZE, Messages.AttachmentsPart_TYPE});
        ICellModifier modifier = new ICellModifier(){

            public boolean canModify(Object element, String property) {
                boolean can = element instanceof ArtifactLink;
                if (can) {
                    AttachmentsPart.this.lastEditedElement = element;
                }
                return can;
            }

            public Object getValue(Object element, String property) {
                if (element instanceof ArtifactLink) {
                    return AttachmentsPart.this.fArtifactLabelProvider.getColumnText(element, 1);
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
                if (element instanceof Item) {
                    element = ((Item)element).getData();
                }
                if (!(element instanceof ArtifactLink)) {
                    return;
                }
                ArtifactLink link = (ArtifactLink)element;
                if (!(value instanceof String)) {
                    return;
                }
                if (!this.getValue(link, property).equals(value) && value != null && !"".equals(((String)value).trim())) {
                    link.setName((String)value);
                }
                AttachmentsPart.this.lastEditedElement = null;
            }
        };
        this.fLinksViewer.setCellModifier(modifier);
        new TooltipSupport((Control)this.fLinksViewer.getTable(), true, true){

            protected Object mapElement(int x, int y) {
                TableItem item = AttachmentsPart.this.fLinksViewer.getTable().getItem(new Point(x, y));
                if (item == null) {
                    return null;
                }
                ArtifactLink link = (ArtifactLink)item.getData();
                IReference reference = link.getReference();
                if (reference.isItemReference()) {
                    return ((IItemReference)reference).getReferencedItem();
                }
                return null;
            }

            protected void openRequested(Object element) {
                URI uri = ItemURI.generateAuditableURI((String)AttachmentsPart.this.fWorkItemWorkingCopy.getTeamRepository().getRepositoryURI(), (Object)element);
                Hyperlinks.openHyperlink((URI)uri);
            }
        };
        this.createActionControls(parent);
        this.addDropTarget(this.fLinksViewer);
        this.addDragSource(this.fLinksViewer);
        this.createActionHandlers(this.fLinksViewer);
        this.createContextMenu((Viewer)this.fLinksViewer, (Control)this.fLinksViewer.getTable());
        this.getSite().registerSelectionProvider((ISelectionProvider)this.fLinksViewer, (Control)this.fLinksViewer.getTable());
        ViewerPane viewerPane = (ViewerPane)this.getSite().getAdapter(ViewerPane.class);
        if (viewerPane != null) {
            this.fViewerPart = new ViewerPart((Viewer)this.fLinksViewer, "references/" + this.fEndPoint);
            viewerPane.addViewerPart(this.fViewerPart);
        }
    }

    private void packColumns() {
        if (this.fLinksViewer != null) {
            TableColumn[] tableColumnArray = this.fLinksViewer.getTable().getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn c = tableColumnArray[n2];
                if (this.fLinksViewer.getTable().getColumn(1) != c) {
                    c.pack();
                }
                ++n2;
            }
        }
    }

    private void createActionControls(Composite parent) {
        FormToolkit toolkit = this.getSite().getToolkit();
        Composite buttons = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        buttons.setLayoutData((Object)new GridData(131072, 4, false, true));
        Button add = toolkit.createButton(buttons, Messages.AttachmentsPart_ADD_FILE, 0);
        add.setLayoutData((Object)new GridData(4, 1, true, false));
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttachmentsPart.addFromFileSystem(AttachmentsPart.this.fWorkItemWorkingCopy);
            }
        });
        Button add2 = toolkit.createButton(buttons, Messages.AttachmentsPart_ADD_SCREENSHOT, 0);
        add2.setLayoutData((Object)new GridData(4, 1, true, false));
        add2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScreenCaptureUtils.addScreenCapture(AttachmentsPart.this.fWorkItemWorkingCopy.getWorkItem());
            }
        });
        final Button remove = toolkit.createButton(buttons, Messages.AttachmentsPart_REMOVE, 0);
        remove.setLayoutData((Object)new GridData(4, 1, true, false));
        remove.setEnabled(!this.fLinksViewer.getSelection().isEmpty());
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttachmentsPart.this.removeSelectedLinks();
            }
        });
        final Button rename = toolkit.createButton(buttons, Messages.AttachmentsPart_RENAME, 8);
        rename.setLayoutData((Object)new GridData(4, 1, true, false));
        rename.setEnabled(AttachmentsPart.getRenameables(this.fLinksViewer.getSelection()).size() == 1);
        rename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttachmentsPart.this.renameSelectedLink();
            }
        });
        this.fSaveas = toolkit.createButton(buttons, Messages.AttachmentsPart_SAVE_AS_BUTTON, 8);
        this.fSaveas.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fSaveas.setEnabled(!this.fLinksViewer.getSelection().isEmpty());
        this.fSaveas.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttachmentsPart.this.saveSelectedLinks();
            }
        });
        this.fLinksViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = event.getSelection();
                remove.setEnabled(!sel.isEmpty());
                AttachmentsPart.this.fSaveas.setEnabled(!AttachmentsPart.getSaveables(sel).isEmpty());
                rename.setEnabled(AttachmentsPart.getRenameables(sel).size() == 1);
            }
        });
    }

    private void createContextMenu(Viewer viewer, Control control) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        Action openAction = new Action(Messages.AttachmentsPart_OPEN){

            public void run() {
                ISelection sel = AttachmentsPart.this.fLinksViewer.getSelection();
                if (sel instanceof IStructuredSelection) {
                    Object[] elements = ((IStructuredSelection)sel).toArray();
                    int i = 0;
                    while (i < elements.length) {
                        Object element = elements[i];
                        if (element instanceof ArtifactLink) {
                            ArtifactLink link = (ArtifactLink)element;
                            if (link.isReplaced() && link.getReference().isItemReference() && ((IItemReference)link.getReference()).getReferencedItem() instanceof IAttachment && ((IAttachment)((IItemReference)link.getReference()).getReferencedItem()).isComplete()) {
                                final IAttachment att = (IAttachment)((IItemReference)link.getReference()).getReferencedItem();
                                new FoundationJob(Messages.AttachmentsPart_OPENING_ATTACHMENT){

                                    protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                                        FileHelper.open(att, monitor);
                                        return Status.OK_STATUS;
                                    }
                                }.schedule();
                                return;
                            }
                            LinkHelper.openArtifact(link);
                        }
                        ++i;
                    }
                }
            }
        };
        Action deleteAction = new Action(Messages.AttachmentsPart_REMOVE){

            public void run() {
                AttachmentsPart.this.removeSelectedLinks();
            }
        };
        Action renameAction = new Action(Messages.AttachmentsPart_RENAME){

            public void run() {
                AttachmentsPart.this.renameSelectedLink();
            }
        };
        Action replaceAction = new Action(Messages.AttachmentsPart_REPLACE_ACTION){

            public void run() {
                AttachmentsPart.this.replaceSelectedLink();
            }
        };
        Action restoreAction = new Action(Messages.AttachmentsPart_REPLACE_FROM_HISTORY_ACTION){

            public void run() {
                AttachmentsPart.this.restoreSelectedLink();
            }
        };
        menuMgr.addMenuListener(new IMenuListener((IAction)openAction, (IAction)deleteAction, (IAction)renameAction, (IAction)replaceAction, (IAction)restoreAction){
            private final /* synthetic */ IAction val$openAction;
            private final /* synthetic */ IAction val$deleteAction;
            private final /* synthetic */ IAction val$renameAction;
            private final /* synthetic */ IAction val$replaceAction;
            private final /* synthetic */ IAction val$restoreAction;
            {
                this.val$openAction = iAction;
                this.val$deleteAction = iAction2;
                this.val$renameAction = iAction3;
                this.val$replaceAction = iAction4;
                this.val$restoreAction = iAction5;
            }

            public void menuAboutToShow(IMenuManager manager) {
                Object object;
                boolean renameable;
                if (!AttachmentsPart.this.fLinksViewer.getSelection().isEmpty()) {
                    manager.add(this.val$openAction);
                    manager.add(this.val$deleteAction);
                }
                boolean bl = renameable = AttachmentsPart.getRenameables(AttachmentsPart.this.fLinksViewer.getSelection()).size() == 1;
                if (renameable) {
                    manager.add(this.val$renameAction);
                }
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new AddFileAction(AttachmentsPart.this.fWorkItemWorkingCopy));
                manager.add((IAction)new AddScreenshotAction(AttachmentsPart.this.fWorkItemWorkingCopy));
                if (renameable) {
                    manager.add(this.val$replaceAction);
                }
                if (((IStructuredSelection)AttachmentsPart.this.fLinksViewer.getSelection()).size() == 1 && (object = ((IStructuredSelection)AttachmentsPart.this.fLinksViewer.getSelection()).getFirstElement()) instanceof ArtifactLink) {
                    IReference reference = ((ArtifactLink)object).getReference();
                    if (reference.isItemReference() && ((IItemReference)reference).getReferencedItem() instanceof IAttachmentHandle) {
                        manager.add(this.val$restoreAction);
                    } else if (((ArtifactLink)object).isReplaced() && (reference = ((ArtifactLink)object).getReplacedReference()).isItemReference() && ((IItemReference)reference).getReferencedItem() instanceof IAttachmentHandle) {
                        manager.add(this.val$restoreAction);
                    }
                }
                manager.add((IContributionItem)new Separator("additions"));
                manager.add((IAction)new PasteAction(AttachmentsPart.this.fWorkItemWorkingCopy, AttachmentsPart.this.fLinksViewer.getTable().getShell()));
            }
        });
        this.getSite().registerContextMenu(String.valueOf(this.getSite().getId((TeamFormPart)this)) + ".artifactLinksSection", menuMgr, (ISelectionProvider)new LinksPart.InternalConvertingSelectionProvider(viewer));
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
    }

    @Override
    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    public void setFocus() {
        if (this.fLinksViewer != null && !this.fLinksViewer.getTable().isDisposed()) {
            this.fLinksViewer.getTable().setFocus();
        }
    }

    public void setInput(Object input) {
        this.removeListeners();
        this.fWorkItemWorkingCopy = null;
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)((Object)input)).isResolved()) {
            this.fWorkItemWorkingCopy = ((WorkItemEditorInput)((Object)input)).getWorkingCopy();
            this.addListeners();
        }
        this.fLinksViewer.setInput((Object)this.fWorkItemWorkingCopy);
        this.packColumns();
    }

    private void addListeners() {
        PresentationHandlerManager mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class);
        if (mgr != null) {
            PresentationDescriptor desc = Util.cloneDescriptor(this.getDescriptor());
            desc.setAttributeId(WorkItemAttributes.getPropertyIdentifier((String)"references"));
            mgr.addPresentationUpdater(this.fPresentationUpdater, desc);
        }
    }

    private void removeListeners() {
        PresentationHandlerManager mgr;
        if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            mgr.removePresentationUpdater(this.fPresentationUpdater);
        }
    }

    public void dispose() {
        if (this.fViewerPart != null) {
            ViewerPane viewerPane = (ViewerPane)this.getSite().getAdapter(ViewerPane.class);
            if (viewerPane != null) {
                viewerPane.removeViewerPart(this.fViewerPart);
            }
            this.fViewerPart = null;
        }
        this.removeListeners();
        this.fWorkItemWorkingCopy = null;
        if (this.fHandlerUpdater != null) {
            this.fHandlerUpdater.dispose();
            this.fHandlerUpdater = null;
        }
        super.dispose();
    }

    private void addDragSource(TableViewer viewer) {
        new ViewerDragSupport((Viewer)viewer, 4){

            public ISelection getSelection() {
                ISelection sel = super.getSelection();
                if (sel instanceof IStructuredSelection) {
                    ArrayList<IItemHandle> result = new ArrayList<IItemHandle>();
                    Object[] objectArray = ((IStructuredSelection)sel).toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IItemReference ref;
                        Object element = objectArray[n2];
                        if (element instanceof ArtifactLink && ((ArtifactLink)element).getReference().isItemReference() && (ref = (IItemReference)((ArtifactLink)element).getReference()).getReferencedItem() instanceof IAttachmentHandle) {
                            result.add(ref.getReferencedItem());
                        }
                        ++n2;
                    }
                    return new StructuredSelection(result);
                }
                return StructuredSelection.EMPTY;
            }
        };
    }

    private void addDropTarget(TableViewer viewer) {
        DropTarget target = new DropTarget(viewer.getControl(), 5);
        target.setTransfer(new Transfer[]{LocalSelectionTransfer.getInstance(), FileTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new AttachmentDropListener(){

            protected WorkItemWorkingCopy getWorkingCopy() {
                return (WorkItemWorkingCopy)AttachmentsPart.this.fLinksViewer.getInput();
            }
        });
    }

    private void removeSelectedLinks() {
        ISelection selection = this.fLinksViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object[] objects = ((IStructuredSelection)selection).toArray();
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof ArtifactLink) {
                    ArtifactLink artifactLink = (ArtifactLink)objects[i];
                    this.fWorkItemWorkingCopy.getReferences().remove(artifactLink.getReference());
                }
                ++i;
            }
        }
    }

    private void renameSelectedLink() {
        ISelection selection = this.fLinksViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            this.fLinksViewer.editElement(object, 1);
        }
    }

    private void replaceSelectedLink() {
        Object object;
        ISelection selection = this.fLinksViewer.getSelection();
        if (selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof ArtifactLink) {
            File file;
            ArtifactLink artifactLink = (ArtifactLink)object;
            FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4100);
            String path = WorkItemIDEUIPlugin.getDefault().getPreferenceStore().getString(ATTACHMENTS_ADD_LOCATION);
            if (path != null) {
                dialog.setFilterPath(path);
            }
            dialog.setText(Messages.AttachmentsPart_REPLACE);
            String sourceName = dialog.open();
            if (sourceName != null && (file = new File(sourceName)) != null && file.exists() && file.isFile()) {
                try {
                    IReference reference = LinkHelper.createReference(file);
                    artifactLink.replace((IURIReference)reference);
                    this.fSaveas.setEnabled(false);
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    Assert.isTrue((boolean)false);
                }
            }
            WorkItemIDEUIPlugin.getDefault().getPreferenceStore().setValue(ATTACHMENTS_ADD_LOCATION, Path.fromOSString((String)dialog.getFilterPath()).makeAbsolute().toString());
        }
    }

    private void restoreSelectedLink() {
        Object object;
        ISelection selection = this.fLinksViewer.getSelection();
        if (selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof ArtifactLink) {
            IReference reference = ((ArtifactLink)object).getReference();
            if (((ArtifactLink)object).isReplaced()) {
                reference = ((ArtifactLink)object).getReplacedReference();
            }
            if (reference.isItemReference() && ((IItemReference)reference).getReferencedItem() instanceof IAttachmentHandle) {
                Object[] result;
                IAttachmentHandle current = (IAttachmentHandle)((IItemReference)reference).getReferencedItem();
                RestoreAttachmentDialog d = new RestoreAttachmentDialog(this.fLinksViewer.getControl().getShell(), this.fWorkItemWorkingCopy.getTeamRepository(), current, (ArtifactLink)object);
                d.setBlockOnOpen(true);
                if (d.open() == 0 && (result = d.getResult()).length > 0 && result[0] instanceof IAttachment) {
                    IAttachment toRestore = (IAttachment)result[0];
                    ((ArtifactLink)object).restore(toRestore);
                }
            }
        }
    }

    private void saveSelectedLinks() {
        List<ArtifactLink> list = AttachmentsPart.getSaveables(this.fLinksViewer.getSelection());
        if (list.size() == 1) {
            String fname;
            IItemReference reference = (IItemReference)list.get(0).getReference();
            FileDialog dialog = new FileDialog(this.fLinksViewer.getControl().getShell(), 8192);
            String path = WorkItemIDEUIPlugin.getDefault().getPreferenceStore().getString(ATTACHMENTS_SAVE_LOCATION);
            if (path != null) {
                dialog.setFilterPath(path);
            }
            dialog.setText(Messages.AttachmentsPart_SAVE_AS);
            dialog.setFileName(this.fArtifactLabelProvider.getColumnText(list.get(0), 1));
            while ((fname = dialog.open()) != null) {
                MessageDialog md;
                File file = new File(fname);
                if (file.exists() && (md = new MessageDialog(this.fLinksViewer.getControl().getShell(), Messages.AttachmentsPart_SAVE_AS, null, NLS.bind((String)Messages.AttachmentsPart_ALREADY_EXISTS, (Object)fname, (Object[])new Object[0]), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1)).open() != 0) continue;
                new FileSaveJob(this.fWorkItemWorkingCopy.getTeamRepository(), reference, file).schedule();
                break;
            }
            WorkItemIDEUIPlugin.getDefault().getPreferenceStore().setValue(ATTACHMENTS_SAVE_LOCATION, Path.fromOSString((String)dialog.getFilterPath()).makeAbsolute().toString());
        } else if (list.size() > 1) {
            DirectoryDialog dialog = new DirectoryDialog(this.fLinksViewer.getControl().getShell());
            String path = WorkItemIDEUIPlugin.getDefault().getPreferenceStore().getString(ATTACHMENTS_SAVE_LOCATION);
            if (path != null) {
                dialog.setFilterPath(path);
            }
            dialog.setText(Messages.AttachmentsPart_SAVE_ATTACHMENTS);
            dialog.setMessage(Messages.AttachmentsPart_SELECT_DIRECTORY);
            String dir = dialog.open();
            if (dir != null) {
                boolean yestoall = false;
                ArrayList<IItemReference> links = new ArrayList<IItemReference>();
                ArrayList<File> files = new ArrayList<File>();
                for (ArtifactLink link : list) {
                    IItemReference reference = (IItemReference)link.getReference();
                    File file = new File(dir, this.fArtifactLabelProvider.getColumnText(link, 1));
                    if (!yestoall && file.exists()) {
                        MessageDialog md = new MessageDialog(this.fLinksViewer.getControl().getShell(), Messages.AttachmentsPart_SAVE_AS, null, NLS.bind((String)Messages.AttachmentsPart_ALREADY_EXISTS, (Object)file.getPath(), (Object[])new Object[0]), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.YES_TO_ALL_LABEL}, 1);
                        int r = md.open();
                        if (r == 2) {
                            yestoall = true;
                        } else if (r != 0) continue;
                    }
                    links.add(reference);
                    files.add(file);
                }
                new FileSaveJob(this.fWorkItemWorkingCopy.getTeamRepository(), links.toArray(new IItemReference[links.size()]), files.toArray(new File[files.size()])).schedule();
            }
            WorkItemIDEUIPlugin.getDefault().getPreferenceStore().setValue(ATTACHMENTS_SAVE_LOCATION, Path.fromOSString((String)dialog.getFilterPath()).makeAbsolute().toString());
        }
    }

    private static List<ArtifactLink> getSaveables(ISelection selection) {
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ArtifactLink> list = new ArrayList<ArtifactLink>();
        for (Object object : (IStructuredSelection)selection) {
            if (!(object instanceof ArtifactLink)) continue;
            IReference reference = ((ArtifactLink)object).getReference();
            if (reference.isItemReference() && ((IItemReference)reference).getReferencedItem() instanceof IAttachmentHandle) {
                list.add((ArtifactLink)object);
                continue;
            }
            if (!((ArtifactLink)object).isReplaced() || ((ArtifactLink)object).needsUpload() || !(reference = ((ArtifactLink)object).getReplacedReference()).isItemReference() || !(((IItemReference)reference).getReferencedItem() instanceof IAttachmentHandle)) continue;
            list.add((ArtifactLink)object);
        }
        return list;
    }

    private static List<ArtifactLink> getRenameables(ISelection selection) {
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ArtifactLink> list = new ArrayList<ArtifactLink>();
        for (Object object : (IStructuredSelection)selection) {
            if (!(object instanceof ArtifactLink)) continue;
            IReference reference = ((ArtifactLink)object).getReference();
            if (reference.isItemReference() && ((IItemReference)reference).getReferencedItem() instanceof IAttachmentHandle) {
                list.add((ArtifactLink)object);
                continue;
            }
            if (!((ArtifactLink)object).needsUpload()) continue;
            list.add((ArtifactLink)object);
        }
        return list;
    }

    private static void addFromFileSystem(WorkItemWorkingCopy workingCopy) {
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4098);
        String path = WorkItemIDEUIPlugin.getDefault().getPreferenceStore().getString(ATTACHMENTS_ADD_LOCATION);
        if (path != null) {
            dialog.setFilterPath(path);
        }
        dialog.setText(Messages.AttachmentsPart_ADD_ATTACHMENT);
        String file = dialog.open();
        if (file != null) {
            String[] stringArray = dialog.getFileNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                AttachmentsPart.addFileSystemLink(workingCopy, Path.fromOSString((String)dialog.getFilterPath()).append(fileName).makeAbsolute().toString());
                ++n2;
            }
        }
        WorkItemIDEUIPlugin.getDefault().getPreferenceStore().setValue(ATTACHMENTS_ADD_LOCATION, Path.fromOSString((String)dialog.getFilterPath()).makeAbsolute().toString());
    }

    public static void addFileSystemLink(WorkItemWorkingCopy workingCopy, String sourceName) {
        File file = new File(sourceName);
        if (file != null && file.exists() && file.isFile()) {
            IWorkItemReferences references = workingCopy.getReferences();
            try {
                IReference reference = LinkHelper.createReference(file);
                if (reference != null) {
                    references.add(WorkItemEndPoints.ATTACHMENT, reference);
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {
                Assert.isTrue((boolean)false);
            }
        }
    }

    private void createActionHandlers(TableViewer linksViewer) {
        IServiceLocator serviceLocator = (IServiceLocator)this.getSite().getAdapter(IServiceLocator.class);
        ActiveControlTracker activeControlTracker = (ActiveControlTracker)this.getSite().getAdapter(ActiveControlTracker.class);
        if (serviceLocator != null && activeControlTracker != null) {
            this.fHandlerUpdater = new HandlerUpdater(serviceLocator, activeControlTracker);
            this.fHandlerUpdater.addAction((IAction)new PasteActionCreator(this.fLinksViewer.getTable().getShell()));
            this.fHandlerUpdater.install((ISelectionProvider)linksViewer, (Control)linksViewer.getTable(), false);
        }
    }

    public static class AddFileAction
    extends Action {
        private WorkItemWorkingCopy fWorkingCopy;

        public AddFileAction(WorkItemWorkingCopy workingCopy) {
            super(Messages.AttachmentsPart_ADD_FILE, ImagePool.WORKITEM_ATTACHMENT);
            this.fWorkingCopy = workingCopy;
        }

        public void run() {
            AttachmentsPart.addFromFileSystem(this.fWorkingCopy);
        }
    }

    public static class AddScreenshotAction
    extends Action {
        private WorkItemWorkingCopy fWorkingCopy;

        public AddScreenshotAction(WorkItemWorkingCopy workingCopy) {
            super(Messages.AttachmentsPart_ADD_SCREENSHOT, ImagePool.WORKITEM_CAPTURE);
            this.fWorkingCopy = workingCopy;
        }

        public void run() {
            ScreenCaptureUtils.addScreenCapture(this.fWorkingCopy.getWorkItem());
        }
    }

    public static class ArtifactLinksLabelProvider
    extends CellLabelProvider {
        private ILabelProvider fLinkLabelProvider = new LinkLabelProvider();
        private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        private StandardLabelProvider fStandardLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        private DateFormat fDateFormatter = DateFormat.getDateInstance(3);
        private DateFormat fTimeFormatter = DateFormat.getTimeInstance(3);
        private ItemHandleAwareHashMap<IContributorHandle, ArtifactLink> fMap = new ItemHandleAwareHashMap();
        private ILabelProviderListener fLabelProviderListener;

        public ITableLabelProvider getLimitedTableLabelProvider() {
            return new ITableLabelProvider(){

                public Image getColumnImage(Object element, int columnIndex) {
                    return ArtifactLinksLabelProvider.this.getColumnImage(element, columnIndex);
                }

                public String getColumnText(Object element, int columnIndex) {
                    return ArtifactLinksLabelProvider.this.getColumnText(element, columnIndex);
                }

                public void addListener(ILabelProviderListener listener) {
                    ArtifactLinksLabelProvider.this.addListener(listener);
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return ArtifactLinksLabelProvider.this.isLabelProperty(element, property);
                }

                public void removeListener(ILabelProviderListener listener) {
                    ArtifactLinksLabelProvider.this.removeListener(listener);
                }
            };
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            int columnIndex = cell.getColumnIndex();
            if (columnIndex != 3) {
                cell.setText(this.getColumnText(element, columnIndex));
                cell.setImage(this.getColumnImage(element, columnIndex));
            } else if (element instanceof ArtifactLink) {
                ArtifactLink link = (ArtifactLink)element;
                IContributorHandle creator = null;
                if (link.isReplaced()) {
                    creator = link.getCreator();
                } else {
                    IAttachment att = null;
                    if (link.getReference().isItemReference()) {
                        if (!(!(((IItemReference)link.getReference()).getReferencedItem() instanceof IAttachment) || link.isReplaced() && link.needsUpload())) {
                            att = (IAttachment)((IItemReference)link.getReference()).getReferencedItem();
                        } else if (((IItemReference)link.getReference()).getReferencedItem() instanceof IAttachmentHandle && this.getTeamRepository() != null) {
                            IAuditableClient auditableClient = (IAuditableClient)this.getTeamRepository().getClientLibrary(IAuditableClient.class);
                            att = (IAttachment)auditableClient.findCachedAuditable((IAuditableHandle)((IAttachmentHandle)((IItemReference)link.getReference()).getReferencedItem()), IAttachment.DEFAULT_PROFILE);
                        }
                    }
                    if (att != null) {
                        creator = att.getCreator();
                    }
                }
                if (creator != null) {
                    IAuditableClient auditableClient = (IAuditableClient)this.getTeamRepository().getClientLibrary(IAuditableClient.class);
                    this.fMap.put((Object)creator, (Object)link);
                    IContributor c = (IContributor)auditableClient.findCachedAuditable((IAuditableHandle)creator, ItemProfile.CONTRIBUTOR_DEFAULT);
                    if (c != null) {
                        ViewerLabel label = new ViewerLabel(null, null);
                        this.fStandardLabelProvider.updateLabel(label, (Object)c);
                        cell.setText(label.getText());
                        cell.setForeground(label.getForeground());
                        cell.setBackground(label.getBackground());
                        cell.setFont(label.getFont());
                    }
                } else {
                    cell.setText(null);
                    cell.setForeground(null);
                    cell.setBackground(null);
                    cell.setFont(null);
                }
            }
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof ArtifactLink) {
                ImageDescriptor descriptor = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.getColumnText(element, 1));
                return JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)descriptor);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ArtifactLink) {
                ArtifactLink link = (ArtifactLink)element;
                IAttachment att = null;
                if (link.getReference().isItemReference()) {
                    if (((IItemReference)link.getReference()).getReferencedItem() instanceof IAttachment) {
                        att = (IAttachment)((IItemReference)link.getReference()).getReferencedItem();
                    } else if (((IItemReference)link.getReference()).getReferencedItem() instanceof IAttachmentHandle && this.getTeamRepository() != null) {
                        IAuditableClient auditableClient = (IAuditableClient)this.getTeamRepository().getClientLibrary(IAuditableClient.class);
                        att = (IAttachment)auditableClient.findCachedAuditable((IAuditableHandle)((IAttachmentHandle)((IItemReference)link.getReference()).getReferencedItem()), IAttachment.DEFAULT_PROFILE);
                    }
                }
                if (columnIndex == 0) {
                    return link.getId();
                }
                if (columnIndex == 1) {
                    return link.getName();
                }
                if (columnIndex == 2) {
                    Timestamp d = null;
                    if (link.isReplaced()) {
                        d = link.getCreationDate();
                    } else if (att != null) {
                        d = att.getCreationDate();
                    }
                    if (d != null) {
                        Date today = new Date();
                        today.setHours(0);
                        today.setMinutes(0);
                        today.setSeconds(0);
                        if (d.after(today)) {
                            return this.fTimeFormatter.format(d);
                        }
                        return this.fDateFormatter.format(d);
                    }
                    return null;
                }
                if (columnIndex == 4) {
                    IContent content;
                    long length = link.getContentLength();
                    if (length > -1L) {
                        return AttachmentHTMLGenerator.smartFormatSize(length);
                    }
                    if (att != null && (content = att.getContent()) != null) {
                        return AttachmentHTMLGenerator.smartFormatSize(content.getEstimatedConvertedLength());
                    }
                    return null;
                }
                if (columnIndex == 5) {
                    if (link.getContentType() != null) {
                        return link.getContentType();
                    }
                    if (att != null && att.getContent() != null) {
                        return att.getContent().getContentType();
                    }
                    return null;
                }
            }
            return null;
        }

        protected ITeamRepository getTeamRepository() {
            return null;
        }

        public String getText(Object element) {
            String text = this.getColumnText(element, 0);
            text = text != null && !text.equals("") ? String.valueOf(text) + " " : "";
            return String.valueOf(text) + this.getColumnText(element, 1);
        }

        public void addListener(ILabelProviderListener listener) {
            if (this.fLabelProviderListener == null && this.fStandardLabelProvider != null) {
                this.fLabelProviderListener = new InternalLabelProviderListener();
                this.fStandardLabelProvider.addListener(this.fLabelProviderListener);
            }
            super.addListener(listener);
        }

        public void dispose() {
            if (this.fLinkLabelProvider != null) {
                this.fLinkLabelProvider.dispose();
                this.fLinkLabelProvider = null;
            }
            if (this.fResourceManager != null) {
                this.fResourceManager.dispose();
                this.fResourceManager = null;
            }
            if (this.fStandardLabelProvider != null) {
                if (this.fLabelProviderListener != null) {
                    this.fStandardLabelProvider.removeListener(this.fLabelProviderListener);
                    this.fLabelProviderListener = null;
                }
                this.fStandardLabelProvider.dispose();
                this.fStandardLabelProvider = null;
            }
        }

        private class InternalLabelProviderListener
        implements ILabelProviderListener {
            private InternalLabelProviderListener() {
            }

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                Object[] elements = event.getElements();
                if (elements != null) {
                    ItemHandleAwareHashSet mapped = new ItemHandleAwareHashSet();
                    Object[] objectArray = elements;
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        ArtifactLink link = (ArtifactLink)ArtifactLinksLabelProvider.this.fMap.get(element);
                        if (link != null) {
                            mapped.add(link);
                        }
                        ++n2;
                    }
                    if (!mapped.isEmpty()) {
                        ArtifactLinksLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)ArtifactLinksLabelProvider.this, mapped.toArray()));
                    }
                } else {
                    ArtifactLinksLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)ArtifactLinksLabelProvider.this, null));
                }
            }
        }
    }

    private class ArtifactLinksViewerContentProvider
    implements IStructuredContentProvider {
        private ArtifactLinksViewerContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof WorkItemWorkingCopy) {
                WorkItemUIWorkingCopy uiWorkingCopy = (WorkItemUIWorkingCopy)AttachmentsPart.this.fWorkItemWorkingCopy.getAdapter(WorkItemUIWorkingCopy.class);
                return uiWorkingCopy.getArtifactLinks().toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class ArtifactSorter
    extends ViewerSorter {
        ITableLabelProvider fLabelProvider;
        int fColumn = 0;
        boolean fAsc = true;

        ArtifactSorter(ITableLabelProvider labelProvider) {
            this.fLabelProvider = labelProvider;
        }

        public void setSortColumn(int column) {
            this.fAsc = this.fColumn == column ? !this.fAsc : true;
            this.fColumn = column;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            String s1 = this.fLabelProvider.getColumnText(e1, this.fColumn);
            String s2 = this.fLabelProvider.getColumnText(e2, this.fColumn);
            if (s1 == null) {
                if (this.fAsc) {
                    return 1;
                }
                return -1;
            }
            if (s2 == null) {
                if (this.fAsc) {
                    return -1;
                }
                return 1;
            }
            if (this.fAsc) {
                if (viewer.getControl() instanceof Tree) {
                    ((Tree)viewer.getControl()).setSortColumn(((Tree)viewer.getControl()).getColumn(this.fColumn));
                    ((Tree)viewer.getControl()).setSortDirection(128);
                } else if (viewer.getControl() instanceof Table) {
                    ((Table)viewer.getControl()).setSortColumn(((Table)viewer.getControl()).getColumn(this.fColumn));
                    ((Table)viewer.getControl()).setSortDirection(128);
                }
                return s1.compareTo(s2);
            }
            if (viewer.getControl() instanceof Tree) {
                ((Tree)viewer.getControl()).setSortColumn(((Tree)viewer.getControl()).getColumn(this.fColumn));
                ((Tree)viewer.getControl()).setSortDirection(1024);
            } else if (viewer.getControl() instanceof Table) {
                ((Table)viewer.getControl()).setSortColumn(((Table)viewer.getControl()).getColumn(this.fColumn));
                ((Table)viewer.getControl()).setSortDirection(1024);
            }
            return s2.compareTo(s1);
        }
    }

    public static abstract class AttachmentDropListener
    extends DropTargetAdapter {
        protected abstract WorkItemWorkingCopy getWorkingCopy();

        public void dragEnter(DropTargetEvent event) {
            this.validateDrop(event);
        }

        public void dragOperationChanged(DropTargetEvent event) {
            this.validateDrop(event);
        }

        public void dropAccept(DropTargetEvent event) {
            this.validateDrop(event);
        }

        public void drop(DropTargetEvent event) {
            this.performDrop(event);
        }

        private void validateDrop(DropTargetEvent event) {
            if (LocalSelectionTransfer.getInstance().isSupportedType(event.currentDataType)) {
                ISelection selection = LocalSelectionTransfer.getInstance().getSelection();
                if (selection instanceof IStructuredSelection) {
                    for (Object element : (IStructuredSelection)selection) {
                        if (element instanceof IFile || element instanceof IAdaptable && ((IAdaptable)element).getAdapter(IResource.class) instanceof IFile) {
                            if ((event.operations & 4) != 0) {
                                event.detail = 4;
                            } else if ((event.operations & 1) != 0) {
                                event.detail = 1;
                            }
                            return;
                        }
                        if (!(element instanceof IAttachmentHandle)) continue;
                        if ((event.operations & 4) != 0) {
                            event.detail = 4;
                        } else if ((event.operations & 1) != 0) {
                            event.detail = 1;
                        }
                        return;
                    }
                }
            } else if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                if ((event.operations & 4) != 0) {
                    event.detail = 4;
                } else if ((event.operations & 1) != 0) {
                    event.detail = 1;
                }
                return;
            }
            event.detail = 0;
        }

        private void performDrop(DropTargetEvent event) {
            if (LocalSelectionTransfer.getInstance().isSupportedType(event.currentDataType)) {
                ISelection selection = LocalSelectionTransfer.getInstance().getSelection();
                if (selection instanceof IStructuredSelection) {
                    try {
                        IWorkItemReferences references = this.getWorkingCopy().getReferences();
                        Iterator iter = ((IStructuredSelection)selection).iterator();
                        while (iter.hasNext()) {
                            IReference newReference = LinkHelper.createReference(iter.next());
                            if (newReference == null) continue;
                            ArrayList list = new ArrayList();
                            if (!WorkItemLinkTypes.isSymmetric((IEndPointDescriptor)WorkItemEndPoints.ATTACHMENT)) {
                                list.addAll(references.getReferences(WorkItemEndPoints.ATTACHMENT));
                            } else {
                                ILinkType linkType = WorkItemEndPoints.ATTACHMENT.getLinkType();
                                list.addAll(references.getReferences(linkType.getSourceEndPointDescriptor()));
                                list.addAll(references.getReferences(linkType.getTargetEndPointDescriptor()));
                            }
                            boolean found = false;
                            for (IReference reference : list) {
                                if (!reference.sameDetailsExcludingCommentAs(newReference)) continue;
                                found = true;
                            }
                            if (found) continue;
                            references.add(WorkItemEndPoints.ATTACHMENT, newReference);
                        }
                    }
                    catch (TeamRepositoryException x) {
                        throw new RuntimeException(x);
                    }
                }
            } else if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                String[] sourceNames = (String[])FileTransfer.getInstance().nativeToJava(event.currentDataType);
                if (sourceNames == null) {
                    sourceNames = new String[]{};
                }
                int i = 0;
                while (i < sourceNames.length) {
                    AttachmentsPart.addFileSystemLink(this.getWorkingCopy(), sourceNames[i]);
                    ++i;
                }
            }
        }
    }

    private static class FileSaveJob
    extends FoundationJob {
        private ITeamRepository fTeamRepository;
        private IItemReference[] fReferences;
        private File[] fFiles;

        public FileSaveJob(ITeamRepository teamRepository, IItemReference[] references, File[] files) {
            super(Messages.AttachmentsPart_SAVING_ATTACHMENTS);
            this.setUser(true);
            this.fTeamRepository = teamRepository;
            this.fReferences = references;
            this.fFiles = files;
        }

        public FileSaveJob(ITeamRepository teamRepository, IItemReference reference, File file) {
            this(teamRepository, new IItemReference[]{reference}, new File[]{file});
        }

        /*
         * Unable to fully structure code
         */
        protected IStatus runProtected(IProgressMonitor monitor) {
            n = this.fReferences.length;
            stati = new IStatus[n];
            if (n == 1) {
                monitor.beginTask(Messages.AttachmentsPart_SAVING_ATTACHMENT, n);
            } else {
                monitor.beginTask(NLS.bind((String)Messages.AttachmentsPart_SAVING_N_ATTACHMENTS, (Object)n, (Object[])new Object[0]), n);
            }
            i = 0;
            block10: while (i < n) {
                submon = new SubProgressMonitor(monitor, 1);
                try {
                    FileSaveJob.checkCancelled(monitor);
                    auditableClient = (IAuditableClient)this.fTeamRepository.getClientLibrary(IAuditableClient.class);
                    item = (IAttachmentHandle)this.fReferences[i].getReferencedItem();
                    attachment = item instanceof IAttachment != false && ((IAttachment)item).isComplete() != false ? (IAttachment)item : (IAttachment)auditableClient.resolveAuditable((IAuditableHandle)item, IAttachment.FULL_PROFILE, (IProgressMonitor)submon);
                    FileSaveJob.checkCancelled(monitor);
                    content = attachment.getContent();
                    submon.beginTask(null, (int)content.getEstimatedConvertedLength());
                    submon.subTask(NLS.bind((String)Messages.AttachmentsPart_DOWNLOADING, (Object)this.fReferences[i].getComment(), (Object[])new Object[0]));
                    try {
                        out = new FileOutputStream(this.fFiles[i]);
                        try {
                            ((ITeamRepository)attachment.getOrigin()).contentManager().retrieveContent(content, (OutputStream)out, (IProgressMonitor)submon);
                        }
                        finally {
                            out.close();
                        }
                    }
                    finally {
                        submon.done();
                    }
                    stati[i] = Status.OK_STATUS;
                }
                catch (OperationCanceledException v0) {
                    j = i;
                    ** while (j < n)
                }
lbl-1000:
                // 1 sources

                {
                    stati[j] = Status.CANCEL_STATUS;
                    ++j;
                    continue;
lbl39:
                    // 1 sources

                    break block10;
                }
                catch (TeamRepositoryException x) {
                    stati[i] = new Status(4, "com.ibm.team.workitem.ide.ui", 0, NLS.bind((String)Messages.AttachmentsPart_ERROR_RETRIEVING, (Object)this.fReferences[i].getComment(), (Object[])new Object[0]), (Throwable)x);
                }
                catch (IOException x) {
                    stati[i] = new Status(4, "com.ibm.team.workitem.ide.ui", 0, NLS.bind((String)Messages.AttachmentsPart_ERROR_SAVING, (Object)this.fReferences[i].getComment(), (Object[])new Object[0]), (Throwable)x);
                }
                ++i;
            }
            monitor.done();
            return new MultiStatus("com.ibm.team.workitem.ide.ui", 0, stati, Messages.AttachmentsPart_ERRORS_SAVING, null);
        }

        private static void checkCancelled(IProgressMonitor monitor) throws OperationCanceledException {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
    }

    public static class PasteAction
    extends Action {
        private WorkItemWorkingCopy fWorkingCopy;
        private final Shell fShell;

        public PasteAction(WorkItemWorkingCopy workingCopy, Shell shell) {
            super(Messages.AttachmentsPart_PAST_ACTION_NAME, null);
            this.fShell = shell;
            this.setActionDefinitionId("org.eclipse.ui.edit.paste");
            this.fWorkingCopy = workingCopy;
        }

        public void run() {
            Clipboard clipboard = new Clipboard(this.fShell.getDisplay());
            try {
                final ImageData data = (ImageData)clipboard.getContents((Transfer)ImageTransfer.getInstance());
                if (data != null) {
                    ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.fShell);
                    try {
                        dialog.run(true, true, new IRunnableWithProgress(){

                            /*
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                monitor.beginTask(Messages.AttachmentsPart_PAST_ACTION_OPERATION_NAME, -1);
                                try {
                                    File file;
                                    try {
                                        file = PasteAction.this.createFile();
                                    }
                                    catch (IOException e1) {
                                        throw new InvocationTargetException(e1);
                                    }
                                    monitor.worked(1);
                                    if (monitor.isCanceled()) {
                                        return;
                                    }
                                    try {
                                        PasteAction.this.save(data, file);
                                    }
                                    catch (FileNotFoundException e) {
                                        throw new InvocationTargetException(e);
                                    }
                                    catch (IOException e) {
                                        throw new InvocationTargetException(e);
                                    }
                                    monitor.worked(10);
                                    if (monitor.isCanceled()) {
                                        return;
                                    }
                                    if (!file.exists()) {
                                        return;
                                    }
                                    IWorkItemReferences references = PasteAction.this.fWorkingCopy.getReferences();
                                    try {
                                        IReference reference = LinkHelper.createReference(file);
                                        if (reference != null) {
                                            references.add(WorkItemEndPoints.ATTACHMENT, reference);
                                        }
                                    }
                                    catch (TeamRepositoryException teamRepositoryException) {
                                        Assert.isTrue((boolean)false);
                                    }
                                    monitor.worked(1);
                                    return;
                                }
                                finally {
                                    monitor.done();
                                }
                            }
                        });
                    }
                    catch (InvocationTargetException e) {
                        WorkItemIDEUIPlugin.getDefault().log(e.getMessage(), e);
                    }
                    catch (InterruptedException e) {
                        WorkItemIDEUIPlugin.getDefault().log(e.getMessage(), e);
                    }
                }
            }
            finally {
                clipboard.dispose();
            }
        }

        private File createFile() throws IOException {
            File result = File.createTempFile(Messages.AttachmentsPart_PAST_ACTION_TEMP_FILE_PREFIX, ".png");
            result.deleteOnExit();
            return result;
        }

        private void save(ImageData data, File file) throws FileNotFoundException, IOException {
            ImageLoader loader = new ImageLoader();
            loader.data = new ImageData[]{data};
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            try {
                loader.save((OutputStream)os, 5);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
    }

    public class PasteActionCreator
    extends Action {
        private final Shell fShell;

        public PasteActionCreator(Shell shell) {
            super(Messages.AttachmentsPart_PAST_ACTION_NAME, null);
            this.fShell = shell;
            this.setActionDefinitionId("org.eclipse.ui.edit.paste");
        }

        public void run() {
            new PasteAction(AttachmentsPart.this.fWorkItemWorkingCopy, this.fShell).run();
        }
    }

    private static class RestoreAttachmentDialog
    extends SelectionDialog {
        private ArtifactLink fLink;
        private IAttachmentHandle fCurrent;
        private ITeamRepository fTeamRepository;
        private TableViewer fTableViewer;
        private HashMap<UUID, IContributor> fContributorCache = new HashMap();

        protected RestoreAttachmentDialog(Shell parentShell, ITeamRepository teamRepository, IAttachmentHandle current, ArtifactLink link) {
            super(parentShell);
            this.fTeamRepository = teamRepository;
            this.fCurrent = current;
            this.fLink = link;
            this.setMessage(Messages.AttachmentsPart_SELECT_HISTORY_ENTRY);
            this.setTitle(Messages.AttachmentsPart_REPLACE_FROM_HISTORY);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 11, IDialogConstants.OPEN_LABEL, false);
            this.createButton(parent, 0, Messages.AttachmentsPart_REPLACE, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 11) {
                if (this.fTableViewer.getSelection() instanceof IStructuredSelection && !this.fTableViewer.getSelection().isEmpty() && ((IStructuredSelection)this.fTableViewer.getSelection()).getFirstElement() instanceof IAttachment) {
                    final IAttachment attachment = (IAttachment)((IStructuredSelection)this.fTableViewer.getSelection()).getFirstElement();
                    new FoundationJob(Messages.AttachmentsPart_OPENING_ATTACHMENT){

                        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                            FileHelper.open(attachment, monitor);
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
                this.setReturnCode(1);
                this.close();
            }
            super.buttonPressed(buttonId);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.createMessageArea(composite);
            this.fTableViewer = new TableViewer(composite, 2820);
            GridData gd = new GridData(1808);
            gd.heightHint = this.fTableViewer.getTable().getItemHeight() * 12;
            gd.widthHint = 660;
            Table table = this.fTableViewer.getTable();
            table.setLayoutData((Object)gd);
            table.setHeaderVisible(true);
            TableColumn c = new TableColumn(table, 16384);
            c.setText(Messages.AttachmentsPart_NAME);
            c.setWidth(180);
            c.setResizable(true);
            c = new TableColumn(table, 16384);
            c.setText(Messages.AttachmentsPart_CREATED);
            c.setWidth(140);
            c.setResizable(true);
            c = new TableColumn(table, 16384);
            c.setText(Messages.AttachmentsPart_CREATED_BY);
            c.setWidth(140);
            c.setResizable(true);
            c = new TableColumn(table, 16384);
            c.setText(Messages.AttachmentsPart_SIZE);
            c.setWidth(50);
            c.setResizable(true);
            c = new TableColumn(table, 16384);
            c.setText(Messages.AttachmentsPart_TYPE);
            c.setWidth(140);
            c.setResizable(true);
            this.fTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    if (inputElement instanceof String) {
                        return new Object[]{inputElement};
                    }
                    if (inputElement instanceof List) {
                        return ((List)inputElement).toArray();
                    }
                    return new Object[0];
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            this.fTableViewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){
                DateFormat fDate = DateFormat.getDateInstance(3);
                DateFormat fTime = DateFormat.getTimeInstance(3);
                ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());

                public void update(ViewerCell cell) {
                    int columnIndex = cell.getColumnIndex();
                    if (cell.getElement() instanceof IAttachment) {
                        IAttachment att = (IAttachment)cell.getElement();
                        switch (columnIndex) {
                            case 0: {
                                cell.setText(att.getName());
                                ImageDescriptor descriptor = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(att.getName());
                                cell.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)descriptor));
                                break;
                            }
                            case 1: {
                                Date modified = att.modified();
                                cell.setText(String.valueOf(this.fDate.format(modified)) + " " + this.fTime.format(modified));
                                cell.setImage(null);
                                break;
                            }
                            case 2: {
                                IContributor c = (IContributor)RestoreAttachmentDialog.this.fContributorCache.get(att.getModifiedBy().getItemId());
                                if (c != null) {
                                    cell.setText(c.getName());
                                    cell.setImage(null);
                                    break;
                                }
                                cell.setText(null);
                                cell.setImage(null);
                                break;
                            }
                            case 3: {
                                cell.setText(AttachmentHTMLGenerator.smartFormatSize(att.getContent().getRawLength()));
                                cell.setImage(null);
                                break;
                            }
                            case 4: {
                                cell.setText(att.getContent().getContentType());
                                cell.setImage(null);
                            }
                        }
                    } else if (cell.getElement() instanceof String) {
                        if (columnIndex == 0) {
                            cell.setText((String)cell.getElement());
                            cell.setImage(null);
                        } else {
                            cell.setText(null);
                            cell.setImage(null);
                        }
                    } else {
                        cell.setText(null);
                        cell.setImage(null);
                    }
                }

                public void dispose() {
                    this.fResourceManager.dispose();
                }
            });
            this.fTableViewer.setInput((Object)Messages.AttachmentsPart_LOADING);
            this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    RestoreAttachmentDialog.this.okPressed();
                }
            });
            this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (RestoreAttachmentDialog.this.fTableViewer.getSelection().isEmpty() || ((IStructuredSelection)RestoreAttachmentDialog.this.fTableViewer.getSelection()).getFirstElement() instanceof String) {
                        RestoreAttachmentDialog.this.getOkButton().setEnabled(false);
                        RestoreAttachmentDialog.this.getButton(11).setEnabled(false);
                    } else {
                        RestoreAttachmentDialog.this.getOkButton().setEnabled(true);
                        RestoreAttachmentDialog.this.getButton(11).setEnabled(true);
                    }
                }
            });
            new TooltipSupport(this.fTableViewer.getControl(), true, false){

                protected Object mapElement(int x, int y) {
                    Object data;
                    TableItem item = RestoreAttachmentDialog.this.fTableViewer.getTable().getItem(new Point(x, y));
                    if (item != null && (data = item.getData()) instanceof IAttachment) {
                        return data;
                    }
                    return null;
                }

                protected Object doResolve(Object element) {
                    return element;
                }
            };
            RestoreAttachmentDialog.applyDialogFont((Control)composite);
            UIUpdaterJob resolverJob = new UIUpdaterJob(Messages.AttachmentsPart_FETCHING_HISTORY){
                List<IAttachment> fAllElements;
                {
                    this.fAllElements = new ArrayList<IAttachment>();
                }

                public IStatus runInBackground(IProgressMonitor monitor) {
                    try {
                        IItemManager manager = RestoreAttachmentDialog.this.fTeamRepository.itemManager();
                        List stateHandles = manager.fetchAllStateHandles((IAuditableHandle)RestoreAttachmentDialog.this.fCurrent, monitor);
                        List states = manager.fetchPartialStates(stateHandles, IAttachment.FULL_PROFILE.getProperties(), monitor);
                        for (Object state : states) {
                            if (!(state instanceof IAttachment)) continue;
                            this.fAllElements.add((IAttachment)state);
                        }
                        Collections.sort(this.fAllElements, new Comparator<IAttachment>(){

                            @Override
                            public int compare(IAttachment o1, IAttachment o2) {
                                return o2.modified().compareTo(o1.modified());
                            }
                        });
                        IAttachment currentState = null;
                        if (this.fAllElements.size() > 0 && !RestoreAttachmentDialog.this.fLink.isReplaced()) {
                            currentState = this.fAllElements.get(0);
                        }
                        if (this.fAllElements.size() > 1) {
                            ArrayList<IAttachment> toRemove = new ArrayList<IAttachment>();
                            IAttachment a = this.fAllElements.get(0);
                            int i = 1;
                            while (i < this.fAllElements.size()) {
                                IAttachment b = this.fAllElements.get(i);
                                if (a.getContent().getContentId().equals((Object)b.getContent().getContentId())) {
                                    toRemove.add(b);
                                }
                                a = b;
                                ++i;
                            }
                            this.fAllElements.removeAll(toRemove);
                        }
                        if (currentState != null) {
                            this.fAllElements.remove(currentState);
                        }
                        ItemHandleAwareHashSet contributorHandles = new ItemHandleAwareHashSet();
                        for (IAttachment a : this.fAllElements) {
                            contributorHandles.add((Object)a.getModifiedBy());
                        }
                        IAuditableClient auditableClient = (IAuditableClient)RestoreAttachmentDialog.this.fTeamRepository.getClientLibrary(IAuditableClient.class);
                        List contributors = auditableClient.resolveAuditables(contributorHandles.toList(), ItemProfile.CONTRIBUTOR_DEFAULT, monitor);
                        for (IContributor c : contributors) {
                            if (c == null) continue;
                            RestoreAttachmentDialog.this.fContributorCache.put(c.getItemId(), c);
                        }
                    }
                    catch (TeamRepositoryException e) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.AttachmentsPart_ERROR_RESOLVING_HISTORY, (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }

                public IStatus runInUI(IProgressMonitor monitor) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (this.fAllElements.isEmpty()) {
                        RestoreAttachmentDialog.this.fTableViewer.setInput((Object)Messages.AttachmentsPart_NO_ELEMENTS_IN_HISTORY);
                    } else {
                        RestoreAttachmentDialog.this.fTableViewer.setInput(this.fAllElements);
                        RestoreAttachmentDialog.this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)this.fAllElements.get(0)));
                    }
                    return Status.OK_STATUS;
                }
            };
            resolverJob.schedule();
            return composite;
        }

        protected void okPressed() {
            IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
            this.setResult(selection.toList());
            super.okPressed();
        }
    }
}

