/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.links;

import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class LinkContentProvider
implements ITreeContentProvider {
    private WorkItemWorkingCopy fWorkingCopy = null;
    private boolean fInSummary;

    public LinkContentProvider() {
        this(false);
    }

    public LinkContentProvider(boolean inSummary) {
        this.fInSummary = inSummary;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IEndPointDescriptor) {
            IEndPointDescriptor referenceType = (IEndPointDescriptor)element;
            if (referenceType.getLinkType().isInternal()) {
                return false;
            }
            IWorkItemReferences references = this.fWorkingCopy.getReferences();
            if (!WorkItemLinkTypes.isSymmetric((IEndPointDescriptor)referenceType)) {
                return references.hasReferences(referenceType);
            }
            ILinkType linkType = referenceType.getLinkType();
            return references.hasReferences(linkType.getSourceEndPointDescriptor()) || references.hasReferences(linkType.getTargetEndPointDescriptor());
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IEndPointDescriptor) {
            IEndPointDescriptor referenceType = (IEndPointDescriptor)parentElement;
            if (referenceType.getLinkType().isInternal()) {
                return new Object[0];
            }
            IWorkItemReferences references = this.fWorkingCopy.getReferences();
            if (!WorkItemLinkTypes.isSymmetric((IEndPointDescriptor)referenceType)) {
                return references.getReferences(referenceType).toArray();
            }
            ArrayList list = new ArrayList();
            ILinkType linkType = referenceType.getLinkType();
            list.addAll(references.getReferences(linkType.getSourceEndPointDescriptor()));
            list.addAll(references.getReferences(linkType.getTargetEndPointDescriptor()));
            return list.toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof IReference) {
            return WorkItemLinkTypes.getEndPointDescriptor((IReference)((IReference)element));
        }
        return null;
    }

    public Object[] getElements(Object inputElement) {
        if (this.fWorkingCopy == null) {
            return new Object[0];
        }
        List descriptors = this.fWorkingCopy.getReferences().getTypes();
        HashSet<IEndPointDescriptor> visible = new HashSet<IEndPointDescriptor>();
        for (IEndPointDescriptor descriptor : descriptors) {
            if (descriptor.getLinkType().isInternal()) continue;
            if (!WorkItemLinkTypes.isSymmetric((IEndPointDescriptor)descriptor)) {
                visible.add(descriptor);
                continue;
            }
            visible.add(descriptor.getLinkType().getTargetEndPointDescriptor());
        }
        if (!this.fInSummary) {
            visible.remove(WorkItemEndPoints.ATTACHMENT);
        }
        return visible.toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fWorkingCopy = (WorkItemWorkingCopy)newInput;
    }

    public void dispose() {
        this.fWorkingCopy = null;
    }

    public static boolean isFiltered(IEndPointDescriptor referenceType) {
        return referenceType == WorkItemEndPoints.ATTACHMENT;
    }
}

