/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.lightweight;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IDetailedStatus;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.IWorkingCopyListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkingCopyEvent;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.internal.WorkItemCommon;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.presentations.EditorPresentation;
import com.ibm.team.workitem.common.internal.presentations.SectionDescriptor;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IDeliverable;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import com.ibm.team.workitem.ide.ui.internal.HelpContextIds;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.lightweight.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormSectionContainer;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.WorkItemEditorSections;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationContext;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import com.ibm.team.workitem.rcp.core.ClientModel;
import com.ibm.team.workitem.rcp.ui.ILightWeightWorkItemCreator;
import com.ibm.team.workitem.rcp.ui.IValidationListener;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.LightweightWorkItemCreationContext;
import com.ibm.team.workitem.rcp.ui.UIWorkItemListener;
import com.ibm.team.workitem.rcp.ui.UIWorkItemWorkingCopyListener;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.internal.Workbench;

public class NewLightWeightWorkItemCreator
implements ILightWeightWorkItemCreator {
    LightweightWorkItemCreationContext fContext;
    private IWorkItem fCreatedWorkItem;
    private WorkItemWorkingCopy fWorkingCopy;
    private FormToolkit fToolkit;
    WorkItemEditorInput fEditorInput;
    private IValidationListener fValidationListener;
    private HashMap<String, Object> fNullValues = new HashMap();
    private List<String> fRequiredProperties;
    private ManagedForm fForm;
    private UIWorkItemListener fWorkItemListener = new UIWorkItemListener(){

        public void workItemAttributeChanged(WorkItemChangeEvent event) {
            if (NewLightWeightWorkItemCreator.this.fWorkingCopy != null && event.affects((IWorkItemHandle)NewLightWeightWorkItemCreator.this.fWorkingCopy.getWorkItem()) && (event.affects(IWorkItem.CATEGORY_PROPERTY) || event.affects(IWorkItem.TARGET_PROPERTY) || event.affects(IWorkItem.TYPE_PROPERTY))) {
                NewLightWeightWorkItemCreator.this.updateRequiredProperties();
            }
            NewLightWeightWorkItemCreator.this.validate(false);
            NewLightWeightWorkItemCreator.this.fPresentationHandlerManager.presentationEvent((WorkItemEvent)event);
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }
    };
    private UIWorkItemWorkingCopyListener fWorkingCopyListener = new UIWorkItemWorkingCopyListener(new IWorkingCopyListener(){

        public void workingCopyEvent(WorkingCopyEvent event) {
            if (event.hasType("saved") || event.hasType("saveCanceled") || event.hasType("reverted")) {
                NewLightWeightWorkItemCreator.this.fPresentationHandlerManager.presentationEvent((WorkItemEvent)event);
            }
        }
    });
    private PresentationHandlerManager fPresentationHandlerManager = new PresentationHandlerManager(new IPresentationContext(){

        public WorkItemWorkingCopy getWorkingCopy() {
            return NewLightWeightWorkItemCreator.this.fWorkingCopy;
        }

        public IWorkbenchWindow getWorkbench() {
            return Workbench.getInstance().getActiveWorkbenchWindow();
        }
    });
    private boolean fSuccessfullySaved;
    private IWorkItemClient fWorkItemClient;
    private EditorPresentation fEditorPresentation;

    public void setValidationListener(IValidationListener listener) {
        this.fValidationListener = listener;
    }

    public IStatus init(LightweightWorkItemCreationContext context, IProgressMonitor monitor) {
        this.fContext = context;
        IStatus status = FoundationUIUtils.validateRepository((ITeamRepository)context.getTeamRepository(), (boolean)true, (IProgressMonitor)monitor);
        if (status.getSeverity() == 8 || status.getSeverity() == 4) {
            this.updateStatus(status);
            return status;
        }
        try {
            this.initWorkItem(monitor);
        }
        catch (InterruptedException interruptedException) {
            this.updateStatus(Status.CANCEL_STATUS);
            return Status.CANCEL_STATUS;
        }
        catch (TeamRepositoryException e) {
            Status status2 = new Status(4, "com.ibm.team.workitem.ide.ui", Messages.NewLightWeightWorkItemCreator_ERROR_WHILE_INITIALIZING_STATUS_MESSAGE, (Throwable)e);
            this.updateStatus((IStatus)status2);
            return status2;
        }
        return Status.OK_STATUS;
    }

    public Control createContent(Composite parent) {
        this.fToolkit = new WorkItemEditorToolkit(new FormColors(parent.getDisplay()));
        this.fToolkit.setBackground(null);
        ScrolledForm sform = this.fToolkit.createScrolledForm(parent);
        sform.setLayoutData((Object)new GridData(1808));
        this.fForm = new ManagedForm(this.fToolkit, sform);
        this.fForm.setContainer((Object)new IAdaptable(){

            public Object getAdapter(Class adapter) {
                if (PresentationHandlerManager.class.equals((Object)adapter)) {
                    return NewLightWeightWorkItemCreator.this.fPresentationHandlerManager;
                }
                if (IWorkbenchWindow.class.equals((Object)adapter)) {
                    return Workbench.getInstance().getActiveWorkbenchWindow();
                }
                return null;
            }
        });
        this.updateRequiredProperties();
        this.createFormContent((IManagedForm)this.fForm);
        Dialog.applyDialogFont((Control)sform.getBody());
        this.validate(true);
        HelpContextIds.hookHelpListener((Control)sform, "com.ibm.team.workitem.ide.ui.work_item_creation_dialog");
        return sform;
    }

    public IStatus save(IProgressMonitor monitor) {
        this.setFormEnabled(false);
        IDetailedStatus status = this.fWorkingCopy.save(monitor);
        this.setFormEnabled(true);
        this.updateStatus((IStatus)status);
        this.fSuccessfullySaved = status.isOK();
        if (this.fSuccessfullySaved) {
            ClientModel.getHistoryManager().addToHistory((IWorkItemHandle)this.fWorkingCopy.getWorkItem().getItemHandle(), WorkItemTextUtilities.getWorkItemText((IWorkItem)this.fWorkingCopy.getWorkItem()));
        }
        return status;
    }

    private void setFormEnabled(final boolean enabled) {
        FoundationUIJob job = new FoundationUIJob(Messages.NewLightWeightWorkItemCreator_SETTING_FORM_ENABLEMENT){

            protected IStatus runProtectedInUI(IProgressMonitor monitor) throws Exception {
                NewLightWeightWorkItemCreator.this.fForm.getForm().setEnabled(enabled);
                return null;
            }
        };
        job.setSystem(true);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    public IWorkItemHandle getCreatedWorkItem() {
        if (!this.fSuccessfullySaved) {
            throw new IllegalStateException(Messages.NewLightWeightWorkItemCreator_CREATED_WORKITEM_NOT_YET_SAVED);
        }
        return (IWorkItemHandle)this.fCreatedWorkItem.getItemHandle();
    }

    private void createFormContent(IManagedForm mform) {
        ScrolledForm form = mform.getForm();
        Composite body = form.getBody();
        FormLayout layout = new FormLayout();
        body.setLayout((Layout)layout);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100);
        formData.right = new FormAttachment(100);
        body.setLayoutData((Object)formData);
        final TeamFormSectionContainer section = this.createPartSection(mform);
        if (section != null) {
            mform.addPart((IFormPart)section.getFormPart());
            formData = new FormData();
            formData.left = new FormAttachment(0);
            formData.top = new FormAttachment(0);
            formData.bottom = new FormAttachment(100);
            formData.right = new FormAttachment(100);
            section.getLayoutControl().setLayoutData((Object)formData);
            section.getFormPart().setFormInput((Object)this.fEditorInput);
        } else {
            Control[] controlArray = body.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.dispose();
                ++n2;
            }
            Composite cont = this.fToolkit.createComposite(body);
            formData = new FormData();
            formData.left = new FormAttachment(0);
            formData.top = new FormAttachment(0);
            formData.bottom = new FormAttachment(100);
            formData.right = new FormAttachment(100);
            cont.setLayoutData((Object)formData);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            cont.setLayout((Layout)gridLayout);
            FormText text = this.fToolkit.createFormText(cont, true);
            GridData data = new GridData(4, 4, true, false);
            data.widthHint = 150;
            text.setLayoutData((Object)data);
            text.setHyperlinkSettings((HyperlinkSettings)this.fToolkit.getHyperlinkGroup());
            text.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    Object href = e.getHref();
                    try {
                        URI uri = URI.create(href.toString());
                        Hyperlinks.open((URI)uri, null);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            });
            String url = Location.itemLocation((IItemHandle)this.fWorkingCopy.getWorkItem().getProjectArea(), (String)this.fWorkingCopy.getTeamRepository().getRepositoryURI()).toAbsoluteUri().toString();
            String message = NLS.bind((String)Messages.NewLightWeightWorkItemCreator_CONFIGURE_PROJECT_AREA, (Object)url, (Object[])new Object[0]);
            text.setText(message, true, false);
        }
        form.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (section != null) {
                    section.getFormPart().dispose();
                }
                if (NewLightWeightWorkItemCreator.this.fWorkingCopy != null) {
                    WorkItemUIWorkingCopy uiWorkingCopy = (WorkItemUIWorkingCopy)NewLightWeightWorkItemCreator.this.fWorkingCopy.getAdapter(WorkItemUIWorkingCopy.class);
                    if (uiWorkingCopy != null) {
                        uiWorkingCopy.getUIWorkItemListener().removeListener((IWorkItemListener)NewLightWeightWorkItemCreator.this.fWorkItemListener);
                    }
                    NewLightWeightWorkItemCreator.this.fWorkingCopy.removeWorkingCopyListener((IWorkingCopyListener)NewLightWeightWorkItemCreator.this.fWorkingCopyListener);
                    NewLightWeightWorkItemCreator.this.fToolkit.dispose();
                }
                NewLightWeightWorkItemCreator.this.fEditorInput.release();
            }
        });
    }

    private TeamFormSectionContainer createPartSection(IManagedForm mform) {
        WorkItemUIWorkingCopy uiWorkingCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(WorkItemUIWorkingCopy.class);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("noHeader", "true");
        SectionDescriptor sectionDescriptor = new SectionDescriptor(this.fEditorPresentation.getPresentationId(), "none", "none", properties);
        TeamFormSectionContainer section = WorkItemEditorSections.createSection(this.fEditorInput, this.fEditorInput.getEditorPresentation().getPresentationsMap(), sectionDescriptor, mform, mform.getForm().getBody(), 256);
        uiWorkingCopy.getUIWorkItemListener().addListener((IWorkItemListener)this.fWorkItemListener);
        this.fWorkingCopy.addWorkingCopyListener((IWorkingCopyListener)this.fWorkingCopyListener);
        return section;
    }

    private void initWorkItem(IProgressMonitor monitor) throws InterruptedException, TeamRepositoryException {
        IWorkItemType workItemType;
        boolean isWorkItemTypeSet = this.fContext.isWorkItemTypeSet();
        int work = 14;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(isWorkItemTypeSet ? work : work + 3));
        this.fWorkItemClient = (IWorkItemClient)this.fContext.getTeamRepository().getClientLibrary(IWorkItemClient.class);
        if (subMonitor.isCanceled()) {
            throw new InterruptedException();
        }
        if (isWorkItemTypeSet) {
            subMonitor.newChild(1);
            workItemType = this.fContext.getWorkItemType();
        } else {
            List workItemTypes = this.fWorkItemClient.findWorkItemTypes(this.fContext.getProjectAreaHandle(), (IProgressMonitor)subMonitor.newChild(3));
            workItemType = !workItemTypes.isEmpty() ? (IWorkItemType)workItemTypes.get(0) : this.fWorkItemClient.findWorkItemType(this.fContext.getProjectAreaHandle(), "defect", (IProgressMonitor)subMonitor.newChild(3));
        }
        if (subMonitor.isCanceled()) {
            throw new InterruptedException();
        }
        subMonitor.newChild(1);
        IWorkItemWorkingCopyManager manager = this.fWorkItemClient.getWorkItemWorkingCopyManager();
        if (subMonitor.isCanceled()) {
            throw new InterruptedException();
        }
        IWorkItemHandle newHandle = manager.connectNew(workItemType, (IProgressMonitor)subMonitor.newChild(5));
        try {
            this.fCreatedWorkItem = manager.getWorkingCopy(newHandle).getWorkItem();
            this.fEditorInput = (WorkItemEditorInput)((Object)Adapters.getAdapter((Object)this.fCreatedWorkItem, IEditorInput.class));
            this.fEditorPresentation = ((WorkItemCommon)this.fWorkItemClient).getEditorPresentation("com.ibm.team.workitem.editor.lightweight", this.fCreatedWorkItem, (IProgressMonitor)subMonitor.newChild(2));
            if (subMonitor.isCanceled()) {
                throw new InterruptedException();
            }
            subMonitor.newChild(6);
            this.fWorkingCopy = this.fEditorInput.getWorkingCopy();
            ((WorkItemWorkingCopyImpl)this.fWorkingCopy).setDirty(true);
        }
        finally {
            manager.disconnect((IWorkItemHandle)this.fCreatedWorkItem);
        }
        this.setContextValues(monitor);
    }

    private void setContextValues(IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItem workItem = this.fWorkingCopy.getWorkItem();
        if (this.fContext.isCategorySet()) {
            workItem.setCategory((ICategoryHandle)this.fContext.getCategory());
        }
        if (this.fContext.isDescriptionSet()) {
            workItem.setHTMLDescription(XMLString.createFromPlainText((String)this.fContext.getDescription()));
        }
        if (this.fContext.isFoundInSet()) {
            IDeliverable foundIn = this.fContext.getFoundIn();
            IAttribute attribute = this.fWorkItemClient.findAttribute(this.fWorkingCopy.getWorkItem().getProjectArea(), IWorkItem.FOUND_IN_PROPERTY, monitor);
            if (attribute != null) {
                workItem.setValue(attribute, (Object)foundIn);
            }
        }
        if (this.fContext.isSeveritySet()) {
            workItem.setSeverity(this.fContext.getSeverity().getIdentifier2());
        }
        if (this.fContext.isSummarySet()) {
            workItem.setHTMLSummary(XMLString.createFromPlainText((String)this.fContext.getSummary()));
        }
    }

    private void updateStatus(final IStatus status) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (NewLightWeightWorkItemCreator.this.fValidationListener == null) {
                    return;
                }
                NewLightWeightWorkItemCreator.this.fValidationListener.validationChanged(status);
            }
        });
    }

    private void validate(boolean silent) {
        if (this.fValidationListener == null) {
            return;
        }
        WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
        ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
        for (String property : this.fRequiredProperties) {
            Object nullValue;
            Object value;
            if (!workItem.contains(property) || !this.equals(value = workItem.getValue(property), nullValue = this.fNullValues.get(property))) continue;
            String message = silent ? "" : NLS.bind((String)Messages.NewLightWeightWorkItemCreator_ATTRIBUTE_NOT_SET, (Object)workItem.findAttribute(WorkItemAttributes.getPropertyIdentifier((String)property)).getDisplayName(), (Object[])new Object[0]);
            this.fValidationListener.validationChanged((IStatus)new Status(4, "com.ibm.team.workitem.ide.ui", message));
            return;
        }
        this.fValidationListener.validationChanged((IStatus)(silent ? new Status(0, "com.ibm.team.workitem.ide.ui", "") : Status.OK_STATUS));
    }

    private boolean equals(Object expected, Object other) {
        if (expected instanceof IItemHandle && other instanceof IItemHandle) {
            return ((IItemHandle)expected).sameItemId((IItemHandle)other);
        }
        if (expected == other) {
            return true;
        }
        if (expected != null) {
            return expected.equals(other);
        }
        return other == null;
    }

    private void updateRequiredProperties() {
        try {
            Workbench.getInstance().getActiveWorkbenchWindow().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IWorkItemClient workitemClient = (IWorkItemClient)NewLightWeightWorkItemCreator.this.fWorkingCopy.getTeamRepository().getClientLibrary(IWorkItemClient.class);
                    try {
                        NewLightWeightWorkItemCreator.this.fRequiredProperties = workitemClient.findRequiredProperties(NewLightWeightWorkItemCreator.this.fWorkingCopy.getWorkItem(), monitor);
                        for (String property : NewLightWeightWorkItemCreator.this.fRequiredProperties) {
                            IAttribute attribute = NewLightWeightWorkItemCreator.this.fWorkItemClient.findAttribute(NewLightWeightWorkItemCreator.this.fContext.getProjectAreaHandle(), property, monitor);
                            Object nullValue = attribute.getNullValue(NewLightWeightWorkItemCreator.this.fWorkItemClient.getAuditableCommon(), monitor);
                            NewLightWeightWorkItemCreator.this.fNullValues.put(property, nullValue);
                        }
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
    }
}

