/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.itempicker;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.ProcessAreaSelectionDialog;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.ide.ui.internal.editor.itempicker.IItemPicker;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessAreaItemPicker
implements IItemPicker {
    private IStatus fStatus = Status.OK_STATUS;

    @Override
    public IItemHandle getItemResult(Object shellContext, Object pickerContext, ITeamRepository teamRepository, String title, String message, List<? extends IItemHandle> filteredItems, List<? extends IItemHandle> initialSelection, boolean includeArchived) {
        Shell shell = null;
        shell = shellContext instanceof Shell ? (Shell)shellContext : Display.getCurrent().getActiveShell();
        ProcessAreaSelectionDialog dialog = new ProcessAreaSelectionDialog(shell, "teamArea".equals(pickerContext));
        if (title != null) {
            dialog.setTitle(title);
        }
        if (message != null) {
            dialog.setMessage(message);
        }
        if ("projectArea".equals(pickerContext)) {
            dialog.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return element instanceof IProjectAreaHandle;
                }
            });
        }
        dialog.setInput((Object)teamRepository);
        if (initialSelection != null && initialSelection.size() == 1) {
            dialog.setInitialElementSelections(initialSelection);
        }
        dialog.setAllowArchivedAreas(includeArchived);
        dialog.setAllowMultiple(false);
        dialog.setDoubleClickSelects(true);
        if (dialog.open() == 0) {
            this.fStatus = Status.OK_STATUS;
            return dialog.getSelectedProcessArea();
        }
        this.fStatus = Status.CANCEL_STATUS;
        return null;
    }

    @Override
    public List<? extends IItemHandle> getItemResults(Object shellContext, Object pickerContext, ITeamRepository teamRepository, String title, String message, List<? extends IItemHandle> filteredItems, List<? extends IItemHandle> initialSelection, boolean includeArchived) {
        Shell shell = null;
        shell = shellContext instanceof Shell ? (Shell)shellContext : Display.getCurrent().getActiveShell();
        String containedType = null;
        if (pickerContext instanceof String) {
            containedType = AttributeTypes.getContainedType((String)((String)pickerContext));
        }
        ProcessAreaSelectionDialog dialog = new ProcessAreaSelectionDialog(shell, "teamArea".equals(containedType));
        if (title != null) {
            dialog.setTitle(title);
        }
        if (message != null) {
            dialog.setMessage(message);
        }
        if ("projectArea".equals(containedType)) {
            dialog.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return element instanceof IProjectAreaHandle;
                }
            });
        }
        dialog.setAllowArchivedAreas(includeArchived);
        dialog.setAllowMultiple(true);
        if (initialSelection != null) {
            dialog.setInitialElementSelections(initialSelection);
        }
        dialog.setInput((Object)teamRepository);
        dialog.setDoubleClickSelects(true);
        if (dialog.open() == 0) {
            this.fStatus = Status.OK_STATUS;
            return Arrays.asList(dialog.getResult());
        }
        this.fStatus = Status.CANCEL_STATUS;
        return null;
    }

    @Override
    public IStatus getStatus() {
        return this.fStatus;
    }
}

