/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.comments;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.HyperlinkHandler;
import com.ibm.team.foundation.rcp.core.internal.HyperlinkHandlerRegistry;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.TeamFormPage;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.URIService;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditor;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemTeamFormPartContainer;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemTeamFormSectionPart;
import com.ibm.team.workitem.ide.ui.internal.editor.comments.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.part.DiscussionPart;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;

public class WorkItemHyperlinkHandler
extends HyperlinkHandler {
    private static final String TARGET_PRESENTATION_QUERY_KEY = "targetPresentation=";
    private static final Status STATUS_COULDNT_RESOLVE = new Status(8, "com.ibm.team.workitem.ide.ui", Messages.WorkItemHyperlinkHandler_COULD_NOT_RESOLVE_WORKITEM_TO_OPEN);
    private static final Status STATUS_REPOSITORY_UNKNOWN = new Status(8, "com.ibm.team.workitem.ide.ui", Messages.WorkItemHyperlinkHandler_COULD_NOT_OPEN_WORKITEM_REPOSITORY_UNKNOWN);
    private static final URI CANCEL_URI = URI.create("error");

    public boolean resolves(URI uri) {
        return IWorkItem.ITEM_TYPE.equals(URIService.findItemType((URI)uri));
    }

    public boolean handles(URI uri) {
        return IWorkItem.ITEM_TYPE.equals(URIService.findItemType((URI)uri)) && URIService.findTeamRepository((URI)uri) != null;
    }

    public Object resolve(URI uri, ContextProvider provider) throws TeamRepositoryException {
        return URIService.resolveObject((URI)uri);
    }

    public IStatus open2(final URI uri, final ContextProvider context, IProgressMonitor monitor) {
        try {
            Object object;
            URI repositoryURI = this.getRepositoryURI(uri, context, monitor);
            if (repositoryURI == null) {
                return STATUS_REPOSITORY_UNKNOWN;
            }
            if (repositoryURI == CANCEL_URI) {
                return Status.OK_STATUS;
            }
            Object tmp = null;
            try {
                tmp = URIService.resolveObject((URI)uri, (IProgressMonitor)monitor);
            }
            catch (ItemNotFoundException itemNotFoundException) {}
            if (tmp == null) {
                tmp = URIService.resolveItemHandle((URI)uri);
            }
            if ((object = tmp) != null) {
                String name = object instanceof IWorkItem ? ((IWorkItem)object).getHTMLSummary().getPlainText() : Messages.WorkItemHyperlinkHandler_WORKITEM;
                WorkItemRCPUIPlugin.runInUI((String)MessageFormat.format(Messages.WorkItemHyperlinkHandler_OPENING, name), (IRunnableWithProgress)new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        IWorkbenchPage page = WorkItemHyperlinkHandler.findWorkbenchPage(context);
                        if (object instanceof IComment) {
                            IEditorPart part = WorkItemUI.openEditor((IWorkbenchPage)page, (Object)((EObject)object).eContainer());
                            if (part != null) {
                                WorkItemHyperlinkHandler.revealComment(part, uri);
                                return;
                            }
                        } else {
                            IEditorPart editorPart = WorkItemUI.openEditor((IWorkbenchPage)page, (Object)object);
                            if (editorPart != null) {
                                String targetPresentationValue = WorkItemHyperlinkHandler.this.getTargetPresentationValue(uri);
                                if (targetPresentationValue != null) {
                                    WorkItemHyperlinkHandler.revealPresentation(editorPart, targetPresentationValue);
                                }
                                return;
                            }
                        }
                        HyperlinkHandlerRegistry.getDefault().getDefaultHandler().open(uri, context, monitor);
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
                return Status.OK_STATUS;
            }
            Location location = Location.location((URI)uri);
            if (location.isNamed()) {
                WorkItemUI.openItemNotFoundDialog((String)(String.valueOf(Messages.WorkItemHyperlinkHandler_WOKRITEM) + location.getNamedId()));
            } else {
                WorkItemUI.openItemNotFoundDialog((String)Messages.WorkItemHyperlinkHandler_WOKRITEM);
            }
            return STATUS_COULDNT_RESOLVE;
        }
        catch (PermissionDeniedException permissionDeniedException) {
            WorkItemUI.openPermissionDeniedDialog((String)Messages.WorkItemHyperlinkHandler_WORKITEM);
            return Status.OK_STATUS;
        }
        catch (ItemNotFoundException itemNotFoundException) {
            WorkItemUI.openItemNotFoundDialog((String)Messages.WorkItemHyperlinkHandler_WORKITEM);
            return Status.OK_STATUS;
        }
        catch (TeamRepositoryException x) {
            return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.WorkItemHyperlinkHandler_EXCEPTION_OPENING_WORKITEM, (Throwable)x);
        }
    }

    private String getTargetPresentationValue(URI uri) {
        String query;
        if (uri != null && (query = uri.getQuery()) != null && query.contains(TARGET_PRESENTATION_QUERY_KEY)) {
            query = query.substring(query.indexOf(TARGET_PRESENTATION_QUERY_KEY));
            query = query.substring(TARGET_PRESENTATION_QUERY_KEY.length());
            return query;
        }
        return null;
    }

    private URI getRepositoryURI(final URI uri, final ContextProvider context, IProgressMonitor monitor) {
        try {
            ITeamRepository repo = URIService.getLoggedInTeamRepository((URI)uri, null);
            IStatus status = FoundationUIUtils.validateRepository((ITeamRepository)repo, (boolean)false, (IProgressMonitor)monitor);
            if (status.getSeverity() == 8) {
                return CANCEL_URI;
            }
            return new URI(repo.getRepositoryURI());
        }
        catch (PermissionDeniedException permissionDeniedException) {
            WorkItemUI.openPermissionDeniedDialog((String)Messages.WorkItemHyperlinkHandler_WORKITEM);
            return null;
        }
        catch (TeamRepositoryException teamRepositoryException) {
            FoundationUIJob job = new FoundationUIJob(Messages.WorkItemHyperlinkHandler_INFORMING_USER_NONAVAILABLE_REPO){

                public IStatus runProtectedInUI(IProgressMonitor monitor) {
                    IWorkbenchPage page = WorkItemHyperlinkHandler.findWorkbenchPage(context);
                    if (page != null) {
                        String repoURI = WorkItemHyperlinkHandler.findRepositoryURI(uri);
                        if (repoURI == null) {
                            repoURI = uri.toString();
                        }
                        MessageDialog.openInformation((Shell)page.getWorkbenchWindow().getShell(), (String)Messages.WorkItemHyperlinkHandler_REPOSITORY_NOT_FOUND_TITLE, (String)NLS.bind((String)Messages.WorkItemHyperlinkHandler_REPOSITORY_NOT_FOUND_INFO, (Object)repoURI, (Object[])new Object[0]));
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
            return null;
        }
        catch (URISyntaxException e) {
            WorkItemIDEUIPlugin.getDefault().log(Messages.WorkItemHyperlinkHandler_ILLEGAL_URI_REPO, e);
            return null;
        }
    }

    private static String findRepositoryURI(URI uri) {
        try {
            Location location = Location.location((URI)uri);
            if (!"".equals(location.getRepoUri())) {
                return location.getRepoUri();
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return null;
    }

    private static void revealPresentation(IEditorPart part, String presentationId) {
        if (part.getEditorInput() instanceof WorkItemEditorInput && !((WorkItemEditorInput)part.getEditorInput()).isResolved()) {
            part.addPropertyListener((IPropertyListener)new InternalPropertyListener(part, presentationId));
            return;
        }
        if (part instanceof WorkItemEditor) {
            ((WorkItemEditor)part).activatePart(presentationId);
        }
    }

    private static void revealComment(IEditorPart part, URI commentURI) {
        if (part.getEditorInput() instanceof WorkItemEditorInput && !((WorkItemEditorInput)part.getEditorInput()).isResolved()) {
            part.addPropertyListener((IPropertyListener)new InternalPropertyListener(part, commentURI));
            return;
        }
        DiscussionPart discussionPart = WorkItemHyperlinkHandler.getDiscussionPart(part);
        if (discussionPart != null) {
            discussionPart.revealComment(commentURI);
        }
    }

    private static DiscussionPart getDiscussionPart(IEditorPart editorPart) {
        if (!(editorPart instanceof WorkItemEditor)) {
            return null;
        }
        List pages = ((WorkItemEditor)editorPart).getPages();
        for (Object page : pages) {
            IFormPart[] formParts;
            if (!(page instanceof TeamFormPage)) continue;
            IFormPart[] iFormPartArray = formParts = ((TeamFormPage)page).getManagedForm().getParts();
            int n = formParts.length;
            int n2 = 0;
            while (n2 < n) {
                IFormPart formPart = iFormPartArray[n2];
                TeamFormPart[] parts = null;
                if (formPart instanceof WorkItemTeamFormSectionPart) {
                    parts = ((WorkItemTeamFormSectionPart)formPart).getParts();
                } else if (formPart instanceof WorkItemTeamFormPartContainer) {
                    parts = ((WorkItemTeamFormPartContainer)formPart).getParts();
                }
                if (parts != null) {
                    TeamFormPart[] teamFormPartArray = parts;
                    int n3 = parts.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TeamFormPart part = teamFormPartArray[n4];
                        if (part instanceof DiscussionPart) {
                            return (DiscussionPart)part;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    public URIReference createHyperlink(Object object) {
        IComment comment = null;
        if (object instanceof IComment) {
            comment = (IComment)object;
            object = ((EObject)object).eContainer();
        }
        if (object instanceof IWorkItemHandle) {
            IWorkItemHandle handle = (IWorkItemHandle)object;
            ITeamRepository teamRepository = (ITeamRepository)handle.getOrigin();
            if (teamRepository == null || !teamRepository.loggedIn()) {
                return super.createHyperlink(object);
            }
            IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
            IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
            try {
                String details;
                String name;
                IWorkItem item = handle instanceof IWorkItem && ((IWorkItem)handle).isNewItem() ? (IWorkItem)handle : (!ThreadCheck.longOpsProhibited() ? (IWorkItem)auditableClient.resolveAuditable((IAuditableHandle)handle, IWorkItem.SMALL_PROFILE, null) : (IWorkItem)auditableClient.findCachedAuditable((IAuditableHandle)handle, IWorkItem.SMALL_PROFILE));
                if (item != null) {
                    IWorkItemType type = !ThreadCheck.longOpsProhibited() ? workItemClient.findWorkItemType(item.getProjectArea(), item.getWorkItemType(), null) : workItemClient.findCachedWorkItemType(item.getProjectArea(), item.getWorkItemType());
                    String typeName = type != null ? String.valueOf(type.getDisplayName().toLowerCase()) + " " : Messages.WorkItemHyperlinkHandler_WORKITEM_NOUN_BLANK;
                    name = String.valueOf(typeName) + WorkItemTextUtilities.getWorkItemId((IWorkItem)item);
                    details = String.valueOf(typeName) + WorkItemTextUtilities.getWorkItemText((IWorkItem)item);
                } else {
                    details = name = Messages.WorkItemHyperlinkHandler_WORKITEM_NOUN;
                }
                if (comment != null) {
                    int index = ((WorkItem)((EObject)comment).eContainer()).getInternalComments().indexOf(comment);
                    name = String.valueOf(name) + NLS.bind((String)Messages.WorkItemHyperlinkHandler_COMMENT_NAME, (Object)(index + 1), (Object[])new Object[0]);
                    details = String.valueOf(details) + NLS.bind((String)Messages.WorkItemHyperlinkHandler_COMMENT_DETAILS, (Object)(index + 1), (Object[])new Object[0]);
                    return new URIReference(name, details, IComment.class.getName(), URIService.createWorkItemCommentURI((IWorkItemHandle)handle, (int)index));
                }
                return new URIReference(name, details, String.valueOf(IWorkItem.ITEM_TYPE.getNamespaceURI()) + "." + IWorkItem.ITEM_TYPE.getName(), URIService.createAuditableURI((ITeamRepository)teamRepository, (IItemHandle)handle));
            }
            catch (ItemNotFoundException itemNotFoundException) {
            }
            catch (TeamRepositoryException e) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.WorkItemHyperlinkHandler_EXCEPTION_RESOLVING_WORKITEM, e);
            }
        }
        return super.createHyperlink(object);
    }

    public boolean links(Object object) {
        if (object instanceof IWorkItemHandle) {
            return true;
        }
        if (object instanceof IComment) {
            return true;
        }
        return super.links(object);
    }

    public static IWorkbenchPage findWorkbenchPage(ContextProvider context) {
        Shell shell = null;
        if (context != null) {
            Object uiContext = context.findUIContext();
            if (uiContext instanceof Shell) {
                shell = (Shell)uiContext;
            } else if (uiContext instanceof IWorkbenchWindow) {
                shell = ((IWorkbenchWindow)uiContext).getShell();
            }
        }
        return Util.getWorkbenchPage(shell);
    }

    public static Shell findShell(ContextProvider context) {
        IWorkbenchWindow activeWindow;
        if (context != null) {
            Object uiContext = context.findUIContext();
            if (uiContext instanceof IWorkbenchPage) {
                return ((IWorkbenchPage)uiContext).getWorkbenchWindow().getShell();
            }
            if (uiContext instanceof Shell) {
                return (Shell)uiContext;
            }
            if (uiContext instanceof IWorkbenchWindow) {
                return ((IWorkbenchWindow)uiContext).getShell();
            }
        }
        if ((activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            return activeWindow.getShell();
        }
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows.length > 0) {
            return windows[0].getShell();
        }
        return null;
    }

    private static class InternalPropertyListener
    implements IPropertyListener {
        private final IEditorPart fPart;
        private final URI fCommentToReveal;
        private final String fPresentationToReveal;

        private InternalPropertyListener(IEditorPart part, URI commentToReveal) {
            this.fPart = part;
            this.fCommentToReveal = commentToReveal;
            this.fPresentationToReveal = null;
        }

        private InternalPropertyListener(IEditorPart part, String presentationToReveal) {
            this.fPart = part;
            this.fPresentationToReveal = presentationToReveal;
            this.fCommentToReveal = null;
        }

        public void propertyChanged(Object source, int propId) {
            if (propId == 258 || propId == 1) {
                this.fPart.removePropertyListener((IPropertyListener)this);
                if (this.fCommentToReveal != null) {
                    WorkItemHyperlinkHandler.revealComment(this.fPart, this.fCommentToReveal);
                } else {
                    WorkItemHyperlinkHandler.revealPresentation(this.fPart, this.fPresentationToReveal);
                }
            }
        }
    }
}

