/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.comments;

import com.ibm.team.foundation.rcp.core.text.ReferencePosition;
import com.ibm.team.repository.common.util.ExtensionRegistryReader;
import com.ibm.team.repository.common.util.ExtensionRegistryReaderListener;
import com.ibm.team.workitem.ide.ui.internal.editor.comments.ILineBasedSubstitutionScanner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineBasedSubstitutionScannerRegistry
implements ExtensionRegistryReaderListener<Object> {
    private static final String SCANNER_EXTENSION_POINT_ID = "lineScanner";
    private List<ILineBasedSubstitutionScanner> fScanners = new ArrayList<ILineBasedSubstitutionScanner>();
    private ExtensionRegistryReader<Object> fExtensionReader = new ExtensionRegistryReader<Object>("com.ibm.team.workitem.ide.ui", "lineScanner"){};

    public static LineBasedSubstitutionScannerRegistry getDefault() {
        return Holder.INSTANCE;
    }

    private LineBasedSubstitutionScannerRegistry() {
        this.fExtensionReader.addListener((ExtensionRegistryReaderListener)this);
        this.fExtensionReader.start();
    }

    public List<ILineBasedSubstitutionScanner> getScanners() {
        return Collections.unmodifiableList(this.fScanners);
    }

    public ReferencePosition[] scan(String text) {
        List<ILineBasedSubstitutionScanner> scanners = this.getScanners();
        for (ILineBasedSubstitutionScanner scanner : scanners) {
            ReferencePosition[] positions = scanner.scan(text);
            if (positions.length <= 0) continue;
            return positions;
        }
        return new ReferencePosition[0];
    }

    public void handleExtensionAdded(IConfigurationElement element, Object descriptor) throws Exception {
        ILineBasedSubstitutionScanner scanner = (ILineBasedSubstitutionScanner)element.createExecutableExtension("class");
        this.fScanners.add(scanner);
    }

    public void handleExtensionRemoved(IConfigurationElement element, Object descriptor) throws Exception {
        ILineBasedSubstitutionScanner scanner = (ILineBasedSubstitutionScanner)element.createExecutableExtension("class");
        this.fScanners.remove(scanner);
    }

    public void handleBundleStarted(String bundleSymbolicName, List<IConfigurationElement> elements, List<Object> descriptors) throws Exception {
    }

    public void handleBundleStopped(String bundleSymbolicName, List<IConfigurationElement> elements, List<Object> descriptors) throws Exception {
    }

    /* synthetic */ LineBasedSubstitutionScannerRegistry(LineBasedSubstitutionScannerRegistry lineBasedSubstitutionScannerRegistry) {
        this();
    }

    private static class Holder {
        private static final LineBasedSubstitutionScannerRegistry INSTANCE = new LineBasedSubstitutionScannerRegistry(null);

        private Holder() {
        }
    }
}

