/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.comments;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.HyperlinkHandler;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.ide.ui.EditorUtilities;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.URIService;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.comments.Messages;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class CategoryHyperlinkHandler
extends HyperlinkHandler {
    public boolean handles(URI uri) {
        return ICategory.ITEM_TYPE.equals(URIService.findItemType((URI)uri));
    }

    public boolean resolves(URI uri) {
        return ICategory.ITEM_TYPE.equals(URIService.findItemType((URI)uri));
    }

    public boolean links(Object object) {
        return object instanceof ICategoryHandle;
    }

    public Object resolve(URI uri, ContextProvider provider, IProgressMonitor monitor) throws CoreException {
        try {
            return URIService.resolveObject((URI)uri, (IProgressMonitor)monitor);
        }
        catch (TeamRepositoryException x) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.team.workitem.ide.ui", x.getMessage(), (Throwable)x));
        }
    }

    public Object resolve(URI uri, ContextProvider provider) throws TeamRepositoryException {
        return URIService.resolveObject((URI)uri, null);
    }

    public IStatus open2(URI uri, ContextProvider context, IProgressMonitor monitor) {
        try {
            URIService.getLoggedInTeamRepository((URI)uri, (IProgressMonitor)monitor);
            Object object = URIService.resolveObject((URI)uri, (IProgressMonitor)monitor);
            if (object instanceof ICategory) {
                ICategory category = (ICategory)object;
                IWorkbenchPage page = CategoryHyperlinkHandler.findWorkbenchPage(context);
                if (page != null) {
                    EditorUtilities.openProjectAreaEditor((IWorkbenchPage)page, (IProjectAreaHandle)category.getProjectArea(), (String)"com.ibm.team.workitem.category");
                }
                return Status.OK_STATUS;
            }
            return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.CategoryHyperlinkHandler_UNEXPECTED_TYPE);
        }
        catch (PermissionDeniedException permissionDeniedException) {
            WorkItemUI.openPermissionDeniedDialog((String)Messages.CategoryHyperlinkHandler_FILED_AGAINST);
            return Status.OK_STATUS;
        }
        catch (TeamRepositoryException x) {
            return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.CategoryHyperlinkHandler_EXCEPTION_RESOLVE, (Throwable)x);
        }
    }

    public void open(URI uri, ContextProvider provider, IProgressMonitor monitor) {
        this.open2(uri, provider, monitor);
    }

    public void open(URI uri, ContextProvider provider) {
        this.open2(uri, provider, null);
    }

    public URIReference createHyperlink(Object object, IProgressMonitor monitor) {
        try {
            if (object instanceof ICategoryHandle) {
                ICategoryHandle handle = (ICategoryHandle)object;
                ITeamRepository repository = (ITeamRepository)handle.getOrigin();
                IAuditableClient auditableClient = (IAuditableClient)repository.getClientLibrary(IAuditableClient.class);
                ItemProfile profile = ItemProfile.createProfile((IItemType)ICategory.ITEM_TYPE, (String[])new String[]{ICategory.NAME_PROPERTY, ICategory.DESCRIPTION_PROPERTY});
                ICategory category = (ICategory)auditableClient.resolveAuditable((IAuditableHandle)handle, profile, monitor);
                URI uri = Location.itemLocation((IItemHandle)handle, (String)repository.getRepositoryURI()).toAbsoluteUri();
                return new URIReference(category.getName(), NLS.bind((String)Messages.CategoryHyperlinkHandler_NAME_DESCRIPTION, (Object)category.getName(), (Object[])new Object[]{category.getHTMLDescription().getPlainText()}), ICategory.class.getName(), uri);
            }
        }
        catch (TeamRepositoryException x) {
            WorkItemIDEUIPlugin.getDefault().log(Messages.CategoryHyperlinkHandler_EXCEPTION_RESOLVE, x);
        }
        return null;
    }

    public URIReference createHyperlink(Object object) {
        return this.createHyperlink(object, null);
    }

    private static IWorkbenchPage findWorkbenchPage(ContextProvider context) {
        Shell shell = null;
        if (context != null) {
            Object uiContext = context.findUIContext();
            if (uiContext instanceof Shell) {
                shell = (Shell)uiContext;
            } else if (uiContext instanceof IWorkbenchWindow) {
                shell = ((IWorkbenchWindow)uiContext).getShell();
            }
        }
        return Util.getWorkbenchPage(shell);
    }
}

