/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.category;

import com.ibm.icu.text.Collator;
import com.ibm.team.collaboration.ui.text.CollaborationPresenceTextDecorator;
import com.ibm.team.foundation.common.internal.util.ExceptionDescription;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.StyledTextViewerSupport;
import com.ibm.team.foundation.rcp.ui.dnd.ViewerDragSupport;
import com.ibm.team.foundation.rcp.ui.internal.util.ExceptionDescriptionUI;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.jface.viewerutilities.ContextMenuHelper;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.rcp.ui.ContextMenuHelper2;
import com.ibm.team.process.rcp.ui.teamnavigator.IMenuOperationTarget;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.ITeamFormPartSite;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.ui.editor.TeamFormPartSite;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.util.CategoriesHelper;
import com.ibm.team.workitem.common.internal.util.CategoriesManager;
import com.ibm.team.workitem.common.internal.util.CategoryTreeNode;
import com.ibm.team.workitem.common.model.CategoryId;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.MultiStaleDataException;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedText;
import com.ibm.team.workitem.ide.ui.internal.editor.DocumentModel;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemProjectAreaEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.category.CategoryPage;
import com.ibm.team.workitem.ide.ui.internal.editor.category.Messages;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.PendingUpdateAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryPart
extends TeamFormPart {
    private static boolean ALLOW_NULL_DEVLINES = false;
    private static final String TEAM_AREA_ASS_COL_LABEL = Messages.CategoryPart_ASSOCIATED_TA_LABEL;
    private static final String TEAM_AREA_COL_LABEL = Messages.CategoryPart_TA_LABEL;
    private static final String CATEGORY_COL_LABEL = Messages.CategoryPart_CATEGORY_LABEL;
    private static final int CATEGORY_COL_INDEX = 0;
    private static final int TEAM_AREA_COL_INDEX = 1;
    private static final String ANY = Messages.CategoryPart_ANY_ENTRY;
    private IProjectArea fProjectArea;
    private CategoryPage fPage;
    private IProgressMonitor fMonitor;
    private CheckboxTreeViewer fCatViewer;
    private TreeViewer fTeamViewer;
    private Object fInput = new Object();
    private CategoriesManager fCategoriesMgr;
    private IDevelopmentLine fCurrentDevline;
    private StandardLabelProvider fStandardLabelProvider;
    private Button fArchiveButton;
    private boolean fShowArchived = false;
    private SharedItemListener fListener = new SharedItemListener();
    private Label fDevelopmentLineLabel;
    private Combo fDevelopmentLineCombo;
    private Button fAssociateButton;
    private Button fDisassociateButton;
    private Button fSetProjectButton;
    private Button fUseDefaultButton;
    private UIUpdaterJob fSetInputJob;
    private boolean fDirty = false;
    private Label fDescriptionLabel;
    private Label fCheckBoxDescription;
    private Button fShowArchivedCheckbox;

    public CategoryPart(CategoryPage page) {
        this.fPage = page;
        this.fStandardLabelProvider = new StandardLabelProvider((ILabelProvider)new LabelProvider(), (IElementRemovedNotifier)new ElementRemovedNotifierImpl());
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    public void createContent(Composite parent) {
        parent.setLayout((Layout)new GridLayout(3, false));
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (CategoryPart.this.fMonitor != null && !CategoryPart.this.fMonitor.isCanceled()) {
                    CategoryPart.this.fMonitor.setCanceled(true);
                }
            }
        });
        Composite composite = new Composite(parent, 0){

            public Point computeSize(int hint, int hint2, boolean changed) {
                Point size = super.computeSize(hint, hint2, changed);
                size.x = 100;
                return size;
            }
        };
        composite.setLayout((Layout)new FillLayout());
        GridData data = new GridData(4, 0x1000000, true, false, 3, 1);
        composite.setLayoutData((Object)data);
        this.fDescriptionLabel = new Label(composite, 64);
        this.fDescriptionLabel.setText(Messages.CategoryPart_DEFINE_CATEGORIES_DESCRIPTION);
        composite = new Composite(parent, 0){

            public Point computeSize(int hint, int hint2, boolean changed) {
                Point size = super.computeSize(hint, hint2, changed);
                size.x = 100;
                return size;
            }
        };
        composite.setLayout((Layout)new FillLayout());
        data = new GridData(4, 0x1000000, true, false);
        data.verticalIndent = 10;
        composite.setLayoutData((Object)data);
        this.fCheckBoxDescription = new Label(composite, 64);
        this.fCheckBoxDescription.setText(Messages.CategoryPart_SELECTED_ARE_VISIBLE);
        new Label(parent, 0);
        Composite combo = new Composite(parent, 0);
        GridLayout gd = new GridLayout(2, false);
        gd.marginWidth = 0;
        gd.marginHeight = 0;
        combo.setLayout((Layout)gd);
        combo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fDevelopmentLineLabel = new Label(combo, 0);
        this.fDevelopmentLineLabel.setText(Messages.CategoryPart_DEVELOPMENT_LINE);
        this.fDevelopmentLineLabel.setVisible(false);
        this.fDevelopmentLineCombo = new Combo(combo, 8);
        this.fDevelopmentLineCombo.setLayoutData((Object)new GridData(16384, 4, false, true));
        this.fDevelopmentLineCombo.setEnabled(false);
        this.fDevelopmentLineCombo.setVisible(false);
        Tree tree = new Tree(parent, 67618);
        data = new GridData(4, 4, true, true);
        data.heightHint = 100;
        tree.setLayoutData((Object)data);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeColumn col = new TreeColumn(tree, 16384, 0);
        col.setWidth(100);
        col.setResizable(true);
        col.setText(CATEGORY_COL_LABEL);
        this.fCatViewer = new CheckboxTreeViewer(tree);
        this.fCatViewer.setColumnProperties(new String[]{CATEGORY_COL_LABEL, TEAM_AREA_ASS_COL_LABEL});
        this.addCategoryProviders((TreeViewer)this.fCatViewer);
        this.fCatViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof CategoryTreeNode) {
                    CategoryTreeNode node = (CategoryTreeNode)element;
                    node.filterTree(!event.getChecked());
                    CategoryPart.this.setDirty(true);
                    CategoryPart.this.updateChecked();
                }
            }
        });
        this.fCatViewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                CategoryPart.this.updateChecked();
            }

            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.fCatViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CategoryPart.this.editSelectedCategory();
            }
        });
        this.addCategoryContextMenu();
        new ViewerDragSupport((Viewer)this.fCatViewer, 7);
        ViewerDropAdapter adapter = new ViewerDropAdapter((Viewer)this.fCatViewer){

            public boolean performDrop(Object data) {
                ITeamAreaHandle team = this.findTeamAreaToAssociate(this.getCurrentTarget());
                if (team != null) {
                    this.associate(team);
                    return true;
                }
                CategoryTreeNode node = this.findCategoryNodeToMove(this.getCurrentTarget());
                if (node != null) {
                    this.move(node);
                    return true;
                }
                return false;
            }

            private void associate(ITeamAreaHandle team) {
                CategoryTreeNode node = (CategoryTreeNode)this.getCurrentTarget();
                if (CategoryPart.this.fCurrentDevline == null) {
                    node.setDefaultTeamArea(team);
                } else {
                    node.setDevelopmentLineTeamArea(team);
                }
                CategoryPart.this.fCatViewer.refresh();
                CategoryPart.this.setDirty(true);
                CategoryPart.this.updateAssociationButtons();
            }

            private void move(CategoryTreeNode node) {
                CategoryTreeNode target = (CategoryTreeNode)this.getCurrentTarget();
                CategoryTreeNode oldParent = node.getParent();
                node.moveTo(target);
                CategoryPart.this.fCatViewer.expandToLevel((Object)target, 1);
                CategoryPart.this.fCatViewer.refresh((Object)target);
                CategoryPart.this.fCatViewer.refresh((Object)oldParent);
                CategoryPart.this.updateChecked();
                CategoryPart.this.fCatViewer.setSelection((ISelection)new StructuredSelection((Object)node));
                CategoryPart.this.fCatViewer.reveal((Object)node);
                CategoryPart.this.setDirty(true);
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                return this.findTeamAreaToAssociate(target) != null || this.findCategoryNodeToMove(target) != null;
            }

            private ITeamAreaHandle findTeamAreaToAssociate(Object target) {
                if (!(target instanceof CategoryTreeNode)) {
                    return null;
                }
                Object element = this.getSelectionElement();
                if (!(element instanceof ITeamAreaHandle)) {
                    return null;
                }
                ITeamAreaHandle team = (ITeamAreaHandle)element;
                if (CategoryPart.this.fCategoriesMgr.getTeamArea(team) == null) {
                    return null;
                }
                if (CategoryPart.this.fCurrentDevline != null && !CategoryPart.this.fCurrentDevline.sameItemId((IItemHandle)CategoryPart.this.fCategoriesMgr.getDevelopmentLine(team))) {
                    return null;
                }
                if (!ALLOW_NULL_DEVLINES && CategoryPart.this.fCategoriesMgr.getDevelopmentLine(team) == null) {
                    return null;
                }
                if (team.sameItemId((IItemHandle)((CategoryTreeNode)target).getTeamArea((IDevelopmentLineHandle)CategoryPart.this.fCurrentDevline))) {
                    return null;
                }
                return team;
            }

            private CategoryTreeNode findCategoryNodeToMove(Object target) {
                if (!(target instanceof CategoryTreeNode)) {
                    return null;
                }
                Object element = this.getSelectionElement();
                if (!(element instanceof CategoryTreeNode)) {
                    return null;
                }
                CategoryTreeNode node = (CategoryTreeNode)element;
                if (CategoryPart.this.fCategoriesMgr != node.getManager()) {
                    return null;
                }
                if (node.getParent() == null) {
                    return null;
                }
                CategoryTreeNode targetNode = (CategoryTreeNode)target;
                if (targetNode.isSubcategory(node)) {
                    return null;
                }
                if (targetNode == node.getParent()) {
                    return null;
                }
                CategoryId newId = CategoriesHelper.createCategoryId((CategoryId)targetNode.getCategoryId(), (String)node.getName());
                for (CategoryTreeNode child : targetNode.getChildren()) {
                    if (!child.getCategoryId().equals((Object)newId)) continue;
                    return null;
                }
                return node;
            }

            public void dragEnter(DropTargetEvent event) {
                Object element = this.getSelectionElement();
                if (element instanceof ITeamAreaHandle && (event.operations & 4) != 0) {
                    event.detail = 4;
                } else if (element instanceof CategoryTreeNode && (event.operations & 2) != 0) {
                    event.detail = 2;
                }
            }

            private Object getSelectionElement() {
                ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return null;
                }
                if (((IStructuredSelection)selection).size() != 1) {
                    return null;
                }
                return ((IStructuredSelection)selection).getFirstElement();
            }
        };
        adapter.setFeedbackEnabled(false);
        this.fCatViewer.addDropSupport(23, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)adapter);
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        Tree teams = new Tree(parent, 2050);
        teams.setHeaderVisible(true);
        data = new GridData(4, 4, true, true);
        data.heightHint = 100;
        teams.setLayoutData((Object)data);
        col = new TreeColumn(teams, 16384, 0);
        col.setWidth(250);
        col.setResizable(true);
        col.setText(TEAM_AREA_COL_LABEL);
        this.fTeamViewer = new TreeViewer(teams);
        this.fTeamViewer.setColumnProperties(new String[]{TEAM_AREA_COL_LABEL});
        this.addTeamProviders(this.fTeamViewer);
        new ViewerDragSupport((Viewer)this.fTeamViewer, 7);
        this.addTeamContextMenu();
        Composite catButtons = new Composite(parent, 0);
        catButtons.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.createButtons((TreeViewer)this.fCatViewer, this.fTeamViewer, catButtons, buttons);
        Utils.updateColumnWidths((Tree)this.fCatViewer.getTree(), (int[])new int[0]);
        this.getSite().registerSelectionProvider((ISelectionProvider)this.fTeamViewer, this.fTeamViewer.getControl());
        this.getSite().registerSelectionProvider((ISelectionProvider)this.fCatViewer, this.fCatViewer.getControl());
    }

    private void addTeamContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ContextMenuHelper.buildStandardContextMenuGroups((IMenuManager)manager);
                ContextMenuHelper.addNewSubmenu((IMenuManager)manager, (boolean)false);
                if (!CategoryPart.this.fTeamViewer.getSelection().isEmpty()) {
                    ContextMenuHelper2.addStandardActions((IMenuManager)manager, (ISelectionProvider)CategoryPart.this.fTeamViewer, (IWorkbenchSite)CategoryPart.this.getSite().getWorkbenchPage().getActivePart().getSite(), (String[])IMenuOperationTarget.ALL_TYPES);
                }
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fTeamViewer.getControl());
        this.fTeamViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(String.valueOf(this.getSite().getId((TeamFormPart)this)) + ".teamViewer", menuMgr, (ISelectionProvider)this.fTeamViewer);
    }

    private void addCategoryContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        Action diss = new Action(Messages.CategoryPart_DISASSOCIATE){

            public void run() {
                boolean changed = false;
                for (Object o : ((ITreeSelection)CategoryPart.this.fCatViewer.getSelection()).toList()) {
                    if (!(o instanceof CategoryTreeNode)) continue;
                    changed = true;
                    CategoryTreeNode node = (CategoryTreeNode)o;
                    node.disassociate((IDevelopmentLineHandle)CategoryPart.this.fCurrentDevline, false);
                }
                if (changed) {
                    CategoryPart.this.setDirty(true);
                    CategoryPart.this.fCatViewer.refresh();
                    CategoryPart.this.updateAssociationButtons();
                }
            }
        };
        Action useDefault = new Action(Messages.CategoryPart_USE_DEFAULT){

            public void run() {
                boolean changed = false;
                for (Object o : ((ITreeSelection)CategoryPart.this.fCatViewer.getSelection()).toList()) {
                    if (!(o instanceof CategoryTreeNode)) continue;
                    changed = true;
                    CategoryTreeNode node = (CategoryTreeNode)o;
                    node.clearDevelopmentLineTeamArea((IDevelopmentLineHandle)CategoryPart.this.fCurrentDevline);
                }
                if (changed) {
                    CategoryPart.this.setDirty(true);
                    CategoryPart.this.fCatViewer.refresh();
                    CategoryPart.this.updateAssociationButtons();
                }
            }
        };
        Action add = new Action(Messages.CategoryPart_ADD_CATEGORY){

            public void run() {
                ITreeSelection selection = (ITreeSelection)CategoryPart.this.fCatViewer.getSelection();
                CategoryTreeNode parent = selection.isEmpty() ? CategoryPart.this.fCategoriesMgr.getRoot() : (CategoryTreeNode)selection.getFirstElement();
                CategoryPart.this.addChild(parent, (TreeViewer)CategoryPart.this.fCatViewer);
            }
        };
        Action edit = new Action(Messages.CategoryPart_EDIT){

            public void run() {
                CategoryPart.this.editSelectedCategory();
            }
        };
        Action archive = new Action(Messages.CategoryPart_ARCHIVE){

            public void run() {
                CategoryPart.this.archiveSelectedCategories();
            }
        };
        Action unarchive = new Action(Messages.CategoryPart_UNARCHIVE){

            public void run() {
                ArrayList<CategoryTreeNode> nodes = new ArrayList<CategoryTreeNode>();
                for (Object o : ((ITreeSelection)CategoryPart.this.fCatViewer.getSelection()).toList()) {
                    if (!(o instanceof CategoryTreeNode)) continue;
                    CategoryTreeNode node = (CategoryTreeNode)o;
                    nodes.add(node);
                }
                if (nodes.isEmpty()) {
                    return;
                }
                for (CategoryTreeNode node : nodes) {
                    node.archiveTree(false);
                }
                CategoryPart.this.setDirty(true);
                CategoryPart.this.fCatViewer.refresh();
                CategoryPart.this.updateChecked();
                CategoryPart.this.updateArchiveButton();
            }
        };
        menuMgr.addMenuListener(new IMenuListener((IAction)diss, (IAction)useDefault, (IAction)add, (IAction)edit, (IAction)archive, (IAction)unarchive){
            private final /* synthetic */ IAction val$diss;
            private final /* synthetic */ IAction val$useDefault;
            private final /* synthetic */ IAction val$add;
            private final /* synthetic */ IAction val$edit;
            private final /* synthetic */ IAction val$archive;
            private final /* synthetic */ IAction val$unarchive;
            {
                this.val$diss = iAction;
                this.val$useDefault = iAction2;
                this.val$add = iAction3;
                this.val$edit = iAction4;
                this.val$archive = iAction5;
                this.val$unarchive = iAction6;
            }

            public void menuAboutToShow(IMenuManager manager) {
                if (((ITreeSelection)CategoryPart.this.fCatViewer.getSelection()).size() == 1 && ((ITreeSelection)CategoryPart.this.fCatViewer.getSelection()).getFirstElement() instanceof IProjectArea) {
                    ContextMenuHelper.buildStandardContextMenuGroups((IMenuManager)manager);
                    ContextMenuHelper.addNewSubmenu((IMenuManager)manager, (boolean)false);
                    ContextMenuHelper2.addStandardActions((IMenuManager)manager, (ISelectionProvider)CategoryPart.this.fCatViewer, (IWorkbenchSite)CategoryPart.this.getSite().getWorkbenchPage().getActivePart().getSite(), (String[])IMenuOperationTarget.ALL_TYPES);
                }
                if (CategoryPart.this.fCategoriesMgr != null && CategoryPart.this.canDisassociate((IStructuredSelection)((ITreeSelection)CategoryPart.this.fCatViewer.getSelection()))) {
                    manager.add(this.val$diss);
                }
                if (CategoryPart.this.fCategoriesMgr != null && CategoryPart.this.canUseDefault((IStructuredSelection)((ITreeSelection)CategoryPart.this.fCatViewer.getSelection()))) {
                    manager.add(this.val$useDefault);
                }
                manager.add((IContributionItem)new Separator());
                if (CategoryPart.this.fCategoriesMgr != null && ((ITreeSelection)CategoryPart.this.fCatViewer.getSelection()).size() <= 1) {
                    manager.add(this.val$add);
                }
                if (CategoryPart.this.fCategoriesMgr != null && ((ITreeSelection)CategoryPart.this.fCatViewer.getSelection()).size() == 1 && !CategoryPart.this.containsRoot((IStructuredSelection)((ITreeSelection)CategoryPart.this.fCatViewer.getSelection()))) {
                    manager.add(this.val$edit);
                }
                if (!(CategoryPart.this.fCategoriesMgr == null || ((ITreeSelection)CategoryPart.this.fCatViewer.getSelection()).isEmpty() || CategoryPart.this.containsRoot((IStructuredSelection)((ITreeSelection)CategoryPart.this.fCatViewer.getSelection())) || CategoryPart.this.containsNoActive((IStructuredSelection)((ITreeSelection)CategoryPart.this.fCatViewer.getSelection())))) {
                    manager.add(this.val$archive);
                }
                if (CategoryPart.this.fCategoriesMgr != null && !((ITreeSelection)CategoryPart.this.fCatViewer.getSelection()).isEmpty() && !CategoryPart.this.containsNoArchived((IStructuredSelection)((ITreeSelection)CategoryPart.this.fCatViewer.getSelection()))) {
                    manager.add(this.val$unarchive);
                }
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fCatViewer.getControl());
        this.fCatViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(String.valueOf(this.getSite().getId((TeamFormPart)this)) + ".categoryViewer", menuMgr, (ISelectionProvider)this.fCatViewer);
    }

    private void addTeamProviders(TreeViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)this.fStandardLabelProvider);
        viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (CategoryPart.this.fCategoriesMgr == null) {
                    return new Object[0];
                }
                if (parentElement instanceof ITeamAreaHandle) {
                    parentElement = CategoryPart.this.fCategoriesMgr.getTeamArea((ITeamAreaHandle)parentElement);
                }
                if (parentElement instanceof ITeamArea) {
                    ArrayList<ITeamArea> result = new ArrayList<ITeamArea>();
                    for (Object element : CategoryPart.this.fProjectArea.getTeamAreaHierarchy().getChildren((ITeamAreaHandle)((ITeamArea)parentElement))) {
                        ITeamArea area = CategoryPart.this.fCategoriesMgr.getTeamArea((ITeamAreaHandle)element);
                        if (!CategoryPart.this.isInDevLineAndNotArchived(area)) continue;
                        result.add(area);
                    }
                    return result.toArray();
                }
                if (parentElement instanceof IProjectAreaHandle) {
                    Assert.isTrue((boolean)CategoryPart.this.fProjectArea.sameItemId((IItemHandle)((IProjectAreaHandle)parentElement)));
                    ArrayList<ITeamArea> result = new ArrayList<ITeamArea>();
                    for (Object element : CategoryPart.this.fProjectArea.getTeamAreaHierarchy().getRoots()) {
                        ITeamArea area = CategoryPart.this.fCategoriesMgr.getTeamArea((ITeamAreaHandle)element);
                        if (!CategoryPart.this.isInDevLineAndNotArchived(area)) continue;
                        result.add(area);
                    }
                    return result.toArray();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                if (element instanceof ITeamArea && CategoryPart.this.fCategoriesMgr != null) {
                    if (CategoryPart.this.fProjectArea.getTeamAreaHierarchy().getParent((ITeamAreaHandle)element) == null) {
                        return null;
                    }
                    return CategoryPart.this.fCategoriesMgr.getTeamArea(CategoryPart.this.fProjectArea.getTeamAreaHierarchy().getParent((ITeamAreaHandle)element));
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element) != null && this.getChildren(element).length > 0;
            }

            public Object[] getElements(Object inputElement) {
                Object[] children = this.getChildren(inputElement);
                if (children.length == 0 && inputElement instanceof IProjectAreaHandle) {
                    return new Object[]{Messages.CategoryPart_NO_TAS_CONFIGURED};
                }
                return children;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String name1 = "";
                if (e1 instanceof String) {
                    name1 = (String)e1;
                } else if (e1 instanceof IProcessArea) {
                    name1 = ((IProcessArea)e1).getName().toLowerCase();
                }
                String name2 = "";
                if (e2 instanceof String) {
                    name2 = (String)e2;
                } else if (e2 instanceof IProcessArea) {
                    name2 = ((IProcessArea)e2).getName().toLowerCase();
                }
                return Collator.getInstance().compare(name1, name2);
            }
        });
    }

    private boolean isInDevLineAndNotArchived(Object element) {
        if (element instanceof ITeamArea) {
            boolean is;
            IDevelopmentLine developmentLine = this.fCategoriesMgr.getDevelopmentLine((ITeamAreaHandle)((ITeamArea)element));
            boolean allowed = ALLOW_NULL_DEVLINES || developmentLine != null;
            boolean bl = is = this.fCurrentDevline == null || this.fCurrentDevline.sameItemId((IItemHandle)developmentLine);
            return allowed && is && !((ITeamArea)element).isArchived();
        }
        return element != null;
    }

    private void addCategoryProviders(TreeViewer viewer) {
        viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parent) {
                if (parent instanceof CategoryTreeNode) {
                    CategoryTreeNode categorynode = (CategoryTreeNode)parent;
                    return categorynode.getChildren().toArray();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                if (element instanceof CategoryTreeNode) {
                    CategoryTreeNode node = (CategoryTreeNode)element;
                    node.getParent();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof CategoryTreeNode) {
                    CategoryTreeNode node = (CategoryTreeNode)element;
                    return !node.getChildren().isEmpty();
                }
                return false;
            }

            public Object[] getElements(Object input) {
                if (input instanceof CategoriesManager) {
                    return new Object[]{((CategoriesManager)input).getRoot()};
                }
                if (input instanceof String) {
                    return new Object[]{input};
                }
                return new Object[]{new PendingUpdateAdapter()};
            }

            public void dispose() {
            }

            public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new CategoriesLabelProvider());
        viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String name1 = ((CategoryTreeNode)e1).getName();
                String name2 = ((CategoryTreeNode)e2).getName();
                return Collator.getInstance().compare(name1, name2);
            }
        });
        viewer.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof CategoryTreeNode) {
                    return CategoryPart.this.fShowArchived || !((CategoryTreeNode)element).isArchived();
                }
                return true;
            }
        }});
    }

    private void createButtons(final TreeViewer cats, final TreeViewer teams, Composite catButtons, Composite buttons) {
        GridLayout gd = new GridLayout(4, false);
        gd.marginWidth = 0;
        gd.marginHeight = 0;
        catButtons.setLayout((Layout)gd);
        final Button addcat = new Button(catButtons, 0x800000);
        addcat.setLayoutData((Object)new GridData(16384, 4, false, false));
        addcat.setText(Messages.CategoryPart_ADD_CATEGORY);
        addcat.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                IStructuredSelection selection = (IStructuredSelection)cats.getSelection();
                CategoryTreeNode parent = selection.isEmpty() ? CategoryPart.this.fCategoriesMgr.getRoot() : (CategoryTreeNode)selection.getFirstElement();
                CategoryPart.this.addChild(parent, cats);
            }
        });
        addcat.setEnabled(false);
        final Button edit = new Button(catButtons, 0x800000);
        edit.setText(Messages.CategoryPart_EDIT);
        edit.setLayoutData((Object)new GridData(16384, 4, false, false));
        edit.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                CategoryPart.this.editSelectedCategory();
            }
        });
        edit.setEnabled(false);
        this.fArchiveButton = new Button(catButtons, 0x800000);
        this.fArchiveButton.setText(Messages.CategoryPart_ARCHIVE);
        this.fArchiveButton.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.fArchiveButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                CategoryPart.this.archiveSelectedCategories();
            }
        });
        this.fArchiveButton.setEnabled(false);
        this.fShowArchivedCheckbox = new Button(catButtons, 0x800020);
        this.fShowArchivedCheckbox.setText(Messages.CategoryPart_SHOW_ARCHIVED);
        this.fShowArchivedCheckbox.setLayoutData((Object)new GridData(131072, 4, true, false));
        this.fShowArchivedCheckbox.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CategoryPart.this.fShowArchived = CategoryPart.this.fShowArchivedCheckbox.getSelection();
                CategoryPart.this.fCatViewer.refresh();
                CategoryPart.this.updateChecked();
            }
        });
        this.fShowArchivedCheckbox.setEnabled(false);
        gd = new GridLayout(1, true);
        gd.marginWidth = 0;
        gd.marginHeight = 0;
        buttons.setLayout((Layout)gd);
        this.fAssociateButton = new Button(buttons, 0x800000);
        this.fAssociateButton.setText(Messages.CategoryPart_ASSOCIATE);
        this.fAssociateButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fAssociateButton.setEnabled(false);
        this.fSetProjectButton = new Button(buttons, 0x800000);
        this.fSetProjectButton.setText(Messages.CategoryPart_ASSOCIATE_PA);
        this.fSetProjectButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fSetProjectButton.setEnabled(false);
        this.fDisassociateButton = new Button(buttons, 0x800000);
        this.fDisassociateButton.setText(Messages.CategoryPart_DISASSOCIATE);
        this.fDisassociateButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fUseDefaultButton = new Button(buttons, 0x800000);
        this.fUseDefaultButton.setText(Messages.CategoryPart_USE_DEFAULT);
        this.fUseDefaultButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fUseDefaultButton.setVisible(false);
        this.fAssociateButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                ISelection catSelection = cats.getSelection();
                ISelection teamSelection = teams.getSelection();
                if (catSelection instanceof IStructuredSelection && teamSelection instanceof IStructuredSelection) {
                    IStructuredSelection strcat = (IStructuredSelection)catSelection;
                    for (Object element : strcat.toList()) {
                        if (!(element instanceof CategoryTreeNode)) continue;
                        CategoryTreeNode node = (CategoryTreeNode)element;
                        IStructuredSelection strteam = (IStructuredSelection)teamSelection;
                        ITeamArea team = (ITeamArea)strteam.getFirstElement();
                        if (CategoryPart.this.fCurrentDevline == null) {
                            node.setDefaultTeamArea((ITeamAreaHandle)team);
                            continue;
                        }
                        node.setDevelopmentLineTeamArea((ITeamAreaHandle)team);
                    }
                    cats.refresh();
                    CategoryPart.this.setDirty(true);
                    CategoryPart.this.updateAssociationButtons();
                }
            }
        });
        this.fDisassociateButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                ISelection catSelection = cats.getSelection();
                if (catSelection instanceof IStructuredSelection) {
                    IStructuredSelection strcat = (IStructuredSelection)catSelection;
                    for (Object element : strcat.toList()) {
                        if (!(element instanceof CategoryTreeNode)) continue;
                        CategoryTreeNode node = (CategoryTreeNode)element;
                        node.disassociate((IDevelopmentLineHandle)CategoryPart.this.fCurrentDevline, false);
                    }
                    cats.refresh();
                    CategoryPart.this.setDirty(true);
                    CategoryPart.this.updateAssociationButtons();
                }
            }
        });
        this.fDisassociateButton.setEnabled(false);
        this.fSetProjectButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                ISelection catSelection = cats.getSelection();
                if (catSelection instanceof IStructuredSelection) {
                    IStructuredSelection strcat = (IStructuredSelection)catSelection;
                    for (Object element : strcat.toList()) {
                        if (!(element instanceof CategoryTreeNode)) continue;
                        CategoryTreeNode node = (CategoryTreeNode)element;
                        node.disassociate((IDevelopmentLineHandle)CategoryPart.this.fCurrentDevline, true);
                    }
                    cats.refresh();
                    CategoryPart.this.setDirty(true);
                    CategoryPart.this.updateAssociationButtons();
                }
            }
        });
        this.fSetProjectButton.setEnabled(false);
        this.fUseDefaultButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                ISelection catSelection = cats.getSelection();
                if (catSelection instanceof IStructuredSelection) {
                    IStructuredSelection strcat = (IStructuredSelection)catSelection;
                    for (Object element : strcat.toList()) {
                        if (!(element instanceof CategoryTreeNode)) continue;
                        CategoryTreeNode node = (CategoryTreeNode)element;
                        node.clearDevelopmentLineTeamArea((IDevelopmentLineHandle)CategoryPart.this.fCurrentDevline);
                    }
                    cats.refresh();
                    CategoryPart.this.setDirty(true);
                    CategoryPart.this.updateAssociationButtons();
                }
            }
        });
        this.fUseDefaultButton.setEnabled(false);
        cats.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    CategoryPart.this.updateAssociationButtons();
                    IStructuredSelection strsel = (IStructuredSelection)selection;
                    if (CategoryPart.this.fCategoriesMgr != null && strsel.size() <= 1) {
                        addcat.setEnabled(true);
                    } else {
                        addcat.setEnabled(false);
                    }
                    if (CategoryPart.this.fCategoriesMgr == null || strsel.size() != 1 || CategoryPart.this.containsRoot(strsel)) {
                        edit.setEnabled(false);
                    } else {
                        edit.setEnabled(true);
                    }
                    CategoryPart.this.updateArchiveButton();
                }
            }
        });
        teams.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    CategoryPart.this.updateAssociationButtons();
                }
            }
        });
    }

    private void updateAssociationButtons() {
        ISelection catSelection = this.fCatViewer.getSelection();
        ISelection teamSelection = this.fTeamViewer.getSelection();
        if (catSelection instanceof IStructuredSelection && teamSelection instanceof IStructuredSelection) {
            IStructuredSelection strcat = (IStructuredSelection)catSelection;
            IStructuredSelection strteam = (IStructuredSelection)teamSelection;
            this.fAssociateButton.setEnabled(this.fCategoriesMgr != null && this.canAssociate(strcat, strteam));
            this.fDisassociateButton.setEnabled(this.fCategoriesMgr != null && this.canDisassociate(strcat));
            this.fSetProjectButton.setEnabled(this.fCategoriesMgr != null && !catSelection.isEmpty() && (this.fCurrentDevline == null || this.fCategoriesMgr.getDevelopmentLines().size() == 1));
            this.fUseDefaultButton.setEnabled(this.fCategoriesMgr != null && this.canUseDefault(strcat));
        }
    }

    private void updateArchiveButton() {
        ISelection selection = this.fCatViewer.getSelection();
        if (this.fCategoriesMgr == null || selection.isEmpty() || !(selection instanceof IStructuredSelection) || this.containsRoot((IStructuredSelection)selection) || this.containsNoActive((IStructuredSelection)selection)) {
            this.fArchiveButton.setEnabled(false);
        } else {
            this.fArchiveButton.setEnabled(true);
        }
        if (this.fCategoriesMgr == null) {
            this.fShowArchivedCheckbox.setEnabled(false);
        } else {
            this.fShowArchivedCheckbox.setEnabled(true);
        }
    }

    private boolean containsRoot(IStructuredSelection selection) {
        for (Object element : selection.toList()) {
            if (!(element instanceof CategoryTreeNode) || ((CategoryTreeNode)element).getParent() != null) continue;
            return true;
        }
        return false;
    }

    private boolean containsNoActive(IStructuredSelection selection) {
        for (Object element : selection.toList()) {
            if (!(element instanceof CategoryTreeNode) || ((CategoryTreeNode)element).isArchived()) continue;
            return false;
        }
        return true;
    }

    private boolean containsNoArchived(IStructuredSelection selection) {
        for (Object element : selection.toList()) {
            if (!(element instanceof CategoryTreeNode) || !((CategoryTreeNode)element).isArchived()) continue;
            return false;
        }
        return true;
    }

    private boolean canDisassociate(IStructuredSelection selection) {
        for (Object element : selection.toList()) {
            if (!(element instanceof CategoryTreeNode) || !((CategoryTreeNode)element).canDisassociate((IDevelopmentLineHandle)this.fCurrentDevline)) continue;
            return true;
        }
        return false;
    }

    private boolean canAssociate(IStructuredSelection categorySelection, IStructuredSelection teamAreaSelection) {
        return !categorySelection.isEmpty() && teamAreaSelection.size() == 1 && teamAreaSelection.getFirstElement() instanceof ITeamAreaHandle;
    }

    private boolean canUseDefault(IStructuredSelection selection) {
        if (this.fCurrentDevline == null) {
            return false;
        }
        for (Object element : selection.toList()) {
            CategoryTreeNode node;
            if (!(element instanceof CategoryTreeNode) || ((node = (CategoryTreeNode)element).getTeamArea((IDevelopmentLineHandle)this.fCurrentDevline) == null || node.getTeamArea((IDevelopmentLineHandle)this.fCurrentDevline).sameItemId((IItemHandle)node.getTeamArea(null))) && (node.getTeamArea((IDevelopmentLineHandle)this.fCurrentDevline) != null || node.getTeamArea(null) == null)) continue;
            return true;
        }
        return false;
    }

    private void setDirty(boolean dirty) {
        boolean changed = this.fPage.isDirty() ^ dirty;
        this.fDirty = dirty;
        if (changed) {
            this.fPage.firePropertyChange(257);
        }
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    private void addChild(CategoryTreeNode parent, TreeViewer viewer) {
        NewCategoryDialog dialog = new NewCategoryDialog(viewer.getControl().getShell());
        dialog.setPath(this.getPath(parent));
        dialog.setUnavailable(this.getChildNames(parent));
        if (dialog.open() != 0) {
            return;
        }
        CategoryTreeNode newnode = parent.createChild(dialog.getName());
        newnode.setDescription(dialog.getDescription());
        viewer.expandToLevel((Object)parent, 1);
        viewer.refresh((Object)parent);
        this.updateChecked();
        viewer.setSelection((ISelection)new StructuredSelection((Object)newnode));
        viewer.reveal((Object)newnode);
        this.setDirty(true);
    }

    private String getPath(CategoryTreeNode node) {
        StringBuilder builder = new StringBuilder();
        while (node != null && node.getParent() != null) {
            builder.insert(0, node.getName());
            node = node.getParent();
            if (node.getParent() == null) continue;
            builder.insert(0, "/");
        }
        return builder.toString();
    }

    private List<String> getChildNames(CategoryTreeNode parent) {
        ArrayList<String> names = new ArrayList<String>();
        for (CategoryTreeNode node : parent.getChildren()) {
            names.add(node.getName());
        }
        return names;
    }

    private void editSelectedCategory() {
        ArrayList<CategoryTreeNode> nodes = new ArrayList<CategoryTreeNode>();
        for (Object o : ((ITreeSelection)this.fCatViewer.getSelection()).toList()) {
            if (!(o instanceof CategoryTreeNode)) continue;
            CategoryTreeNode node = (CategoryTreeNode)o;
            nodes.add(node);
        }
        if (nodes.size() != 1) {
            return;
        }
        CategoryTreeNode node = (CategoryTreeNode)nodes.get(0);
        CategoryTreeNode parent = node.getParent();
        if (parent == null) {
            return;
        }
        NewCategoryDialog dialog = new NewCategoryDialog(this.getShell());
        dialog.setTitle(Messages.CategoryPart_EDIT_CATEGORY);
        dialog.setName(node.getName());
        dialog.setPath(this.getPath(parent));
        dialog.setDescription(node.getDescription());
        List<String> childNames = this.getAllChildNames(parent);
        childNames.remove(node.getName());
        dialog.setUnavailable(childNames);
        if (dialog.open() != 0) {
            return;
        }
        node.renameTo(dialog.getName());
        node.setDescription(dialog.getDescription());
        this.setDirty(true);
        this.fCatViewer.refresh((Object)node, true);
    }

    private List<String> getAllChildNames(CategoryTreeNode parent) {
        ArrayList<String> names = new ArrayList<String>();
        for (CategoryTreeNode node : parent.getChildren()) {
            names.add(node.getName());
        }
        return names;
    }

    private void archiveSelectedCategories() {
        String message;
        String subcategories;
        boolean hasChildren = false;
        ArrayList<CategoryTreeNode> nodes = new ArrayList<CategoryTreeNode>();
        for (Object o : ((ITreeSelection)this.fCatViewer.getSelection()).toList()) {
            if (!(o instanceof CategoryTreeNode)) continue;
            CategoryTreeNode node = (CategoryTreeNode)o;
            nodes.add(node);
            if (node.getChildren().isEmpty()) continue;
            hasChildren = true;
        }
        if (nodes.isEmpty()) {
            return;
        }
        if (nodes.size() == 1) {
            subcategories = hasChildren ? Messages.CategoryPart_BLANK_AND_ITS_SUBCATEGORIES : "";
            message = NLS.bind((String)Messages.CategoryPart_SURE_TO_ARCHIVE_CATEGORY, (Object)((CategoryTreeNode)nodes.get(0)).getName(), (Object[])new Object[]{subcategories});
        } else {
            subcategories = hasChildren ? Messages.CategoryPart_BLANK_AND_THEIR_SUBCATEGORIES : "";
            message = NLS.bind((String)Messages.CategoryPart_SURE_TO_ARCHIVE_CATEGORIES, (Object)nodes.size(), (Object[])new Object[]{subcategories});
        }
        boolean confirmed = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.CategoryPart_CONFIRM_ARCHIVE, (String)message);
        if (!confirmed) {
            return;
        }
        for (CategoryTreeNode node : nodes) {
            node.archiveTree(true);
        }
        this.setDirty(true);
        this.fCatViewer.refresh();
        this.updateChecked();
        this.updateArchiveButton();
    }

    private void updateViewers() {
        if (this.fCategoriesMgr == null) {
            this.initializeUI();
            return;
        }
        UIUpdaterJob j = new UIUpdaterJob(Messages.CategoryPart_UPDATE_TAS){

            public IStatus runInBackground(IProgressMonitor monitor) {
                if (CategoryPart.this.fProjectArea == null || CategoryPart.this.fCategoriesMgr == null) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    CategoryPart.this.fCategoriesMgr.updateTeamAreas(monitor);
                    CategoryPart.this.fProjectArea = CategoryPart.this.fCategoriesMgr.getProjectArea();
                }
                catch (TeamRepositoryException e) {
                    return new Status(4, "com.ibm.team.workitem.rcp.ui", e.getMessage(), (Throwable)e);
                }
                return super.runInBackground(monitor);
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                if (CategoryPart.this.fCatViewer != null && !CategoryPart.this.fCatViewer.getControl().isDisposed()) {
                    CategoryPart.this.fCatViewer.refresh();
                }
                if (CategoryPart.this.fTeamViewer != null && !CategoryPart.this.fTeamViewer.getControl().isDisposed()) {
                    CategoryPart.this.fTeamViewer.refresh();
                }
                if (CategoryPart.this.fCatViewer != null && !CategoryPart.this.fCatViewer.getControl().isDisposed()) {
                    CategoryPart.this.updateVisibility();
                }
                if (!CategoryPart.this.fDevelopmentLineCombo.isDisposed()) {
                    CategoryPart.this.updateDevelopmentLines();
                }
                return super.runInUI(monitor);
            }
        };
        j.schedule();
    }

    private boolean hasVisibleEntries() {
        if (this.fProjectArea.getTeamAreas().isEmpty()) {
            return false;
        }
        for (Object element : this.fProjectArea.getTeamAreaHierarchy().getRoots()) {
            ITeamArea area = this.fCategoriesMgr.getTeamArea((ITeamAreaHandle)element);
            if (!this.isInDevLineAndNotArchived(area)) continue;
            return true;
        }
        return false;
    }

    private void updateVisibility() {
        boolean visible = this.hasVisibleEntries();
        if (visible) {
            this.fDescriptionLabel.setText(Messages.CategoryPart_DEFINE_CATEGORIES_AND_ASSOCIATE_DESCRIPTION);
            this.fCheckBoxDescription.setText(Messages.CategoryPart_SELECTED_ARE_VISIBLE);
        } else {
            this.fDescriptionLabel.setText(Messages.CategoryPart_DEFINE_CATEGORIES_DESCRIPTION);
            this.fCheckBoxDescription.setText(Messages.CategoryPart_SELECTED_ARE_VISIBLE_TO_PA_MEMEBERS);
        }
        this.fTeamViewer.getControl().setVisible(visible);
        this.fAssociateButton.setVisible(visible);
        this.fSetProjectButton.setVisible(visible);
        this.fDisassociateButton.setVisible(visible);
        if (visible && this.fCatViewer.getTree().getColumnCount() == 1) {
            TreeColumn col = new TreeColumn(this.fCatViewer.getTree(), 16384, 1);
            col.setWidth(100);
            col.setResizable(true);
            col.setText(TEAM_AREA_ASS_COL_LABEL);
            if (!"gtk".equals(SWT.getPlatform())) {
                Utils.updateColumnWidths((Tree)this.fCatViewer.getTree(), (int[])new int[0]);
            }
        }
        this.fTeamViewer.getControl().getParent().layout(new Control[]{this.fTeamViewer.getControl(), this.fDescriptionLabel, this.fCheckBoxDescription});
    }

    private void initializeUI() {
        this.fSetInputJob = new UIUpdaterJob(Messages.CategoryPart_INITIALIZING_CATEGORIES){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus runInBackground(IProgressMonitor monitor) {
                IStatus status;
                if (CategoryPart.this.fProjectArea == null) {
                    return Status.CANCEL_STATUS;
                }
                if (!CategoryPart.this.fProjectArea.isInitialized()) {
                    CategoryPart.this.fInput = Messages.CategoryPart_PA_NOT_INITIALIZED;
                    return Status.OK_STATUS;
                }
                CategoryPart.this.fMonitor = monitor;
                try {
                    ITeamRepository repo = (ITeamRepository)CategoryPart.this.fProjectArea.getOrigin();
                    IAuditableClient auditableClient = (IAuditableClient)repo.getClientLibrary(IAuditableClient.class);
                    this.checkMonitor();
                    IProjectArea iProjectArea = CategoryPart.this.fProjectArea;
                    synchronized (iProjectArea) {
                        if (CategoryPart.this.fCategoriesMgr == null || !CategoryPart.this.fCategoriesMgr.getProjectArea().sameItemId((IItemHandle)CategoryPart.this.fProjectArea)) {
                            CategoryPart.this.fCategoriesMgr = CategoriesManager.createInstance((IAuditableCommon)auditableClient, (IProjectAreaHandle)CategoryPart.this.fProjectArea, (IProgressMonitor)monitor);
                        }
                    }
                    this.checkMonitor();
                    CategoryPart.this.fCurrentDevline = null;
                    CategoryPart.this.fInput = CategoryPart.this.fCategoriesMgr;
                    status = Status.OK_STATUS;
                }
                catch (TeamRepositoryException e) {
                    status = new Status(4, "com.ibm.team.workitem.rcp.ui", e.getMessage(), (Throwable)e);
                }
                catch (InterruptedException interruptedException) {
                    status = Status.CANCEL_STATUS;
                }
                CategoryPart.this.fMonitor = null;
                return status;
            }

            private void checkMonitor() throws InterruptedException {
                if (CategoryPart.this.fMonitor == null || CategoryPart.this.fMonitor.isCanceled()) {
                    throw new InterruptedException();
                }
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                if (CategoryPart.this.fCatViewer != null && !CategoryPart.this.fCatViewer.getControl().isDisposed()) {
                    CategoryPart.this.updateVisibility();
                    if (CategoryPart.this.fCategoriesMgr != null) {
                        CategoryPart.this.updateDevelopmentLines();
                    } else {
                        CategoryPart.this.fCatViewer.setInput(CategoryPart.this.fInput);
                    }
                }
                CategoryPart.this.fSetInputJob = null;
                return super.runInUI(monitor);
            }
        };
        this.fSetInputJob.schedule();
    }

    private void updateDevelopmentLines() {
        int idx = 0;
        int i = 1;
        this.fDevelopmentLineCombo.removeAll();
        this.fDevelopmentLineCombo.setEnabled(true);
        this.fDevelopmentLineCombo.add(ANY);
        ArrayList devLines = new ArrayList(this.fCategoriesMgr.getDevelopmentLines());
        Collections.sort(devLines, new Comparator<IDevelopmentLine>(){

            @Override
            public int compare(IDevelopmentLine o1, IDevelopmentLine o2) {
                return Collator.getInstance().compare(o1.getId(), o2.getId());
            }
        });
        for (IDevelopmentLine devline : devLines) {
            if (devline.isArchived()) continue;
            this.fDevelopmentLineCombo.add(devline.getLabel());
            if (devline.sameItemId((IItemHandle)this.fCurrentDevline)) {
                idx = i;
            }
            ++i;
        }
        this.fDevelopmentLineCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CategoryPart.this.handleDevlineChanged();
            }
        });
        this.fDevelopmentLineCombo.select(idx);
        if (devLines.size() > 1) {
            this.fDevelopmentLineLabel.setVisible(true);
            this.fDevelopmentLineCombo.setVisible(true);
            this.fUseDefaultButton.setVisible(true);
        }
        this.handleDevlineChanged();
    }

    private void handleDevlineChanged() {
        this.fCurrentDevline = null;
        String newcurr = this.fDevelopmentLineCombo.getItem(this.fDevelopmentLineCombo.getSelectionIndex());
        for (IDevelopmentLine devline : this.fCategoriesMgr.getDevelopmentLines()) {
            if (!newcurr.equals(devline.getLabel())) continue;
            this.fCurrentDevline = devline;
            break;
        }
        if (this.fCatViewer.getInput() != this.fInput) {
            this.fCatViewer.setInput(this.fInput);
            if (this.fInput instanceof CategoriesManager) {
                this.fCatViewer.expandToLevel(2);
                this.updateChecked();
            }
            this.fCatViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        } else {
            this.fCatViewer.refresh();
        }
        this.fTeamViewer.setInput((Object)this.fProjectArea);
        this.fTeamViewer.expandAll();
        this.updateAssociationButtons();
    }

    public void setInput(Object input) {
        if (input instanceof WorkItemProjectAreaEditorInput) {
            this.fProjectArea = ((WorkItemProjectAreaEditorInput)input).getProjectArea();
            this.initializeUI();
            IItemManager itemManager = ((ITeamRepository)this.fProjectArea.getOrigin()).itemManager();
            itemManager.addItemChangeListener(IProjectArea.ITEM_TYPE, (ISharedItemChangeListener)this.fListener);
            itemManager.addItemChangeListener(ITeamArea.ITEM_TYPE, (ISharedItemChangeListener)this.fListener);
            itemManager.addItemChangeListener(IDevelopmentLine.ITEM_TYPE, (ISharedItemChangeListener)this.fListener);
        }
    }

    public boolean save(IProgressMonitor monitor) {
        if (this.fCategoriesMgr != null && this.isDirty()) {
            try {
                this.getSite().getWorkbenchPage().getWorkbenchWindow().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            CategoryPart.this.fCategoriesMgr.removeNewArchived();
                            CategoryPart.this.fCategoriesMgr.save(monitor);
                        }
                        catch (TeamRepositoryException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
                this.fCatViewer.refresh();
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof MultiStaleDataException) {
                    this.handleStale((MultiStaleDataException)cause);
                    return false;
                }
                ExceptionDescriptionUI.handleDescription((IWorkbenchWindow)this.getSite().getWorkbenchPage().getWorkbenchWindow(), (ExceptionDescription)ExceptionDescription.findDescription((String)Messages.CategoryPart_SAVING_CATEGORIES, (Throwable)cause));
                WorkItemRCPUIPlugin.getDefault().log(Messages.CategoryPart_ERROR_SAVING_CATEGORIES, (Throwable)e);
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            this.setDirty(false);
        }
        return true;
    }

    private Shell getShell() {
        return Display.getDefault().getActiveShell();
    }

    private void handleStale(MultiStaleDataException x) {
        FoundationUIJob staleJob = new FoundationUIJob(Messages.CategoryPart_HANDLING_STALE_DATA){

            public IStatus runProtectedInUI(IProgressMonitor monitor) {
                if (CategoryPart.this.fProjectArea == null) {
                    return Status.CANCEL_STATUS;
                }
                if (MessageDialog.openQuestion((Shell)CategoryPart.this.getShell(), (String)Messages.CategoryPart_SAVE_CONFLICT, (String)Messages.CategoryPart_CHANGES_CONFLICT)) {
                    try {
                        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                monitor.beginTask(Messages.CategoryPart_REFRESHING_ITEMS, 4);
                                ITeamRepository repo = (ITeamRepository)CategoryPart.this.fProjectArea.getOrigin();
                                try {
                                    CategoryPart.this.fProjectArea = (IProjectArea)repo.itemManager().fetchCompleteItem(CategoryPart.this.fProjectArea.getItemHandle(), 1, monitor);
                                }
                                catch (TeamRepositoryException e) {
                                    throw new InvocationTargetException(e, Messages.CategoryPart_ERROR_REFRESHING_PA);
                                }
                                monitor.worked(1);
                                if (monitor.isCanceled()) {
                                    throw new InterruptedException();
                                }
                                try {
                                    List cachedCategories = repo.itemManager().getKnownSharedItems(ICategory.ITEM_TYPE);
                                    repo.itemManager().refreshSharedItems(cachedCategories, monitor);
                                }
                                catch (TeamRepositoryException e) {
                                    throw new InvocationTargetException(e, Messages.CategoryPart_ERROR_REFRESHING_CATEGORIES);
                                }
                                monitor.worked(2);
                                if (monitor.isCanceled()) {
                                    throw new InterruptedException();
                                }
                                CategoryPart.this.fCategoriesMgr = null;
                            }
                        });
                        CategoryPart.this.setDirty(false);
                        CategoryPart.this.setInput(new WorkItemProjectAreaEditorInput(CategoryPart.this.fProjectArea));
                    }
                    catch (InvocationTargetException e) {
                        MessageDialog.openError((Shell)CategoryPart.this.getShell(), (String)Messages.CategoryPart_ERROR_HANDLING_SAVE_CONFLICT, (String)e.getMessage());
                        WorkItemRCPUIPlugin.getDefault().log(e.getMessage(), (Throwable)e);
                    }
                    catch (InterruptedException interruptedException) {
                        return Status.CANCEL_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        staleJob.setSystem(true);
        staleJob.schedule();
    }

    public void dispose() {
        if (this.fStandardLabelProvider != null) {
            this.fStandardLabelProvider.dispose();
            this.fStandardLabelProvider = null;
        }
        if (this.fListener != null && this.fProjectArea != null) {
            IItemManager itemManager = ((ITeamRepository)this.fProjectArea.getOrigin()).itemManager();
            itemManager.removeItemChangeListener(IProjectArea.ITEM_TYPE, (ISharedItemChangeListener)this.fListener);
            itemManager.removeItemChangeListener(ITeamArea.ITEM_TYPE, (ISharedItemChangeListener)this.fListener);
            itemManager.removeItemChangeListener(IDevelopmentLine.ITEM_TYPE, (ISharedItemChangeListener)this.fListener);
            this.fListener = null;
        }
        super.dispose();
    }

    private void updateChecked() {
        this.updateChecked(this.fCategoriesMgr.getRoot(), false);
    }

    private boolean updateChecked(CategoryTreeNode node, boolean parentFiltered) {
        if (!this.fShowArchived && node.isArchived()) {
            return false;
        }
        boolean filtered = parentFiltered || node.isFiltered();
        boolean hasFiltered = false;
        for (CategoryTreeNode child : node.getChildren()) {
            hasFiltered |= this.updateChecked(child, filtered);
        }
        if (filtered) {
            this.fCatViewer.setGrayChecked((Object)node, false);
        } else if (hasFiltered) {
            this.fCatViewer.setGrayChecked((Object)node, true);
        } else {
            this.fCatViewer.setChecked((Object)node, true);
            this.fCatViewer.setGrayed((Object)node, false);
        }
        return node.isFiltered() || hasFiltered;
    }

    private class CategoriesLabelProvider
    extends CellLabelProvider {
        private CategoriesLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (element instanceof CategoryTreeNode) {
                CategoryTreeNode node = (CategoryTreeNode)element;
                switch (cell.getColumnIndex()) {
                    case 0: {
                        cell.setText(node.getParent() == null ? Messages.CategoryPart_ROOT_CATEGORY : node.getName());
                        cell.setForeground(Display.getDefault().getSystemColor(node.isArchived() ? 18 : 24));
                        break;
                    }
                    case 1: {
                        int sameDevline = 0;
                        for (ITeamAreaHandle root : CategoryPart.this.fProjectArea.getTeamAreaHierarchy().getRoots()) {
                            if (CategoryPart.this.fCurrentDevline != null && !CategoryPart.this.fCurrentDevline.sameItemId((IItemHandle)CategoryPart.this.fCategoriesMgr.getDevelopmentLine(root))) continue;
                            ++sameDevline;
                        }
                        ITeamArea defaultTeamArea = node.getTeamArea(null);
                        ITeamArea teamArea = node.getTeamArea((IDevelopmentLineHandle)CategoryPart.this.fCurrentDevline);
                        boolean isDefault = CategoryPart.this.fCurrentDevline != null && (teamArea == null || this.equals((IItemHandle)defaultTeamArea, (IItemHandle)teamArea));
                        boolean isInherited = node.getParent() != null && this.equals((IItemHandle)node.getParent().getTeamArea((IDevelopmentLineHandle)CategoryPart.this.fCurrentDevline), (IItemHandle)teamArea);
                        cell.setForeground(Display.getDefault().getSystemColor(isDefault || isInherited ? 18 : 24));
                        boolean stripFirstSegment = sameDevline == 1;
                        cell.setText(this.getText(teamArea != null ? teamArea : defaultTeamArea, stripFirstSegment, isDefault, isInherited));
                    }
                }
                return;
            }
            if (element instanceof String && cell.getColumnIndex() == 0) {
                cell.setText((String)element);
            }
            if (cell.getColumnIndex() == 0 && element instanceof PendingUpdateAdapter) {
                cell.setText(((PendingUpdateAdapter)element).getLabel(element));
            }
        }

        private boolean equals(IItemHandle left, IItemHandle right) {
            return left == right || left != null && left.sameItemId(right);
        }

        private String getText(ITeamArea teamArea, boolean stripFirstSegment, boolean isDefault, boolean isInherited) {
            StringBuilder text = new StringBuilder();
            if (teamArea != null) {
                text.append(CategoryPart.this.fCategoriesMgr.getTeamAreaPath((ITeamAreaHandle)teamArea));
                int index = text.indexOf("/");
                if (stripFirstSegment && index > 0) {
                    text.replace(0, index + 1, "");
                }
                if (teamArea.isArchived()) {
                    text.append(Messages.CategoryPart_ARCHIVED_LABEL_DECORATION);
                }
            } else {
                text.append(Messages.CategoryPart_PA_META);
            }
            if (isDefault) {
                text.append(Messages.CategoryPart_DEFAULT_LABEL_DECORATION);
            } else if (isInherited) {
                text.append(Messages.CategoryPart_INHERITED_LABEL_DECORATION);
            }
            return text.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NewCategoryDialog
    extends Dialog {
        private String fTitle = Messages.CategoryPart_ADD_NEW_CATEGORY;
        private String fName = "";
        private String fPath = "";
        private DocumentModel fDescriptionModel = new DocumentModel();
        private DecoratedText fNameText;
        private StyledTextViewerSupport fDescriptionSupport;
        private Label fPathLabel;
        private List<String> fUnavailable = Collections.emptyList();

        public NewCategoryDialog(Shell parentShell) {
            super(parentShell);
        }

        public void setTitle(String title) {
            this.fTitle = title;
        }

        public String getName() {
            return this.fName;
        }

        public void setName(String name) {
            this.fName = name;
        }

        public void setPath(String path) {
            this.fPath = path;
        }

        public XMLString getDescription() {
            return this.fDescriptionModel.getDocument().getHTML();
        }

        public void setDescription(XMLString description) {
            this.fDescriptionModel.getDocument().setHTML(description);
        }

        public void setUnavailable(List<String> unavailable) {
            this.fUnavailable = unavailable;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(this.fTitle);
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = (Composite)super.createDialogArea(parent);
            Composite composite = new Composite(container, 0);
            GridData data = new GridData(4, 4, true, true);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            composite.setLayoutData((Object)data);
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 9;
            composite.setLayout((Layout)layout);
            Label label = new Label(composite, 0);
            label.setText(Messages.CategoryPart_NAME);
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.fNameText = new DecoratedText(composite, 2052);
            data = new GridData(4, 0x1000000, true, false);
            this.fNameText.getLayoutControl().setLayoutData((Object)data);
            this.fNameText.getText().setFocus();
            this.fNameText.getText().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NewCategoryDialog.this.fName = ((String)NewCategoryDialog.this.fNameText.getValue()).trim();
                    String path = NewCategoryDialog.this.fPath;
                    if (!"".equals(path)) {
                        path = String.valueOf(path) + "/";
                    }
                    path = String.valueOf(path) + NewCategoryDialog.this.fName;
                    NewCategoryDialog.this.fPathLabel.setText(TextProcessor.process((String)path));
                    NewCategoryDialog.this.validateInput();
                }
            });
            label = new Label(composite, 0);
            label.setText(Messages.CategoryPart_PATH);
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.fPathLabel = new Label(composite, 0);
            this.fPathLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.fPathLabel.setText(TextProcessor.process((String)this.fPath));
            this.fNameText.setValue(this.fName);
            this.fNameText.setSelection((ISelection)new TextSelection(0, this.fName.length()));
            label = new Label(composite, 0);
            label.setText(Messages.CategoryPart_DESCRIPTION);
            label.setLayoutData((Object)new GridData(16384, 128, false, false));
            this.fDescriptionSupport = new StyledTextViewerSupport();
            this.fDescriptionSupport.getTextViewerDecorators().add(0, new CollaborationPresenceTextDecorator());
            this.fDescriptionSupport.setMargin(new Point(1, 1));
            this.fDescriptionSupport.init((ITeamFormPartSite)new TeamFormPartSite(null));
            this.fDescriptionSupport.setStyle(68162);
            this.fDescriptionSupport.createContent(composite);
            SourceViewer sourceViewer = this.fDescriptionSupport.getSourceViewer();
            Control control = sourceViewer.getControl();
            data = new GridData(4, 4, true, true);
            data.widthHint = 64;
            data.heightHint = this.fDescriptionSupport.getSourceViewer().getTextWidget().getLineHeight() * 5;
            control.setLayoutData((Object)data);
            this.fDescriptionSupport.getSourceViewer().setDocument((IDocument)this.fDescriptionModel.getDocument(), this.fDescriptionModel.getAnnotationModel());
            this.fDescriptionSupport.updateBaseURI();
            NewCategoryDialog.applyDialogFont((Control)container);
            return container;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.validateInput();
        }

        private void validateInput() {
            Button okButton = this.getButton(0);
            if (okButton == null) {
                return;
            }
            IStatus nameStatus = this.getNameStatus();
            if (this.getButtonBar() != null) {
                this.fNameText.setStatus(nameStatus);
            }
            boolean enabled = nameStatus.getSeverity() != 4 && nameStatus.getSeverity() != 8;
            okButton.setEnabled(enabled);
        }

        private IStatus getNameStatus() {
            if (this.fName.length() == 0) {
                return new Status(4, "com.ibm.team.workitem.rcp.ui", Messages.CategoryPart_NAME_EMPTY);
            }
            if (this.fName.contains("/")) {
                return new Status(4, "com.ibm.team.workitem.rcp.ui", Messages.CategoryPart_NAME_CONTAINS_SLASH);
            }
            if (this.fUnavailable.contains(this.fName)) {
                return new Status(4, "com.ibm.team.workitem.rcp.ui", Messages.CategoryPart_NAME_EXISTS);
            }
            return Status.OK_STATUS;
        }

        public boolean close() {
            boolean close = super.close();
            if (close && this.fDescriptionSupport != null) {
                this.fDescriptionSupport.dispose();
                this.fDescriptionSupport = null;
            }
            return close;
        }
    }

    private class SharedItemListener
    implements ISharedItemChangeListener {
        private SharedItemListener() {
        }

        public void itemsChanged(List events) {
            boolean affected = false;
            for (ISharedItemChangeEvent shEvent : events) {
                if (shEvent.getSharedItem() instanceof IProjectArea && shEvent.getSharedItem().sameItemId((IItemHandle)CategoryPart.this.fProjectArea) && CategoryPart.this.fCategoriesMgr == null) {
                    affected = true;
                    break;
                }
                if (!(shEvent.getSharedItem() instanceof ITeamArea) && !(shEvent.getSharedItem() instanceof IDevelopmentLine)) continue;
                affected = true;
                break;
            }
            if (affected) {
                CategoryPart.this.updateViewers();
            }
        }
    }
}

