/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.calm;

import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.workitem.common.calm.PickerDescription;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteItemDialog
extends Dialog {
    private static final String PROTOCOL = "comBrowser://";
    private static final String ITEM_KEY_URI = "rdf:resource";
    private final PickerDescription fPickerDescription;
    private Browser fBrowser;
    private Collection<RemoteItem> fRemoteItems;

    public RemoteItemDialog(Shell parentShell, PickerDescription pickerDescription) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fPickerDescription = pickerDescription;
    }

    public Collection<RemoteItem> getItems() {
        return this.fRemoteItems;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.fPickerDescription.getTitle());
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridData gd = (GridData)container.getLayoutData();
        gd.widthHint = this.fPickerDescription.getWidthHintInPixels();
        gd.heightHint = this.fPickerDescription.getHeightHintInPixels();
        GridLayout layout = (GridLayout)container.getLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        final String url = String.valueOf(this.fPickerDescription.getPickerURL()) + "#oslc-windowName-1.0";
        final String returnURL = String.valueOf(url) + "-return-location";
        this.fBrowser = new Browser(container, 0);
        this.fBrowser.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fBrowser.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    RemoteItemDialog.this.close();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.fBrowser.addLocationListener(new LocationListener(){

            public void changed(LocationEvent event) {
                if (event.location.equals(RemoteItemDialog.this.fPickerDescription.getPickerURL())) {
                    RemoteItemDialog.this.fBrowser.setUrl(url);
                } else if (event.location.equals(url)) {
                    RemoteItemDialog.this.fBrowser.execute("document.getElementsByTagName('body')[0].style.overflow='hidden'");
                }
                if (event.location.equals(url)) {
                    this.setWindowName(returnURL);
                }
            }

            public void changing(LocationEvent event) {
                String result;
                if (event.location.equals(returnURL) && (result = this.getWindowName()) != null) {
                    RemoteItemDialog.this.processResult(result);
                }
            }

            private void setWindowName(String newLocation) {
                String command = "window.name= '" + newLocation + "';";
                RemoteItemDialog.this.fBrowser.execute(command);
            }

            private String getWindowName() {
                StatusTextListenerImpl listener = new StatusTextListenerImpl();
                RemoteItemDialog.this.fBrowser.addStatusTextListener((StatusTextListener)listener);
                try {
                    String command = "window.status= 'comBrowser://' + window.name;";
                    RemoteItemDialog.this.fBrowser.execute(command);
                    String string = listener.result;
                    return string;
                }
                finally {
                    RemoteItemDialog.this.fBrowser.removeStatusTextListener((StatusTextListener)listener);
                }
            }

            class StatusTextListenerImpl
            implements StatusTextListener {
                public String result;

                StatusTextListenerImpl() {
                }

                public void changed(StatusTextEvent event) {
                    String text = event.text;
                    this.result = text.startsWith(RemoteItemDialog.PROTOCOL) ? text.substring(RemoteItemDialog.PROTOCOL.length()) : null;
                }
            }
        });
        this.fBrowser.setUrl(url);
        RemoteItemDialog.applyDialogFont((Control)container);
        return container;
    }

    protected void processResult(String data) {
        if (data.length() != 0) {
            try {
                String resultKey = String.valueOf(this.fPickerDescription.getResultNamespace()) + ":results";
                String titleKey = String.valueOf(this.fPickerDescription.getResultNamespace()) + ":label";
                JSONObject reponse = JSONObject.parse((Reader)new StringReader(data));
                if (reponse != null && reponse.get((Object)resultKey) instanceof JSONArray) {
                    JSONArray returnElements = (JSONArray)reponse.get((Object)resultKey);
                    ArrayList<RemoteItem> result = new ArrayList<RemoteItem>();
                    for (Object obj : returnElements) {
                        if (!(obj instanceof JSONObject)) continue;
                        JSONObject current = (JSONObject)obj;
                        Object urlObject = current.get((Object)ITEM_KEY_URI);
                        Object commentObject = current.get((Object)titleKey);
                        if (!(urlObject instanceof String) || !(commentObject instanceof String)) continue;
                        result.add(new RemoteItem((String)urlObject, (String)commentObject));
                    }
                    this.fRemoteItems = result;
                    this.setReturnCode(0);
                    this.close();
                    return;
                }
            }
            catch (IOException e) {
                WorkItemIDEUIPlugin.getDefault().log((IStatus)new Status(4, "com.ibm.team.workitem.ide.ui", 4, MessageFormat.format(Messages.RemoteItemDialog_ERROR_DIALOG_RESULT, data), (Throwable)e));
            }
        }
        this.setReturnCode(1);
        this.close();
    }

    public static class RemoteItem {
        private final String fURI;
        private final String fLinkComment;

        private RemoteItem(String uri, String linkComment) {
            this.fURI = uri;
            this.fLinkComment = linkComment;
        }

        public URI getURI() {
            return URI.create(this.fURI);
        }

        public String getComment() {
            return this.fLinkComment;
        }
    }
}

