/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.calm;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.transport.client.ITeamRawRestServiceClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeaderValueParser;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RESTHelper {
    public static String APPLICATION_JSON = "application/json";
    public static String APPLICATION_OSCL_CM_JSON = "application/x-oslc-cm-change-request+json";

    public static String performGet(String url, String contentType, String failureMessage, ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("Accept", contentType);
        ITeamRawRestServiceClient.IRawRestClientConnection.Response response = RESTHelper.performGet(url, headers, failureMessage, repository, monitor);
        return RESTHelper.readResponse(response);
    }

    public static ITeamRawRestServiceClient.IRawRestClientConnection.Response performGet(String url, Map<String, String> headers, String failureMessage, ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
        IClientLibraryContext.IServiceRunnable<ITeamRawRestServiceClient.IRawRestClientConnection.Response> block = RESTHelper.rawRestDoGetBlock(url, headers, repository);
        ITeamRawRestServiceClient.IRawRestClientConnection.Response response = (ITeamRawRestServiceClient.IRawRestClientConnection.Response)((IClientLibraryContext)repository).callCancelableService(block, monitor);
        if (response.getStatusCode() != 200) {
            throw new TeamRepositoryException(failureMessage);
        }
        return response;
    }

    public static ITeamRawRestServiceClient.IRawRestClientConnection.Response performPut(String url, Map<String, String> headers, String content, String encoding, String failureMessage, ITeamRepository repository, IProgressMonitor monitor) throws TeamRepositoryException {
        IClientLibraryContext.IServiceRunnable<ITeamRawRestServiceClient.IRawRestClientConnection.Response> block = RESTHelper.rawRestDoPutBlock(url, headers, content, encoding, repository);
        ITeamRawRestServiceClient.IRawRestClientConnection.Response response = (ITeamRawRestServiceClient.IRawRestClientConnection.Response)((IClientLibraryContext)repository).callCancelableService(block, monitor);
        if (response.getStatusCode() != 200) {
            throw new TeamRepositoryException(failureMessage);
        }
        return response;
    }

    public static Reader getResponseReader(ITeamRawRestServiceClient.IRawRestClientConnection.Response response) throws TeamRepositoryException {
        try {
            InputStream stream = response.getResponseStream();
            return new InputStreamReader(stream, RESTHelper.getEncoding(response, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    public static String getEncoding(ITeamRawRestServiceClient.IRawRestClientConnection.Response response, String defaultCharset) {
        NameValuePair param;
        HeaderElement[] values;
        String contentTypeHeader = response.getResponseHeader("Content-Type");
        if (contentTypeHeader != null && (values = BasicHeaderValueParser.parseElements((String)contentTypeHeader, null)).length > 0 && (param = values[0].getParameterByName("charset")) != null) {
            return param.getValue();
        }
        return defaultCharset;
    }

    public static String readResponse(ITeamRawRestServiceClient.IRawRestClientConnection.Response response) throws TeamRepositoryException {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(8192);
            InputStream stream = response.getResponseStream();
            byte[] bytes = new byte[8192];
            try {
                int ch = stream.read(bytes);
                while (ch != -1) {
                    buffer.write(bytes, 0, ch);
                    ch = stream.read(bytes);
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
            return buffer.toString(RESTHelper.getEncoding(response, "UTF-8"));
        }
        catch (IOException e) {
            throw new TeamRepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    private static IClientLibraryContext.IServiceRunnable<ITeamRawRestServiceClient.IRawRestClientConnection.Response> rawRestDoGetBlock(final String resourceUrlString, final Map<String, String> headers, ITeamRepository repository) {
        final ITeamRawRestServiceClient rawRestServiceClient = repository.getRawRestServiceClient();
        IClientLibraryContext.IServiceRunnable<ITeamRawRestServiceClient.IRawRestClientConnection.Response> block = new IClientLibraryContext.IServiceRunnable<ITeamRawRestServiceClient.IRawRestClientConnection.Response>(){

            public ITeamRawRestServiceClient.IRawRestClientConnection.Response run(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    URI url = new URI(resourceUrlString);
                    ITeamRawRestServiceClient.IRawRestClientConnection connection = rawRestServiceClient.getConnection(url);
                    for (Map.Entry header : headers.entrySet()) {
                        connection.addRequestHeader((String)header.getKey(), (String)header.getValue());
                    }
                    ITeamRawRestServiceClient.IRawRestClientConnection.Response resp = connection.doGet();
                    return resp;
                }
                catch (URISyntaxException e) {
                    throw new TeamRepositoryException(e.getMessage(), (Throwable)e);
                }
            }
        };
        return block;
    }

    private static IClientLibraryContext.IServiceRunnable<ITeamRawRestServiceClient.IRawRestClientConnection.Response> rawRestDoPutBlock(final String resourceUrlString, final Map<String, String> headers, final String content, final String encoding, ITeamRepository repository) {
        final ITeamRawRestServiceClient rawRestServiceClient = repository.getRawRestServiceClient();
        IClientLibraryContext.IServiceRunnable<ITeamRawRestServiceClient.IRawRestClientConnection.Response> block = new IClientLibraryContext.IServiceRunnable<ITeamRawRestServiceClient.IRawRestClientConnection.Response>(){

            public ITeamRawRestServiceClient.IRawRestClientConnection.Response run(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    URI url = new URI(resourceUrlString);
                    ITeamRawRestServiceClient.IRawRestClientConnection connection = rawRestServiceClient.getConnection(url);
                    for (Map.Entry header : headers.entrySet()) {
                        connection.addRequestHeader((String)header.getKey(), (String)header.getValue());
                    }
                    byte[] bytes = content.getBytes(encoding);
                    ITeamRawRestServiceClient.IRawRestClientConnection.Response resp = connection.doPut((InputStream)new ByteArrayInputStream(bytes), (long)bytes.length, encoding);
                    return resp;
                }
                catch (URISyntaxException e) {
                    throw new TeamRepositoryException(e.getMessage(), (Throwable)e);
                }
                catch (UnsupportedEncodingException e) {
                    throw new TeamRepositoryException(e.getMessage(), (Throwable)e);
                }
            }
        };
        return block;
    }

    public static String urlEncode(String str) {
        return RESTHelper.urlEncode(str, "UTF-8");
    }

    public static String urlEncode(String str, String encoding) {
        try {
            String newStr = URLEncoder.encode(str, encoding);
            return newStr.replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return str;
        }
    }
}

