/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.internal.presentations.AbstractPresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.AttributeTypePresentationIdBindingManager;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.AttributePart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationPart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationsManager;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class WorkItemEditorParts {
    public static TeamFormPart createPart(WorkItemWorkingCopy workingCopy, AbstractPresentationDescriptor descriptor) {
        if (descriptor instanceof PresentationDescriptor) {
            PresentationDescriptor desc = (PresentationDescriptor)descriptor;
            if (desc.getKind() != null) {
                if ("com.ibm.team.workitem.kind.special.doNotShow".equals(desc.getKind())) {
                    return null;
                }
                if (PresentationsManager.needsAttribute(desc.getKind())) {
                    if (desc.getAttributeId() == null) {
                        WorkItemIDEUIPlugin.getDefault().log((IStatus)new Status(4, "com.ibm.team.workitem.ide.ui", NLS.bind((String)Messages.WorkItemEditorParts_PRESENTATION_REQUIRES_ATTRIBUTE, (Object)desc.getKind(), (Object[])new Object[]{desc.getElementId()})));
                        return null;
                    }
                    WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)workingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
                    ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
                    IAttribute attribute = workItem.findAttribute(desc.getAttributeId());
                    if (attribute == null) {
                        return null;
                    }
                    desc = WorkItemEditorParts.addDependencies(desc, workItem, attribute);
                    return WorkItemEditorParts.createAttributePart(desc.getKind(), attribute, desc);
                }
                return WorkItemEditorParts.createPresentationPart(desc);
            }
            if (desc.getAttributeId() == null) {
                WorkItemIDEUIPlugin.getDefault().log((IStatus)new Status(4, "com.ibm.team.workitem.ide.ui", NLS.bind((String)Messages.WorkItemEditorParts_KIND_AND_ATTRIBUTE_ID_MISSING, (Object)desc.getElementId(), (Object[])new Object[0])));
                return null;
            }
            WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)workingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
            ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
            IAttribute attribute = workItem.findAttribute(desc.getAttributeId());
            if (attribute == null) {
                return null;
            }
            String kind = AttributeTypePresentationIdBindingManager.getAttributeTypePresentationId((String)attribute.getAttributeType());
            if (kind == null) {
                WorkItemIDEUIPlugin.getDefault().log((IStatus)new Status(4, "com.ibm.team.workitem.ide.ui", NLS.bind((String)Messages.WorkItemEditorParts_NO_DEFAULT_PRESENTATION, (Object)attribute.getIdentifier(), (Object[])new Object[]{attribute.getAttributeType()})));
                return null;
            }
            desc = WorkItemEditorParts.addDependencies(desc, workItem, attribute);
            return WorkItemEditorParts.createAttributePart(kind, attribute, desc);
        }
        return null;
    }

    private static PresentationDescriptor addDependencies(PresentationDescriptor desc, ResolvedWorkItem workItem, IAttribute attribute) {
        if (!attribute.getDependencies().isEmpty()) {
            HashSet<String> dependencies = new HashSet<String>();
            block0: for (IAttributeHandle h : attribute.getDependencies()) {
                for (IAttribute a : workItem.getAttributes()) {
                    if (!h.sameItemId((IItemHandle)a)) continue;
                    dependencies.add(a.getIdentifier());
                    continue block0;
                }
            }
            desc = Util.addDependencies(desc, dependencies.toArray(new String[dependencies.size()]));
        }
        return desc;
    }

    private static TeamFormPart createPresentationPart(PresentationDescriptor desc) {
        PresentationPart p = PresentationsManager.getPresentation(desc.getKind());
        if (p == null) {
            return null;
        }
        p.initialize(desc);
        return p;
    }

    private static TeamFormPart createAttributePart(String kind, IAttribute attribute, PresentationDescriptor desc) {
        PresentationPart p = PresentationsManager.getAttributePresentation(attribute, kind);
        if (p == null || !(p instanceof AttributePart)) {
            return null;
        }
        AttributePart ap = (AttributePart)p;
        ap.initialize(attribute, desc);
        return ap;
    }
}

