/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.IProjectLink;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.process.internal.client.ProcessClientService;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.internal.util.WorkItemEventResolver;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.WorkItemCommon;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.internal.presentations.EditorPresentation;
import com.ibm.team.workitem.common.model.IApproval;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.ItemURI;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.AbstractWorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.util.SafeRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemEditorInput
extends AbstractWorkItemEditorInput {
    private IWorkItemWorkingCopyManager fWorkingCopyManager;
    private WorkItemWorkingCopy fWorkingCopy;
    private List<IAuditable> fAuxiliaryItems;
    private EditorPresentation fEditorPresentation;
    private Set<Object> fNullValues;
    private TeamRepositoryException fException;
    private boolean fIsResolved = false;
    private boolean fCanEmptyComments;
    private int fReferenceCount = 0;
    private String fTargetId;

    public WorkItemEditorInput(IWorkItemHandle workItemHandle) {
        super(workItemHandle);
    }

    public WorkItemEditorInput(IWorkItemHandle workItemHandle, String presentationTargetId) {
        super(workItemHandle);
        this.fTargetId = presentationTargetId;
    }

    public TeamRepositoryException getException() {
        return this.fException;
    }

    public Object getAdapter(Class adapter) {
        if (WorkItemWorkingCopy.class.equals((Object)adapter)) {
            return this.getWorkingCopy();
        }
        return super.getAdapter(adapter);
    }

    public IWorkItemWorkingCopyManager getWorkingCopyManager() {
        return this.fWorkingCopyManager;
    }

    public WorkItemWorkingCopy getWorkingCopy() {
        return this.getWorkingCopy(null);
    }

    public WorkItemWorkingCopy getWorkingCopy(IProgressMonitor monitor) {
        this.fetchAll(monitor);
        return this.fWorkingCopy;
    }

    public IWorkItem getWorkItem() {
        this.fetchAll(null);
        if (this.fWorkingCopy.getWorkItem().isNewItem()) {
            return this.fWorkingCopy.getWorkItem();
        }
        return ((WorkItemWorkingCopyImpl)this.fWorkingCopy).getSharedItem();
    }

    private void fetchAll(final IProgressMonitor monitor) {
        if (this.needsLoading()) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ITeamRepository repository = (ITeamRepository)WorkItemEditorInput.this.fWorkItemHandle.getOrigin();
                    IAuditableClient auditableClient = (IAuditableClient)repository.getClientLibrary(IAuditableClient.class);
                    final IWorkItemClient workItemClient = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
                    IStatus status = FoundationUIUtils.validateRepository((ITeamRepository)repository, (boolean)false, (IProgressMonitor)monitor);
                    if (!status.isOK()) {
                        throw new CoreException(status);
                    }
                    IWorkItem cachedItem = (IWorkItem)auditableClient.findCachedAuditable((IAuditableHandle)WorkItemEditorInput.this.fWorkItemHandle, IWorkItem.FULL_PROFILE);
                    List cachedLinks = ((WorkItemWorkingCopyManager)workItemClient.getWorkItemWorkingCopyManager()).findCachedLinks(WorkItemEditorInput.this.fWorkItemHandle);
                    WorkItemEditorInput.this.fWorkingCopyManager = workItemClient.createWorkingCopyManager(Messages.WorkItemEditorInput_WORK_ITEM_EDITOR, true);
                    try {
                        WorkItemEditorInput.this.fWorkingCopyManager.connect(WorkItemEditorInput.this.fWorkItemHandle, IWorkItem.FULL_PROFILE, monitor);
                    }
                    catch (ItemNotFoundException x) {
                        if (!(WorkItemEditorInput.this.fWorkItemHandle instanceof IWorkItem)) {
                            throw x;
                        }
                        WorkItemWorkingCopy copy = ((WorkItemWorkingCopyManager)WorkItemEditorInput.this.fWorkingCopyManager).createNewUnconnected((IWorkItem)WorkItemEditorInput.this.fWorkItemHandle);
                        ((WorkItemWorkingCopyManager)WorkItemEditorInput.this.fWorkingCopyManager).connectNew(copy, monitor);
                    }
                    WorkItemEditorInput.this.fWorkingCopy = WorkItemEditorInput.this.fWorkingCopyManager.getWorkingCopy(WorkItemEditorInput.this.fWorkItemHandle);
                    WorkItemEditorInput.this.fAuxiliaryItems = WorkItemEditorInput.this.resolveAuxiliaryItems(WorkItemEditorInput.this.fWorkingCopy, monitor);
                    WorkItemEditorInput.this.fIsResolved = true;
                    if (!(cachedItem == null && cachedLinks == null || ((WorkItemWorkingCopyImpl)WorkItemEditorInput.this.fWorkingCopy).hasOtherWriteConnection(WorkItemEditorInput.this.fWorkingCopyManager))) {
                        final IWorkItemHandle handle = WorkItemEditorInput.this.fWorkItemHandle;
                        workItemClient.getWorkItemWorkingCopyManager().connect(handle, IWorkItem.FULL_PROFILE, monitor);
                        FoundationJob job = new FoundationJob(Messages.WorkItemEditor_REFRESHING_WORKITEM){

                            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                                try {
                                    ((WorkItemWorkingCopyManager)workItemClient.getWorkItemWorkingCopyManager()).refreshWithCurrent(handle, true, monitor);
                                }
                                finally {
                                    workItemClient.getWorkItemWorkingCopyManager().disconnect(handle);
                                }
                                return null;
                            }
                        };
                        job.setSystem(true);
                        job.schedule();
                    }
                }

                public void handleException(Throwable exception) {
                    WorkItemEditorInput.this.dispose();
                    if (exception instanceof TeamRepositoryException) {
                        WorkItemEditorInput.this.fException = (TeamRepositoryException)exception;
                    } else {
                        WorkItemEditorInput.this.fException = new TeamRepositoryException(exception);
                    }
                }
            });
        }
    }

    public boolean needsLoading() {
        return this.fWorkingCopy == null && this.fException == null;
    }

    public boolean isResolved() {
        return this.fIsResolved;
    }

    public EditorPresentation getEditorPresentation() {
        return this.fEditorPresentation;
    }

    public boolean loggedInContributorCanEmptyComments() {
        return this.fCanEmptyComments;
    }

    private List<IAuditable> resolveAuxiliaryItems(WorkItemWorkingCopy workingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IAuditable> items = new ArrayList<IAuditable>();
        IWorkItem workItem = workingCopy.getWorkItem();
        ITeamRepository teamRepository = (ITeamRepository)workItem.getOrigin();
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)workingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
        uiCopy.resolve(monitor);
        this.updateEditorPresentation(monitor);
        this.fNullValues = new HashSet<Object>();
        for (IAttribute att : uiCopy.getResolvedWorkItem().getAttributes()) {
            this.fNullValues.add(att.getNullValue((IAuditableCommon)auditableClient, monitor));
        }
        workItemClient.findWorkItemType(workItem.getProjectArea(), workItem.getWorkItemType(), monitor);
        ArrayList<IContributorHandle> contributors = new ArrayList<IContributorHandle>();
        IComment[] contents = workItem.getComments().getContents();
        int i = 0;
        while (i < contents.length) {
            contributors.add(contents[i].getCreator());
            ++i;
        }
        List approvals = ((WorkItem)workItem).getInternalApprovals();
        for (IApproval approval : approvals) {
            contributors.add(approval.getApprover());
        }
        ProcessClientService processClient = (ProcessClientService)teamRepository.getClientLibrary(IProcessItemService.class);
        try {
            this.fCanEmptyComments = processClient.assertPermission("JazzAdmins", monitor);
        }
        catch (TeamRepositoryException teamRepositoryException) {}
        items.addAll(auditableClient.resolveAuditables(contributors, ItemProfile.CONTRIBUTOR_DEFAULT, monitor));
        items.addAll(workItemClient.findAttributes(workItem.getProjectArea(), monitor));
        workItemClient.findWorkflowInfo(workItem, monitor);
        items.addAll(this.resolveReferences(workingCopy, monitor));
        workItemClient.areAdditionalSaveParametersSupported(monitor);
        return items;
    }

    void updateEditorPresentation(IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemClient workItemClient = (IWorkItemClient)this.fWorkingCopy.getTeamRepository().getClientLibrary(IWorkItemClient.class);
        this.fEditorPresentation = ((WorkItemCommon)workItemClient).getEditorPresentation(this.fTargetId, this.fWorkingCopy.getWorkItem(), monitor);
    }

    private List<IAuditable> resolveReferences(WorkItemWorkingCopy workingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = workingCopy.getTeamRepository();
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        HashMap<IItemType, ArrayList<IAuditableHandle>> map = new HashMap<IItemType, ArrayList<IAuditableHandle>>();
        IWorkItemReferences references = workingCopy.getReferences();
        List referenceTypes = references.getTypes();
        for (IEndPointDescriptor descriptor : referenceTypes) {
            List list = references.getReferences(descriptor);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IReference reference = (IReference)iterator.next();
                IAuditableHandle handle = this.findAuditableHandle(monitor, auditableClient, reference);
                if (handle == null) continue;
                ArrayList<IAuditableHandle> handles = (ArrayList<IAuditableHandle>)map.get(handle.getItemType());
                if (handles == null) {
                    handles = new ArrayList<IAuditableHandle>();
                    map.put(handle.getItemType(), handles);
                }
                handles.add(handle);
            }
        }
        ArrayList<IAuditable> items = new ArrayList<IAuditable>();
        for (Map.Entry entry : map.entrySet()) {
            ItemProfile profile = WorkItemEventResolver.getRequiredProfile((IItemType)((IItemType)entry.getKey()));
            items.addAll(auditableClient.resolveAuditables((List)entry.getValue(), profile, monitor));
        }
        IProjectAreaHandle iProjectAreaHandle = workingCopy.getWorkItem().getProjectArea();
        IProjectArea projectArea = (IProjectArea)auditableClient.resolveAuditable((IAuditableHandle)iProjectAreaHandle, ItemProfile.createProfile((IItemType)IProjectArea.ITEM_TYPE, (String[])new String[]{ProcessCommon.getPropertyName(IProjectArea.class, (String)"projectLinks")}), monitor);
        List projectLinks = auditableClient.resolveAuditables(Arrays.asList(projectArea.getProjectLinks()), ItemProfile.createFullProfile((IItemType)IProjectLink.ITEM_TYPE), monitor);
        items.add((IAuditable)projectArea);
        items.addAll(projectLinks);
        return items;
    }

    private IAuditableHandle findAuditableHandle(IProgressMonitor monitor, IAuditableClient auditableClient, IReference reference) throws TeamRepositoryException {
        ITeamRepository teamRepository;
        IItemHandle link;
        IItemHandle object = null;
        if (reference.isItemReference()) {
            object = ((IItemReference)reference).getReferencedItem();
        } else if (reference.isURIReference() && (link = (IItemHandle)((EObject)reference).eContainer()) != null && (teamRepository = (ITeamRepository)link.getOrigin()) != null) {
            try {
                object = ItemURI.resolveItemHandle((IAuditableCommon)auditableClient, (URI)((IURIReference)reference).getURI());
            }
            catch (TeamRepositoryException x) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.WorkItemEditorInput_ERROR_RESOLVING_URI, x);
            }
        }
        if (object instanceof IAuditableHandle) {
            return (IAuditableHandle)object;
        }
        return null;
    }

    public void acquire() {
        ++this.fReferenceCount;
    }

    public void release() {
        if (--this.fReferenceCount == 0) {
            this.dispose();
        }
    }

    private void dispose() {
        if (this.fWorkingCopyManager != null) {
            if (this.fWorkingCopy != null) {
                this.fWorkingCopyManager.disconnect((IWorkItemHandle)this.getWorkItem());
                this.fWorkingCopy = null;
            }
            this.fWorkingCopyManager.dispose();
            this.fWorkingCopyManager = null;
        }
        if (this.fAuxiliaryItems != null) {
            this.fAuxiliaryItems = null;
        }
        if (this.fNullValues != null) {
            this.fNullValues = null;
        }
        this.fTargetId = null;
        if (this.fWorkItemHandle instanceof IWorkItem && ((IWorkItem)this.fWorkItemHandle).getId() != -1) {
            this.fWorkItemHandle = (IWorkItemHandle)((IWorkItem)this.fWorkItemHandle).getItemHandle();
        }
        this.fException = null;
        this.fIsResolved = false;
    }

    public URIReference getReference() {
        return Hyperlinks.createHyperlink((Object)this.fWorkItemHandle);
    }
}

