/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.CommandAction;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.IViewerPaneListener;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.SourceViewerPane;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.ViewerPane;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.ViewerPaneAction;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.ViewerPart;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.actions.ExtractWorkItemAction;
import com.ibm.team.workitem.ide.ui.internal.actions.ReferenceWorkItemAction;
import com.ibm.team.workitem.ide.ui.internal.actions.RefreshWorkItemEditorAction;
import com.ibm.team.workitem.ide.ui.internal.actions.RevertWorkItemEditorAction;
import com.ibm.team.workitem.ide.ui.internal.editor.DeleteLinkAction;
import com.ibm.team.workitem.ide.ui.internal.editor.GotoAnnotationAction;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditor;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.QueriesUI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class WorkItemEditorActionBarContributor
extends EditorActionBarContributor {
    private static final String WORK_ITEM_EDIT_GROUP = "workitem";
    private static final String WORK_ITEM_EDIT_EXT_GROUP = "workitem.ext";
    private WorkItemEditor fWorkItemEditor;
    private Action fFindAll;
    private Action fRemoveOccurrences;
    private GotoAnnotationAction fPreviousAnnotation;
    private GotoAnnotationAction fNextAnnotation;
    private Action fQuickQuery;
    private ReferenceWorkItemAction fReferenceWorkItem;
    private ExtractWorkItemAction fExtractWorkItemAction;
    private RefreshWorkItemEditorAction fRefresh;
    private RevertWorkItemEditorAction fRevert;
    private ArrayList<CommandAction> fCommandActions = new ArrayList();
    private IEditorPart fPart;
    private ViewerPart fViewerPart;
    private InternalListener fInternalListener = new InternalListener();
    private ViewerPaneAction fDeleteLink;
    private List<IHandlerActivation> fActivations = new ArrayList<IHandlerActivation>();

    public WorkItemEditorActionBarContributor() {
        this.fFindAll = new FindAllAction(Messages.WorkItemEditorActionBarContributor_FIND_ALL_TITLE, Messages.WorkItemEditorActionBarContributor_FIND_ALL_ACTION_MESSAGE, "com.ibm.magnolia.edit.model.find.all", AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.team.workitem.ide.ui", (String)"icons/etool16/find_all.gif"));
        this.fQuickQuery = new QuickQueryAction(Messages.WorkItemEditorActionBarContributor_QUICK_QUERY, Messages.WorkItemEditorActionBarContributor_QUERY_FOR_TEXT, "com.ibm.magnolia.edit.model.query.selection", AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.team.workitem.ide.ui", (String)"icons/etool16/find_all.gif"));
        this.fReferenceWorkItem = new ReferenceWorkItemAction();
        this.fExtractWorkItemAction = new ExtractWorkItemAction();
        this.fRemoveOccurrences = new RemoveOccurrencesAction(Messages.WorkItemEditorActionBarContributor_REMOVE_OCCURENCES, Messages.WorkItemEditorActionBarContributor_REMOVE_OCCURRENCE_ANNOTATIONS, "com.ibm.magnolia.edit.model.remove.occurrences", null);
        this.fPreviousAnnotation = new GotoAnnotationAction(Messages.WorkItemEditorActionBarContributor_PREVIOUS_ANNOTATION, false);
        this.fNextAnnotation = new GotoAnnotationAction(Messages.WorkItemEditorActionBarContributor_NEXT_ANNOTATION, true);
        this.fRefresh = new RefreshWorkItemEditorAction(Messages.WorkItemEditorActionBarContributor_REFRESH, Messages.WorkItemEditorActionBarContributor_REFRESH_WITH_SAVED_STATE, ActionFactory.REFRESH.getId(), null);
        this.fRevert = new RevertWorkItemEditorAction(Messages.WorkItemEditorActionBarContributor_REVERT, Messages.WorkItemEditorActionBarContributor_REVERT_TO_SAVED_STATE, ITextEditorActionConstants.REVERT, null);
        this.fDeleteLink = new DeleteLinkAction(Messages.WorkItemEditorActionBarContributor_DELETE_WITHMNEMONICS, Messages.WorkItemEditorActionBarContributor_DELETE, ActionFactory.DELETE.getId(), null);
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        super.init(bars, page);
        bars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoNextAnnotation", (IAction)this.fNextAnnotation);
        bars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoPreviousAnnotation", (IAction)this.fPreviousAnnotation);
        bars.setGlobalActionHandler(ITextEditorActionConstants.NEXT, (IAction)this.fNextAnnotation);
        bars.setGlobalActionHandler(ITextEditorActionConstants.PREVIOUS, (IAction)this.fPreviousAnnotation);
        bars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.fRefresh);
        bars.setGlobalActionHandler(ITextEditorActionConstants.REVERT, (IAction)this.fRevert);
        bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.fDeleteLink);
        Object version = Platform.getBundle((String)"org.eclipse.ui").getHeaders().get("Bundle-Version");
        if (version instanceof String && ((String)version).startsWith("3.3")) {
            bars.setGlobalActionHandler(ITextEditorActionConstants.CUT, (IAction)this.remember(new CommandAction(bars.getServiceLocator(), "org.eclipse.ui.edit.cut")));
            bars.setGlobalActionHandler(ITextEditorActionConstants.COPY, (IAction)this.remember(new CommandAction(bars.getServiceLocator(), "org.eclipse.ui.edit.copy")));
            bars.setGlobalActionHandler(ITextEditorActionConstants.PASTE, (IAction)this.remember(new CommandAction(bars.getServiceLocator(), "org.eclipse.ui.edit.paste")));
            bars.setGlobalActionHandler(ITextEditorActionConstants.UNDO, (IAction)this.remember(new CommandAction(bars.getServiceLocator(), "org.eclipse.ui.edit.undo")));
            bars.setGlobalActionHandler(ITextEditorActionConstants.REDO, (IAction)this.remember(new CommandAction(bars.getServiceLocator(), "org.eclipse.ui.edit.redo")));
        }
    }

    private CommandAction remember(CommandAction action) {
        this.fCommandActions.add(action);
        return action;
    }

    public void contributeToMenu(IMenuManager menuManager) {
        IMenuManager editMenu = menuManager.findMenuUsingPath("edit");
        if (editMenu != null) {
            editMenu.prependToGroup("find.ext", (IAction)this.fRemoveOccurrences);
            editMenu.prependToGroup("find.ext", (IAction)this.fFindAll);
            editMenu.appendToGroup("find.ext", (IContributionItem)new Separator(WORK_ITEM_EDIT_GROUP));
            editMenu.appendToGroup(WORK_ITEM_EDIT_GROUP, (IAction)this.fExtractWorkItemAction);
            editMenu.appendToGroup(WORK_ITEM_EDIT_GROUP, (IAction)this.fReferenceWorkItem);
            editMenu.appendToGroup(WORK_ITEM_EDIT_GROUP, (IContributionItem)new GroupMarker(WORK_ITEM_EDIT_EXT_GROUP));
        }
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        IHandlerService handlerService;
        ViewerPane pane;
        super.setActiveEditor(targetEditor);
        this.fRefresh.setEditor(targetEditor);
        this.fRevert.setEditor(targetEditor);
        this.fReferenceWorkItem.setPart((IWorkbenchPart)targetEditor);
        this.fExtractWorkItemAction.setPart((IWorkbenchPart)targetEditor);
        this.fPreviousAnnotation.setPart((IWorkbenchPart)targetEditor);
        this.fNextAnnotation.setPart((IWorkbenchPart)targetEditor);
        this.fWorkItemEditor = targetEditor instanceof WorkItemEditor ? (WorkItemEditor)targetEditor : null;
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null && this.fWorkItemEditor != null) {
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.FIND, this.fWorkItemEditor.getAction("org.eclipse.ui.edit.findReplace"));
        }
        if (this.fPart != null) {
            pane = (ViewerPane)this.fPart.getAdapter(ViewerPane.class);
            if (pane != null && !pane.isDisposed()) {
                pane.removeViewerPaneListener((IViewerPaneListener)this.fInternalListener);
            }
            this.fPart.getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this.fInternalListener);
            this.fPart.removePropertyListener((IPropertyListener)this.fInternalListener);
            handlerService = (IHandlerService)this.fPart.getSite().getService(IHandlerService.class);
            if (handlerService != null) {
                handlerService.deactivateHandlers(this.fActivations);
            }
            this.fActivations.clear();
        }
        this.fPart = targetEditor;
        if (this.fPart != null) {
            pane = (ViewerPane)this.fPart.getAdapter(ViewerPane.class);
            if (pane != null) {
                pane.addViewerPaneListener((IViewerPaneListener)this.fInternalListener);
                this.fPart.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this.fInternalListener);
                this.handleActiveViewerChanged(pane.getActiveViewerPart());
            } else {
                this.handleActiveViewerChanged(null);
            }
            this.fPart.addPropertyListener((IPropertyListener)this.fInternalListener);
            handlerService = (IHandlerService)this.fPart.getSite().getService(IHandlerService.class);
            if (handlerService != null) {
                this.fActivations.add(handlerService.activateHandler("com.ibm.magnolia.edit.referenceworkitem", (IHandler)new ActionHandler((IAction)this.fReferenceWorkItem)));
                this.fActivations.add(handlerService.activateHandler("com.ibm.magnolia.edit.model.query.selection", (IHandler)new ActionHandler((IAction)this.fQuickQuery)));
                this.fActivations.add(handlerService.activateHandler("com.ibm.magnolia.edit.extractworkitem", (IHandler)new ActionHandler((IAction)this.fExtractWorkItemAction)));
            }
        } else {
            this.handleActiveViewerChanged(null);
        }
    }

    public void dispose() {
        if (this.fCommandActions != null) {
            for (CommandAction action : this.fCommandActions) {
                action.dispose();
            }
            this.fCommandActions.clear();
            this.fCommandActions = null;
        }
        this.setActiveEditor(null);
        super.dispose();
    }

    private void handleActiveViewerChanged(ViewerPart viewerPart) {
        this.fViewerPart = viewerPart;
        this.fDeleteLink.setViewerPart(this.fViewerPart);
        this.fDeleteLink.update();
        this.fReferenceWorkItem.update();
        this.fExtractWorkItemAction.update();
    }

    private void handleSelectionChanged(SelectionChangedEvent event) {
        this.fDeleteLink.update();
        this.fExtractWorkItemAction.update();
    }

    private void handleInputChanged() {
        this.fDeleteLink.update();
        this.fReferenceWorkItem.update();
        this.fExtractWorkItemAction.update();
    }

    private void handleDirtyStateChanged() {
        this.fExtractWorkItemAction.update();
    }

    private class FindAllAction
    extends Action {
        public FindAllAction(String text, String tooltip, String cmdId, ImageDescriptor image) {
            this.setText(text);
            this.setToolTipText(tooltip);
            this.setActionDefinitionId(cmdId);
            this.setImageDescriptor(image);
        }

        public void run() {
            if (WorkItemEditorActionBarContributor.this.fWorkItemEditor == null) {
                return;
            }
            IEditorInput editorInput = WorkItemEditorActionBarContributor.this.fWorkItemEditor.getEditorInput();
            if (!(editorInput instanceof WorkItemEditorInput) || !((WorkItemEditorInput)editorInput).isResolved()) {
                return;
            }
            WorkItemWorkingCopy copy = ((WorkItemEditorInput)editorInput).getWorkingCopy();
            InputDialog dialog = new InputDialog(WorkItemEditorActionBarContributor.this.fWorkItemEditor.getSite().getShell(), Messages.WorkItemEditorActionBarContributor_FIND_ALL_TITLE, Messages.WorkItemEditorActionBarContributor_FIND_ALL_MESSAGE, "", null);
            if (dialog.open() != 0) {
                return;
            }
            IWorkItemUIWorkingCopy uiWorkingCopy = (IWorkItemUIWorkingCopy)copy.getAdapter(IWorkItemUIWorkingCopy.class);
            ((WorkItemUIWorkingCopy)uiWorkingCopy).markOccurrences(dialog.getValue(), false, false, true);
        }
    }

    private class InternalListener
    implements IViewerPaneListener,
    ISelectionChangedListener,
    IPropertyListener {
        private InternalListener() {
        }

        public void viewerPartActivated(ViewerPart viewerPart) {
            WorkItemEditorActionBarContributor.this.handleActiveViewerChanged(viewerPart);
        }

        public void viewerPartDeactivated(ViewerPart viewerPart) {
            WorkItemEditorActionBarContributor.this.handleActiveViewerChanged(null);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            WorkItemEditorActionBarContributor.this.handleSelectionChanged(event);
        }

        public void propertyChanged(Object source, int propId) {
            if (propId == 258) {
                WorkItemEditorActionBarContributor.this.handleInputChanged();
            }
            if (propId == 257) {
                WorkItemEditorActionBarContributor.this.handleDirtyStateChanged();
            }
        }
    }

    private class QuickQueryAction
    extends Action {
        public QuickQueryAction(String text, String tooltip, String cmdId, ImageDescriptor image) {
            this.setText(text);
            this.setToolTipText(tooltip);
            this.setActionDefinitionId(cmdId);
            this.setImageDescriptor(image);
        }

        public void run() {
            if (WorkItemEditorActionBarContributor.this.fWorkItemEditor == null) {
                return;
            }
            SourceViewerPane pane = (SourceViewerPane)WorkItemEditorActionBarContributor.this.fWorkItemEditor.getAdapter(SourceViewerPane.class);
            if (pane == null) {
                return;
            }
            ISourceViewer viewer = pane.getLastActiveSourceViewer();
            if (viewer == null) {
                viewer = pane.getFirstVisibleSourceViewer();
            }
            if (viewer == null) {
                return;
            }
            IEditorInput editorInput = WorkItemEditorActionBarContributor.this.fWorkItemEditor.getEditorInput();
            if (!(editorInput instanceof WorkItemEditorInput) || !((WorkItemEditorInput)editorInput).isResolved()) {
                return;
            }
            WorkItemEditorInput input = (WorkItemEditorInput)editorInput;
            ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
            String text = selection.getText();
            if (text == null || text.length() == 0) {
                return;
            }
            IWorkbenchWindow workbenchWindow = WorkItemEditorActionBarContributor.this.fWorkItemEditor.getSite().getWorkbenchWindow();
            if (workbenchWindow == null) {
                return;
            }
            QueriesUI.showQueryResults((IWorkbenchWindow)workbenchWindow, (IProjectAreaHandle)input.getWorkItem().getProjectArea(), (String)text);
        }
    }

    private class RemoveOccurrencesAction
    extends Action {
        public RemoveOccurrencesAction(String text, String tooltip, String cmdId, ImageDescriptor image) {
            this.setText(text);
            this.setToolTipText(tooltip);
            this.setActionDefinitionId(cmdId);
            this.setImageDescriptor(image);
        }

        public void run() {
            if (WorkItemEditorActionBarContributor.this.fWorkItemEditor == null) {
                return;
            }
            IEditorInput editorInput = WorkItemEditorActionBarContributor.this.fWorkItemEditor.getEditorInput();
            if (!(editorInput instanceof WorkItemEditorInput) || !((WorkItemEditorInput)editorInput).isResolved()) {
                return;
            }
            WorkItemWorkingCopy copy = ((WorkItemEditorInput)editorInput).getWorkingCopy();
            IWorkItemUIWorkingCopy uiWorkingCopy = (IWorkItemUIWorkingCopy)copy.getAdapter(IWorkItemUIWorkingCopy.class);
            ((WorkItemUIWorkingCopy)uiWorkingCopy).removeOccurrences();
        }
    }
}

