/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedText;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class URIReferenceDialog
extends Dialog {
    public static final String ADD_URI_REFERENCE = Messages.URIReferenceDialog_ADD_URI_REF;
    private String fTitle;
    private String fURI = "";
    private String fComment = "";
    private DecoratedText fURIText;
    private DecoratedText fCommentText;

    public URIReferenceDialog(Shell parentShell, String title) {
        super(parentShell);
        this.fTitle = title;
    }

    public URI getURI() {
        return URI.create(this.fURI);
    }

    public void setURI(URI uri) {
        this.fURI = uri.toString();
    }

    public String getComment() {
        return this.fComment;
    }

    public void setComment(String comment) {
        this.fComment = comment;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.fTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(container, 0);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        composite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 9;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(Messages.URIReferenceDialog_URI);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fURIText = new DecoratedText(composite, 2052);
        data = new GridData(4, 0x1000000, true, false);
        this.fURIText.getLayoutControl().setLayoutData((Object)data);
        this.fURIText.getText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                URIReferenceDialog.this.fURI = ((String)URIReferenceDialog.this.fURIText.getValue()).trim();
                URIReferenceDialog.this.validateInput();
            }
        });
        this.fURIText.setValue(this.fURI);
        this.fURIText.setSelection((ISelection)new TextSelection(0, this.fURI.length()));
        this.fURIText.getText().setFocus();
        label = new Label(composite, 0);
        label.setText(Messages.URIReferenceDialog_COMMENT);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fCommentText = new DecoratedText(composite, 2052);
        data = new GridData(4, 0x1000000, true, false);
        this.fCommentText.getLayoutControl().setLayoutData((Object)data);
        this.fCommentText.getText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                URIReferenceDialog.this.fComment = ((String)URIReferenceDialog.this.fCommentText.getValue()).trim();
                URIReferenceDialog.this.validateInput();
            }
        });
        this.fCommentText.setValue(this.fComment);
        URIReferenceDialog.applyDialogFont((Control)container);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.validateInput();
    }

    private void validateInput() {
        Button okButton = this.getButton(0);
        if (okButton == null) {
            return;
        }
        IStatus uriStatus = this.getURIStatus();
        if (this.getButtonBar() != null) {
            this.fURIText.setStatus(uriStatus);
        }
        boolean enabled = uriStatus.getSeverity() != 4 && uriStatus.getSeverity() != 8;
        okButton.setEnabled(enabled);
    }

    private IStatus getURIStatus() {
        if (this.fURI.length() == 0) {
            return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.URIReferenceDialog_URI_EMPTY);
        }
        try {
            new URI(this.fURI);
        }
        catch (URISyntaxException uRISyntaxException) {
            return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.URIReferenceDialog_URI_INVALID);
        }
        return Status.OK_STATUS;
    }
}

