/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.collaboration.ui.text.CollaborationPresenceTextDecorator;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.StyledTextViewerMenuListener;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.StyledTextViewerSupport;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContentAssistProposalCategory;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.FavoritesProposalComputer;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.IContentAssistProposalsComputer;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ReferenceInsertionStrategy;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.StyledDocumentInsertionStrategy;
import com.ibm.team.workitem.ide.ui.internal.actions.ExtractWorkItemAction;
import com.ibm.team.workitem.ide.ui.internal.actions.ReferenceWorkItemAction;
import com.ibm.team.workitem.ide.ui.internal.editor.CommentsDocument;
import com.ibm.team.workitem.ide.ui.internal.editor.EmptyCommentAction;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.UserPickerProposalComputer;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditor;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemPickerProposalComputer;
import com.ibm.team.workitem.ide.ui.internal.editor.templates.TemplateProposalComputer;
import com.ibm.team.workitem.rcp.ui.internal.UserProposalComputer;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemHistoryProposalComputer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SourceViewerSupport {
    private StyledTextViewerSupport fStyledDocumentPart = SourceViewerSupport.createStyledTextViewerSupport();

    public SourceViewerSupport(Composite container, boolean useOverviewRuler, boolean useProjectionViewer, Point margin, int style) {
        this.fStyledDocumentPart.setUseOverviewRuler(useOverviewRuler);
        this.fStyledDocumentPart.setUseProjectionViewer(useProjectionViewer);
        this.fStyledDocumentPart.setStyle(style);
        this.fStyledDocumentPart.setMargin(margin);
        this.fStyledDocumentPart.createContent(container);
    }

    public SourceViewer getSourceViewer() {
        return this.fStyledDocumentPart.getSourceViewer();
    }

    public void dispose() {
        this.fStyledDocumentPart.dispose();
    }

    public static StyledTextViewerSupport createStyledTextViewerSupport() {
        StyledTextViewerSupport viewerSupport = new StyledTextViewerSupport();
        viewerSupport.setContentAssistProposalCategories(SourceViewerSupport.createContentAssistProposalCategories());
        viewerSupport.getTextViewerDecorators().add(0, new CollaborationPresenceTextDecorator());
        viewerSupport.setContextMenuListener((IMenuListener)new StyledTextViewerMenuListener(viewerSupport){

            public void menuAboutToShow(IMenuManager manager) {
                IWorkbenchPart part;
                super.menuAboutToShow(manager);
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = window != null ? window.getActivePage() : null;
                IWorkbenchPart iWorkbenchPart = part = page != null ? page.getActivePart() : null;
                if (part != null) {
                    IEditorInput input;
                    manager.add((IAction)new ExtractWorkItemAction(part, (ISourceViewer)this.getViewerSupport().getSourceViewer()));
                    manager.add((IAction)new ReferenceWorkItemAction(part, (ISourceViewer)this.getViewerSupport().getSourceViewer()));
                    if (this.getViewerSupport().getSourceViewer().getDocument() instanceof CommentsDocument && part instanceof WorkItemEditor && (input = ((WorkItemEditor)part).getEditorInput()) instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved() && ((WorkItemEditorInput)input).loggedInContributorCanEmptyComments()) {
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)new EmptyCommentAction(part, (ISourceViewer)this.getViewerSupport().getSourceViewer()));
                    }
                }
            }
        });
        return viewerSupport;
    }

    private static ContentAssistProposalCategory[] createContentAssistProposalCategories() {
        return new ContentAssistProposalCategory[]{new ContentAssistProposalCategory(Messages.SourceViewerSupport_CONTENT_ASSIST_CATEGORY_DEFAULT_LABEL, new IContentAssistProposalsComputer[]{new FavoritesProposalComputer((ReferenceInsertionStrategy)StyledDocumentInsertionStrategy.getInstance()), new WorkItemHistoryProposalComputer((ReferenceInsertionStrategy)StyledDocumentInsertionStrategy.getInstance()), new UserProposalComputer((ReferenceInsertionStrategy)StyledDocumentInsertionStrategy.getInstance(), false)}), new ContentAssistProposalCategory(Messages.SourceViewerSupport_CONTENT_ASSIST_CATEGORY_FAVORITES_LABEL, new IContentAssistProposalsComputer[]{new FavoritesProposalComputer((ReferenceInsertionStrategy)StyledDocumentInsertionStrategy.getInstance())}), new ContentAssistProposalCategory(Messages.SourceViewerSupport_CONTENT_ASSIST_CATEGORY_WORK_ITEM_HISTORY_LABEL, new IContentAssistProposalsComputer[]{new WorkItemHistoryProposalComputer((ReferenceInsertionStrategy)StyledDocumentInsertionStrategy.getInstance()), new WorkItemPickerProposalComputer((ReferenceInsertionStrategy)StyledDocumentInsertionStrategy.getInstance())}), new ContentAssistProposalCategory(Messages.SourceViewerSupport_CONTENT_ASSIST_CATEGORY_USERS_LABEL, new IContentAssistProposalsComputer[]{new UserProposalComputer((ReferenceInsertionStrategy)StyledDocumentInsertionStrategy.getInstance(), false), new UserPickerProposalComputer((ReferenceInsertionStrategy)StyledDocumentInsertionStrategy.getInstance(), false)}), new ContentAssistProposalCategory(Messages.SourceViewerSupport_CONTENT_ASSIST_CATEGORY_TEMPLATES_LABEL, new IContentAssistProposalsComputer[]{new TemplateProposalComputer("context_type_workitem_editor")})};
    }
}

