/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.ui.editor.TeamFormPartContainer;
import com.ibm.team.workitem.common.internal.presentations.AbstractPresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.SectionDescriptor;
import com.ibm.team.workitem.ide.ui.internal.HelpContextIds;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.TeamSashForm;
import com.ibm.team.workitem.ide.ui.internal.editor.TeamSashFormLayout;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorParts;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemTeamFormSectionPart;
import com.ibm.team.workitem.ide.ui.internal.editor.part.DiscussionPart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.HTMLAttributePart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationTab;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormHeadlessSection;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormSectionContainer;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.WorkItemEditorSections;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class OverviewTab
extends PresentationTab {
    public static final String TAB_ID = "com.ibm.team.workitem.ide.ui.editor.page.overview";
    public static final String DETAILS_SLOT = "details";
    private static final String LINKSSUMMARY_SLOT = "linksSummary";
    public static final String QUICKINFO_SLOT = "quickInfo";
    public static final String DESCRIPTION_SLOT = "description";
    public static final String DISCUSSION_SLOT = "discussion";
    public static Map<String, String> SLOTS = new HashMap<String, String>();
    public static List<String> SMALL_SLOTS = new ArrayList<String>();
    private TeamFormSectionContainer fDescriptionSection;
    private WorkItemTeamFormSectionPart fCommentsSection;
    private DiscussionPart fDiscussionPart;

    static {
        SLOTS.put(DETAILS_SLOT, Messages.OverviewTab_DETAILS);
        SLOTS.put(QUICKINFO_SLOT, Messages.OverviewTab_QUICK_INFORMATION);
        SLOTS.put(DESCRIPTION_SLOT, Messages.OverviewTab_DESCRIPTION);
        SLOTS.put(DISCUSSION_SLOT, Messages.OverviewTab_DISCUSSION);
        SMALL_SLOTS.add(DETAILS_SLOT);
        SMALL_SLOTS.add(QUICKINFO_SLOT);
    }

    public OverviewTab() {
        super(TAB_ID, Messages.OverviewTab_OVERVIEW_TAB_TITLE);
    }

    public OverviewTab(String id, String title) {
        super(id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        Assert.isNotNull(this.getPresentations());
        Assert.isNotNull((Object)this.getWorkingCopy());
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        body.setLayout((Layout)new GridLayout(1, false));
        TeamSashForm tab = new TeamSashForm(body, 256);
        tab.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).create());
        managedForm.getToolkit().adapt((Composite)tab);
        TeamSashForm left = new TeamSashForm(tab, 512);
        managedForm.getToolkit().adapt((Composite)left);
        final TeamSashForm right = new TeamSashForm(tab, 512);
        managedForm.getToolkit().adapt((Composite)right);
        SectionDescriptor detailsDesc = null;
        SectionDescriptor linksDesc = null;
        SectionDescriptor descriptionDesc = null;
        SectionDescriptor discussionDesc = null;
        if (this.getPresentations().get(this.getId()) == null) {
            return;
        }
        List<AbstractPresentationDescriptor> sections = this.getPresentations().get(this.getId());
        for (AbstractPresentationDescriptor desc : sections) {
            if (!(desc instanceof SectionDescriptor)) continue;
            SectionDescriptor sd = (SectionDescriptor)desc;
            if (DETAILS_SLOT.equals(sd.getSlot())) {
                detailsDesc = sd;
                continue;
            }
            if (DESCRIPTION_SLOT.equals(sd.getSlot())) {
                descriptionDesc = sd;
                continue;
            }
            if (DISCUSSION_SLOT.equals(sd.getSlot())) {
                discussionDesc = sd;
                continue;
            }
            if (!LINKSSUMMARY_SLOT.equals(sd.getSlot()) && !QUICKINFO_SLOT.equals(sd.getSlot())) continue;
            linksDesc = sd;
        }
        TeamFormSectionContainer detailsSection = null;
        TeamFormHeadlessSection linksSummarySection = null;
        this.fDescriptionSection = null;
        this.fCommentsSection = null;
        this.fDiscussionPart = null;
        if (detailsDesc != null) {
            int style = 256;
            if (detailsDesc.isExpanded()) {
                style |= 0x40;
            }
            if (linksDesc != null) {
                style |= 2;
            }
            detailsSection = WorkItemEditorSections.createSection((WorkItemEditorInput)this.getEditorInput(), this.getPresentations(), detailsDesc, managedForm, left, style);
        }
        if (detailsSection != null) {
            this.addPart((IFormPart)detailsSection.getFormPart(), detailsSection.getLayoutControl());
            detailsSection.getFormPart().setFormInput((Object)this.getEditorInput());
        }
        TeamFormSectionContainer quickInfo = null;
        if (linksDesc != null) {
            linksSummarySection = new TeamFormHeadlessSection(this.getWorkingCopy(), this.getPresentations(), linksDesc);
            quickInfo = new TeamFormSectionContainer((AbstractFormPart)linksSummarySection, TeamFormHeadlessSection.setup((TeamFormPartContainer)linksSummarySection, (IManagedForm)managedForm, (Composite)left));
            this.addPart((IFormPart)linksSummarySection, quickInfo.getLayoutControl());
            linksSummarySection.setFormInput(this.getEditorInput());
        }
        if (descriptionDesc != null) {
            int style = 256;
            if (discussionDesc != null) {
                style |= 2;
            }
            if (descriptionDesc.isExpanded()) {
                style |= 0x40;
            }
            this.fDescriptionSection = WorkItemEditorSections.createSection((WorkItemEditorInput)this.getEditorInput(), this.getPresentations(), descriptionDesc, managedForm, right, style);
        }
        if (this.fDescriptionSection != null) {
            this.addPart((IFormPart)this.fDescriptionSection.getFormPart(), this.fDescriptionSection.getLayoutControl());
            this.fDescriptionSection.getFormPart().setFormInput((Object)this.getEditorInput());
        }
        if (discussionDesc != null) {
            ArrayList<TeamFormPart> parts = new ArrayList<TeamFormPart>();
            List<AbstractPresentationDescriptor> descriptors = this.getPresentations().get(discussionDesc.getElementId());
            if (descriptors != null && !descriptors.isEmpty()) {
                for (AbstractPresentationDescriptor d : descriptors) {
                    TeamFormPart part = WorkItemEditorParts.createPart(this.getWorkingCopy(), d);
                    if (part == null) continue;
                    parts.add(part);
                }
            }
            if (parts.size() > 0) {
                for (TeamFormPart part : parts) {
                    if (!(part instanceof DiscussionPart)) continue;
                    this.fDiscussionPart = (DiscussionPart)part;
                    break;
                }
                int style = 8448;
                if (descriptionDesc != null) {
                    style |= 2;
                }
                if (discussionDesc.isExpanded()) {
                    style |= 0x40;
                }
                this.fCommentsSection = new WorkItemTeamFormSectionPart(managedForm, right, style, discussionDesc.getTitle(), parts.toArray(new TeamFormPart[parts.size()]));
            }
        }
        if (this.fCommentsSection != null) {
            this.addPart((SectionPart)this.fCommentsSection);
            this.fCommentsSection.setFormInput(this.getEditorInput());
        }
        if (this.fDiscussionPart != null) {
            right.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    if (OverviewTab.this.fCommentsSection.getSection() == e.getSource()) {
                        OverviewTab.this.fDiscussionPart.updateSectionHeaderLink();
                    }
                }
            });
        }
        if (this.fDiscussionPart != null) {
            IWorkItemUIWorkingCopy uiCopy = (IWorkItemUIWorkingCopy)this.getWorkingCopy().getAdapter(IWorkItemUIWorkingCopy.class);
            if (this.getWorkingCopy().getWorkItem().getComments().getContents().length == 0 && uiCopy.getNewComment().getLength() == 0) {
                if (this.fDescriptionSection != null) {
                    this.fCommentsSection.getSection().setExpanded(false);
                }
            } else if (uiCopy.getNewComment().getLength() > 0) {
                this.fDiscussionPart.revealNewComment();
            }
        }
        if (detailsSection == null && linksSummarySection == null) {
            left.dispose();
        } else if (detailsSection != null && linksSummarySection != null) {
            int[] weights = new int[2];
            if (Util.isFixedHeight(detailsSection)) {
                weights[0] = -1;
                left.setSashEnabled(false);
            } else {
                weights[0] = Util.guessWeight(detailsSection);
            }
            if (Util.isFixedHeight(quickInfo)) {
                weights[1] = -1;
                left.setSashEnabled(false);
            } else {
                weights[1] = Util.guessWeight(quickInfo);
            }
            left.setWeights(weights);
        } else {
            left.setWeights(new int[]{1});
        }
        if (this.fDescriptionSection == null && this.fCommentsSection == null) {
            right.dispose();
        } else if (this.fDescriptionSection != null && this.fCommentsSection != null) {
            int[] weights = new int[2];
            weights[0] = Util.isFixedHeight(this.fDescriptionSection) ? -1 : Util.guessWeight(this.fDescriptionSection);
            TeamFormSectionContainer comments = new TeamFormSectionContainer((AbstractFormPart)this.fCommentsSection, (Control)this.fCommentsSection.getSection());
            weights[1] = Util.isFixedHeight(comments) ? -1 : Util.guessWeight(comments);
            right.setWeights(weights);
            right.setLayout(new TeamSashFormLayout(){
                private boolean fUpdateWeights = true;

                protected void layout(Composite composite, boolean flushCache) {
                    Rectangle clientArea = composite.getClientArea();
                    if (this.fUpdateWeights && clientArea.width > 1 && clientArea.height > 1) {
                        this.fUpdateWeights = false;
                        if (OverviewTab.this.fDescriptionSection.getFormPart() instanceof WorkItemTeamFormSectionPart && ((WorkItemTeamFormSectionPart)OverviewTab.this.fDescriptionSection.getFormPart()).getParts().length == 1 && ((WorkItemTeamFormSectionPart)OverviewTab.this.fDescriptionSection.getFormPart()).getParts()[0] instanceof HTMLAttributePart) {
                            HTMLAttributePart part = (HTMLAttributePart)((WorkItemTeamFormSectionPart)OverviewTab.this.fDescriptionSection.getFormPart()).getParts()[0];
                            Control changed = part.setMinHints(false);
                            composite.changed(new Control[]{changed});
                            int descHeight = ((OverviewTab)OverviewTab.this).fDescriptionSection.getLayoutControl().computeSize((int)clientArea.width, (int)-1, (boolean)false).y;
                            changed = part.setMinHints(true);
                            composite.changed(new Control[]{changed});
                            if (descHeight > 0) {
                                TeamSashForm sashForm = (TeamSashForm)composite;
                                Sash[] sashes = sashForm.sashes;
                                int sashwidth = sashes.length > 0 ? sashForm.SASH_WIDTH + sashes[0].getBorderWidth() * 2 : sashForm.SASH_WIDTH;
                                int available = clientArea.height - (sashwidth + 2 * sashForm.SPACING);
                                if (available > 0) {
                                    int descWeight = (descHeight + 2) * 10000 / available;
                                    descWeight = Math.min(descWeight, 3000);
                                    right.updateWeights(new int[]{descWeight, 10000 - descWeight});
                                }
                            }
                        }
                    }
                    super.layout(composite, flushCache);
                }
            });
        } else {
            right.setWeights(new int[]{1});
        }
        if (!left.isDisposed() && !right.isDisposed()) {
            tab.setWeights(new int[]{-1, 1});
        } else if (!left.isDisposed() || !right.isDisposed()) {
            tab.setWeights(new int[]{1});
        }
        HelpContextIds.hookHelpListener((Control)form, "com.ibm.team.workitem.ide.ui.work_item_editor_overview_page");
    }

    public void setFocus() {
        if (this.getLastActivePart() != null) {
            this.getLastActivePart().setFocus();
        } else if (this.fDescriptionSection != null) {
            this.fDescriptionSection.getFormPart().setFocus();
        }
    }

    public void dispose() {
        this.fDescriptionSection = null;
        this.fCommentsSection = null;
        this.fDiscussionPart = null;
        super.dispose();
    }
}

