/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.foundation.client.internal.util.ClientURIUtils;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.core.hyperlinks.StandardContextProvider;
import com.ibm.team.jface.viewerutilities.SelectionProvider;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectLink;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.model.ItemHandle;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.WorkItemOperation;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.ArtifactLink;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.calm.AbstractServiceDocument;
import com.ibm.team.workitem.common.calm.CALMLinkType;
import com.ibm.team.workitem.common.calm.PickerDescription;
import com.ibm.team.workitem.common.internal.util.Utils;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.IAttachmentHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.URIReferenceDialog;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.calm.RESTHelper;
import com.ibm.team.workitem.ide.ui.internal.editor.calm.RemoteItemDialog;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.wizards.LinkWorkItemOperation;
import com.ibm.team.workitem.rcp.ui.workitempicker.WorkItemSelectionDialog;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IInputSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.IUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkHelper {
    public static IReference createReference(Object object) throws TeamRepositoryException {
        IResource resource;
        IAdaptable adaptable;
        IItemHandle handle;
        if (object instanceof URIReference) {
            URIReference reference = (URIReference)object;
            ITeamRepository linkRepo = ClientURIUtils.findTeamRepository((URI)reference.getURI());
            if (linkRepo != null) {
                try {
                    Location location = Location.location((URI)reference.getURI());
                    IItemHandle itemHandle = location.getItemHandle();
                    if (itemHandle != null) {
                        ((ItemHandle)itemHandle).setOrigin((Object)linkRepo);
                        return IReferenceFactory.INSTANCE.createReferenceToItem(itemHandle, reference.getName());
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (TeamRepositoryException teamRepositoryException) {}
            }
            return IReferenceFactory.INSTANCE.createReferenceFromURI(reference.getURI(), reference.getName());
        }
        if (object instanceof IAuditableHandle) {
            return LinkHelper.createReference((IAuditableHandle)object);
        }
        if (object instanceof IReference) {
            return ((IReference)object).makeClone();
        }
        if (object instanceof IAdaptable && (handle = (IItemHandle)(adaptable = (IAdaptable)object).getAdapter(IItemHandle.class)) instanceof IAuditableHandle) {
            return LinkHelper.createReference((IAuditableHandle)handle);
        }
        if (object instanceof File && ((File)object).isFile()) {
            return IReferenceFactory.INSTANCE.createReferenceFromURI(((File)object).toURI(), ((File)object).getName());
        }
        IFile file = null;
        if (object instanceof IFile) {
            file = (IFile)object;
        } else if (object instanceof IAdaptable && (resource = (IResource)((IAdaptable)object).getAdapter(IResource.class)) instanceof IFile) {
            file = (IFile)resource;
        }
        if (file != null) {
            return IReferenceFactory.INSTANCE.createReferenceFromURI(file.getLocationURI(), file.getName());
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object convertURIReferenceToItemHandle(Object obj, ITeamRepository repository) {
        if (obj instanceof IReference && ((IReference)obj).isURIReference()) {
            IURIReference uriRef = (IURIReference)obj;
            try {
                IItemHandle itemHandle = Location.location((URI)uriRef.getURI()).getItemHandle();
                if (itemHandle == null) return obj;
                ((ItemHandle)itemHandle).setOrigin((Object)repository);
                return itemHandle;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return obj;
            }
            catch (IllegalStateException illegalStateException) {
                return obj;
            }
            catch (TeamRepositoryException teamRepositoryException) {
                return obj;
            }
        }
        if (!(obj instanceof URIReference)) return obj;
        URIReference uriRef = (URIReference)obj;
        try {
            IItemHandle itemHandle = Location.location((URI)uriRef.getURI()).getItemHandle();
            if (itemHandle == null) return obj;
            ((ItemHandle)itemHandle).setOrigin((Object)repository);
            return itemHandle;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return obj;
        }
        catch (IllegalStateException illegalStateException) {
            return obj;
        }
        catch (TeamRepositoryException teamRepositoryException) {
            return obj;
        }
    }

    public static IReference createReference(IAuditableHandle handle) throws TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)handle.getOrigin();
        ILinkManager linkManager = (ILinkManager)teamRepository.getClientLibrary(ILinkManager.class);
        if (handle instanceof IWorkItemHandle) {
            IAuditableClient auditableClient = (IAuditableClient)((ITeamRepository)handle.getOrigin()).getClientLibrary(IAuditableClient.class);
            IWorkItem workItem = (IWorkItem)auditableClient.resolveAuditable(handle, IWorkItem.SMALL_PROFILE, null);
            return WorkItemLinkTypes.createWorkItemReference((IWorkItem)workItem);
        }
        if (handle instanceof IAttachmentHandle) {
            IAuditableClient auditableClient = (IAuditableClient)((ITeamRepository)handle.getOrigin()).getClientLibrary(IAuditableClient.class);
            IAttachment attachment = (IAttachment)auditableClient.resolveAuditable(handle, IAttachment.SMALL_PROFILE, null);
            return WorkItemLinkTypes.createAttachmentReference((IAttachment)attachment);
        }
        return linkManager.referenceFactory().createReferenceToItem((IItemHandle)handle);
    }

    public static void openReferences(final ITeamRepository teamRepository, final List<IReference> references) {
        FoundationJob job = new FoundationJob(Messages.LinkHelper_OPENING_REFERENCES){

            protected IStatus runProtected(IProgressMonitor monitor) {
                ArrayList<URI> uris = new ArrayList<URI>();
                URI context = null;
                for (IReference reference : references) {
                    URI uri;
                    if (context == null) {
                        context = Location.itemLocation((IItemHandle)reference.getLink(), (String)teamRepository.getRepositoryURI()).toAbsoluteUri();
                    }
                    if ((uri = ClientUtils.createURI((String)teamRepository.getRepositoryURI(), (IReference)reference)) == null) continue;
                    uris.add(uri);
                }
                return Hyperlinks.open(uris, (ContextProvider)new StandardContextProvider(null, new URIReference("context", "", context)), (IProgressMonitor)monitor);
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public static void openArtifact(ArtifactLink artifactLink) {
        IReference reference = artifactLink.getReference();
        ILink link = reference.getLink();
        if (link != null && link.getOrigin() instanceof ITeamRepository) {
            ArrayList<IReference> references = new ArrayList<IReference>();
            references.add(reference);
            LinkHelper.openReferences((ITeamRepository)link.getOrigin(), references);
        }
    }

    private static void addWorkItemReference(final IWorkbenchPage page, IEndPointDescriptor type, final WorkItemWorkingCopy input) throws TeamRepositoryException {
        IWorkItemReferences references = input.getReferences();
        Action preCreationAction = new Action(){

            public void runWithEvent(Event event) {
                if (input.getWorkItem().isNewItem()) {
                    event.doit &= MessageDialog.openConfirm((Shell)((Control)event.widget).getShell(), (String)Messages.LinkHelper_SAVE_WORK_ITEM_TITLE, (String)Messages.LinkHelper_SAVE_WORK_ITEM_QUESTION);
                }
            }
        };
        Runnable preCreationRunnable = new Runnable(){

            public void run() {
                IEditorPart editorPart;
                boolean ok;
                if (input.getWorkItem().isNewItem() && !(ok = Util.saveNewWorkItem(editorPart = WorkItemUI.openEditor((IWorkbenchPage)page, (Object)input.getWorkItem()), input))) {
                    throw new OperationCanceledException();
                }
            }
        };
        ILinkType linkType = type.getLinkType();
        IEndPointDescriptor opposite = type == linkType.getTargetEndPointDescriptor() ? linkType.getSourceEndPointDescriptor() : linkType.getTargetEndPointDescriptor();
        LinkWorkItemOperation postSaveOperation = LinkWorkItemOperation.create((IEndPointDescriptor)opposite, Collections.singletonList((IWorkItemHandle)input.getWorkItem().getItemHandle()), (boolean)false);
        if (type.isMultiValued()) {
            WorkItemSelectionDialog dialog = new WorkItemSelectionDialog(page.getWorkbenchWindow().getShell(), input.getWorkItem().getProjectArea(), true);
            dialog.setExcluded(new IWorkItemHandle[]{input.getWorkItem()});
            dialog.setPreCreationAction((IAction)preCreationAction);
            dialog.setPreCreationRunnable(preCreationRunnable);
            dialog.setPostCreationOperation((WorkItemOperation)postSaveOperation);
            IWorkItemHandle[] handles = dialog.getMultipleWorkItems();
            if (handles == null || handles.length == 0) {
                return;
            }
            int i = 0;
            while (i < handles.length) {
                ArrayList list = new ArrayList();
                if (!WorkItemLinkTypes.isSymmetric((IEndPointDescriptor)type)) {
                    list.addAll(references.getReferences(type));
                } else {
                    list.addAll(references.getReferences(linkType.getSourceEndPointDescriptor()));
                    list.addAll(references.getReferences(linkType.getTargetEndPointDescriptor()));
                }
                IReference newReference = LinkHelper.createReference((IAuditableHandle)handles[i]);
                boolean found = false;
                for (IReference reference : list) {
                    if (!reference.sameDetailsExcludingCommentAs(newReference)) continue;
                    found = true;
                }
                if (!found) {
                    references.add(type, newReference);
                }
                ++i;
            }
        } else {
            WorkItemSelectionDialog dialog = new WorkItemSelectionDialog(page.getWorkbenchWindow().getShell(), input.getWorkItem().getProjectArea(), false);
            dialog.setExcluded(new IWorkItemHandle[]{input.getWorkItem()});
            dialog.setPreCreationAction((IAction)preCreationAction);
            dialog.setPreCreationRunnable(preCreationRunnable);
            dialog.setPostCreationOperation((WorkItemOperation)postSaveOperation);
            IWorkItemHandle handle = dialog.getSingleWorkItem();
            if (handle == null) {
                return;
            }
            references.set(type, LinkHelper.createReference((IAuditableHandle)handle));
        }
    }

    private static void addURIReference(IEndPointDescriptor type, WorkItemWorkingCopy input, Shell shell) throws TeamRepositoryException {
        URIReferenceDialog dialog = new URIReferenceDialog(shell, URIReferenceDialog.ADD_URI_REFERENCE);
        if (dialog.open() == 0) {
            IWorkItemReferences references = input.getReferences();
            IURIReference reference = IReferenceFactory.INSTANCE.createReferenceFromURI(dialog.getURI(), dialog.getComment());
            references.add(type, (IReference)reference);
        }
    }

    private static PickerDescription evaluatePickerDescription(final WorkItemWorkingCopy input, final CALMLinkType calmLink, final IProjectLink projectLink, IWorkbenchWindow window, String linkName) {
        final PickerDescription[] pickerDescriptions = new PickerDescription[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        ITeamRepository repository = input.getTeamRepository();
                        String targetServicesUrl = projectLink.getTargetServicesUrl();
                        if (targetServicesUrl == null) {
                            throw new TeamRepositoryException(MessageFormat.format(Messages.LinkHelper_ERROR_NO_LINK_SERVICE, projectLink.getLabel()));
                        }
                        String errorMessage = MessageFormat.format(Messages.LinkHelper_ERROR_READING_SERVICE_DOC, targetServicesUrl);
                        String content = RESTHelper.performGet(targetServicesUrl, HttpUtil.MediaType.XML.toString(), errorMessage, repository, monitor);
                        AbstractServiceDocument serviceDocument = calmLink.getServiceDocument(content);
                        if (serviceDocument != null) {
                            pickerDescriptions[0] = serviceDocument.getPickerDescription(calmLink);
                        }
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            window.run(true, true, runnable);
            PickerDescription result = pickerDescriptions[0];
            if (result != null) {
                return result;
            }
            MessageDialog.openInformation((Shell)window.getShell(), (String)Messages.LinkHelper_ERROR_TITLE, (String)MessageFormat.format(Messages.LinkHelper_NO_PICKER_PROVIDED, projectLink.getLabel(), linkName));
        }
        catch (InvocationTargetException e) {
            String message = Messages.LinkHelper_ERROR_ACCESSING_PICKER_DIALOG;
            Status status = new Status(4, "com.ibm.team.workitem.ide.ui", 4, message, e.getTargetException());
            ErrorDialog.openError((Shell)window.getShell(), (String)Messages.LinkHelper_ERROR_TITLE, (String)message, (IStatus)status);
            WorkItemIDEUIPlugin.getDefault().log((IStatus)status);
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    private static boolean addCALMReference(IEndPointDescriptor type, WorkItemWorkingCopy input, IProjectLink projectLink, IWorkbenchWindow window) throws TeamRepositoryException {
        CALMLinkType calmLink = CALMLinkType.getCALMLink((ILinkType)type.getLinkType());
        if (calmLink == null) {
            return false;
        }
        PickerDescription pickerDescription = LinkHelper.evaluatePickerDescription(input, calmLink, projectLink, window, type.getDisplayName());
        if (pickerDescription == null) {
            return false;
        }
        RemoteItemDialog dialog = new RemoteItemDialog(window.getShell(), pickerDescription);
        if (dialog.open() == 0) {
            IWorkItemReferences references = input.getReferences();
            Collection<RemoteItemDialog.RemoteItem> items = dialog.getItems();
            for (RemoteItemDialog.RemoteItem item : items) {
                IURIReference reference = IReferenceFactory.INSTANCE.createReferenceFromURI(item.getURI(), item.getComment());
                List existingReferences = references.getReferences(type);
                for (IReference existingRef : existingReferences) {
                    if (!item.getURI().equals(existingRef.createURI())) continue;
                    references.remove(existingRef);
                }
                references.add(type, (IReference)reference);
            }
        }
        return true;
    }

    public static void addSelectionActions(IWorkbenchPage page, IMenuManager manager, IInputSelectionProvider inputProvider) {
        DeleteLinkAction delete;
        AddLinkAction add;
        if (inputProvider.getSelection().isEmpty()) {
            LinkHelper.addEmptySelectionActions(page, manager, (WorkItemWorkingCopy)inputProvider.getInput());
            return;
        }
        OpenLinkAction open = new OpenLinkAction(inputProvider);
        if (open.isEnabled()) {
            manager.add((IAction)open);
        }
        manager.add((IContributionItem)new Separator());
        IEndPointDescriptor descriptor = LinkHelper.findReferenceType(inputProvider.getSelection());
        if (descriptor != null && (add = new AddLinkAction(page, inputProvider, String.valueOf(LinkHelper.getSelectionOperationLabel(descriptor)) + "...")).isEnabled()) {
            manager.add((IAction)add);
        }
        if ((delete = new DeleteLinkAction(inputProvider)).isEnabled()) {
            manager.add((IAction)delete);
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private static List<IProjectLink> getProjectLinks(WorkItemWorkingCopy workingCopy) {
        List projectLinks;
        if (!LinkHelper.canModifyCalmLinks(workingCopy)) {
            return null;
        }
        ITeamRepository repository = workingCopy.getTeamRepository();
        IAuditableClient auditableClient = (IAuditableClient)repository.getClientLibrary(IAuditableClient.class);
        ItemProfile profile = ItemProfile.createProfile((IItemType)IProjectArea.ITEM_TYPE, (String[])new String[]{ProcessCommon.getPropertyName(IProjectArea.class, (String)"projectLinks")});
        IProjectArea projectArea = (IProjectArea)auditableClient.findCachedAuditable((IAuditableHandle)workingCopy.getWorkItem().getProjectArea(), profile);
        if (projectArea != null && !(projectLinks = auditableClient.findCachedAuditables(Arrays.asList(projectArea.getProjectLinks()), ItemProfile.createFullProfile((IItemType)IProjectLink.ITEM_TYPE))).isEmpty()) {
            return projectLinks;
        }
        return null;
    }

    public static boolean canModifyCalmLinks(WorkItemWorkingCopy workingCopy) {
        ITeamRepository repository = workingCopy.getTeamRepository();
        IWorkItemClient workItemClient = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
        return workItemClient != null && workItemClient.areAdditionalSaveParametersSupported(null);
    }

    public static void addEmptySelectionActions(IWorkbenchPage page, IMenuManager manager, WorkItemWorkingCopy workingCopy) {
        ILinkType lastType = null;
        ArrayList<IEndPointDescriptor> descriptors = new ArrayList<IEndPointDescriptor>();
        for (IEndPointDescriptor descriptor : Utils.getSortedWriteableDescriptors()) {
            String operation;
            AddLinkAction add;
            ILinkType linkType = descriptor.getLinkType();
            IEndPointDescriptor target = linkType.getTargetEndPointDescriptor();
            IEndPointDescriptor source = linkType.getSourceEndPointDescriptor();
            if (WorkItemLinkTypes.isSymmetric((ILinkType)linkType) && (descriptors.contains(target) || descriptors.contains(source)) || !(add = new AddLinkAction(page, workingCopy, descriptor, operation = LinkHelper.getEmptySelectionOperationLabel(descriptor), null)).isEnabled()) continue;
            descriptors.add(descriptor);
            if (lastType != null && lastType != linkType) {
                manager.add((IContributionItem)new Separator());
            }
            lastType = linkType;
            manager.add((IAction)add);
        }
        List<IProjectLink> projectLinks = LinkHelper.getProjectLinks(workingCopy);
        if (projectLinks != null && !projectLinks.isEmpty()) {
            for (IProjectLink projectLink : projectLinks) {
                List endPointDescriptors = CALMLinkType.getCALMEndPointDescriptors((IProjectLink)projectLink);
                for (IEndPointDescriptor descriptor : endPointDescriptors) {
                    ILinkType linkType = descriptor.getLinkType();
                    String operation = MessageFormat.format(Messages.LinkHelper_COMPOSED_LINK_ACTION_NAME, LinkHelper.getEmptySelectionOperationLabel(descriptor), projectLink.getLabel());
                    AddLinkAction add = new AddLinkAction(page, workingCopy, descriptor, operation, projectLink);
                    if (!add.isEnabled()) continue;
                    if (lastType != null && lastType != linkType) {
                        manager.add((IContributionItem)new Separator());
                    }
                    lastType = linkType;
                    manager.add((IAction)add);
                }
            }
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private static String getEmptySelectionOperationLabel(IEndPointDescriptor descriptor) {
        if (WorkItemEndPoints.DUPLICATE_OF_WORK_ITEM.equals(descriptor)) {
            return NLS.bind((String)Messages.LinkHelper_MAKE_OPERATION, (Object)descriptor.getDisplayName(), (Object[])new Object[0]);
        }
        if (descriptor.isSingleValued()) {
            return NLS.bind((String)Messages.LinkHelper_SET_OPERATION, (Object)descriptor.getDisplayName(), (Object[])new Object[0]);
        }
        return NLS.bind((String)Messages.LinkHelper_ADD_OPERATION, (Object)descriptor.getDisplayName(), (Object[])new Object[0]);
    }

    public static void addDropActions(IMenuManager manager, WorkItemWorkingCopy workingCopy, List<?> elements) {
        ILinkType lastType = null;
        for (IEndPointDescriptor descriptor : LinkHelper.getTargetTypes(elements, Utils.getSortedWriteableDescriptors(), workingCopy)) {
            String operation;
            AddLinkToEndPointAction addLinkAction;
            if (descriptor.isSingleValued() && elements.size() > 1 || !(addLinkAction = new AddLinkToEndPointAction(workingCopy, descriptor, operation = LinkHelper.getDropOperationLabel(descriptor), elements)).isEnabled()) continue;
            ILinkType linkType = descriptor.getLinkType();
            if (lastType != null && lastType != linkType) {
                manager.add((IContributionItem)new Separator());
            }
            lastType = linkType;
            manager.add((IAction)addLinkAction);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new Action(Messages.LinkHelper_CANCEL){

            public void run() {
            }
        });
        manager.add((IContributionItem)new Separator("additions"));
    }

    private static String getDropOperationLabel(IEndPointDescriptor descriptor) {
        if (descriptor.isSingleValued()) {
            return NLS.bind((String)Messages.LinkHelper_SET_AS_OPERATION, (Object)descriptor.getDisplayName(), (Object[])new Object[0]);
        }
        return NLS.bind((String)Messages.LinkHelper_ADD_AS_OPERATION, (Object)descriptor.getDisplayName(), (Object[])new Object[0]);
    }

    private static String getSelectionOperationLabel(IEndPointDescriptor descriptor) {
        if (descriptor.isSingleValued()) {
            return Messages.LinkHelper_REPLACE;
        }
        return Messages.LinkHelper_ADD;
    }

    private static IEndPointDescriptor findReferenceType(ISelection selection) {
        if (selection.isEmpty()) {
            return null;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        if (structuredSelection.size() != 1) {
            return null;
        }
        Object element = structuredSelection.getFirstElement();
        if (element instanceof IEndPointDescriptor) {
            return (IEndPointDescriptor)element;
        }
        return null;
    }

    public static List<IEndPointDescriptor> getTargetTypes(List<?> elements, List<IEndPointDescriptor> available, WorkItemWorkingCopy workingCopy) {
        ArrayList<IEndPointDescriptor> result = new ArrayList<IEndPointDescriptor>();
        for (IEndPointDescriptor descriptor : available) {
            ILinkType linkType;
            IEndPointDescriptor opposite;
            if (!descriptor.isMultiValued() && elements.size() > 1 || !WorkItemLinkTypes.isUserWritable((IEndPointDescriptor)descriptor) || (opposite = (linkType = descriptor.getLinkType()).getSourceEndPointDescriptor() == descriptor ? linkType.getTargetEndPointDescriptor() : linkType.getSourceEndPointDescriptor()).getReferencedItemType() != IWorkItem.ITEM_TYPE || WorkItemLinkTypes.isSymmetric((IEndPointDescriptor)descriptor) && result.contains(opposite)) continue;
            boolean conform = true;
            boolean someNew = false;
            List existing = workingCopy.getReferences().getReferences(descriptor);
            for (Object element : elements) {
                if (!(descriptor.getReferencedItemType() == null || element instanceof IItemHandle && descriptor.getReferencedItemType() == ((IItemHandle)element).getItemType())) {
                    conform = false;
                    break;
                }
                boolean found = false;
                for (IReference reference : existing) {
                    if (element instanceof IItemHandle) {
                        IItemHandle exist = LinkHelper.findItemHandle(reference);
                        if (exist == null || !exist.sameItemId((IItemHandle)element)) continue;
                        found = true;
                        break;
                    }
                    if (!(element instanceof URIReference) || !reference.isURIReference() || !((URIReference)element).getURI().equals(((IURIReference)reference).getURI())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                someNew = true;
            }
            if (!conform || !someNew) continue;
            result.add(descriptor);
        }
        return result;
    }

    public static IItemHandle findItemHandle(Object obj) {
        if (obj instanceof IItemHandle) {
            return (IItemHandle)obj;
        }
        if (obj instanceof IReference) {
            IReference reference = (IReference)obj;
            if (reference.isItemReference()) {
                return ((IItemReference)reference).getReferencedItem();
            }
            if (reference.isURIReference()) {
                try {
                    IItemHandle handle = Location.location((URI)((IURIReference)obj).getURI()).getItemHandle();
                    ITeamRepository linkRepo = ClientURIUtils.findTeamRepository((URI)((IURIReference)obj).getURI());
                    if (handle != null && linkRepo != null) {
                        ((ItemHandle)handle).setOrigin((Object)linkRepo);
                        return handle;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (TeamRepositoryException teamRepositoryException) {}
                return null;
            }
        }
        if (obj instanceof URIReference) {
            try {
                IItemHandle handle = Location.location((URI)((URIReference)obj).getURI()).getItemHandle();
                ITeamRepository linkRepo = ClientURIUtils.findTeamRepository((URI)((IURIReference)obj).getURI());
                if (handle != null && linkRepo != null) {
                    ((ItemHandle)handle).setOrigin((Object)linkRepo);
                    return handle;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (TeamRepositoryException teamRepositoryException) {}
            return null;
        }
        if (obj instanceof IAdaptable) {
            return (IItemHandle)((IAdaptable)obj).getAdapter(IItemHandle.class);
        }
        return null;
    }

    public static class AddLinkAction
    extends Action {
        private IWorkbenchPage fPage;
        private WorkItemWorkingCopy fWorkingCopy;
        private IEndPointDescriptor fType;
        private IProjectLink fProjectLink;

        public AddLinkAction(IWorkbenchPage page, IInputSelectionProvider inputProvider, String text) {
            this(page, (WorkItemWorkingCopy)inputProvider.getInput(), LinkHelper.findReferenceType(inputProvider.getSelection()), text, null);
        }

        public AddLinkAction(IWorkbenchPage page, WorkItemWorkingCopy workingCopy, IEndPointDescriptor type) {
            this(page, workingCopy, type, String.valueOf(type.getDisplayName()) + "...", null);
        }

        public AddLinkAction(IWorkbenchPage page, WorkItemWorkingCopy workingCopy, IEndPointDescriptor type, String text, IProjectLink projectLink) {
            this.fPage = page;
            this.fWorkingCopy = workingCopy;
            this.fType = type;
            this.fProjectLink = projectLink;
            this.setText(text);
            if (type != null && type.getIcon() != null) {
                this.setImageDescriptor(WorkItemUI.getImageDescriptor((URL)type.getIcon()));
            }
            this.setEnabled(this.canRun());
        }

        private boolean isCalmLink() {
            return this.fProjectLink != null;
        }

        private boolean canRun() {
            IEndPointDescriptor otherEndPoint;
            if (this.fType == null) {
                return false;
            }
            if (this.isCalmLink()) {
                return true;
            }
            if (!WorkItemLinkTypes.isUserWritable((IEndPointDescriptor)this.fType)) {
                return false;
            }
            IEndPointDescriptor sourceEndPoint = this.fType.getLinkType().getSourceEndPointDescriptor();
            IEndPointDescriptor targetEndPoint = this.fType.getLinkType().getTargetEndPointDescriptor();
            IEndPointDescriptor iEndPointDescriptor = otherEndPoint = this.fType == sourceEndPoint ? targetEndPoint : sourceEndPoint;
            if (otherEndPoint.getReferencedItemType() == IWorkItem.ITEM_TYPE && this.fType.getReferencedItemType() == null) {
                return true;
            }
            return sourceEndPoint.getReferencedItemType() == IWorkItem.ITEM_TYPE && targetEndPoint.getReferencedItemType() == IWorkItem.ITEM_TYPE;
        }

        public void run() {
            if (!this.canRun()) {
                return;
            }
            try {
                IItemType itemType = this.fType.getReferencedItemType();
                if (itemType == IWorkItem.ITEM_TYPE) {
                    LinkHelper.addWorkItemReference(this.fPage, this.fType, this.fWorkingCopy);
                } else if (this.isCalmLink()) {
                    LinkHelper.addCALMReference(this.fType, this.fWorkingCopy, this.fProjectLink, this.fPage.getWorkbenchWindow());
                } else if (itemType == null) {
                    LinkHelper.addURIReference(this.fType, this.fWorkingCopy, this.fPage.getWorkbenchWindow().getShell());
                }
            }
            catch (TeamRepositoryException x) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.LinkHelper_EXCEPTION_CREATING_LINK, x);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddLinkToEndPointAction
    extends Action {
        private IEndPointDescriptor fType;
        private WorkItemWorkingCopy fWorkingCopy;
        private List<?> fElements;

        public AddLinkToEndPointAction(WorkItemWorkingCopy workingCopy, IEndPointDescriptor type, String text, Object element) {
            this(workingCopy, type, text, Collections.singletonList(element));
        }

        public AddLinkToEndPointAction(WorkItemWorkingCopy workingCopy, IEndPointDescriptor type, String text, List<?> elements) {
            this.fWorkingCopy = workingCopy;
            this.fType = type;
            this.fElements = elements;
            this.setText(text);
            if (type.getIcon() != null) {
                this.setImageDescriptor(WorkItemUI.getImageDescriptor((URL)type.getIcon()));
            }
            this.setEnabled(this.canRun());
        }

        private boolean canRun() {
            return this.fType != null && (WorkItemLinkTypes.isUserWritable((IEndPointDescriptor)this.fType) || CALMLinkType.isCalmLinkWithPicker((IEndPointDescriptor)this.fType));
        }

        public void run() {
            block14: {
                if (!this.canRun()) {
                    return;
                }
                try {
                    ITeamRepository teamRepository = this.fWorkingCopy.getTeamRepository();
                    IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                    ArrayList<IReference> newReferences = new ArrayList<IReference>();
                    for (Object element : this.fElements) {
                        IReference reference = LinkHelper.createReference(element);
                        if (reference == null) continue;
                        newReferences.add(reference);
                    }
                    if (newReferences.isEmpty()) {
                        return;
                    }
                    IWorkItemReferences references = this.fWorkingCopy.getReferences();
                    if (this.fType.isMultiValued()) {
                        ArrayList list = new ArrayList();
                        if (!WorkItemLinkTypes.isSymmetric((IEndPointDescriptor)this.fType)) {
                            list.addAll(references.getReferences(this.fType));
                        } else {
                            ILinkType linkType = this.fType.getLinkType();
                            list.addAll(references.getReferences(linkType.getSourceEndPointDescriptor()));
                            list.addAll(references.getReferences(linkType.getTargetEndPointDescriptor()));
                        }
                        Iterator iter = newReferences.iterator();
                        block6: while (iter.hasNext()) {
                            IReference reference = (IReference)iter.next();
                            for (IReference ref : list) {
                                if (!ref.sameDetailsExcludingCommentAs(reference)) continue;
                                iter.remove();
                                continue block6;
                            }
                        }
                        if (newReferences.isEmpty()) break block14;
                        try {
                            workItemClient.getWorkItemWorkingCopyManager().beginCompoundWorkItemChange((IWorkItemHandle)this.fWorkingCopy.getWorkItem());
                            for (IReference reference : newReferences) {
                                references.add(this.fType, reference);
                            }
                            break block14;
                        }
                        finally {
                            workItemClient.getWorkItemWorkingCopyManager().endCompoundWorkItemChange((IWorkItemHandle)this.fWorkingCopy.getWorkItem());
                        }
                    }
                    references.set(this.fType, (IReference)newReferences.get(0));
                }
                catch (TeamRepositoryException x) {
                    WorkItemIDEUIPlugin.getDefault().log(Messages.LinkHelper_EXCEPTION_CREATING_LINK, x);
                }
            }
        }
    }

    public static class DeleteLinkAction
    extends Action
    implements IUpdate {
        private IInputSelectionProvider fInputProvider;

        public DeleteLinkAction(IInputSelectionProvider inputProvider) {
            this.fInputProvider = inputProvider;
            this.setText(Messages.LinkHelper_REMOVE);
            this.update();
        }

        public void update() {
            this.setEnabled(this.canRun());
        }

        private boolean canRun() {
            ISelection selection = this.fInputProvider.getSelection();
            if (selection.isEmpty()) {
                return false;
            }
            WorkItemWorkingCopy input = (WorkItemWorkingCopy)this.fInputProvider.getInput();
            if (!(selection instanceof IStructuredSelection) || input == null) {
                return false;
            }
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object object : structuredSelection) {
                if (!(object instanceof IReference)) {
                    return false;
                }
                IEndPointDescriptor referenceType = this.findReferenceType(object);
                if (referenceType == null) {
                    return false;
                }
                if (!WorkItemLinkTypes.isUserDeletable((IEndPointDescriptor)referenceType)) {
                    return false;
                }
                if (!WorkItemLinkTypes.isCalmLink((IEndPointDescriptor)referenceType) || LinkHelper.canModifyCalmLinks(input)) continue;
                return false;
            }
            return true;
        }

        private IEndPointDescriptor findReferenceType(Object element) {
            if (element instanceof IEndPointDescriptor) {
                return (IEndPointDescriptor)element;
            }
            if (element instanceof IReference) {
                return WorkItemLinkTypes.getEndPointDescriptor((IReference)((IReference)element));
            }
            return null;
        }

        public void run() {
            if (!this.canRun()) {
                return;
            }
            IStructuredSelection selection = (IStructuredSelection)this.fInputProvider.getSelection();
            WorkItemWorkingCopy input = (WorkItemWorkingCopy)this.fInputProvider.getInput();
            for (Object next : selection) {
                if (!(next instanceof IReference)) continue;
                input.getReferences().remove((IReference)next);
            }
        }
    }

    public static class InputSelectionProvider
    extends SelectionProvider
    implements IInputSelectionProvider {
        private Object fInput;

        public InputSelectionProvider() {
        }

        public InputSelectionProvider(Object input, ISelection selection) {
            this.setInput(input);
            this.setSelection(selection);
        }

        public Object getInput() {
            return this.fInput;
        }

        public void setInput(Object input) {
            this.fInput = input;
        }
    }

    public static class OpenLinkAction
    extends Action
    implements IUpdate {
        private IInputSelectionProvider fInputProvider;

        public OpenLinkAction(IInputSelectionProvider inputProvider) {
            this.fInputProvider = inputProvider;
            this.setText(Messages.LinkHelper_OPEN);
            this.update();
        }

        public void update() {
            this.setEnabled(this.canRun());
        }

        private boolean canRun() {
            ISelection selection = this.fInputProvider.getSelection();
            if (selection.isEmpty()) {
                return false;
            }
            WorkItemWorkingCopy input = (WorkItemWorkingCopy)this.fInputProvider.getInput();
            if (!(selection instanceof IStructuredSelection) || input == null) {
                return false;
            }
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object object : structuredSelection) {
                if (object instanceof IReference) continue;
                return false;
            }
            return true;
        }

        public void run() {
            if (!this.canRun()) {
                return;
            }
            IStructuredSelection selection = (IStructuredSelection)this.fInputProvider.getSelection();
            ArrayList<IReference> references = new ArrayList<IReference>();
            for (Object next : selection) {
                if (!(next instanceof IReference)) continue;
                references.add((IReference)next);
            }
            LinkHelper.openReferences(((WorkItemWorkingCopy)this.fInputProvider.getInput()).getTeamRepository(), references);
        }
    }
}

