/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.workitem.common.internal.presentations.AbstractPresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.SectionDescriptor;
import com.ibm.team.workitem.ide.ui.internal.HelpContextIds;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationTab;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormSectionContainer;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.WorkItemEditorSections;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class HistoryTab
extends PresentationTab {
    public static final String TAB_ID = "com.ibm.team.workitem.ide.ui.editor.page.history";
    public static Map<String, String> SLOTS = Collections.emptyMap();
    public static List<String> SMALL_SLOTS = Collections.emptyList();

    public HistoryTab() {
        super(TAB_ID, Messages.HistoryTab_HISTORY_TABNAME);
    }

    public HistoryTab(String id, String title) {
        super(id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        Assert.isNotNull(this.getPresentations());
        Assert.isNotNull((Object)this.getWorkingCopy());
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        body.setLayout((Layout)Util.createPageFormLayout());
        SectionDescriptor historyDesc = null;
        if (this.getPresentations().get(this.getId()) == null) {
            return;
        }
        List<AbstractPresentationDescriptor> sections = this.getPresentations().get(this.getId());
        for (AbstractPresentationDescriptor desc : sections) {
            if (!(desc instanceof SectionDescriptor)) continue;
            historyDesc = (SectionDescriptor)desc;
            break;
        }
        TeamFormSectionContainer container = null;
        if (historyDesc != null) {
            int style = 256;
            if (historyDesc.isExpanded()) {
                style |= 0x40;
            }
            container = WorkItemEditorSections.createSection((WorkItemEditorInput)this.getEditorInput(), this.getPresentations(), historyDesc, managedForm, style);
        }
        if (container != null) {
            FormData data = new FormData();
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            data.top = new FormAttachment(0);
            data.bottom = new FormAttachment(100);
            data.width = 1;
            data.height = 1;
            container.getLayoutControl().setLayoutData((Object)data);
            this.addPart((IFormPart)container.getFormPart(), container.getLayoutControl());
            container.getFormPart().setFormInput((Object)this.getEditorInput());
        }
        HelpContextIds.hookHelpListener((Control)form, "com.ibm.team.workitem.ide.ui.work_item_editor_history_page");
    }
}

