/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.SourceViewerPane;
import com.ibm.team.workitem.ide.ui.internal.editor.AnnotationIterator;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;

public class GotoAnnotationAction
extends Action {
    private IWorkbenchPart fPart;
    private boolean fForward;

    public GotoAnnotationAction(String prefix, boolean forward) {
        this.fForward = forward;
    }

    public void run() {
        this.gotoAnnotation(this.fForward);
    }

    public void gotoAnnotation(boolean forward) {
        if (this.fPart == null) {
            return;
        }
        SourceViewerPane pane = (SourceViewerPane)this.fPart.getAdapter(SourceViewerPane.class);
        if (pane == null) {
            return;
        }
        ISourceViewer viewer = pane.getLastActiveSourceViewer();
        if (viewer == null) {
            viewer = pane.getFirstVisibleSourceViewer();
        }
        if (viewer == null) {
            return;
        }
        ISourceViewer startViewer = viewer;
        ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
        Position position = this.getNextAnnotation(viewer, selection.getOffset(), selection.getLength(), forward, false);
        while (position == null) {
            if ((viewer = pane.getNextVisibleSourceViewer(viewer)) == startViewer || viewer == null) break;
            position = forward ? this.getNextAnnotation(viewer, 0, 0, forward, false) : this.getNextAnnotation(viewer, viewer.getDocument().getLength(), 0, forward, false);
        }
        if (position != null) {
            if (!viewer.getTextWidget().isFocusControl()) {
                viewer.getTextWidget().setFocus();
            }
            viewer.revealRange(position.getOffset(), position.getLength());
            viewer.setSelectedRange(position.getOffset(), position.getLength());
        }
    }

    private Position getNextAnnotation(ISourceViewer viewer, int offset, int length, boolean forward, boolean wrap) {
        Position nextAnnotationPosition = null;
        Position containingAnnotationPosition = null;
        boolean currentAnnotation = false;
        IDocument document = viewer.getDocument();
        int endOfDocument = document.getLength();
        int distance = Integer.MAX_VALUE;
        IAnnotationModel model = viewer.getAnnotationModel();
        AnnotationIterator e = new AnnotationIterator(model, true, true);
        while (e.hasNext()) {
            Position p;
            Annotation a = (Annotation)e.next();
            if (!this.isNavigationTarget(a) || (p = model.getPosition(a)) == null) continue;
            if (forward && p.offset == offset || !forward && p.offset + p.getLength() == offset + length) {
                if (containingAnnotationPosition != null && (!forward || p.length < containingAnnotationPosition.length) && (forward || p.length < containingAnnotationPosition.length)) continue;
                containingAnnotationPosition = p;
                currentAnnotation = p.length == length;
                continue;
            }
            int currentDistance = 0;
            if (forward) {
                currentDistance = p.getOffset() - offset;
                if (currentDistance < 0) {
                    if (!wrap) continue;
                    currentDistance = endOfDocument + currentDistance;
                }
                if (currentDistance >= distance && (currentDistance != distance || p.length >= nextAnnotationPosition.length)) continue;
                distance = currentDistance;
                nextAnnotationPosition = p;
                continue;
            }
            currentDistance = offset + length - (p.getOffset() + p.length);
            if (currentDistance < 0) {
                if (!wrap) continue;
                currentDistance = endOfDocument + currentDistance;
            }
            if (currentDistance >= distance && (currentDistance != distance || p.length >= nextAnnotationPosition.length)) continue;
            distance = currentDistance;
            nextAnnotationPosition = p;
        }
        if (containingAnnotationPosition != null && !currentAnnotation) {
            return new Position(containingAnnotationPosition.getOffset(), containingAnnotationPosition.getLength());
        }
        if (nextAnnotationPosition != null) {
            return new Position(nextAnnotationPosition.getOffset(), nextAnnotationPosition.getLength());
        }
        return null;
    }

    private boolean isNavigationTarget(Annotation annotation) {
        String key;
        Preferences preferences = EditorsUI.getPluginPreferences();
        AnnotationPreference preference = EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
        String string = key = preference == null ? null : preference.getIsGoToNextNavigationTargetKey();
        return key != null && preferences.getBoolean(key);
    }

    public IWorkbenchPart getPart() {
        return this.fPart;
    }

    public void setPart(IWorkbenchPart part) {
        this.fPart = part;
    }
}

