/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.SourceViewerPane;
import java.util.ArrayList;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.IFindReplaceTargetExtension2;
import org.eclipse.ui.texteditor.ITextEditorExtension2;

public class FindReplaceTarget
implements IFindReplaceTarget,
IFindReplaceTargetExtension,
IFindReplaceTargetExtension2,
IFindReplaceTargetExtension3 {
    private ITextEditorExtension2 fEditor;
    private SourceViewerPane fPane;

    public FindReplaceTarget(ITextEditorExtension2 editor, SourceViewerPane pane) {
        this.fEditor = editor;
        this.fPane = pane;
    }

    public boolean canPerformFind() {
        ISourceViewer[] viewers = this.fPane.getSourceViewers();
        int i = 0;
        while (i < viewers.length) {
            if (viewers[i].getFindReplaceTarget().canPerformFind()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int findAndSelect(int offset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
        return this.findAndSelect(offset, findString, searchForward, caseSensitive, wholeWord, false);
    }

    public int findAndSelect(int offset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord, boolean regExSearch) {
        ISourceViewer viewer = this.getFirstViewer(offset, searchForward);
        if (viewer != null) {
            int result = this.findAndSelect(viewer, offset > -1 ? offset - this.getViewerOffset(viewer) : -1, findString, searchForward, caseSensitive, wholeWord, regExSearch);
            while (result <= -1) {
                if ((viewer = this.getNextViewer(viewer, searchForward)) == null) break;
                result = this.findAndSelect(viewer, -1, findString, searchForward, caseSensitive, wholeWord, regExSearch);
            }
            if (result > -1) {
                this.fPane.setLastActiveSourceViewer(viewer);
                return result + this.getViewerOffset(viewer);
            }
        }
        return -1;
    }

    public Point getSelection() {
        ISourceViewer viewer = this.getLastActiveViewer();
        if (viewer != null) {
            Point selection = viewer.getFindReplaceTarget().getSelection();
            return new Point(selection.x + this.getViewerOffset(viewer), selection.y);
        }
        return new Point(0, 0);
    }

    public String getSelectionText() {
        ISourceViewer viewer = this.getLastActiveViewer();
        if (viewer != null && viewer.getDocument() != null) {
            return viewer.getFindReplaceTarget().getSelectionText();
        }
        return "";
    }

    public boolean isEditable() {
        ISourceViewer viewer = this.getLastActiveViewer();
        if (viewer != null) {
            return viewer.getFindReplaceTarget().isEditable();
        }
        return this.fEditor.isEditorInputModifiable();
    }

    public void replaceSelection(String text) {
        this.replaceSelection(text, false);
    }

    public void replaceSelection(String text, boolean regExReplace) {
        IFindReplaceTarget target;
        ISourceViewer viewer = this.getLastActiveViewer();
        IFindReplaceTarget iFindReplaceTarget = target = viewer != null ? viewer.getFindReplaceTarget() : null;
        if (target != null && target.isEditable()) {
            if (target instanceof IFindReplaceTargetExtension3) {
                ((IFindReplaceTargetExtension3)target).replaceSelection(text, regExReplace);
            } else if (!regExReplace) {
                target.replaceSelection(text);
            }
        }
    }

    public void beginSession() {
        ISourceViewer[] viewers = this.fPane.getSourceViewers();
        int i = 0;
        while (i < viewers.length) {
            IFindReplaceTarget target = viewers[i].getFindReplaceTarget();
            if (target instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)target).beginSession();
            }
            ++i;
        }
    }

    public void endSession() {
        ISourceViewer[] viewers = this.fPane.getSourceViewers();
        int i = 0;
        while (i < viewers.length) {
            IFindReplaceTarget target = viewers[i].getFindReplaceTarget();
            if (target instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)target).endSession();
            }
            ++i;
        }
    }

    public IRegion getScope() {
        IRegion scope;
        ISourceViewer viewer = this.getLastActiveExtension();
        if (viewer != null && (scope = ((IFindReplaceTargetExtension)viewer.getFindReplaceTarget()).getScope()) != null) {
            return new Region(scope.getOffset() + this.getViewerOffset(viewer), scope.getLength());
        }
        return null;
    }

    public void setScope(IRegion scope) {
        ISourceViewer viewer = this.getLastActiveExtension();
        if (viewer != null) {
            scope = scope != null ? new Region(scope.getOffset() - this.getViewerOffset(viewer), scope.getLength()) : null;
            ((IFindReplaceTargetExtension)viewer.getFindReplaceTarget()).setScope(scope);
        }
    }

    public Point getLineSelection() {
        ISourceViewer viewer = this.getLastActiveExtension();
        if (viewer != null) {
            Point selection = ((IFindReplaceTargetExtension)viewer.getFindReplaceTarget()).getLineSelection();
            return new Point(selection.x + this.getViewerOffset(viewer), selection.y);
        }
        return new Point(0, 0);
    }

    public void setSelection(int offset, int length) {
        ISourceViewer viewer = this.getLastActiveExtension();
        if (viewer != null) {
            ((IFindReplaceTargetExtension)viewer.getFindReplaceTarget()).setSelection(offset, length);
        }
    }

    public void setScopeHighlightColor(Color color) {
        ISourceViewer[] viewers = this.fPane.getSourceViewers();
        int i = 0;
        while (i < viewers.length) {
            IFindReplaceTarget target = viewers[i].getFindReplaceTarget();
            if (target instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)target).setScopeHighlightColor(color);
            }
            ++i;
        }
    }

    public void setReplaceAllMode(boolean replaceAll) {
        ISourceViewer[] viewers = this.fPane.getSourceViewers();
        int i = 0;
        while (i < viewers.length) {
            IFindReplaceTarget target = viewers[i].getFindReplaceTarget();
            if (target instanceof IFindReplaceTargetExtension && target.isEditable()) {
                ((IFindReplaceTargetExtension)target).setReplaceAllMode(replaceAll);
            }
            ++i;
        }
    }

    public boolean validateTargetState() {
        ISourceViewer viewer = this.getLastActiveViewer();
        if (viewer != null && viewer.getFindReplaceTarget() instanceof IFindReplaceTargetExtension2) {
            return ((IFindReplaceTargetExtension2)viewer.getFindReplaceTarget()).validateTargetState();
        }
        return this.fEditor.validateEditorInputState();
    }

    private int findAndSelect(ISourceViewer viewer, int offset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord, boolean regExSearch) {
        IFindReplaceTarget target = viewer.getFindReplaceTarget();
        if (target instanceof IFindReplaceTargetExtension3) {
            return ((IFindReplaceTargetExtension3)target).findAndSelect(offset, findString, searchForward, caseSensitive, wholeWord, regExSearch);
        }
        if (!regExSearch) {
            return target.findAndSelect(offset, findString, searchForward, caseSensitive, wholeWord);
        }
        return -1;
    }

    private ISourceViewer getLastActiveViewer() {
        ISourceViewer viewer = this.fPane.getLastActiveSourceViewer();
        if (this.indexOf(viewer) != -1) {
            return viewer;
        }
        return null;
    }

    private ISourceViewer getLastActiveExtension() {
        ISourceViewer viewer = this.getLastActiveViewer();
        if (viewer != null && viewer.getFindReplaceTarget() instanceof IFindReplaceTargetExtension) {
            return viewer;
        }
        return null;
    }

    private ISourceViewer[] getVisibleViewers() {
        ArrayList<ISourceViewer> visible = new ArrayList<ISourceViewer>();
        ISourceViewer[] viewers = this.fPane.getSourceViewers();
        int i = 0;
        while (i < viewers.length) {
            ISourceViewer viewer = viewers[i];
            if (viewer.getTextWidget().isVisible()) {
                visible.add(viewer);
            }
            ++i;
        }
        return visible.toArray(new ISourceViewer[visible.size()]);
    }

    private ISourceViewer getNextViewer(ISourceViewer viewer, boolean searchForward) {
        viewer = this.getSucceedingViewer(viewer, searchForward);
        while (viewer != null && !viewer.getFindReplaceTarget().canPerformFind()) {
            viewer = this.getSucceedingViewer(viewer, searchForward);
        }
        return viewer;
    }

    private ISourceViewer getFirstViewer(int offset, boolean searchForward) {
        ISourceViewer viewer = this.getViewerAtOffset(offset, searchForward);
        while (viewer != null && !viewer.getFindReplaceTarget().canPerformFind()) {
            viewer = this.getSucceedingViewer(viewer, searchForward);
        }
        return viewer;
    }

    private ISourceViewer getSucceedingViewer(ISourceViewer viewer, boolean forward) {
        int i = this.indexOf(viewer);
        if (i == -1) {
            return null;
        }
        ISourceViewer[] viewers = this.getVisibleViewers();
        if (forward && i + 1 < viewers.length) {
            return viewers[i + 1];
        }
        if (!forward && i > 0) {
            return viewers[i - 1];
        }
        return null;
    }

    private ISourceViewer getViewerAtOffset(int offset, boolean forward) {
        ISourceViewer[] viewers = this.getVisibleViewers();
        if (offset < 0 && !forward && viewers.length > 0) {
            return viewers[viewers.length - 1];
        }
        int i = 0;
        while (i < viewers.length) {
            ISourceViewer viewer = viewers[i];
            int length = viewer.getTextWidget().getCharCount();
            if (offset < length) {
                return viewer;
            }
            offset -= length;
            ++i;
        }
        return null;
    }

    private int getViewerOffset(ISourceViewer viewer) {
        ISourceViewer[] viewers = this.fPane.getSourceViewers();
        int i = 0;
        int offset = 0;
        while (i < viewers.length) {
            if (viewer == viewers[i]) {
                return offset;
            }
            offset += viewers[i].getTextWidget().getCharCount();
            ++i;
        }
        throw new IllegalArgumentException();
    }

    private int indexOf(ISourceViewer viewer) {
        ISourceViewer[] viewers = this.getVisibleViewers();
        int i = 0;
        while (i < viewers.length) {
            if (viewer == viewers[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

