/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.StyledEditingAction;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.ide.ui.internal.editor.CommentsDocument;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class EmptyCommentAction
extends StyledEditingAction {
    public EmptyCommentAction(IWorkbenchPart part, ISourceViewer sourceViewer) {
        super(Messages.EmptyCommentAction_EMPTY_COMMENT, null, null, sourceViewer);
        this.setPart(part);
    }

    public void run() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        ITextSelection selection = (ITextSelection)sourceViewer.getSelectionProvider().getSelection();
        CommentsDocument document = (CommentsDocument)sourceViewer.getDocument();
        List comments = document.getComments(selection.getOffset(), selection.getLength());
        if (comments.isEmpty()) {
            MessageDialog.openInformation((Shell)sourceViewer.getTextWidget().getShell(), (String)Messages.EmptyCommentAction_NO_COMMENT_SELECTED, (String)Messages.EmptyCommentAction_SELECTION_NOT_INLCUDES_COMMENT);
            return;
        }
        String list = "";
        for (IComment comment : comments) {
            int index = ((WorkItem)((EObject)comment).eContainer()).getInternalComments().indexOf(comment) + 1;
            list = NLS.bind((String)Messages.EmptyCommentAction_APPEND_COMMENT_INDEX_TO_LIST, (Object)list, (Object[])new Object[]{index});
        }
        if (list.length() > 2) {
            list = list.substring(2);
        }
        String message = NLS.bind((String)Messages.EmptyCommentAction_EMPTY_FOLLOWING_COMMENTS, (Object)list, (Object[])new Object[0]);
        if (MessageDialog.openQuestion((Shell)sourceViewer.getTextWidget().getShell(), (String)Messages.EmptyCommentAction_EMPTY_COMMENT_DIALOG_TITLE, (String)message)) {
            for (IComment comment : comments) {
                document.emptyComment(comment);
            }
        }
    }
}

