/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.rcp.ui.internal.util.UserInitiatedJobContext;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.editor.ExtractWorkItemOperation;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DuplicateWorkItemAction
extends Action
implements IObjectActionDelegate {
    private static final String[] COPY_ATTRIBUTES = new String[]{IWorkItem.TYPE_PROPERTY, IWorkItem.PROJECT_AREA_PROPERTY, IWorkItem.SUMMARY_PROPERTY, IWorkItem.SEVERITY_PROPERTY, IWorkItem.FOUND_IN_PROPERTY, IWorkItem.DESCRIPTION_PROPERTY, IWorkItem.CATEGORY_PROPERTY, IWorkItem.TAGS_PROPERTY};
    private ISelection fSelection;
    private IWorkbenchPart fPart;

    public DuplicateWorkItemAction() {
        this(null, null, null);
    }

    public DuplicateWorkItemAction(IWorkbenchPart part) {
        this(null, ImagePool.CREATE_DUPLICATE, part);
    }

    private DuplicateWorkItemAction(String text, ImageDescriptor image, IWorkbenchPart part) {
        super(text, image);
        this.setToolTipText(Messages.DuplicateWorkItemAction_DUPLICATE_AND_CONNECT);
        this.setDisabledImageDescriptor(ImageDescriptor.createWithFlags((ImageDescriptor)image, (int)1));
        this.fPart = part;
        this.update();
    }

    public void run() {
        this.run((IAction)this);
    }

    public void run(IAction action) {
        if (!this.shouldEnable()) {
            return;
        }
        final IWorkItemHandle source = this.getWorkItem();
        final ITeamRepository teamRepository = (ITeamRepository)source.getOrigin();
        IWorkbenchWindow window = this.fPart != null ? this.fPart.getSite().getWorkbenchWindow() : PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            FoundationJob job = new FoundationJob(Messages.DuplicateWorkItemAction_DUPLICATING_WORKITEM, UserInitiatedJobContext.create((IWorkbenchWindow)window, (IAction)action, (ITeamRepository[])new ITeamRepository[]{teamRepository})){

                protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                    IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
                    IWorkItem sourceItem = (IWorkItem)auditableClient.resolveAuditable((IAuditableHandle)source, IWorkItem.FULL_PROFILE, monitor);
                    ExtractWorkItemOperation operation = new ExtractWorkItemOperation((IWorkItemHandle)sourceItem, Messages.DuplicateWorkItemAction_COPIED, null, null, Collections.singletonList(sourceItem.getCreator()), WorkItemEndPoints.COPIED_FROM_WORK_ITEM, COPY_ATTRIBUTES);
                    operation.run(sourceItem.getProjectArea(), sourceItem.getWorkItemType(), monitor);
                    return null;
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    private IWorkItemHandle getWorkItem() {
        IWorkItemHandle handle = null;
        if (this.isWorkItemSelected()) {
            handle = (IWorkItemHandle)((IStructuredSelection)this.fSelection).getFirstElement();
        } else if (this.isWorkItemOpen()) {
            IEditorPart editorPart = (IEditorPart)this.getPart();
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)editorPart.getEditorInput();
            handle = workItemEditorInput.getWorkItemHandle();
        }
        if (handle instanceof IWorkItem && ((IWorkItem)handle).isNewItem()) {
            return null;
        }
        return handle;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
        action.setEnabled(this.shouldEnable());
    }

    private boolean shouldEnable() {
        return this.getWorkItem() != null;
    }

    private boolean isWorkItemSelected() {
        if (this.fSelection == null || this.fSelection.isEmpty() || !(this.fSelection instanceof IStructuredSelection)) {
            return false;
        }
        Object element = ((IStructuredSelection)this.fSelection).getFirstElement();
        return element instanceof IWorkItemHandle && (!(element instanceof IWorkItem) || !((IWorkItem)element).isNewItem());
    }

    private boolean isWorkItemOpen() {
        IWorkbenchPart part = this.getPart();
        if (!(part instanceof IEditorPart)) {
            return false;
        }
        IEditorInput input = ((IEditorPart)part).getEditorInput();
        if (!(input instanceof WorkItemEditorInput) || !((WorkItemEditorInput)input).isResolved()) {
            return false;
        }
        WorkItemWorkingCopy workingCopy = ((WorkItemEditorInput)input).getWorkingCopy();
        return !workingCopy.getWorkItem().isNewItem();
    }

    public void update() {
        this.setEnabled(this.shouldEnable());
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fPart = targetPart;
    }

    public IWorkbenchPart getPart() {
        return this.fPart;
    }
}

