/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.workitem.common.internal.presentations.AbstractPresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.SectionDescriptor;
import com.ibm.team.workitem.ide.ui.internal.HelpContextIds;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.TeamSashForm;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationTab;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormSectionContainer;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.WorkItemEditorSections;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class CustomAttributesTab
extends PresentationTab {
    public static final String TAB_ID = "com.ibm.team.workitem.ide.ui.editor.page.customAttributes";
    private static final String LEFT_SLOT = "left";
    private static final String RIGHT_SLOT = "right";
    public static Map<String, String> SLOTS = new HashMap<String, String>();
    public static List<String> SMALL_SLOTS = new ArrayList<String>();

    static {
        SLOTS.put(LEFT_SLOT, Messages.CustomAttributesTab_LEFT);
        SLOTS.put(RIGHT_SLOT, Messages.CustomAttributesTab_RIGHT);
        SMALL_SLOTS.add(LEFT_SLOT);
    }

    public CustomAttributesTab() {
        super(TAB_ID, Messages.CustomAttributesTab_CUSTOM_TAB_NAME);
    }

    public CustomAttributesTab(String id, String title) {
        super(id, title);
    }

    public boolean isEmpty(WorkItemEditorInput input) {
        List<AbstractPresentationDescriptor> descriptors = this.getPresentations().get(this.getId());
        if (descriptors == null || descriptors.isEmpty()) {
            return true;
        }
        for (AbstractPresentationDescriptor section : descriptors) {
            if (!(section instanceof SectionDescriptor)) continue;
            List<AbstractPresentationDescriptor> presentations = this.getPresentations().get(section.getElementId());
            if (presentations == null || presentations.isEmpty()) {
                if (!WorkItemEditorSections.isCollectorSection((SectionDescriptor)section) || WorkItemEditorSections.getCollectorRelevantAttributes(input, this.getPresentations()).isEmpty()) continue;
                return false;
            }
            for (AbstractPresentationDescriptor presentation : presentations) {
                if (!(presentation instanceof PresentationDescriptor) || "com.ibm.team.workitem.kind.special.doNotShow".equals(((PresentationDescriptor)presentation).getKind())) continue;
                return false;
            }
        }
        return true;
    }

    protected void createFormContent(IManagedForm managedForm) {
        int i;
        int[] weights;
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        body.setLayout((Layout)new GridLayout(1, false));
        ArrayList<SectionDescriptor> leftSections = new ArrayList<SectionDescriptor>();
        ArrayList<SectionDescriptor> rightSections = new ArrayList<SectionDescriptor>();
        if (this.getPresentations().get(this.getId()) != null) {
            List<AbstractPresentationDescriptor> sections = this.getPresentations().get(this.getId());
            for (AbstractPresentationDescriptor desc : sections) {
                if (!(desc instanceof SectionDescriptor)) continue;
                SectionDescriptor sd = (SectionDescriptor)desc;
                if (LEFT_SLOT.equals(sd.getSlot())) {
                    leftSections.add(sd);
                    continue;
                }
                if (!RIGHT_SLOT.equals(sd.getSlot())) continue;
                rightSections.add(sd);
            }
        }
        TeamSashForm tab = new TeamSashForm(body, 256);
        tab.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).create());
        managedForm.getToolkit().adapt((Composite)tab);
        TeamSashForm left = new TeamSashForm(tab, 512);
        managedForm.getToolkit().adapt((Composite)left);
        ArrayList<Object> leftContainers = new ArrayList<Object>();
        for (SectionDescriptor desc : leftSections) {
            Object container;
            int style = 256;
            if (desc.isExpanded()) {
                style |= 0x40;
            }
            if (leftSections.size() > 1) {
                style |= 2;
            }
            if ((container = WorkItemEditorSections.createSection((WorkItemEditorInput)this.getEditorInput(), this.getPresentations(), desc, managedForm, left, style)) == null) continue;
            leftContainers.add(container);
            this.addPart((IFormPart)((TeamFormSectionContainer)container).getFormPart(), ((TeamFormSectionContainer)container).getLayoutControl());
            ((TeamFormSectionContainer)container).getFormPart().setFormInput((Object)this.getEditorInput());
        }
        TeamSashForm right = new TeamSashForm(tab, 512);
        managedForm.getToolkit().adapt((Composite)right);
        ArrayList<TeamFormSectionContainer> rightContainers = new ArrayList<TeamFormSectionContainer>();
        for (SectionDescriptor desc : rightSections) {
            TeamFormSectionContainer section;
            int style = 256;
            if (desc.isExpanded()) {
                style |= 0x40;
            }
            if (rightSections.size() > 1) {
                style |= 2;
            }
            if (desc.getProperties() != null && "true".equalsIgnoreCase((String)desc.getProperties().get("noHeader"))) {
                style = 0;
            }
            if ((section = WorkItemEditorSections.createSection((WorkItemEditorInput)this.getEditorInput(), this.getPresentations(), desc, managedForm, right, style)) == null) continue;
            rightContainers.add(section);
            this.addPart((IFormPart)section.getFormPart(), section.getLayoutControl());
            section.getFormPart().setFormInput((Object)this.getEditorInput());
        }
        if (leftContainers.isEmpty()) {
            left.dispose();
        }
        if (rightContainers.isEmpty()) {
            right.dispose();
        }
        if (!leftContainers.isEmpty() && !rightContainers.isEmpty()) {
            tab.setWeights(new int[]{-1, 1});
        } else if (!leftContainers.isEmpty() || !rightContainers.isEmpty()) {
            tab.setWeights(new int[]{1});
        }
        if (!leftContainers.isEmpty()) {
            int l = leftContainers.size();
            weights = new int[l];
            i = 0;
            while (i < l) {
                weights[i] = Util.isFixedHeight((TeamFormSectionContainer)leftContainers.get(i)) ? -1 : Util.guessWeight((TeamFormSectionContainer)leftContainers.get(i));
                ++i;
            }
            left.setWeights(weights);
        }
        if (!rightContainers.isEmpty()) {
            int l = rightContainers.size();
            weights = new int[l];
            i = 0;
            while (i < l) {
                weights[i] = Util.isFixedHeight((TeamFormSectionContainer)rightContainers.get(i)) ? -1 : Util.guessWeight((TeamFormSectionContainer)rightContainers.get(i));
                ++i;
            }
            right.setWeights(weights);
        }
        HelpContextIds.hookHelpListener((Control)form, "com.ibm.team.workitem.ide.ui.work_item_editor_custom_attributes_page");
    }

    protected void setInput(IEditorInput input) {
        IManagedForm managedForm = this.getManagedForm();
        if (managedForm != null) {
            this.clearFormContent(managedForm);
        }
        super.setInput(input);
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved()) {
            super.initialize(((WorkItemEditorInput)input).getWorkingCopy(), this.getPresentations(), this.getDescriptor());
        } else {
            super.initialize(null, this.getPresentations(), this.getDescriptor());
        }
        if (managedForm != null) {
            this.createFormContent(managedForm);
            managedForm.setInput((Object)input);
        }
    }

    private void clearFormContent(IManagedForm managedForm) {
        IFormPart[] parts = managedForm.getParts();
        if (parts != null) {
            int i = 0;
            while (i < parts.length) {
                managedForm.removePart(parts[i]);
                parts[i].dispose();
                if (parts[i] instanceof SectionPart) {
                    SectionPart sectionPart = (SectionPart)parts[i];
                    sectionPart.getSection().dispose();
                }
                ++i;
            }
            managedForm.reflow(true);
        }
    }
}

