/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.IAttachmentHandle;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PlatformUI;

public class AttachmentEditorInput
extends PlatformObject
implements IStorageEditorInput {
    private AttachmentStorage fAttachmentStorage;

    public AttachmentEditorInput(IAttachment attachment) {
        this.fAttachmentStorage = new AttachmentStorage(attachment);
    }

    public IStorage getStorage() throws CoreException {
        return this.fAttachmentStorage;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.fAttachmentStorage.getName());
    }

    public String getName() {
        return this.fAttachmentStorage.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.fAttachmentStorage.getName();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AttachmentEditorInput)) {
            return false;
        }
        return ((AttachmentEditorInput)((Object)obj)).getAttachmentHandle().sameItemId((IItemHandle)this.getAttachmentHandle());
    }

    public IAttachmentHandle getAttachmentHandle() {
        return this.fAttachmentStorage.getAttachmentHandle();
    }

    private static class AttachmentStorage
    extends PlatformObject
    implements IStorage {
        private IAttachment fAttachment;

        public AttachmentStorage(IAttachment attachment) {
            this.fAttachment = attachment;
        }

        public InputStream getContents() throws CoreException {
            try {
                return this.getInputStream(this.fAttachment.getContent(), null);
            }
            catch (TeamRepositoryException x) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.team.workitem.ide.ui", 4, NLS.bind((String)Messages.AttachmentEditorInput_EXCEPTION_RESOLVING, (Object)this.fAttachment.getName(), (Object[])new Object[0]), (Throwable)x));
            }
        }

        private InputStream getInputStream(IContent content, IProgressMonitor monitor) throws TeamRepositoryException {
            return ((ITeamRepository)this.fAttachment.getOrigin()).contentManager().retrieveContentStream(content, monitor);
        }

        public IPath getFullPath() {
            return null;
        }

        public String getName() {
            return this.fAttachment.getName();
        }

        public boolean isReadOnly() {
            return true;
        }

        public IAttachmentHandle getAttachmentHandle() {
            return this.fAttachment;
        }
    }
}

