/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.workitem.common.internal.presentations.AbstractPresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.SectionDescriptor;
import com.ibm.team.workitem.ide.ui.internal.HelpContextIds;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorParts;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemTeamFormSectionPart;
import com.ibm.team.workitem.ide.ui.internal.editor.part.ApprovalsPart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationTab;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class ApprovalsTab
extends PresentationTab {
    public static final String TAB_ID = "com.ibm.team.workitem.ide.ui.editor.page.approvals";
    public static Map<String, String> SLOTS = Collections.emptyMap();
    public static List<String> SMALL_SLOTS = Collections.emptyList();
    private ApprovalsPart fApprovalsPart;

    public ApprovalsTab() {
        super(TAB_ID, Messages.ApprovalsTab_APPROVALS_TABNAME);
    }

    public ApprovalsTab(String id, String title) {
        super(id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        Assert.isNotNull(this.getPresentations());
        Assert.isNotNull((Object)this.getWorkingCopy());
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        body.setLayout((Layout)Util.createPageFormLayout());
        SectionDescriptor approvalsDesc = null;
        if (this.getPresentations().get(this.getId()) == null) {
            return;
        }
        List<AbstractPresentationDescriptor> sections = this.getPresentations().get(this.getId());
        for (AbstractPresentationDescriptor desc : sections) {
            if (!(desc instanceof SectionDescriptor)) continue;
            approvalsDesc = (SectionDescriptor)desc;
            break;
        }
        WorkItemTeamFormSectionPart approvalsSection = null;
        if (approvalsDesc != null) {
            ArrayList<TeamFormPart> parts = new ArrayList<TeamFormPart>();
            List<AbstractPresentationDescriptor> descriptors = this.getPresentations().get(approvalsDesc.getElementId());
            if (descriptors != null && !descriptors.isEmpty()) {
                for (AbstractPresentationDescriptor d : descriptors) {
                    TeamFormPart part = WorkItemEditorParts.createPart(this.getWorkingCopy(), d);
                    if (part == null) continue;
                    parts.add(part);
                }
            }
            if (parts.size() > 0) {
                for (TeamFormPart part : parts) {
                    if (!(part instanceof ApprovalsPart)) continue;
                    this.fApprovalsPart = (ApprovalsPart)part;
                    break;
                }
                String title = Messages.ApprovalsTab_APPROVALS_SECTIONNAME;
                if (approvalsDesc.getProperties() != null && approvalsDesc.getProperties().get("title") != null) {
                    title = (String)approvalsDesc.getProperties().get("title");
                }
                int style = 256;
                if (approvalsDesc.isExpanded()) {
                    style |= 0x40;
                }
                approvalsSection = new WorkItemTeamFormSectionPart(managedForm, style, title, parts.toArray(new TeamFormPart[parts.size()])){

                    public void setFocus() {
                        if (this.getLastFocusControl() == null) {
                            this.getParts()[0].setFocus();
                        } else {
                            super.setFocus();
                        }
                    }
                };
            }
        }
        if (approvalsSection != null) {
            FormData data = new FormData();
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            data.top = new FormAttachment(0);
            data.bottom = new FormAttachment(100);
            data.width = 1;
            data.height = 1;
            approvalsSection.getSection().setLayoutData((Object)data);
            this.addPart((SectionPart)approvalsSection);
            approvalsSection.setFormInput(this.getEditorInput());
        }
        HelpContextIds.hookHelpListener((Control)form, "com.ibm.team.workitem.ide.ui.work_item_editor_approvals_page");
    }

    public void setApprovalSelection(Object approval) {
        this.fApprovalsPart.setApprovalSelection(approval);
    }

    public void dispose() {
        this.fApprovalsPart = null;
        super.dispose();
    }
}

