/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.capture;

import com.ibm.icu.text.DateFormat;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.WorkItemOperation;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.capture.Messages;
import com.ibm.team.workitem.ide.ui.internal.capture.ScreenCapture;
import com.ibm.team.workitem.ide.ui.internal.editor.LinkHelper;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditor;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.WorkItemUIOperation;
import com.ibm.team.workitem.rcp.ui.workitempicker.WorkItemSelectionDialog;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ScreenCaptureUtils {
    private static boolean fgIsLinux = "gtk".equals(SWT.getPlatform());

    public static void addScreenCapture(final IWorkItem wi) {
        ScreenCapture capture = new ScreenCapture(){

            public String createActions(ToolBarManager toolBarManager, ResourceManager resourceManager) {
                WorkItemEditor editor;
                IEditorInput editorInput;
                IEditorPart activeEditor;
                IWorkbenchPage activePage;
                IWorkItem workItem = wi;
                IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (activeWorkbenchWindow != null && (activePage = activeWorkbenchWindow.getActivePage()) != null && (activeEditor = activePage.getActiveEditor()) instanceof WorkItemEditor && (editorInput = (editor = (WorkItemEditor)activeEditor).getEditorInput()) instanceof WorkItemEditorInput && ((WorkItemEditorInput)editorInput).isResolved()) {
                    WorkItemEditorInput input = (WorkItemEditorInput)editorInput;
                    workItem = input.getWorkItem();
                }
                if (workItem != null) {
                    ScreenCaptureUtils.createAttachToWorkitem(this, toolBarManager, this.getShell(), workItem);
                }
                ScreenCaptureUtils.createAttachNew(this, toolBarManager, this.getShell());
                ScreenCaptureUtils.createAttachToOtherWorkitems(this, toolBarManager, this.getShell());
                return Messages.ScreenCaptureUtils_ATTACH_TO;
            }
        };
        capture.open();
    }

    private static void createAttachNew(final ScreenCapture capture, ToolBarManager toolBarManager, final Shell shell) {
        Action action = new Action(Messages.ScreenCaptureUtils_NEW_WORKITEM){

            public void run() {
                BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        if (fgIsLinux && !capture.getCaptureWindowShell().isDisposed()) {
                            capture.getCaptureWindowShell().setVisible(false);
                        }
                        try {
                            ScreenCaptureUtils.createWorkItem(capture, shell);
                        }
                        finally {
                            if (fgIsLinux && !capture.getCaptureWindowShell().isDisposed()) {
                                capture.getCaptureWindowShell().setVisible(true);
                            }
                        }
                    }
                });
            }
        };
        action.setImageDescriptor(ImagePool.NEW_WORKITEM);
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        toolBarManager.add((IContributionItem)item);
    }

    private static void createAttachToWorkitem(final ScreenCapture capture, ToolBarManager toolBarManager, final Shell shell, final IWorkItem workItem) {
        Action action = new Action(NLS.bind((String)Messages.ScreenCaptureUtils_WORKITEM_ID, (Object)WorkItemTextUtilities.getWorkItemId((IWorkItem)workItem), (Object[])new Object[0])){

            public void run() {
                BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        if (fgIsLinux && !capture.getCaptureWindowShell().isDisposed()) {
                            capture.getCaptureWindowShell().setVisible(false);
                        }
                        try {
                            ScreenCaptureUtils.addScreenCaptureAttachment(capture, shell, (IWorkItemHandle)workItem);
                        }
                        finally {
                            if (fgIsLinux && !capture.getCaptureWindowShell().isDisposed()) {
                                capture.getCaptureWindowShell().setVisible(true);
                            }
                        }
                    }
                });
            }
        };
        action.setImageDescriptor(ImagePool.WORKITEM_ATTACHMENT);
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        toolBarManager.add((IContributionItem)item);
    }

    private static void createAttachToOtherWorkitems(final ScreenCapture capture, ToolBarManager toolBarManager, final Shell shell) {
        Action action = new Action(Messages.ScreenCaptureUtils_OTHER_WORKITEM){

            public void run() {
                BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        WorkItemOperation operation = ScreenCaptureUtils.createAttachmentOperation(capture, shell);
                        if (operation == null) {
                            return;
                        }
                        if (fgIsLinux && !capture.getCaptureWindowShell().isDisposed()) {
                            capture.getCaptureWindowShell().setVisible(false);
                        }
                        try {
                            WorkItemSelectionDialog dialog = new WorkItemSelectionDialog(shell, false);
                            dialog.setPostCreationOperation(operation);
                            IWorkItemHandle handle = dialog.getSingleWorkItem();
                            if (handle != null) {
                                operation.runInJob(handle);
                            }
                        }
                        finally {
                            if (fgIsLinux && !capture.getCaptureWindowShell().isDisposed()) {
                                capture.getCaptureWindowShell().setVisible(true);
                            }
                        }
                    }
                });
            }
        };
        action.setImageDescriptor(ImagePool.WORKITEM_ATTACHMENT);
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        toolBarManager.add((IContributionItem)item);
    }

    private static void createWorkItem(ScreenCapture capture, Shell shell) {
        WorkItemOperation operation = ScreenCaptureUtils.createAttachmentOperation(capture, shell);
        if (operation != null) {
            WorkItemUI.createWorkItem((Shell)shell, null, (WorkItemOperation)operation);
        }
    }

    private static void addScreenCaptureAttachment(ScreenCapture capture, Shell shell, IWorkItemHandle handle) {
        WorkItemOperation operation = ScreenCaptureUtils.createAttachmentOperation(capture, shell);
        if (operation != null) {
            operation.runInJob(handle);
        }
    }

    private static WorkItemOperation createAttachmentOperation(ScreenCapture capture, Shell shell) {
        try {
            File file = capture.saveToTemp();
            if (file != null && file.exists() && file.isFile()) {
                return new WorkItemAttachmentOperation(file, shell);
            }
        }
        catch (IOException e) {
            WorkItemIDEUIPlugin.getDefault().log(Messages.ScreenCaptureUtils_ERROR_WHILE_SAVING, e);
        }
        return null;
    }

    private static class WorkItemAttachmentOperation
    extends WorkItemUIOperation {
        private File fFile;
        private Shell fShellToClose;

        private WorkItemAttachmentOperation(File file, Shell shellToClose) {
            super(Messages.ScreenCaptureUtils_ATTACH_FILE, IWorkItem.FULL_PROFILE);
            Assert.isTrue((boolean)file.exists());
            Assert.isTrue((boolean)file.isFile());
            this.fFile = file;
            this.fShellToClose = shellToClose;
        }

        protected void execute(WorkItemWorkingCopy[] workingCopies, IProgressMonitor monitor) throws TeamRepositoryException {
            int i = 0;
            while (i < workingCopies.length) {
                IWorkItem workItem = workingCopies[i].getWorkItem();
                if (workItem.isNewItem()) {
                    String date = DateFormat.getDateTimeInstance().format(new Date());
                    XMLString existingDescription = workItem.getHTMLDescription();
                    if (existingDescription == null) {
                        workItem.setHTMLDescription(XMLString.createFromPlainText((String)NLS.bind((String)Messages.ScreenCaptureUtils_SCREENSHOT_VISUALIZES, (Object)date, (Object[])new Object[0])));
                    }
                }
                IReference reference = LinkHelper.createReference(this.fFile);
                workingCopies[i].getReferences().add(WorkItemEndPoints.ATTACHMENT, reference);
                ++i;
            }
        }

        protected void commitInUI(WorkItemWorkingCopy[] workingCopies, IProgressMonitor monitor) {
            super.commitInUI(workingCopies, monitor);
            if (!(monitor != null && monitor.isCanceled() || this.fShellToClose.isDisposed())) {
                this.fShellToClose.close();
            }
        }
    }
}

