/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowBinding;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowBindingManager {
    private static final String WORKITEMCATEGORYBINDING = "workItemCategoryBinding";
    private static final String WORKITEMCATEGORYID = "workItemCategoryId";
    private static final String WORKFLOWID = "workflowId";

    public static List<WorkflowBinding> readWorkflowBindings(ModelElement configurationElement) {
        ArrayList<WorkflowBinding> bindings = new ArrayList<WorkflowBinding>();
        if (configurationElement != null) {
            for (ModelElement element : configurationElement.getChildElements()) {
                if (!WORKITEMCATEGORYBINDING.equals(element.getName())) continue;
                String category = element.getAttribute(WORKITEMCATEGORYID);
                String workflow = element.getAttribute(WORKFLOWID);
                if (category == null || workflow == null) continue;
                bindings.add(new WorkflowBinding(category, workflow, null));
            }
        }
        return bindings;
    }

    public static void writeWorkflowBindings(IMemento memento, List<WorkflowBinding> workflowBindings) {
        for (WorkflowBinding binding : workflowBindings) {
            if (binding.getCategoryId() == null || binding.getWorkflowId() == null) continue;
            IMemento b = memento.createChild(WORKITEMCATEGORYBINDING);
            b.putString(WORKITEMCATEGORYID, binding.getCategoryId());
            b.putString(WORKFLOWID, binding.getWorkflowId());
        }
    }
}

