/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow;

import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AspectEditorUtil;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ModeledElement;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WFWorkflow
extends ModeledElement {
    public static final String RESOLUTIONS_PROPERTY = "resolutions";
    public static final String ACTIONS_PROPERTY = "actions";
    public static final String STATES_PROPERTY = "states";
    public static final String DEFAULTACTIONS_PROPERTY = "defaultactions";
    public static final String WORKFLOW_PROPERTY = "workflow";
    static final String RESOLUTION_PREFIX = ".resolution.r";
    static final String STATE_PREFIX = ".state.s";
    private Set<WFChangeListener> fChangeListeners = new HashSet<WFChangeListener>();
    private String fName;
    private String fId;
    private String fDescription;
    private WFAction fStartAction;
    private WFAction fResolveAction;
    private WFAction fReopenAction;
    private List<WFAction> fActions = new ArrayList<WFAction>();
    private List<WFState> fStates = new ArrayList<WFState>();
    private List<WFResolution> fResolutions = new ArrayList<WFResolution>();
    private int fMaxResolutionId = 0;
    private int fMaxStateId = 0;
    private int fMaxActionId = 0;

    public WFWorkflow(String name, String id, String description) {
        this.fName = name;
        this.fId = id;
        this.fDescription = description;
    }

    @Override
    public String getIdentifier() {
        return this.fId;
    }

    public void addResolution(WFResolution resolution) {
        int id = AspectEditorUtil.getIdNumberSuffix(resolution.getId());
        if (id > this.fMaxResolutionId) {
            this.fMaxResolutionId = id;
        }
        this.fResolutions.add(resolution);
        this.notifyListeners(WORKFLOW_PROPERTY, resolution);
    }

    public void removeResolution(WFResolution resolution) {
        for (WFAction act : this.fActions) {
            if (!act.getResolutions().contains(resolution)) continue;
            act.getResolutions().remove(resolution);
        }
        this.fResolutions.remove(resolution);
        this.notifyListeners(WORKFLOW_PROPERTY, resolution);
    }

    public void setActions(Collection<? extends WFAction> actions) {
        this.fActions = new ArrayList<WFAction>(actions);
        for (WFAction action : this.fActions) {
            int id = AspectEditorUtil.getIdNumberSuffix(action.getId());
            if (id <= this.fMaxActionId) continue;
            this.fMaxActionId = id;
        }
        this.notifyListeners(WORKFLOW_PROPERTY, this.fActions);
    }

    public void setStates(Collection<? extends WFState> states) {
        this.fStates = new ArrayList<WFState>(states);
        for (WFState state : this.fStates) {
            int id = AspectEditorUtil.getIdNumberSuffix(state.getId());
            if (id <= this.fMaxStateId) continue;
            this.fMaxStateId = id;
        }
        this.notifyListeners(WORKFLOW_PROPERTY, this.fStates);
    }

    public void addAction(WFAction action) {
        int id = AspectEditorUtil.getIdNumberSuffix(action.getId());
        if (id > this.fMaxActionId) {
            this.fMaxActionId = id;
        }
        this.fActions.add(action);
        this.notifyListeners(WORKFLOW_PROPERTY, action);
    }

    public void removeAction(WFAction action) {
        for (WFState sta : this.fStates) {
            if (!sta.getActions().contains(action)) continue;
            sta.getActions().remove(action);
        }
        if (this.fReopenAction == action) {
            this.fReopenAction = null;
        }
        if (this.fResolveAction == action) {
            this.fResolveAction = null;
        }
        if (this.fStartAction == action) {
            this.fStartAction = null;
        }
        this.fActions.remove(action);
        this.notifyListeners(WORKFLOW_PROPERTY, action);
    }

    public void addState(WFState state) {
        int id = AspectEditorUtil.getIdNumberSuffix(state.getId());
        if (id > this.fMaxStateId) {
            this.fMaxStateId = id;
        }
        this.fStates.add(state);
        this.notifyListeners(WORKFLOW_PROPERTY, state);
    }

    public void removeState(WFState state) {
        ArrayList<WFAction> toRemove = new ArrayList<WFAction>();
        for (WFAction action : this.fActions) {
            if (action.getTargetState() != state) continue;
            toRemove.add(action);
        }
        for (WFAction action : toRemove) {
            this.removeAction(action);
        }
        this.fStates.remove(state);
        this.notifyListeners(WORKFLOW_PROPERTY, state);
    }

    public void setResolutions(Collection<? extends WFResolution> resolutions) {
        this.fResolutions = new ArrayList<WFResolution>(resolutions);
        for (WFResolution resolution : this.fResolutions) {
            int id = AspectEditorUtil.getIdNumberSuffix(resolution.getId());
            if (id <= this.fMaxResolutionId) continue;
            this.fMaxResolutionId = id;
        }
        this.notifyListeners(WORKFLOW_PROPERTY, this.fResolutions);
    }

    public List<WFAction> getActions() {
        return this.fActions;
    }

    public List<WFState> getStates() {
        return this.fStates;
    }

    public List<WFResolution> getResolutions() {
        return this.fResolutions;
    }

    public WFAction getStartAction() {
        return this.fStartAction;
    }

    public void setStartAction(WFAction startAction) {
        this.fStartAction = startAction;
        this.notifyListeners(DEFAULTACTIONS_PROPERTY, this);
    }

    public WFAction getResolveAction() {
        return this.fResolveAction;
    }

    public void setResolveAction(WFAction resolveAction) {
        this.fResolveAction = resolveAction;
        this.notifyListeners(DEFAULTACTIONS_PROPERTY, this);
    }

    public WFAction getReopenAction() {
        return this.fReopenAction;
    }

    public void setReopenAction(WFAction reopenAction) {
        this.fReopenAction = reopenAction;
        this.notifyListeners(DEFAULTACTIONS_PROPERTY, this);
    }

    @Override
    public String getName() {
        return this.fName;
    }

    public String getId() {
        return this.fId;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public void setName(String name) {
        this.fName = name;
        this.notifyListeners(WORKFLOW_PROPERTY, this);
    }

    public void setDescription(String description) {
        this.fDescription = description;
        this.notifyListeners(WORKFLOW_PROPERTY, this);
    }

    public void addWFChangeListener(WFChangeListener listener) {
        this.fChangeListeners.add(listener);
    }

    public void removeWFChangeListener(WFChangeListener listener) {
        this.fChangeListeners.remove(listener);
    }

    public void notifyListeners(String property, Object changed) {
        WFChangeEvent event = new WFChangeEvent(property, changed);
        for (WFChangeListener listener : this.fChangeListeners) {
            listener.wfChanged(event);
        }
    }

    public String generateResolutionId() {
        ++this.fMaxResolutionId;
        int id = this.fMaxResolutionId;
        return String.valueOf(this.getId()) + RESOLUTION_PREFIX + id;
    }

    public String generateStateId() {
        ++this.fMaxStateId;
        int id = this.fMaxStateId;
        return String.valueOf(this.getId()) + STATE_PREFIX + id;
    }

    public String generateActionId() {
        ++this.fMaxActionId;
        int id = this.fMaxActionId;
        return String.valueOf(this.getId()) + ".action.a" + id;
    }

    public WFWorkflow duplicate(String id) {
        WFWorkflow flow = new WFWorkflow(NLS.bind((String)Messages.WFWorkflow_COPY_OF, (Object)this.fName, (Object[])new Object[0]), id, this.fDescription);
        HashMap<String, Object> newStates = new HashMap<String, Object>();
        for (WFState s : this.fStates) {
            WFState fs = new WFState(flow, flow.generateStateId(), s.getName(), s.getDescription(), s.getIcon(), s.getGroup(), s.getShowResolution());
            newStates.put(s.getId(), fs);
            flow.addState(fs);
        }
        HashMap<String, WFAction> newActions = new HashMap<String, WFAction>();
        for (WFAction a : this.fActions) {
            WFAction fa = new WFAction(flow, flow.generateActionId(), a.getName(), a.getDescription(), a.getIcon());
            newActions.put(a.getId(), fa);
            flow.addAction(fa);
        }
        HashMap<String, WFResolution> newResolutions = new HashMap<String, WFResolution>();
        for (WFResolution r : this.fResolutions) {
            WFResolution fr = new WFResolution(flow, flow.generateResolutionId(), r.getName(), r.getDescription(), r.getIcon());
            newResolutions.put(r.getId(), fr);
            flow.addResolution(fr);
        }
        for (WFState s : this.fStates) {
            WFState newState = (WFState)newStates.get(s.getId());
            for (WFAction a : s.getActions()) {
                newState.addAction((WFAction)newActions.get(a.getId()));
            }
        }
        for (WFAction a : this.fActions) {
            WFAction newAction = (WFAction)newActions.get(a.getId());
            for (WFResolution r : a.getResolutions()) {
                newAction.addResolution((WFResolution)newResolutions.get(r.getId()));
            }
            newAction.setTargetState((WFState)newStates.get(a.getTargetState().getId()));
        }
        if (this.fStartAction != null) {
            flow.setStartAction((WFAction)newActions.get(this.fStartAction.getId()));
        }
        if (this.fReopenAction != null) {
            flow.setReopenAction((WFAction)newActions.get(this.fReopenAction.getId()));
        }
        if (this.fResolveAction != null) {
            flow.setResolveAction((WFAction)newActions.get(this.fResolveAction.getId()));
        }
        return flow;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WFAction {
        private String fId;
        private String fName;
        private String fDescription;
        private String fIcon;
        private WFState fTargetState;
        private List<WFResolution> fResolutions = new ArrayList<WFResolution>();
        private WFWorkflow fFlow;

        public WFAction(WFWorkflow workflow, String id, String name, String description, String icon) {
            this.fId = id;
            this.fName = name;
            this.fDescription = description;
            this.fIcon = icon;
            this.fFlow = workflow;
        }

        public String getName() {
            return this.fName;
        }

        public void setName(String name) {
            this.fName = name;
            this.fFlow.notifyListeners(WFWorkflow.ACTIONS_PROPERTY, this);
        }

        public String getId() {
            return this.fId;
        }

        public WFState getTargetState() {
            return this.fTargetState;
        }

        public void setTargetState(WFState target) {
            this.fTargetState = target;
            this.fFlow.notifyListeners(WFWorkflow.ACTIONS_PROPERTY, target);
        }

        public String getDescription() {
            return this.fDescription;
        }

        public void setDescription(String description) {
            this.fDescription = description;
            this.fFlow.notifyListeners(WFWorkflow.ACTIONS_PROPERTY, this);
        }

        public String getIcon() {
            return this.fIcon;
        }

        public void setIcon(String icon) {
            this.fIcon = icon;
            this.fFlow.notifyListeners(WFWorkflow.ACTIONS_PROPERTY, this);
        }

        public List<WFResolution> getResolutions() {
            return this.fResolutions;
        }

        public void removeResolution(WFResolution resolution) {
            if (this.fResolutions.remove(resolution)) {
                this.fFlow.notifyListeners(WFWorkflow.ACTIONS_PROPERTY, resolution);
            }
        }

        public void addResolution(WFResolution resolution) {
            this.fResolutions.add(resolution);
            this.fFlow.notifyListeners(WFWorkflow.ACTIONS_PROPERTY, resolution);
        }
    }

    public static class WFChangeEvent {
        private Object fData;
        private String fProperty;

        public WFChangeEvent(String property, Object data) {
            this.fProperty = property;
            this.fData = data;
        }

        public boolean affects(String property) {
            return property.equals(this.fProperty);
        }

        public Object getData() {
            return this.fData;
        }
    }

    public static interface WFChangeListener {
        public void wfChanged(WFChangeEvent var1);
    }

    public static class WFResolution
    extends ModeledElement {
        private String fId;
        private String fName;
        private String fDescription;
        private String fIcon;
        private WFWorkflow fFlow;

        public WFResolution(WFWorkflow workflow, String id, String name, String description, String icon) {
            this.fId = id;
            this.fName = name;
            this.fDescription = description;
            this.fIcon = icon;
            this.fFlow = workflow;
        }

        public String getName() {
            return this.fName;
        }

        public void setName(String name) {
            this.fName = name;
            this.fFlow.notifyListeners(WFWorkflow.RESOLUTIONS_PROPERTY, this);
        }

        public String getId() {
            return this.fId;
        }

        public String getDescription() {
            return this.fDescription;
        }

        public void setDescription(String description) {
            this.fDescription = description;
            this.fFlow.notifyListeners(WFWorkflow.RESOLUTIONS_PROPERTY, this);
        }

        public String getIcon() {
            return this.fIcon;
        }

        public void setIcon(String icon) {
            this.fIcon = icon;
            this.fFlow.notifyListeners(WFWorkflow.RESOLUTIONS_PROPERTY, this);
        }

        public String getIdentifier() {
            return this.getId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WFState
    extends ModeledElement {
        private String fId;
        private String fName;
        private String fDescription;
        private String fIcon;
        private String fGroup;
        private boolean fShowresolution;
        private List<WFAction> fActions = new ArrayList<WFAction>();
        private WFWorkflow fFlow;

        public WFState(WFWorkflow workflow, String id, String name, String description, String icon, String group, boolean showResolution) {
            this.fId = id;
            this.fName = name;
            this.fDescription = description;
            this.fIcon = icon;
            this.fGroup = group;
            this.fShowresolution = showResolution;
            this.fFlow = workflow;
        }

        public void addAction(WFAction action) {
            if (action != null) {
                this.fActions.add(action);
            }
            this.fFlow.notifyListeners(WFWorkflow.STATES_PROPERTY, action);
        }

        public List<WFAction> getActions() {
            return this.fActions;
        }

        @Override
        public String getName() {
            return this.fName;
        }

        public void setName(String name) {
            this.fName = name;
            this.fFlow.notifyListeners(WFWorkflow.STATES_PROPERTY, this);
        }

        @Override
        public String getIdentifier() {
            return this.fId;
        }

        public String getId() {
            return this.getIdentifier();
        }

        public String getDescription() {
            return this.fDescription;
        }

        public void setDescription(String description) {
            this.fDescription = description;
            this.fFlow.notifyListeners(WFWorkflow.STATES_PROPERTY, this);
        }

        public String getIcon() {
            return this.fIcon;
        }

        public void setIcon(String icon) {
            this.fIcon = icon;
            this.fFlow.notifyListeners(WFWorkflow.STATES_PROPERTY, this);
        }

        public String getGroup() {
            return this.fGroup;
        }

        public void setGroup(String group) {
            this.fGroup = group;
            this.fFlow.notifyListeners(WFWorkflow.STATES_PROPERTY, this);
        }

        public boolean getShowResolution() {
            return this.fShowresolution;
        }

        public void setShowResolution(boolean show) {
            this.fShowresolution = show;
            this.fFlow.notifyListeners(WFWorkflow.STATES_PROPERTY, this);
        }
    }
}

