/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow;

import com.ibm.icu.text.Collator;
import com.ibm.team.process.client.workingcopies.IProcessContainerWorkingCopy;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AspectEditorUtil;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IDirtyStateTracker;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IPrefixProvider;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ProcessAttachmentIconSelectionDialog;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.SimpleTableLabelProvider;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WFWorkflow;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowAspectEditor;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowEditorPart;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ResolutionsPart
extends TeamFormPart {
    private WFWorkflow fWorkflow;
    private TableViewer fResolutionViewer;
    private Button fAddResolution;
    private WFWorkflow.WFChangeListener fWFChangedListener = new WFWorkflow.WFChangeListener(){

        public void wfChanged(final WFWorkflow.WFChangeEvent event) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (event.affects("resolutions") && ResolutionsPart.this.fResolutionViewer != null && !ResolutionsPart.this.fResolutionViewer.getControl().isDisposed()) {
                        ResolutionsPart.this.fResolutionViewer.refresh();
                        if (event.getData() instanceof WFWorkflow.WFResolution) {
                            ResolutionsPart.this.fResolutionViewer.setSelection((ISelection)new StructuredSelection(event.getData()), true);
                            ResolutionsPart.this.fResolutionViewer.getTable().setFocus();
                        }
                    } else if (event.affects("workflow") && ResolutionsPart.this.fResolutionViewer != null && !ResolutionsPart.this.fResolutionViewer.getControl().isDisposed() && event.getData() instanceof WFWorkflow.WFResolution) {
                        ResolutionsPart.this.fResolutionViewer.refresh();
                        ResolutionsPart.this.fResolutionViewer.setSelection((ISelection)new StructuredSelection(event.getData()), true);
                        ResolutionsPart.this.fResolutionViewer.getTable().setFocus();
                        ResolutionsPart.this.fReflowableContainer.needReflow();
                    }
                }
            });
        }
    };
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private IDirtyStateTracker fTracker;
    private IPrefixProvider fPrefixProvider;
    private WorkflowAspectEditor fReflowableContainer;
    private static final int RES_COL_NAME = 0;
    private static final int RES_COL_DESC = 1;
    private static final String NAME_LABEL = Messages.ResolutionsPart_NAME_LABEL;
    private static final String DESC_LABEL = Messages.ResolutionsPart_DESCRIPTION_LABEL;
    private static final Map<String, Integer> RES_PROP_COL = new HashMap<String, Integer>();

    static {
        RES_PROP_COL.put(NAME_LABEL, 0);
        RES_PROP_COL.put(DESC_LABEL, 1);
    }

    ResolutionsPart(IPrefixProvider prefixProvider, IDirtyStateTracker tracker, WorkflowAspectEditor reflowable) {
        this.fPrefixProvider = prefixProvider;
        this.fTracker = tracker;
        this.fReflowableContainer = reflowable;
    }

    private void setDirty() {
        this.fTracker.setDirty();
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    public void createContent(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        this.createResolutionViewer(parent);
    }

    private void createResolutionViewer(Composite parent) {
        FormToolkit toolkit = this.getSite().getToolkit();
        Composite comp = toolkit.createComposite(parent, 0);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout g = new GridLayout(2, false);
        g.marginWidth = 0;
        comp.setLayout((Layout)g);
        Table t = new Table(comp, 67586);
        t.setHeaderVisible(true);
        t.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = t.getItemHeight() * 6;
        t.setLayoutData((Object)data);
        TableColumn c = new TableColumn(t, 0);
        c.setWidth(150);
        c.setResizable(true);
        c.setText(NAME_LABEL);
        c = new TableColumn(t, 0);
        c.setWidth(250);
        c.setResizable(true);
        c.setText(DESC_LABEL);
        this.fResolutionViewer = new TableViewer(t);
        this.fResolutionViewer.setColumnProperties(new String[]{NAME_LABEL, DESC_LABEL});
        this.fResolutionViewer.setLabelProvider((IBaseLabelProvider)new SimpleTableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof WFWorkflow.WFResolution) {
                    WFWorkflow.WFResolution res = (WFWorkflow.WFResolution)element;
                    switch (columnIndex) {
                        case 0: {
                            return res.getName();
                        }
                        case 1: {
                            return res.getDescription();
                        }
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                if (element instanceof WFWorkflow.WFResolution) {
                    WFWorkflow.WFResolution res = (WFWorkflow.WFResolution)element;
                    if (columnIndex == 0 && res.getIcon() != null) {
                        return this.getImage(element, res.getIcon());
                    }
                }
                return null;
            }

            protected IProcessContainerWorkingCopy getProcessContainer() {
                return ResolutionsPart.this.fPrefixProvider.getProcessContainer();
            }

            protected ResourceManager getResourceManager() {
                return ResolutionsPart.this.fResourceManager;
            }
        });
        this.fResolutionViewer.setContentProvider((IContentProvider)new WorkflowEditorPart.SimpleContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof WFWorkflow) {
                    return ((WFWorkflow)inputElement).getResolutions().toArray();
                }
                return null;
            }
        });
        Composite buttonBar = new Composite(comp, 0);
        data = new GridData(16384, 1, false, false);
        buttonBar.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginTop = this.fResolutionViewer.getTable().getHeaderHeight();
        buttonBar.setLayout((Layout)layout);
        final Button removeResolution = toolkit.createButton(buttonBar, Messages.ResolutionsPart_REMOVE, 0x800000);
        removeResolution.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        removeResolution.setEnabled(false);
        removeResolution.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ResolutionsPart.this.fResolutionViewer.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)ResolutionsPart.this.fResolutionViewer.getSelection();
                    for (Object o : sel.toList()) {
                        if (!(o instanceof WFWorkflow.WFResolution)) continue;
                        ResolutionsPart.this.fWorkflow.removeResolution((WFWorkflow.WFResolution)o);
                        ResolutionsPart.this.setDirty();
                    }
                }
            }
        });
        final Collator coll = Collator.getInstance();
        coll.setStrength(1);
        this.fResolutionViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof WFWorkflow.WFResolution && e2 instanceof WFWorkflow.WFResolution) {
                    return coll.compare(((WFWorkflow.WFResolution)e1).getName(), ((WFWorkflow.WFResolution)e2).getName());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.fAddResolution = toolkit.createButton(buttonBar, Messages.ResolutionsPart_ADD, 0x800000);
        this.fAddResolution.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fAddResolution.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddEditResolutionDialog d = new AddEditResolutionDialog(Display.getCurrent().getActiveShell(), Messages.ResolutionsPart_ADD_RESOLUTION, null, null, null, ResolutionsPart.this.fPrefixProvider, ResolutionsPart.this.fResourceManager);
                if (d.open() == 0) {
                    String name = d.getName();
                    String description = d.getDescription();
                    String iconUrl = d.getIconUrl();
                    ResolutionsPart.this.fWorkflow.addResolution(new WFWorkflow.WFResolution(ResolutionsPart.this.fWorkflow, ResolutionsPart.this.fWorkflow.generateResolutionId(), name, description, iconUrl));
                    ResolutionsPart.this.setDirty();
                }
            }
        });
        final Button editResolution = toolkit.createButton(buttonBar, Messages.ResolutionsPart_EDIT, 0x800000);
        editResolution.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        editResolution.setEnabled(false);
        editResolution.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResolutionsPart.this.editResolution();
            }
        });
        this.fResolutionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeResolution.setEnabled(!ResolutionsPart.this.fResolutionViewer.getSelection().isEmpty());
                editResolution.setEnabled(((IStructuredSelection)ResolutionsPart.this.fResolutionViewer.getSelection()).size() == 1);
            }
        });
        this.fResolutionViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (((IStructuredSelection)ResolutionsPart.this.fResolutionViewer.getSelection()).size() == 1) {
                    ResolutionsPart.this.editResolution();
                }
            }
        });
        this.updateEnablement();
        Utils.updateColumnWidths((Table)this.fResolutionViewer.getTable(), (int[])new int[]{-1, 1});
    }

    private void editResolution() {
        WFWorkflow.WFResolution res = (WFWorkflow.WFResolution)((IStructuredSelection)this.fResolutionViewer.getSelection()).getFirstElement();
        AddEditResolutionDialog d = new AddEditResolutionDialog(Display.getCurrent().getActiveShell(), Messages.ResolutionsPart_EDIT_RESOLUTION, res.getName(), res.getDescription(), res.getIcon(), this.fPrefixProvider, this.fResourceManager);
        if (d.open() == 0) {
            String name = d.getName();
            String description = d.getDescription();
            String iconUrl = d.getIconUrl();
            if (!name.equals(res.getName())) {
                res.setName(name);
                this.setDirty();
            }
            if (!AspectEditorUtil.equals(description, res.getDescription())) {
                res.setDescription(description);
                this.setDirty();
            }
            if (!AspectEditorUtil.equals(iconUrl, res.getIcon())) {
                res.setIcon(iconUrl);
                this.setDirty();
            }
        }
    }

    private void updateEnablement() {
        if (this.fAddResolution != null && !this.fAddResolution.isDisposed()) {
            this.fAddResolution.setEnabled(this.fWorkflow != null);
            this.fResolutionViewer.getControl().setEnabled(this.fWorkflow != null);
        }
    }

    public void setInput(Object input) {
        if (this.fWorkflow != null) {
            this.fWorkflow.removeWFChangeListener(this.fWFChangedListener);
        }
        if (input instanceof WFWorkflow) {
            this.fWorkflow = (WFWorkflow)input;
            this.fWorkflow.addWFChangeListener(this.fWFChangedListener);
            this.fResolutionViewer.setInput((Object)this.fWorkflow);
        } else {
            this.fWorkflow = null;
            this.fResolutionViewer.setInput(null);
        }
        this.updateEnablement();
    }

    public void dispose() {
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
        super.dispose();
    }

    private static class AddEditResolutionDialog
    extends ProcessAttachmentIconSelectionDialog {
        private Text fNameField;
        private Text fDescriptionField;
        private String fDescription;
        private String fName;

        protected AddEditResolutionDialog(Shell parentShell, String title, String name, String description, String iconUrl, IPrefixProvider prefixProvider, ResourceManager resourceManager) {
            super(parentShell, title, iconUrl, prefixProvider, resourceManager);
            this.fName = name;
            this.fDescription = description;
            this.setValidator(new ProcessAttachmentIconSelectionDialog.IDialogValidator(){

                public IStatus isValid() {
                    String n;
                    if ((AddEditResolutionDialog.this.fName == null || "".equals(AddEditResolutionDialog.this.fName.trim())) && AddEditResolutionDialog.this.fNameField != null && !AddEditResolutionDialog.this.fNameField.isDisposed() && (n = AddEditResolutionDialog.this.fNameField.getText()).trim().equals("")) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.ResolutionsPart_EMPTY_NAME);
                    }
                    if (AddEditResolutionDialog.this.getIconUrl() == null) {
                        return new Status(2, "com.ibm.team.workitem.ide.ui", Messages.ResolutionsPart_NO_ICON);
                    }
                    return Status.OK_STATUS;
                }
            });
        }

        protected void okPressed() {
            this.fName = this.fNameField.getText();
            super.okPressed();
        }

        protected void iconChanged() {
            this.validate();
        }

        public String getName() {
            return this.fName.trim();
        }

        public String getDescription() {
            if (this.fDescription != null) {
                return this.fDescription.trim();
            }
            return this.fDescription;
        }

        protected void createUpperDialogPart(Composite parent) {
            Label l = new Label(parent, 0);
            l.setText(Messages.ResolutionsPart_NAME);
            l.setLayoutData((Object)new GridData());
            this.fNameField = new Text(parent, 2048);
            if (this.fName != null) {
                this.fNameField.setText(this.fName);
            }
            this.fNameField.setLayoutData((Object)new GridData(4, 4, true, false));
            this.fNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddEditResolutionDialog.this.fName = AddEditResolutionDialog.this.fNameField.getText();
                    AddEditResolutionDialog.this.validate();
                }
            });
            l = new Label(parent, 0);
            l.setText(Messages.ResolutionsPart_DESCRIPTION);
            l.setLayoutData((Object)new GridData(4, 128, false, false));
            this.fDescriptionField = new Text(parent, 2112);
            if (this.fDescription != null) {
                this.fDescriptionField.setText(this.fDescription);
            }
            GridData data = new GridData(4, 4, true, false);
            GC gc = new GC((Drawable)l);
            data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)2);
            gc.dispose();
            this.fDescriptionField.setLayoutData((Object)data);
            this.fDescriptionField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddEditResolutionDialog.this.fDescription = AddEditResolutionDialog.this.fDescriptionField.getText();
                }
            });
        }
    }
}

