/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow;

import com.ibm.icu.text.Collator;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.process.client.workingcopies.IProcessContainerWorkingCopy;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AspectEditorUtil;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IDirtyStateTracker;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IPrefixProvider;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ProcessAttachmentIconSelectionDialog;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.SimpleTableLabelProvider;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WFWorkflow;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowAspectEditor;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowEditorPart;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedCombo;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ActionsPart
extends TeamFormPart {
    private WFWorkflow fWorkflow;
    private TableViewer fActionViewer;
    private CheckboxTableViewer fResolutionsViewer;
    private static final int ACT_COL_NAME = 0;
    private static final int ACT_COL_STATE = 1;
    private static final int ACT_COL_DESC = 2;
    private static final int RES_COL_SET = 0;
    private static final int RES_COL_NAME = 1;
    private static final String NAME_LABEL = Messages.ActionsPart_NAME_LABEL;
    private static final String DESC_LABEL = Messages.ActionsPart_DESCRIPTION_LABEL;
    private static final String STATE_LABEL = Messages.ActionsPart_STATE_LABEL;
    private static final String RESOLUTION_LABEL = Messages.ActionsPart_RESOLUTION_LABEL;
    private static final String SET_LABEL = Messages.ActionsPart_SET_LABEL;
    private static final Map<String, Integer> ACT_PROP_COL = new HashMap<String, Integer>();
    private WFWorkflow.WFChangeListener fWFChangedListener = new WFWorkflow.WFChangeListener(){

        public void wfChanged(final WFWorkflow.WFChangeEvent event) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (event.affects("resolutions") && ActionsPart.this.fActionViewer != null && !ActionsPart.this.fActionViewer.getControl().isDisposed()) {
                        ActionsPart.this.fResolutionsViewer.refresh();
                    } else if (event.affects("states") && ActionsPart.this.fActionViewer != null && !ActionsPart.this.fActionViewer.getControl().isDisposed()) {
                        ActionsPart.this.fActionViewer.refresh();
                    } else if (event.affects("actions") && ActionsPart.this.fActionViewer != null && !ActionsPart.this.fActionViewer.getControl().isDisposed()) {
                        ActionsPart.this.fActionViewer.refresh();
                        if (event.getData() instanceof WFWorkflow.WFAction) {
                            ActionsPart.this.fActionViewer.setSelection((ISelection)new StructuredSelection(event.getData()), true);
                            ActionsPart.this.fActionViewer.getTable().setFocus();
                        }
                        ActionsPart.this.fResolutionsViewer.refresh();
                    } else if (event.affects("workflow") && ActionsPart.this.fActionViewer != null && !ActionsPart.this.fActionViewer.getControl().isDisposed()) {
                        if (event.getData() instanceof WFWorkflow.WFAction) {
                            ActionsPart.this.fActionViewer.refresh();
                            ActionsPart.this.fActionViewer.setSelection((ISelection)new StructuredSelection(event.getData()), true);
                            ActionsPart.this.fActionViewer.getTable().setFocus();
                            ActionsPart.this.fReflowableContainer.needReflow();
                        } else if (event.getData() instanceof WFWorkflow.WFResolution) {
                            ActionsPart.this.fResolutionsViewer.refresh();
                            ActionsPart.this.fReflowableContainer.needReflow();
                        }
                    }
                }
            });
        }
    };
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private IPrefixProvider fPrefixProvider;
    private IDirtyStateTracker fTracker;
    private WorkflowAspectEditor fReflowableContainer;

    static {
        ACT_PROP_COL.put(NAME_LABEL, 0);
        ACT_PROP_COL.put(DESC_LABEL, 2);
        ACT_PROP_COL.put(STATE_LABEL, 1);
    }

    ActionsPart(IPrefixProvider prefixProvider, IDirtyStateTracker tracker, WorkflowAspectEditor reflowable) {
        this.fPrefixProvider = prefixProvider;
        this.fTracker = tracker;
        this.fReflowableContainer = reflowable;
    }

    private void setDirty() {
        this.fTracker.setDirty();
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    public void createContent(Composite parent) {
        GridLayout layout = new GridLayout(4, false);
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        this.createActionViewer(parent);
        this.createButtons(parent);
        this.createResolutionsViewer(parent);
        this.updateEnablement();
    }

    private void createButtons(Composite parent) {
        FormToolkit toolkit = this.getSite().getToolkit();
        Composite buttonBar = new Composite(parent, 0);
        GridData data = new GridData(16384, 1, false, false);
        buttonBar.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginTop = this.fActionViewer.getTable().getHeaderHeight();
        buttonBar.setLayout((Layout)layout);
        final Button removeAction = toolkit.createButton(buttonBar, Messages.ActionsPart_REMOVE, 0x800000);
        removeAction.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        removeAction.setEnabled(false);
        removeAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ActionsPart.this.fActionViewer.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)ActionsPart.this.fActionViewer.getSelection();
                    for (Object o : sel.toList()) {
                        if (!(o instanceof WFWorkflow.WFAction)) continue;
                        ActionsPart.this.fWorkflow.removeAction((WFWorkflow.WFAction)o);
                        ActionsPart.this.setDirty();
                    }
                }
            }
        });
        final Button editAction = toolkit.createButton(buttonBar, Messages.ActionsPart_EDIT, 0x800000);
        editAction.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        editAction.setEnabled(false);
        editAction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionsPart.this.editAction();
            }
        });
        this.fActionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeAction.setEnabled(!ActionsPart.this.fActionViewer.getSelection().isEmpty());
                editAction.setEnabled(((IStructuredSelection)ActionsPart.this.fActionViewer.getSelection()).size() == 1);
            }
        });
        Composite fill = toolkit.createComposite(parent, 0);
        data = new GridData();
        data.widthHint = 0;
        fill.setLayoutData((Object)data);
    }

    private void editAction() {
        WFWorkflow.WFAction act = (WFWorkflow.WFAction)((IStructuredSelection)this.fActionViewer.getSelection()).getFirstElement();
        AddEditActionDialog d = new AddEditActionDialog(Display.getCurrent().getActiveShell(), Messages.ActionsPart_EDIT_ACTION, act.getName(), act.getDescription(), act.getIcon(), act.getTargetState().getName(), this.fPrefixProvider, this.fResourceManager);
        if (d.open() == 0) {
            String name = d.getName();
            String description = d.getDescription();
            String iconUrl = d.getIconUrl();
            if (!name.equals(act.getName())) {
                act.setName(name);
                this.setDirty();
            }
            if (!AspectEditorUtil.equals(description, act.getDescription())) {
                act.setDescription(description);
                this.setDirty();
            }
            if (!AspectEditorUtil.equals(iconUrl, act.getIcon())) {
                act.setIcon(iconUrl);
                this.setDirty();
            }
        }
    }

    private WFWorkflow.WFAction getSelectedAction() {
        if (this.fActionViewer.getSelection() instanceof IStructuredSelection && ((IStructuredSelection)this.fActionViewer.getSelection()).getFirstElement() instanceof WFWorkflow.WFAction) {
            return (WFWorkflow.WFAction)((IStructuredSelection)this.fActionViewer.getSelection()).getFirstElement();
        }
        return null;
    }

    private void createResolutionsViewer(Composite parent) {
        Composite comp = this.getSite().getToolkit().createComposite(parent, 0);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout g = new GridLayout();
        g.marginWidth = 0;
        comp.setLayout((Layout)g);
        Table t = new Table(comp, 67616);
        t.setHeaderVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = t.getItemHeight() * 6;
        t.setLayoutData((Object)data);
        TableColumn c = new TableColumn(t, 0);
        c.setWidth(30);
        c.setResizable(true);
        c.setText(SET_LABEL);
        c = new TableColumn(t, 0);
        c.setWidth(150);
        c.setResizable(true);
        c.setText(RESOLUTION_LABEL);
        this.fResolutionsViewer = new CheckboxTableViewer(t);
        this.fResolutionsViewer.setColumnProperties(new String[]{SET_LABEL, NAME_LABEL});
        this.fResolutionsViewer.setLabelProvider((IBaseLabelProvider)new SimpleTableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof WFWorkflow.WFResolution && columnIndex == 1) {
                    return ((WFWorkflow.WFResolution)element).getName();
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            protected IProcessContainerWorkingCopy getProcessContainer() {
                return ActionsPart.this.fPrefixProvider.getProcessContainer();
            }

            protected ResourceManager getResourceManager() {
                return ActionsPart.this.fResourceManager;
            }
        });
        this.fResolutionsViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    ActionsPart.this.getSelectedAction().addResolution((WFWorkflow.WFResolution)event.getElement());
                    ActionsPart.this.setDirty();
                } else {
                    ActionsPart.this.getSelectedAction().removeResolution((WFWorkflow.WFResolution)event.getElement());
                    ActionsPart.this.setDirty();
                }
            }
        });
        this.fResolutionsViewer.setContentProvider((IContentProvider)new WorkflowEditorPart.SimpleContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof WFWorkflow) {
                    return ((WFWorkflow)inputElement).getResolutions().toArray();
                }
                return null;
            }
        });
        final Collator coll = Collator.getInstance();
        coll.setStrength(1);
        this.fResolutionsViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof WFWorkflow.WFResolution && e2 instanceof WFWorkflow.WFResolution) {
                    return coll.compare(((WFWorkflow.WFResolution)e1).getName(), ((WFWorkflow.WFResolution)e2).getName());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.fActionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ActionsPart.this.updateEnablement();
                ActionsPart.this.updateChecked();
            }
        });
        Utils.updateColumnWidths((Table)this.fResolutionsViewer.getTable(), (int[])new int[]{-1, 1});
    }

    private void updateChecked() {
        if (((IStructuredSelection)this.fActionViewer.getSelection()).size() == 1) {
            this.fResolutionsViewer.setCheckedElements(this.getSelectedAction().getResolutions().toArray());
        } else {
            this.fResolutionsViewer.setCheckedElements(new Object[0]);
        }
    }

    private void createActionViewer(Composite parent) {
        Composite comp = this.getSite().getToolkit().createComposite(parent, 0);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout g = new GridLayout();
        g.marginWidth = 0;
        comp.setLayout((Layout)g);
        Table t = new Table(comp, 67586);
        t.setHeaderVisible(true);
        t.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = t.getItemHeight() * 6;
        t.setLayoutData((Object)data);
        TableColumn c = new TableColumn(t, 0);
        c.setWidth(150);
        c.setResizable(true);
        c.setText(NAME_LABEL);
        c = new TableColumn(t, 0);
        c.setWidth(120);
        c.setResizable(true);
        c.setText(STATE_LABEL);
        c = new TableColumn(t, 0);
        c.setWidth(150);
        c.setResizable(true);
        c.setText(DESC_LABEL);
        this.fActionViewer = new TableViewer(t);
        this.fActionViewer.setColumnProperties(new String[]{NAME_LABEL, STATE_LABEL, DESC_LABEL});
        this.fActionViewer.setLabelProvider((IBaseLabelProvider)new SimpleTableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof WFWorkflow.WFAction) {
                    WFWorkflow.WFAction act = (WFWorkflow.WFAction)element;
                    switch (columnIndex) {
                        case 0: {
                            return act.getName();
                        }
                        case 2: {
                            return act.getDescription();
                        }
                        case 1: {
                            if (act.getTargetState() != null) {
                                return act.getTargetState().getName();
                            }
                            return null;
                        }
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                if (element instanceof WFWorkflow.WFAction) {
                    WFWorkflow.WFAction act = (WFWorkflow.WFAction)element;
                    if (columnIndex == 0) {
                        if (act.getIcon() != null) {
                            return this.getImage(element, act.getIcon());
                        }
                    } else if (columnIndex == 1 && act.getTargetState() != null && act.getTargetState().getIcon() != null) {
                        return this.getImage(element, act.getTargetState().getIcon());
                    }
                }
                return null;
            }

            protected IProcessContainerWorkingCopy getProcessContainer() {
                return ActionsPart.this.fPrefixProvider.getProcessContainer();
            }

            protected ResourceManager getResourceManager() {
                return ActionsPart.this.fResourceManager;
            }
        });
        this.fActionViewer.setContentProvider((IContentProvider)new WorkflowEditorPart.SimpleContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof WFWorkflow) {
                    return ((WFWorkflow)inputElement).getActions().toArray();
                }
                return null;
            }
        });
        final Collator coll = Collator.getInstance();
        coll.setStrength(1);
        this.fActionViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof WFWorkflow.WFAction && e2 instanceof WFWorkflow.WFAction) {
                    return coll.compare(((WFWorkflow.WFAction)e1).getName(), ((WFWorkflow.WFAction)e2).getName());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.fActionViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (((IStructuredSelection)ActionsPart.this.fActionViewer.getSelection()).size() == 1) {
                    ActionsPart.this.editAction();
                }
            }
        });
        Utils.updateColumnWidths((Table)this.fActionViewer.getTable(), (int[])new int[]{-1, -1, 1});
    }

    private void updateEnablement() {
        if (this.fActionViewer != null && !this.fActionViewer.getControl().isDisposed()) {
            this.fActionViewer.getControl().setEnabled(this.fWorkflow != null);
            this.fResolutionsViewer.getControl().setEnabled(this.fWorkflow != null && ((IStructuredSelection)this.fActionViewer.getSelection()).size() == 1);
        }
    }

    public void setInput(Object input) {
        if (this.fWorkflow != null) {
            this.fWorkflow.removeWFChangeListener(this.fWFChangedListener);
        }
        if (input instanceof WFWorkflow) {
            this.fWorkflow = (WFWorkflow)input;
            this.fWorkflow.addWFChangeListener(this.fWFChangedListener);
            this.fActionViewer.setInput((Object)this.fWorkflow);
            this.fResolutionsViewer.setInput((Object)this.fWorkflow);
            this.fResolutionsViewer.getTable().getColumn(0).pack();
        } else {
            this.fWorkflow = null;
            this.fActionViewer.setInput(null);
            this.fResolutionsViewer.setInput(null);
        }
        this.updateEnablement();
    }

    public void dispose() {
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
        super.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AddEditActionDialog
    extends ProcessAttachmentIconSelectionDialog {
        private static final String STATE_NONE = Messages.ActionsPart_NONE;
        private Text fNameField;
        private Text fDescriptionField;
        private String fDescription;
        private String fName;
        private String fTarget;
        private List<WFWorkflow.WFState> fAllStates;
        private WFWorkflow.WFState fState;
        private IPrefixProvider fPrefixProvider;
        private ResourceManager fResourceManager;

        protected AddEditActionDialog(Shell parentShell, String title, List<WFWorkflow.WFState> states, IPrefixProvider prefixProvider, ResourceManager resourceManager) {
            super(parentShell, title, null, prefixProvider, resourceManager);
            this.fPrefixProvider = prefixProvider;
            this.fResourceManager = resourceManager;
            this.fAllStates = states != null ? new ArrayList<WFWorkflow.WFState>(states) : new ArrayList<WFWorkflow.WFState>();
            this.setValidator(new ProcessAttachmentIconSelectionDialog.IDialogValidator(){

                public IStatus isValid() {
                    String n;
                    if ((AddEditActionDialog.this.fName == null || "".equals(AddEditActionDialog.this.fName.trim())) && AddEditActionDialog.this.fNameField != null && !AddEditActionDialog.this.fNameField.isDisposed() && (n = AddEditActionDialog.this.fNameField.getText()).trim().equals("")) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.ActionsPart_EMPTY_NAME);
                    }
                    if (AddEditActionDialog.this.fState == null) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.ActionsPart_NO_TARGET_STATE);
                    }
                    if (AddEditActionDialog.this.getIconUrl() == null) {
                        return new Status(2, "com.ibm.team.workitem.ide.ui", Messages.ActionsPart_NO_ICON);
                    }
                    return Status.OK_STATUS;
                }
            });
        }

        protected AddEditActionDialog(Shell parentShell, String title, String name, String description, String iconUrl, String target, IPrefixProvider prefixProvider, ResourceManager resourceManager) {
            super(parentShell, title, iconUrl, prefixProvider, resourceManager);
            this.fName = name;
            this.fDescription = description;
            this.fTarget = target;
            this.setValidator(new ProcessAttachmentIconSelectionDialog.IDialogValidator(){

                public IStatus isValid() {
                    String n;
                    if ((AddEditActionDialog.this.fName == null || "".equals(AddEditActionDialog.this.fName.trim())) && AddEditActionDialog.this.fNameField != null && !AddEditActionDialog.this.fNameField.isDisposed() && (n = AddEditActionDialog.this.fNameField.getText()).trim().equals("")) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.ActionsPart_EMPTY_NAME);
                    }
                    if (AddEditActionDialog.this.getIconUrl() == null) {
                        return new Status(2, "com.ibm.team.workitem.ide.ui", Messages.ActionsPart_NO_ICON);
                    }
                    return Status.OK_STATUS;
                }
            });
        }

        protected void okPressed() {
            this.fName = this.fNameField.getText();
            super.okPressed();
        }

        @Override
        protected void iconChanged() {
            this.validate();
        }

        public String getName() {
            return this.fName.trim();
        }

        public String getDescription() {
            if (this.fDescription != null) {
                return this.fDescription.trim();
            }
            return this.fDescription;
        }

        public WFWorkflow.WFState getTargetState() {
            return this.fState;
        }

        @Override
        protected void createUpperDialogPart(Composite parent) {
            Label l = new Label(parent, 0);
            l.setText(Messages.ActionsPart_NAME);
            l.setLayoutData((Object)new GridData());
            this.fNameField = new Text(parent, 2048);
            if (this.fName != null) {
                this.fNameField.setText(this.fName);
            }
            this.fNameField.setLayoutData((Object)new GridData(4, 4, true, false));
            this.fNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddEditActionDialog.this.fName = AddEditActionDialog.this.fNameField.getText();
                    AddEditActionDialog.this.validate();
                }
            });
            l = new Label(parent, 0);
            l.setText(Messages.ActionsPart_DESCRIPTION);
            l.setLayoutData((Object)new GridData(4, 128, false, false));
            this.fDescriptionField = new Text(parent, 2112);
            if (this.fDescription != null) {
                this.fDescriptionField.setText(this.fDescription);
            }
            GridData data = new GridData(4, 4, true, false);
            GC gc = new GC((Drawable)l);
            data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)2);
            gc.dispose();
            this.fDescriptionField.setLayoutData((Object)data);
            this.fDescriptionField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddEditActionDialog.this.fDescription = AddEditActionDialog.this.fDescriptionField.getText();
                }
            });
            l = new Label(parent, 0);
            l.setText(Messages.ActionsPart_STATE);
            l.setLayoutData((Object)new GridData(4, 128, false, false));
            if (this.fTarget == null) {
                final DecoratedCombo combo = new DecoratedCombo(parent, 8, 1);
                combo.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        Object value = combo.getValue();
                        if (STATE_NONE.equals(value)) {
                            AddEditActionDialog.this.fState = null;
                        } else {
                            AddEditActionDialog.this.fState = (WFWorkflow.WFState)value;
                        }
                        AddEditActionDialog.this.validate();
                    }
                });
                combo.setValue((Object)STATE_NONE);
                combo.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        if (element instanceof String) {
                            return (String)element;
                        }
                        return ((WFWorkflow.WFState)element).getName();
                    }

                    public Image getImage(Object element) {
                        WFWorkflow.WFState state;
                        if (element instanceof WFWorkflow.WFState && (state = (WFWorkflow.WFState)element).getIcon() != null) {
                            return this.getImage(element, state.getIcon());
                        }
                        return JazzResources.getImage((ResourceManager)AddEditActionDialog.this.fResourceManager, (ImageDescriptor)ImagePool.EMPTY_ICON, null);
                    }

                    private Image getImage(final Object element, String iconPath) {
                        return AspectEditorUtil.getImage(AddEditActionDialog.this.fPrefixProvider.getProcessContainer(), iconPath, AddEditActionDialog.this.fResourceManager, new Runnable(){

                            public void run() {
                                this.fireChanged(element);
                            }
                        });
                    }

                    private void fireChanged(Object element) {
                        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, element));
                    }
                });
                Object[] valueSet = new Object[this.fAllStates.size() + 1];
                valueSet[0] = STATE_NONE;
                int i = 1;
                for (WFWorkflow.WFState s : this.fAllStates) {
                    valueSet[i] = s;
                    ++i;
                }
                combo.setValueSet(valueSet);
            } else {
                l = new Label(parent, 0);
                l.setText(this.fTarget);
                l.setLayoutData((Object)new GridData(4, 128, true, false));
            }
        }
    }
}

