/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.type;

import com.ibm.team.process.client.workingcopies.IProcessContainerWorkingCopy;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AspectEditorUtil;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IDirtyStateTracker;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IPrefixProvider;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ProcessAttachmentIconSelectionDialog;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.SimpleTableLabelProvider;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.editorpresentation.EditorIdBinding;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeAspectEditor;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeCategory;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeCategoryChangeListener;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeManager;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypePart
extends TeamFormPart {
    private TypeCategory fCategory;
    private TableViewer fTypeViewer;
    private Button fAddType;
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private static final int COL_NAME = 0;
    private static final int COL_ID = 1;
    private static final String ID_LABEL = Messages.TypePart_ID_LABEL;
    private static final String NAME_LABEL = Messages.TypePart_NAME_LABEL;
    private static final String ALIAS_LABEL = Messages.TypePart_ALIAS_LABEL;
    private IDirtyStateTracker fTracker;
    private IPrefixProvider fPrefixProvider;
    private TypeCategoryChangeListener fListener = new TypeCategoryChangeListener(){

        public void typeCategoryChanged(final TypeCategory.TypeCategoryChangeEvent e) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    TypePart.this.fTypeViewer.refresh();
                    TypePart.this.fAliasViewer.refresh();
                    if (e.getChanged() instanceof TypeCategory.Type) {
                        TypePart.this.fTypeViewer.setSelection((ISelection)new StructuredSelection(e.getChanged()));
                        TypePart.this.fTypeViewer.getTable().setFocus();
                    }
                    if (e.elementCountChanged()) {
                        TypePart.this.fReflowableContainer.needReflow();
                    }
                }
            });
        }
    };
    private TableViewer fAliasViewer;
    private List<EditorIdBinding> fBindings;
    private TypeAspectEditor fReflowableContainer;
    private Set<TypeCategory.Type> fEditableTypes;

    TypePart(IPrefixProvider prefixProvider, IDirtyStateTracker tracker, TypeAspectEditor reflowableControl) {
        this.fTracker = tracker;
        this.fPrefixProvider = prefixProvider;
        this.fReflowableContainer = reflowableControl;
    }

    private void setDirty() {
        this.fTracker.setDirty();
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    public void createContent(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        this.createViewer(parent);
    }

    private void createViewer(Composite parent) {
        FormToolkit toolkit = this.getSite().getToolkit();
        Composite comp = toolkit.createComposite(parent, 0);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout g = new GridLayout(5, false);
        g.marginWidth = 0;
        comp.setLayout((Layout)g);
        Table t = new Table(comp, 67586);
        t.setHeaderVisible(true);
        t.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = t.getItemHeight() * 6;
        data.widthHint = 210;
        t.setLayoutData((Object)data);
        TableColumn c = new TableColumn(t, 0);
        c.setWidth(160);
        c.setResizable(true);
        c.setText(NAME_LABEL);
        c = new TableColumn(t, 0);
        c.setWidth(150);
        c.setResizable(true);
        c.setText(ID_LABEL);
        this.fTypeViewer = new TableViewer(t);
        this.fTypeViewer.setColumnProperties(new String[]{ID_LABEL, NAME_LABEL});
        this.fTypeViewer.setLabelProvider((IBaseLabelProvider)new SimpleTableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof TypeCategory.Type) {
                    if (columnIndex == 0) {
                        return ((TypeCategory.Type)element).getName();
                    }
                    if (columnIndex == 1) {
                        return ((TypeCategory.Type)element).getId();
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                if (element instanceof TypeCategory.Type && columnIndex == 0 && ((TypeCategory.Type)element).getIcon() != null) {
                    return this.getImage(element, ((TypeCategory.Type)element).getIcon());
                }
                return null;
            }

            protected IProcessContainerWorkingCopy getProcessContainer() {
                return TypePart.this.fPrefixProvider.getProcessContainer();
            }

            protected ResourceManager getResourceManager() {
                return TypePart.this.fResourceManager;
            }
        });
        this.fTypeViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof TypeCategory) {
                    return ((TypeCategory)inputElement).getTypes().toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        Composite buttonBar = new Composite(comp, 0);
        data = new GridData(16384, 1, false, false);
        buttonBar.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginTop = this.fTypeViewer.getTable().getHeaderHeight();
        buttonBar.setLayout((Layout)layout);
        final Button removeType = toolkit.createButton(buttonBar, Messages.TypePart_REMOVE, 0x800000);
        removeType.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        removeType.setEnabled(false);
        removeType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TypePart.this.fTypeViewer.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)TypePart.this.fTypeViewer.getSelection();
                    for (Object o : sel.toList()) {
                        if (!(o instanceof TypeCategory.Type)) continue;
                        String editor = null;
                        for (EditorIdBinding binding : TypePart.this.fBindings) {
                            if (binding.getType() == null || !binding.getType().getId().equals(((TypeCategory.Type)o).getId())) continue;
                            editor = binding.getEditorId();
                            break;
                        }
                        if (editor != null) {
                            String message = NLS.bind((String)Messages.TypePart_REMOVING_WARNING, (Object)((TypeCategory.Type)o).getName(), (Object[])new Object[]{editor});
                            if (!MessageDialog.openConfirm((Shell)TypePart.this.fTypeViewer.getControl().getShell(), (String)Messages.TypePart_REMOVE_TYPE, (String)message)) continue;
                        }
                        TypePart.this.fCategory.removeType((TypeCategory.Type)o);
                        TypePart.this.fCategory.getSortedTypes().remove(o);
                        TypePart.this.setDirty();
                        TypePart.this.fReflowableContainer.updateLabels();
                    }
                }
            }
        });
        this.fAddType = toolkit.createButton(buttonBar, Messages.TypePart_ADD, 0x800000);
        this.fAddType.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fAddType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddEditTypeDialog d = new AddEditTypeDialog(Display.getCurrent().getActiveShell(), Messages.TypePart_ADD_TYPE, null, null, null, TypePart.this.getExistingTypes(), TypePart.this.fPrefixProvider, TypePart.this.fResourceManager, true);
                if (d.open() == 0) {
                    String id = d.getId();
                    String name = d.getName();
                    String icon = d.getIconUrl();
                    TypeCategory typeCategory = TypePart.this.fCategory;
                    typeCategory.getClass();
                    TypeCategory.Type type = typeCategory.new TypeCategory.Type(id, name, icon, null, new ArrayList<String>());
                    if (TypePart.this.fTypeViewer.getSelection().isEmpty()) {
                        TypePart.this.fCategory.addType(type);
                        TypePart.this.fCategory.getSortedTypes().add(TypeManager.getNextIndex(TypePart.this.fCategory.getSortedTypes(), TypePart.this.fCategory.getTypes(), null), type);
                    } else {
                        TypePart.this.fCategory.addType(type, (TypeCategory.Type)((IStructuredSelection)TypePart.this.fTypeViewer.getSelection()).getFirstElement());
                        TypePart.this.fCategory.getSortedTypes().add(TypeManager.getNextIndex(TypePart.this.fCategory.getSortedTypes(), TypePart.this.fCategory.getTypes(), (TypeCategory.Type)((IStructuredSelection)TypePart.this.fTypeViewer.getSelection()).getFirstElement()), type);
                    }
                    TypePart.this.fEditableTypes.add(type);
                    TypePart.this.setDirty();
                    TypePart.this.fReflowableContainer.updateLabels();
                }
            }
        });
        final Button editType = toolkit.createButton(buttonBar, Messages.TypePart_EDIT, 0x800000);
        editType.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        editType.setEnabled(false);
        editType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TypePart.this.editType();
            }
        });
        Composite fill = toolkit.createComposite(comp, 0);
        data = new GridData();
        data.widthHint = 0;
        fill.setLayoutData((Object)data);
        t = new Table(comp, 67586);
        t.setHeaderVisible(true);
        data = new GridData(4, 4, true, true);
        data.minimumHeight = t.getItemHeight() * 6;
        data.widthHint = 120;
        t.setLayoutData((Object)data);
        c = new TableColumn(t, 0);
        c.setWidth(120);
        c.setResizable(true);
        c.setText(ALIAS_LABEL);
        this.fAliasViewer = new TableViewer(t);
        this.fAliasViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof String) {
                    return (String)element;
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.fAliasViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof TypeCategory.Type) {
                    return ((TypeCategory.Type)inputElement).getAliases().toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fTypeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (TypePart.this.fTypeViewer.getSelection().isEmpty() || ((IStructuredSelection)TypePart.this.fTypeViewer.getSelection()).size() != 1) {
                    TypePart.this.fAliasViewer.setInput(null);
                } else {
                    TypePart.this.fAliasViewer.setInput(((IStructuredSelection)TypePart.this.fTypeViewer.getSelection()).getFirstElement());
                }
            }
        });
        buttonBar = new Composite(comp, 0);
        data = new GridData(16384, 1, false, false);
        buttonBar.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.marginTop = this.fAliasViewer.getTable().getHeaderHeight();
        buttonBar.setLayout((Layout)layout);
        final Button removeAlias = toolkit.createButton(buttonBar, Messages.TypePart_REMOVE, 0x800000);
        removeAlias.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        removeAlias.setEnabled(false);
        removeAlias.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TypePart.this.fAliasViewer.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)TypePart.this.fAliasViewer.getSelection();
                    for (Object o : sel.toList()) {
                        if (!(o instanceof String)) continue;
                        TypeCategory.Type t = (TypeCategory.Type)TypePart.this.fAliasViewer.getInput();
                        t.removeAlias((String)o);
                        TypePart.this.setDirty();
                    }
                }
            }
        });
        this.fAliasViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeAlias.setEnabled(!TypePart.this.fAliasViewer.getSelection().isEmpty());
            }
        });
        final Button addAlias = toolkit.createButton(buttonBar, Messages.TypePart_ADD, 0x800000);
        addAlias.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        addAlias.setEnabled(false);
        addAlias.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog d = new InputDialog(Display.getDefault().getActiveShell(), Messages.TypePart_ADD_ALIAS, Messages.TypePart_ENTER_ALIAS_NAME, "", new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText == null || newText.trim().equals("")) {
                            return Messages.TypePart_EMPTY_ALIAS;
                        }
                        return null;
                    }
                });
                if (d.open() != 0) {
                    return;
                }
                String name = d.getValue();
                TypeCategory.Type t = (TypeCategory.Type)TypePart.this.fAliasViewer.getInput();
                t.addAlias(name);
                TypePart.this.setDirty();
            }
        });
        this.fTypeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeType.setEnabled(!TypePart.this.fTypeViewer.getSelection().isEmpty());
                editType.setEnabled(((IStructuredSelection)TypePart.this.fTypeViewer.getSelection()).size() == 1);
                addAlias.setEnabled(((IStructuredSelection)TypePart.this.fTypeViewer.getSelection()).size() == 1);
            }
        });
        this.fTypeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (((IStructuredSelection)TypePart.this.fTypeViewer.getSelection()).size() == 1) {
                    TypePart.this.editType();
                }
            }
        });
        this.updateEnablement();
        if (!"gtk".equals(SWT.getPlatform())) {
            Utils.updateColumnWidths((Table)this.fTypeViewer.getTable(), (int[])new int[]{-1, 1});
            Utils.updateColumnWidths((Table)this.fAliasViewer.getTable(), (int[])new int[]{1});
        }
    }

    private void editType() {
        if (this.fTypeViewer.getSelection() instanceof IStructuredSelection) {
            TypeCategory.Type t = (TypeCategory.Type)((IStructuredSelection)this.fTypeViewer.getSelection()).getFirstElement();
            AddEditTypeDialog d = new AddEditTypeDialog(Display.getCurrent().getActiveShell(), Messages.TypePart_EDIT_TYPE, t.getId(), t.getName(), t.getIcon(), this.getExistingTypes(), this.fPrefixProvider, this.fResourceManager, this.fEditableTypes.contains(t));
            if (d.open() == 0) {
                String name = d.getName();
                String icon = d.getIconUrl();
                if (!t.getName().equals(name)) {
                    t.setName(name);
                    this.setDirty();
                    this.fReflowableContainer.updateLabels();
                }
                String id = d.getId();
                if (this.fEditableTypes.contains(t) && !t.getId().equals(id)) {
                    t.setId(id);
                    this.setDirty();
                }
                if (t.getIcon() == null && icon != null) {
                    t.setIcon(icon);
                    t.setDimmedIcon(null);
                    this.setDirty();
                } else if (t.getIcon() != null && !t.getIcon().equals(icon)) {
                    t.setIcon(icon);
                    t.setDimmedIcon(null);
                    this.setDirty();
                }
            }
        }
    }

    private void updateEnablement() {
        if (this.fAddType != null && !this.fAddType.isDisposed()) {
            this.fAddType.setEnabled(this.fCategory != null);
            this.fTypeViewer.getControl().setEnabled(this.fCategory != null);
            this.fAliasViewer.getControl().setEnabled(this.fCategory != null);
        }
    }

    void setBindings(List<EditorIdBinding> bindings) {
        this.fBindings = bindings;
    }

    private Set<TypeCategory.Type> getExistingTypes() {
        HashSet<TypeCategory.Type> types = new HashSet<TypeCategory.Type>();
        for (TypeCategory tc : this.fReflowableContainer.getAllCategories()) {
            types.addAll(tc.getTypes());
        }
        return types;
    }

    public void setInput(Object input) {
        if (this.fCategory != null) {
            this.fCategory.removeListener(this.fListener);
        }
        this.fEditableTypes = new HashSet<TypeCategory.Type>();
        if (input instanceof TypeCategory) {
            this.fCategory = (TypeCategory)input;
            this.fTypeViewer.setInput((Object)this.fCategory);
            this.fCategory.addListener(this.fListener);
        } else {
            this.fCategory = null;
            this.fTypeViewer.setInput(null);
        }
        this.updateEnablement();
    }

    public void dispose() {
        if (this.fCategory != null) {
            this.fCategory.removeListener(this.fListener);
        }
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
        super.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AddEditTypeDialog
    extends ProcessAttachmentIconSelectionDialog {
        private Text fIdField;
        private Text fNameField;
        private String fId;
        private String fOldId;
        private String fName;
        private boolean fEditable;
        private Set<TypeCategory.Type> fTypes;
        private ModifyListener fProposeIdListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = AddEditTypeDialog.this.fNameField.getText();
                String[] split = text.split("[\\s:/\\\\]");
                if (split.length > 0) {
                    text = split[0].toLowerCase();
                    AddEditTypeDialog.this.fIdField.setText(text);
                }
            }
        };

        protected AddEditTypeDialog(Shell parentShell, String title, String id, String name, String iconUrl, Set<TypeCategory.Type> existingTypes, IPrefixProvider prefixProvider, ResourceManager resourceManager, boolean editable) {
            super(parentShell, title, iconUrl, prefixProvider, resourceManager);
            this.fName = name;
            this.fId = id;
            this.fOldId = id;
            this.fEditable = editable;
            this.fTypes = existingTypes == null ? new HashSet<TypeCategory.Type>() : new HashSet<TypeCategory.Type>(existingTypes);
            this.setValidator(new ProcessAttachmentIconSelectionDialog.IDialogValidator(){

                public IStatus isValid() {
                    int severity;
                    if (AddEditTypeDialog.this.fName == null || "".equals(AddEditTypeDialog.this.fName.trim())) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.TypePart_EMPTY_NAME);
                    }
                    if (!AspectEditorUtil.isValidLength(AddEditTypeDialog.this.fName, 250)) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", NLS.bind((String)Messages.TypePart_NAME_TOO_LONG, (Object)250, (Object[])new Object[0]));
                    }
                    int n = severity = AddEditTypeDialog.this.fEditable ? 4 : 2;
                    if (AddEditTypeDialog.this.fId == null || "".equals(AddEditTypeDialog.this.fId.trim())) {
                        return new Status(severity, "com.ibm.team.workitem.ide.ui", Messages.TypePart_EMPTY_ID);
                    }
                    if (AddEditTypeDialog.this.fId.split("\\s").length > 1) {
                        return new Status(severity, "com.ibm.team.workitem.ide.ui", Messages.TypePart_NO_WHITESPACES);
                    }
                    if (!AspectEditorUtil.isValidPathSegment(AddEditTypeDialog.this.fId)) {
                        return new Status(severity, "com.ibm.team.workitem.ide.ui", Messages.TypePart_NO_PATH_CHARACTERS);
                    }
                    if (!AspectEditorUtil.isValidLength(AddEditTypeDialog.this.fId, 250)) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", NLS.bind((String)Messages.TypePart_ID_TOO_LONG, (Object)250, (Object[])new Object[0]));
                    }
                    if (!AspectEditorUtil.equals(AddEditTypeDialog.this.fId, AddEditTypeDialog.this.fOldId)) {
                        for (TypeCategory.Type t : AddEditTypeDialog.this.fTypes) {
                            if (!AddEditTypeDialog.this.fId.equals(t.getId())) continue;
                            return new Status(severity, "com.ibm.team.workitem.ide.ui", Messages.TypePart_DUPLICATE_TYPE);
                        }
                    }
                    if (AddEditTypeDialog.this.getIconUrl() == null) {
                        return new Status(2, "com.ibm.team.workitem.ide.ui", Messages.TypePart_NO_ICON);
                    }
                    return Status.OK_STATUS;
                }
            });
        }

        protected void okPressed() {
            super.okPressed();
        }

        @Override
        protected void iconChanged() {
            this.validate();
        }

        public String getName() {
            return this.fName.trim();
        }

        public String getId() {
            return this.fId.trim();
        }

        @Override
        protected void createUpperDialogPart(Composite parent) {
            Label l = new Label(parent, 0);
            l.setText(Messages.TypePart_NAME);
            l.setLayoutData((Object)new GridData());
            this.fNameField = new Text(parent, 2048);
            if (this.fName != null) {
                this.fNameField.setText(this.fName);
            }
            this.fNameField.setLayoutData((Object)new GridData(4, 4, true, false));
            this.fNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddEditTypeDialog.this.fName = AddEditTypeDialog.this.fNameField.getText().trim();
                    AddEditTypeDialog.this.validate();
                }
            });
            if (this.fEditable && this.fOldId == null) {
                this.fNameField.addModifyListener(this.fProposeIdListener);
            }
            l = new Label(parent, 0);
            l.setText(Messages.TypePart_ID);
            l.setLayoutData((Object)new GridData());
            this.fIdField = new Text(parent, 2048);
            if (this.fId != null) {
                this.fIdField.setText(this.fId);
            }
            this.fIdField.setLayoutData((Object)new GridData(4, 4, true, false));
            this.fIdField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddEditTypeDialog.this.fId = AddEditTypeDialog.this.fIdField.getText().trim();
                    AddEditTypeDialog.this.validate();
                }
            });
            if (this.fEditable) {
                this.fIdField.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusGained(FocusEvent e) {
                        AddEditTypeDialog.this.fNameField.removeModifyListener(AddEditTypeDialog.this.fProposeIdListener);
                    }
                });
            }
            if (!this.fEditable) {
                this.fIdField.setEditable(false);
                this.fIdField.setEnabled(false);
            }
        }
    }
}

