/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.type;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.internal.common.model.AbstractElement;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeCategory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeManager {
    public static final String ID = "id";
    public static final String CATEGORY = "category";
    public static final String NAME = "name";
    public static final String ICON = "icon";
    private static final String DIMMEDICON = "dimmedicon";
    private static final String ALIAS = "alias";
    public static final String TYPE = "type";
    private static final String READ_ONLY = "readOnly";
    private static final String CUSTOMATTRIBUTES = "customAttributes";
    private static final String CUSTOMATTRIBUTE = "customAttribute";
    private static final String ATTRIBUTE_DEFINITION = "attributeDefinition";
    private static final String ATTRIBUTE_DEFINITIONS = "attributeDefinitions";

    public static List<TypeCategory> readTypeCategories(ModelElement configurationElement) {
        ArrayList<TypeCategory> typeCategories = new ArrayList<TypeCategory>();
        ArrayList<TypeCategory.Type> sortedTypes = new ArrayList<TypeCategory.Type>();
        ArrayList<TypeCategory.CustomAttribute> attributeDefinitions = new ArrayList<TypeCategory.CustomAttribute>();
        if (configurationElement != null) {
            for (ModelElement element : configurationElement.getChildElements()) {
                if (!ATTRIBUTE_DEFINITIONS.equals(element.getName()) || element.getChildElements() == null) continue;
                for (ModelElement e : element.getChildElements()) {
                    if (!ATTRIBUTE_DEFINITION.equals(e.getName())) continue;
                    TypeManager.readAttributeDefinition(e, attributeDefinitions);
                }
            }
            for (ModelElement element : configurationElement.getChildElements()) {
                if (TYPE.equals(element.getName())) {
                    TypeManager.readType(element, typeCategories, sortedTypes);
                    continue;
                }
                if (!CUSTOMATTRIBUTES.equals(element.getName())) continue;
                TypeManager.readCustomAttributes(element, typeCategories, attributeDefinitions);
            }
        }
        for (TypeCategory cat : typeCategories) {
            cat.setSortedTypes(sortedTypes);
            cat.setAttributeDefinitions(attributeDefinitions);
        }
        return typeCategories;
    }

    private static void readType(ModelElement element, List<TypeCategory> categories, List<TypeCategory.Type> sortedTypes) {
        String dimmedIcon;
        String cat = element.getAttribute(CATEGORY);
        TypeCategory category = null;
        for (TypeCategory tc : categories) {
            if (!tc.getIdentifier().equals(cat)) continue;
            category = tc;
            break;
        }
        if (category == null) {
            category = new TypeCategory(cat);
            categories.add(category);
        }
        String id = element.getAttribute(ID);
        String name = element.getAttribute(NAME);
        String icon = element.getAttribute(ICON);
        if ("".equals(icon)) {
            icon = null;
        }
        if ("".equals(dimmedIcon = element.getAttribute(DIMMEDICON))) {
            dimmedIcon = null;
        }
        ArrayList<String> aliases = new ArrayList<String>();
        if (element.getChildElements() != null) {
            for (ModelElement e : element.getChildElements()) {
                String alName;
                if (!ALIAS.equals(e.getName()) || (alName = e.getAttribute(NAME)) == null) continue;
                aliases.add(alName);
            }
        }
        TypeCategory typeCategory = category;
        typeCategory.getClass();
        TypeCategory.Type type = typeCategory.new TypeCategory.Type(id, name, icon, dimmedIcon, aliases);
        category.addType(type);
        sortedTypes.add(type);
    }

    private static void readAttributeDefinition(ModelElement element, List<TypeCategory.CustomAttribute> attributeDefinitions) {
        String id = element.getAttribute(ID);
        String name = element.getAttribute(NAME);
        String attributeType = element.getAttribute(TYPE);
        boolean isReadOnly = Boolean.valueOf(element.getAttribute(READ_ONLY));
        attributeDefinitions.add(new TypeCategory.CustomAttribute(id, name, attributeType, false, true, isReadOnly, element));
    }

    private static void readCustomAttributes(ModelElement element, List<TypeCategory> categories, List<TypeCategory.CustomAttribute> attributeDefinitions) {
        String cat = element.getAttribute(CATEGORY);
        TypeCategory category = null;
        for (TypeCategory tc : categories) {
            if (!tc.getIdentifier().equals(cat)) continue;
            category = tc;
            break;
        }
        if (category == null) {
            category = new TypeCategory(cat);
            categories.add(category);
        }
        if (element.getChildElements() != null) {
            for (ModelElement e : element.getChildElements()) {
                if (!CUSTOMATTRIBUTE.equals(e.getName())) continue;
                String id = e.getAttribute(ID);
                String name = e.getAttribute(NAME);
                String attributeType = e.getAttribute(TYPE);
                boolean isReadOnly = Boolean.valueOf(e.getAttribute(READ_ONLY));
                TypeCategory.CustomAttribute attr = TypeManager.findExistingAttribute(attributeDefinitions, id);
                if (attr == null) {
                    attr = new TypeCategory.CustomAttribute(id, name, attributeType, false, true, isReadOnly, e);
                }
                category.addCustomAttribute(attr);
            }
        }
    }

    static TypeCategory.CustomAttribute findExistingAttribute(List<TypeCategory.CustomAttribute> attributeDefinitions, String id) {
        for (TypeCategory.CustomAttribute c : attributeDefinitions) {
            if (!c.getId().equals(id)) continue;
            return c;
        }
        return null;
    }

    private static void writeType(IMemento parentMemento, TypeCategory.Type type, TypeCategory category) {
        IMemento memento = parentMemento.createChild(TYPE);
        memento.putString(ID, type.getId());
        memento.putString(CATEGORY, category.getIdentifier());
        memento.putString(NAME, type.getName());
        String icon = type.getIcon();
        if (icon == null) {
            icon = "";
        }
        memento.putString(ICON, icon);
        String dimmedIcon = type.getDimmedIcon();
        if (dimmedIcon != null) {
            memento.putString(DIMMEDICON, dimmedIcon);
        }
        for (String alias : type.getAliases()) {
            IMemento al = memento.createChild(ALIAS);
            al.putString(NAME, alias);
        }
    }

    private static void writeCustomAttribute(IMemento parentMemento, TypeCategory category) {
        IMemento memento = parentMemento.createChild(CUSTOMATTRIBUTES);
        memento.putString(CATEGORY, category.getIdentifier());
        for (TypeCategory.CustomAttribute attribute : category.getCustomAttributes()) {
            IMemento child = memento.createChild(CUSTOMATTRIBUTE);
            TypeManager.writeCustomAttribute(child, attribute);
        }
    }

    private static void writeCustomAttribute(IMemento memento, TypeCategory.CustomAttribute attribute) {
        memento.putString(ID, attribute.getId());
        memento.putString(NAME, attribute.getName());
        memento.putString(TYPE, attribute.getAttributeType());
    }

    private static void writeAttributeDefinition(IMemento memento, TypeCategory.CustomAttribute attribute) {
        IMemento definition = memento.createChild(ATTRIBUTE_DEFINITION);
        definition.putString(ID, attribute.getId());
        definition.putString(NAME, attribute.getName());
        definition.putString(TYPE, attribute.getAttributeType());
        if (attribute.isReadOnly()) {
            definition.putString(READ_ONLY, Boolean.TRUE.toString());
        }
        if (attribute.getElement() != null) {
            for (AbstractElement childElement : attribute.getElement().getChildElements()) {
                TypeManager.addToMemento(childElement, definition);
            }
        }
    }

    private static void addToMemento(AbstractElement element, IMemento memento) {
        IMemento childMemento = memento.createChild(element.getName());
        String[] stringArray = element.getAttributeNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attributeId = stringArray[n2];
            childMemento.putString(attributeId, element.getAttribute(attributeId));
            ++n2;
        }
        for (AbstractElement child : element.getChildElements()) {
            TypeManager.addToMemento(child, childMemento);
        }
    }

    public static void writeTypeCategories(IMemento memento, List<TypeCategory> categories) {
        List<TypeCategory.Type> sortedTypes = TypeManager.findSortedTypesList(categories);
        List<TypeCategory.CustomAttribute> attributeDefinitions = TypeManager.findAttributeDefinitions(categories);
        HashMap<TypeCategory.Type, TypeCategory> cache = new HashMap<TypeCategory.Type, TypeCategory>();
        for (TypeCategory c : categories) {
            for (TypeCategory.Type t : c.getTypes()) {
                cache.put(t, c);
            }
        }
        for (TypeCategory.Type t : sortedTypes) {
            TypeManager.writeType(memento, t, (TypeCategory)cache.get(t));
        }
        for (TypeCategory c : categories) {
            if (c.getCustomAttributes().isEmpty()) continue;
            TypeManager.writeCustomAttribute(memento, c);
        }
        if (!attributeDefinitions.isEmpty()) {
            IMemento defintions = memento.createChild(ATTRIBUTE_DEFINITIONS);
            for (TypeCategory.CustomAttribute a : attributeDefinitions) {
                TypeManager.writeAttributeDefinition(defintions, a);
            }
        }
    }

    static List<TypeCategory.Type> findSortedTypesList(List<TypeCategory> elements) {
        for (TypeCategory cat : elements) {
            if (cat.getSortedTypes() == null) continue;
            return cat.getSortedTypes();
        }
        return new ArrayList<TypeCategory.Type>();
    }

    static int getNextIndex(List<TypeCategory.Type> sortedTypes, List<TypeCategory.Type> typesOfTheVeryCategory, TypeCategory.Type element) {
        int index;
        if (element != null && (index = sortedTypes.indexOf(element)) > -1) {
            return index + 1;
        }
        index = -1;
        for (TypeCategory.Type t : typesOfTheVeryCategory) {
            if (sortedTypes.indexOf(t) <= index) continue;
            index = sortedTypes.indexOf(t);
        }
        if (index > -1) {
            return index + 1;
        }
        return sortedTypes.size();
    }

    static List<TypeCategory.CustomAttribute> findAttributeDefinitions(List<TypeCategory> elements) {
        for (TypeCategory cat : elements) {
            if (cat.getAttributeDefinitions() == null) continue;
            return cat.getAttributeDefinitions();
        }
        return new ArrayList<TypeCategory.CustomAttribute>();
    }
}

