/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.type;

import com.ibm.team.process.common.ModelElement;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AspectEditorUtil;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ModeledElement;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeCategoryChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeCategory
extends ModeledElement
implements TypeCategoryChangeListener {
    private Set<TypeCategoryChangeListener> fListeners = new HashSet<TypeCategoryChangeListener>();
    private String fCategoryId;
    private List<Type> fTypes;
    private List<CustomAttribute> fCustomAttributes;
    private List<CustomAttribute> fAttributeDefinitions;
    private List<Type> fSortedTypes;

    public TypeCategory(String categoryId) {
        this.fCategoryId = categoryId;
        this.fTypes = new ArrayList<Type>();
        this.fCustomAttributes = new ArrayList<CustomAttribute>();
    }

    public void addType(Type type) {
        this.fTypes.add(type);
        this.notifyListeners(this, true);
    }

    public void addType(Type type, Type beforeIt) {
        if (beforeIt != null && this.fTypes.indexOf(beforeIt) > -1) {
            this.fTypes.add(this.fTypes.indexOf(beforeIt) + 1, type);
        } else {
            this.fTypes.add(type);
        }
        this.notifyListeners(type, true);
    }

    public void removeType(Type type) {
        this.fTypes.remove(type);
        this.notifyListeners(type, true);
    }

    public List<Type> getTypes() {
        return this.fTypes;
    }

    public List<CustomAttribute> getCustomAttributes() {
        return this.fCustomAttributes;
    }

    public void addCustomAttribute(CustomAttribute customAttribute) {
        this.fCustomAttributes.add(customAttribute);
        customAttribute.addListener(this);
        this.notifyListeners(this, true);
    }

    public void addCustomAttribute(CustomAttribute customAttribute, CustomAttribute beforeIt) {
        if (beforeIt != null && this.fCustomAttributes.indexOf(beforeIt) > -1) {
            this.fCustomAttributes.add(this.fCustomAttributes.indexOf(beforeIt) + 1, customAttribute);
        } else {
            this.fCustomAttributes.add(customAttribute);
        }
        customAttribute.addListener(this);
        this.notifyListeners(customAttribute, true);
    }

    public void removeCustomAttribute(CustomAttribute customAttribute) {
        this.fCustomAttributes.remove(customAttribute);
        customAttribute.removeListener(this);
        this.notifyListeners(customAttribute, true);
    }

    public void addListener(TypeCategoryChangeListener listener) {
        this.fListeners.add(listener);
    }

    public void removeListener(TypeCategoryChangeListener listener) {
        this.fListeners.remove(listener);
    }

    public void notifyListeners(Object changed, boolean countChanged) {
        TypeCategoryChangeEvent event = new TypeCategoryChangeEvent(changed, countChanged);
        for (TypeCategoryChangeListener listener : this.fListeners) {
            listener.typeCategoryChanged(event);
        }
    }

    @Override
    public void typeCategoryChanged(TypeCategoryChangeEvent e) {
        for (TypeCategoryChangeListener listener : this.fListeners) {
            listener.typeCategoryChanged(e);
        }
    }

    @Override
    public String getIdentifier() {
        return this.fCategoryId;
    }

    @Override
    public String getName() {
        String name = AspectEditorUtil.getTypeCategoryDisplayName(this);
        if (name == null) {
            return super.getName();
        }
        return name;
    }

    void setSortedTypes(List<Type> sortedTypes) {
        this.fSortedTypes = sortedTypes;
    }

    List<Type> getSortedTypes() {
        return this.fSortedTypes;
    }

    public void setAttributeDefinitions(List<CustomAttribute> attributeDefinitions) {
        this.fAttributeDefinitions = attributeDefinitions;
    }

    public List<CustomAttribute> getAttributeDefinitions() {
        return this.fAttributeDefinitions;
    }

    public static class CustomAttribute {
        private String fId;
        private String fName;
        private String fAttributeType;
        private boolean fTypeModifyable;
        private boolean fCustomAttribute;
        private boolean fIsReadOnly;
        private ModelElement fElement;
        private Set<TypeCategoryChangeListener> fListeners = new HashSet<TypeCategoryChangeListener>();

        public CustomAttribute(String id, String name, String attributeType, boolean modifyableAttributeType, boolean customAttribute, boolean isReadOnly, ModelElement element) {
            this.fId = id;
            this.fName = name;
            this.fAttributeType = attributeType;
            this.fTypeModifyable = modifyableAttributeType;
            this.fCustomAttribute = customAttribute;
            this.fIsReadOnly = isReadOnly;
            this.fElement = element;
        }

        public boolean isTypeModifyable() {
            return this.fTypeModifyable;
        }

        public String getId() {
            return this.fId;
        }

        public String getName() {
            return this.fName;
        }

        public String getAttributeType() {
            return this.fAttributeType;
        }

        public void setId(String id) {
            this.fId = id;
            this.notifyListeners(this, false);
        }

        public void setName(String name) {
            this.fName = name;
            this.notifyListeners(this, false);
        }

        public void setAttributeType(String attributeType) {
            this.fAttributeType = attributeType;
            this.notifyListeners(this, false);
        }

        public void setIsReadOnly(boolean isReadOnly) {
            this.fIsReadOnly = isReadOnly;
        }

        public boolean isReadOnly() {
            return this.fIsReadOnly;
        }

        public boolean isCustomAttribute() {
            return this.fCustomAttribute;
        }

        ModelElement getElement() {
            return this.fElement;
        }

        public void addListener(TypeCategoryChangeListener listener) {
            this.fListeners.add(listener);
        }

        public void removeListener(TypeCategoryChangeListener listener) {
            this.fListeners.remove(listener);
        }

        public void notifyListeners(Object changed, boolean countChanged) {
            TypeCategoryChangeEvent event = new TypeCategoryChangeEvent(changed, countChanged);
            for (TypeCategoryChangeListener listener : this.fListeners) {
                listener.typeCategoryChanged(event);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Type
    extends ModeledElement {
        private String fId;
        private String fName;
        private String fIcon;
        private String fDimmedIcon;
        private List<String> fAliases;

        public void setId(String id) {
            this.fId = id;
            TypeCategory.this.notifyListeners(this, false);
        }

        public void setName(String name) {
            this.fName = name;
            TypeCategory.this.notifyListeners(this, false);
        }

        public void setIcon(String icon) {
            this.fIcon = icon;
            TypeCategory.this.notifyListeners(this, false);
        }

        public void setDimmedIcon(String dimmedIcon) {
            this.fDimmedIcon = dimmedIcon;
            TypeCategory.this.notifyListeners(this, false);
        }

        public Type(String id, String name, String icon, String dimmedIcon, List<String> aliases) {
            this.fId = id;
            this.fName = name;
            this.fIcon = icon;
            this.fDimmedIcon = dimmedIcon;
            this.fAliases = new ArrayList<String>();
            this.fAliases.addAll(aliases);
        }

        public String getId() {
            return this.fId;
        }

        @Override
        public String getName() {
            return this.fName;
        }

        public String getIcon() {
            return this.fIcon;
        }

        public String getDimmedIcon() {
            return this.fDimmedIcon;
        }

        public List<String> getAliases() {
            return this.fAliases;
        }

        public void addAlias(String alias) {
            this.fAliases.add(alias);
            TypeCategory.this.notifyListeners(this, false);
        }

        public void removeAlias(String alias) {
            this.fAliases.remove(alias);
            TypeCategory.this.notifyListeners(this, false);
        }

        @Override
        public String getIdentifier() {
            return this.getId();
        }
    }

    public static class TypeCategoryChangeEvent {
        private Object fChanged;
        private boolean fCountChanged;

        public TypeCategoryChangeEvent(Object changed, boolean elementCountChanged) {
            this.fChanged = changed;
            this.fCountChanged = elementCountChanged;
        }

        public Object getChanged() {
            return this.fChanged;
        }

        public boolean elementCountChanged() {
            return this.fCountChanged;
        }
    }
}

