/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.type;

import com.ibm.icu.text.Collator;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.workitem.common.model.AttributeType;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AspectEditorUtil;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IDirtyStateTracker;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ProcessAttachmentIconSelectionDialog;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeAspectEditor;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeCategory;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeCategoryChangeListener;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeManager;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedCombo;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomAttributesPart
extends TeamFormPart {
    private TypeCategory fCategory;
    private TableViewer fCustomViewer;
    private Button fAddAttr;
    private List<String> fEnumerationTypes = new ArrayList<String>();
    private Set<TypeCategory.CustomAttribute> fRepositoryAttributes = new HashSet<TypeCategory.CustomAttribute>();
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private IDirtyStateTracker fTracker;
    private TypeAspectEditor fReflowableContainer;
    private Set<TypeCategory.CustomAttribute> fEditableAttributes;
    private boolean fTemplate = false;
    private static final int COL_NAME = 0;
    private static final int COL_TYPE = 1;
    private static final int COL_ID = 2;
    private static final String ID_LABEL = Messages.CustomAttributesPart_ID_LABEL;
    private static final String NAME_LABEL = Messages.CustomAttributesPart_NAME_LABEL;
    private static final String TYPE_LABEL = Messages.CustomAttributesPart_TYPE_LABEL;
    private static final String NO_TYPE = Messages.CustomAttributesPart_NO_TYPE_ENTRY;
    private static final Map<String, Integer> PROP_COL = new HashMap<String, Integer>();
    private static final List<String> CUSTOMTYPES = new ArrayList<String>();
    private TypeCategoryChangeListener fListener = new TypeCategoryChangeListener(){

        public void typeCategoryChanged(final TypeCategory.TypeCategoryChangeEvent e) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    CustomAttributesPart.this.fCustomViewer.refresh();
                    if (e.getChanged() instanceof TypeCategory.CustomAttribute) {
                        CustomAttributesPart.this.fCustomViewer.setSelection((ISelection)new StructuredSelection(e.getChanged()));
                        CustomAttributesPart.this.fCustomViewer.getTable().setFocus();
                    }
                    if (e.elementCountChanged()) {
                        CustomAttributesPart.this.fReflowableContainer.needReflow();
                    }
                }
            });
        }
    };

    static {
        PROP_COL.put(ID_LABEL, 2);
        PROP_COL.put(NAME_LABEL, 0);
        PROP_COL.put(TYPE_LABEL, 1);
        for (AttributeType t : AttributeTypes.getAttributeTypes()) {
            if (!AttributeTypes.isSupportedCustomAttributeType((String)t.getIdentifier()) || AttributeTypes.isEnumerationAttributeType((String)t.getIdentifier())) continue;
            CUSTOMTYPES.add(t.getIdentifier());
        }
        CUSTOMTYPES.remove("duration");
    }

    public CustomAttributesPart(IDirtyStateTracker tracker, TypeAspectEditor reflowableControl) {
        this.fTracker = tracker;
        this.fReflowableContainer = reflowableControl;
    }

    private void setDirty() {
        this.fTracker.setDirty();
    }

    public void setTemplate(boolean template) {
        this.fTemplate = template;
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    public void createContent(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        this.createViewer(parent);
    }

    public void setEnumerationTypes(List<String> enumerationTypes) {
        this.fEnumerationTypes = enumerationTypes;
    }

    private List<String> getTypes() {
        ArrayList<String> cTypes = new ArrayList<String>();
        cTypes.addAll(CUSTOMTYPES);
        cTypes.addAll(this.fEnumerationTypes);
        Collections.sort(cTypes, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Collator.getInstance().compare(o1, o2);
            }
        });
        cTypes.add(0, NO_TYPE);
        return cTypes;
    }

    public void setRepositoryAttributes(Set<TypeCategory.CustomAttribute> repositoryAttributes) {
        this.fRepositoryAttributes = repositoryAttributes;
    }

    private Set<TypeCategory.CustomAttribute> getExistingAttributes() {
        HashSet<TypeCategory.CustomAttribute> attributes = new HashSet<TypeCategory.CustomAttribute>();
        for (TypeCategory tc : this.fReflowableContainer.getAllCategories()) {
            attributes.addAll(tc.getCustomAttributes());
        }
        for (TypeCategory.CustomAttribute repoAttribute : this.fRepositoryAttributes) {
            attributes.add(repoAttribute);
        }
        return attributes;
    }

    private Set<TypeCategory.CustomAttribute> getOtherExistingCustomAttributese() {
        HashMap<String, TypeCategory.CustomAttribute> map = new HashMap<String, TypeCategory.CustomAttribute>();
        for (TypeCategory tc : this.fReflowableContainer.getAllCategories()) {
            for (TypeCategory.CustomAttribute a : tc.getCustomAttributes()) {
                map.put(a.getId(), a);
            }
        }
        for (TypeCategory.CustomAttribute r : this.fRepositoryAttributes) {
            if (!r.isCustomAttribute()) continue;
            map.put(r.getId(), r);
        }
        for (TypeCategory.CustomAttribute a : this.fCategory.getCustomAttributes()) {
            map.remove(a.getId());
        }
        return new HashSet<TypeCategory.CustomAttribute>(map.values());
    }

    private void createViewer(Composite parent) {
        FormToolkit toolkit = this.getSite().getToolkit();
        Composite comp = toolkit.createComposite(parent, 0);
        GridData data = new GridData(4, 4, true, true);
        comp.setLayoutData((Object)data);
        GridLayout g = new GridLayout(2, false);
        g.marginWidth = 0;
        comp.setLayout((Layout)g);
        Table t = new Table(comp, 67586);
        t.setHeaderVisible(true);
        t.setLinesVisible(true);
        data = new GridData(4, 4, true, true);
        data.widthHint = 450;
        data.minimumHeight = t.getItemHeight() * 6;
        t.setLayoutData((Object)data);
        TableColumn c = new TableColumn(t, 0);
        c.setWidth(120);
        c.setResizable(true);
        c.setText(NAME_LABEL);
        c = new TableColumn(t, 0);
        c.setWidth(180);
        c.setResizable(true);
        c.setText(TYPE_LABEL);
        c = new TableColumn(t, 0);
        c.setWidth(150);
        c.setResizable(true);
        c.setText(ID_LABEL);
        this.fCustomViewer = new TableViewer(t);
        this.fCustomViewer.setColumnProperties(new String[]{NAME_LABEL, TYPE_LABEL, ID_LABEL});
        this.fCustomViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof TypeCategory.CustomAttribute) {
                    if (columnIndex == 0) {
                        return ((TypeCategory.CustomAttribute)element).getName();
                    }
                    if (columnIndex == 2) {
                        return ((TypeCategory.CustomAttribute)element).getId();
                    }
                    if (columnIndex == 1) {
                        String type = ((TypeCategory.CustomAttribute)element).getAttributeType();
                        if (type == null) {
                            type = NO_TYPE;
                        }
                        return AttributeTypes.getDisplayName(null, (String)type);
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.fCustomViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof TypeCategory) {
                    return ((TypeCategory)inputElement).getCustomAttributes().toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        Composite buttonBar = new Composite(comp, 0);
        data = new GridData(16384, 1, false, false);
        buttonBar.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginTop = this.fCustomViewer.getTable().getHeaderHeight();
        buttonBar.setLayout((Layout)layout);
        final Button removeAttr = toolkit.createButton(buttonBar, Messages.CustomAttributesPart_REMOVE, 0x800000);
        removeAttr.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        removeAttr.setEnabled(false);
        removeAttr.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CustomAttributesPart.this.fCustomViewer.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)CustomAttributesPart.this.fCustomViewer.getSelection();
                    for (Object o : sel.toList()) {
                        if (!(o instanceof TypeCategory.CustomAttribute)) continue;
                        CustomAttributesPart.this.fCategory.removeCustomAttribute((TypeCategory.CustomAttribute)o);
                        CustomAttributesPart.this.setDirty();
                        CustomAttributesPart.this.fReflowableContainer.updateRepositoryAttributes();
                    }
                }
            }
        });
        this.fAddAttr = toolkit.createButton(buttonBar, Messages.CustomAttributesPart_ADD, 0x800000);
        this.fAddAttr.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fAddAttr.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddEditCustomAttributeDialog d = new AddEditCustomAttributeDialog(Display.getCurrent().getActiveShell(), Messages.CustomAttributesPart_ADD_CUSTOM_ATTRIBUTE, null, null, null, CustomAttributesPart.this.getExistingAttributes(), CustomAttributesPart.this.getOtherExistingCustomAttributese(), CustomAttributesPart.this.getTypes(), true, CustomAttributesPart.this.fResourceManager);
                if (d.open() == 0) {
                    String id = d.getId();
                    String name = d.getName();
                    String type = d.getType();
                    List<TypeCategory.CustomAttribute> attributeDefinitions = TypeManager.findAttributeDefinitions(CustomAttributesPart.this.fReflowableContainer.getAllCategories());
                    TypeCategory.CustomAttribute customAttribute = TypeManager.findExistingAttribute(attributeDefinitions, id);
                    if (customAttribute == null) {
                        customAttribute = new TypeCategory.CustomAttribute(id, name, type, true, true, false, null);
                        attributeDefinitions.add(customAttribute);
                        CustomAttributesPart.this.fEditableAttributes.add(customAttribute);
                    }
                    if (CustomAttributesPart.this.fCustomViewer.getSelection().isEmpty()) {
                        CustomAttributesPart.this.fCategory.addCustomAttribute(customAttribute);
                    } else {
                        CustomAttributesPart.this.fCategory.addCustomAttribute(customAttribute, (TypeCategory.CustomAttribute)((IStructuredSelection)CustomAttributesPart.this.fCustomViewer.getSelection()).getFirstElement());
                    }
                    CustomAttributesPart.this.setDirty();
                }
            }
        });
        final Button editAttribute = toolkit.createButton(buttonBar, Messages.CustomAttributesPart_EDIT, 0x800000);
        editAttribute.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        editAttribute.setEnabled(false);
        editAttribute.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomAttributesPart.this.editAttribute();
            }
        });
        this.fCustomViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeAttr.setEnabled(!CustomAttributesPart.this.fCustomViewer.getSelection().isEmpty());
                editAttribute.setEnabled(((IStructuredSelection)CustomAttributesPart.this.fCustomViewer.getSelection()).size() == 1);
            }
        });
        this.fCustomViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (((IStructuredSelection)CustomAttributesPart.this.fCustomViewer.getSelection()).size() == 1) {
                    CustomAttributesPart.this.editAttribute();
                }
            }
        });
        this.updateEnablement();
        if (!"gtk".equals(SWT.getPlatform())) {
            Utils.updateColumnWidths((Table)this.fCustomViewer.getTable(), (int[])new int[]{-1, -1, 1});
        }
    }

    private void editAttribute() {
        if (this.fCustomViewer.getSelection() instanceof IStructuredSelection) {
            TypeCategory.CustomAttribute c = (TypeCategory.CustomAttribute)((IStructuredSelection)this.fCustomViewer.getSelection()).getFirstElement();
            boolean editable = this.fTemplate || this.fEditableAttributes.contains(c);
            AddEditCustomAttributeDialog d = new AddEditCustomAttributeDialog(Display.getCurrent().getActiveShell(), Messages.CustomAttributesPart_EDIT_CUSTOM_ATTRIBUTES, c.getId(), c.getName(), c.getAttributeType(), this.getExistingAttributes(), this.getOtherExistingCustomAttributese(), this.getTypes(), editable, this.fResourceManager);
            if (d.open() == 0) {
                String name = d.getName();
                if (!c.getName().equals(name)) {
                    c.setName(name);
                    this.setDirty();
                }
                String id = d.getId();
                if (editable && !c.getId().equals(id)) {
                    c.setId(id);
                    this.setDirty();
                }
                String type = d.getType();
                if (editable && !c.getAttributeType().equals(type)) {
                    c.setAttributeType(type);
                    this.setDirty();
                }
            }
        }
    }

    private void updateEnablement() {
        if (this.fAddAttr != null && !this.fAddAttr.isDisposed()) {
            this.fAddAttr.setEnabled(this.fCategory != null);
            this.fCustomViewer.getControl().setEnabled(this.fCategory != null);
        }
    }

    public void setInput(Object input) {
        if (this.fCategory != null) {
            this.fCategory.removeListener(this.fListener);
        }
        this.fEditableAttributes = new HashSet<TypeCategory.CustomAttribute>();
        if (input instanceof TypeCategory) {
            this.fCategory = (TypeCategory)input;
            this.fCustomViewer.setInput((Object)this.fCategory);
            this.fCategory.addListener(this.fListener);
        } else {
            this.fCategory = null;
            this.fCustomViewer.setInput(null);
        }
        this.updateEnablement();
    }

    public void dispose() {
        if (this.fCategory != null) {
            this.fCategory.removeListener(this.fListener);
        }
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
        super.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AddEditCustomAttributeDialog
    extends ProcessAttachmentIconSelectionDialog {
        protected static final String NONE = Messages.CustomAttributesPart_NONE;
        private Text fIdField;
        private Text fNameField;
        private String fName;
        private String fId;
        private String fOldId;
        private String fType;
        private boolean fEditable;
        private List<String> fTypes;
        private Set<TypeCategory.CustomAttribute> fAttributes;
        private Set<TypeCategory.CustomAttribute> fOtherAttributes;
        private ModifyListener fProposeIdListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String[] split = AddEditCustomAttributeDialog.this.fNameField.getText().split("[\\s:/\\\\]");
                if (split.length > 0) {
                    String text = split[0].toLowerCase();
                    AddEditCustomAttributeDialog.this.fIdField.setText(text);
                }
            }
        };
        private Group fReuse;
        private Group fNew;
        private DecoratedCombo fReuseCombo;
        private TypeCategory.CustomAttribute fReused;
        private boolean fIsReused;
        private DecoratedCombo fCombo;

        protected AddEditCustomAttributeDialog(Shell parentShell, String title, String id, String name, String type, Set<TypeCategory.CustomAttribute> existingAttributes, Set<TypeCategory.CustomAttribute> otherCustomAttributes, List<String> types, boolean editable, ResourceManager resourceManager) {
            super(parentShell, title, null, null, resourceManager);
            this.fName = name;
            this.fId = id;
            this.fOldId = id;
            this.fType = type;
            this.fEditable = editable;
            this.fAttributes = existingAttributes == null ? new HashSet<TypeCategory.CustomAttribute>() : new HashSet<TypeCategory.CustomAttribute>(existingAttributes);
            this.fOtherAttributes = otherCustomAttributes == null ? new HashSet<TypeCategory.CustomAttribute>() : new HashSet<TypeCategory.CustomAttribute>(otherCustomAttributes);
            this.fTypes = types == null ? new ArrayList<String>() : new ArrayList<String>(types);
            Collections.sort(this.fTypes, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if (NO_TYPE.equals(o1)) {
                        return -1;
                    }
                    if (NO_TYPE.equals(o2)) {
                        return 1;
                    }
                    return Collator.getInstance().compare(AttributeTypes.getDisplayName(null, (String)o1), AttributeTypes.getDisplayName(null, (String)o2));
                }
            });
            this.setValidator(new ProcessAttachmentIconSelectionDialog.IDialogValidator(){

                public IStatus isValid() {
                    if (!AddEditCustomAttributeDialog.this.fIsReused) {
                        int severity;
                        if (AddEditCustomAttributeDialog.this.fName == null || "".equals(AddEditCustomAttributeDialog.this.fName.trim())) {
                            return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.CustomAttributesPart_EMPTY_NAME);
                        }
                        if (!AspectEditorUtil.isValidLength(AddEditCustomAttributeDialog.this.fName, 250)) {
                            return new Status(4, "com.ibm.team.workitem.ide.ui", NLS.bind((String)Messages.CustomAttributesPart_NAME_TOO_LONG, (Object)250, (Object[])new Object[0]));
                        }
                        int n = severity = AddEditCustomAttributeDialog.this.fEditable ? 4 : 2;
                        if (AddEditCustomAttributeDialog.this.fId == null || "".equals(AddEditCustomAttributeDialog.this.fId.trim())) {
                            return new Status(severity, "com.ibm.team.workitem.ide.ui", Messages.CustomAttributesPart_EMPTY_ID);
                        }
                        if (AddEditCustomAttributeDialog.this.fId.split("\\s").length > 1) {
                            return new Status(severity, "com.ibm.team.workitem.ide.ui", Messages.CustomAttributesPart_NO_WHITESPACES);
                        }
                        if (!AspectEditorUtil.isValidPathSegment(AddEditCustomAttributeDialog.this.fId)) {
                            return new Status(severity, "com.ibm.team.workitem.ide.ui", Messages.CustomAttributesPart_NO_PATH_CHARACTERS);
                        }
                        if (!AspectEditorUtil.isValidLength(AddEditCustomAttributeDialog.this.fId, 250)) {
                            return new Status(4, "com.ibm.team.workitem.ide.ui", NLS.bind((String)Messages.CustomAttributesPart_ID_TOO_LONG, (Object)250, (Object[])new Object[0]));
                        }
                        if (!AspectEditorUtil.equals(AddEditCustomAttributeDialog.this.fId, AddEditCustomAttributeDialog.this.fOldId)) {
                            for (TypeCategory.CustomAttribute a : AddEditCustomAttributeDialog.this.fAttributes) {
                                if (!AddEditCustomAttributeDialog.this.fId.equals(a.getId())) continue;
                                return new Status(severity, "com.ibm.team.workitem.ide.ui", Messages.CustomAttributesPart_DUPLICATE_CUSTOM_ATTRIBUTE);
                            }
                        }
                        if (AddEditCustomAttributeDialog.this.fType == null) {
                            return new Status(severity, "com.ibm.team.workitem.ide.ui", Messages.CustomAttributesPart_NO_TYPE);
                        }
                    } else if (AddEditCustomAttributeDialog.this.fReused == null) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.CustomAttributesPart_SELECT_EXISTING_ATTRIBUTE);
                    }
                    return Status.OK_STATUS;
                }
            });
        }

        public String getName() {
            if (this.fIsReused) {
                return this.fReused.getName();
            }
            return this.fName.trim();
        }

        public String getId() {
            if (this.fIsReused) {
                return this.fReused.getId();
            }
            return this.fId.trim();
        }

        public String getType() {
            if (this.fIsReused) {
                return this.fReused.getAttributeType();
            }
            return this.fType;
        }

        @Override
        protected void createUpperDialogPart(Composite parent) {
            Composite comp = parent;
            if (this.fId == null && !this.fOtherAttributes.isEmpty()) {
                Button radio = new Button(parent, 16);
                radio.setText(Messages.CustomAttributesPart_NEW_ATTRIBUTE);
                radio.setSelection(true);
                radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Control c;
                        AddEditCustomAttributeDialog.this.fIsReused = false;
                        AddEditCustomAttributeDialog.this.fNew.setEnabled(true);
                        Control[] controlArray = AddEditCustomAttributeDialog.this.fNew.getChildren();
                        int n = controlArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            c = controlArray[n2];
                            c.setEnabled(true);
                            ++n2;
                        }
                        AddEditCustomAttributeDialog.this.fReuse.setEnabled(false);
                        controlArray = AddEditCustomAttributeDialog.this.fReuse.getChildren();
                        n = controlArray.length;
                        n2 = 0;
                        while (n2 < n) {
                            c = controlArray[n2];
                            c.setEnabled(false);
                            ++n2;
                        }
                        AddEditCustomAttributeDialog.this.fReuseCombo.getCombo().setEnabled(false);
                        AddEditCustomAttributeDialog.this.validate();
                    }
                });
                this.fNew = new Group(parent, 0);
                this.fNew.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
                GridLayout layout = new GridLayout(2, false);
                this.fNew.setLayout((Layout)layout);
                comp = this.fNew;
            }
            Label l = new Label(comp, 0);
            l.setText(Messages.CustomAttributesPart_NAME);
            l.setLayoutData((Object)new GridData());
            this.fNameField = new Text(comp, 2048);
            if (this.fName != null) {
                this.fNameField.setText(this.fName);
            }
            this.fNameField.setLayoutData((Object)new GridData(4, 4, true, false));
            this.fNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddEditCustomAttributeDialog.this.fName = AddEditCustomAttributeDialog.this.fNameField.getText().trim();
                    AddEditCustomAttributeDialog.this.validate();
                }
            });
            if (this.fEditable && this.fOldId == null) {
                this.fNameField.addModifyListener(this.fProposeIdListener);
            }
            l = new Label(comp, 0);
            l.setText(Messages.CustomAttributesPart_ID);
            l.setLayoutData((Object)new GridData());
            this.fIdField = new Text(comp, 2048);
            if (this.fId != null) {
                this.fIdField.setText(this.fId);
            }
            this.fIdField.setLayoutData((Object)new GridData(4, 4, true, false));
            this.fIdField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddEditCustomAttributeDialog.this.fId = AddEditCustomAttributeDialog.this.fIdField.getText().trim();
                    AddEditCustomAttributeDialog.this.validate();
                }
            });
            if (this.fEditable) {
                this.fIdField.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusGained(FocusEvent e) {
                        AddEditCustomAttributeDialog.this.fNameField.removeModifyListener(AddEditCustomAttributeDialog.this.fProposeIdListener);
                    }
                });
            }
            if (!this.fEditable) {
                this.fIdField.setEditable(false);
                this.fIdField.setEnabled(false);
            }
            l = new Label(comp, 0);
            l.setText(Messages.CustomAttributesPart_TYPE);
            l.setLayoutData((Object)new GridData());
            this.fCombo = new DecoratedCombo(comp, 8, 4);
            AspectEditorUtil.adaptCombo(this.fCombo.getCombo());
            this.fCombo.getLayoutControl().setLayoutData((Object)new GridData(4, 4, true, false));
            this.fCombo.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    return AttributeTypes.getDisplayName(null, (String)((String)element));
                }
            });
            this.fCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object value = AddEditCustomAttributeDialog.this.fCombo.getValue();
                    if (NO_TYPE.equals(value)) {
                        AddEditCustomAttributeDialog.this.fType = null;
                    } else {
                        AddEditCustomAttributeDialog.this.fType = (String)value;
                    }
                    AddEditCustomAttributeDialog.this.validate();
                }
            });
            this.fCombo.setValueSet(this.fTypes.toArray());
            if (this.fType == null) {
                this.fCombo.setValue((Object)NO_TYPE);
            } else {
                this.fCombo.setValue((Object)this.fType);
            }
            if (!this.fEditable) {
                this.fCombo.getCombo().setEnabled(false);
            }
            if (this.fId == null && !this.fOtherAttributes.isEmpty()) {
                Label filler = new Label(parent, 0);
                filler.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
                Button radio = new Button(parent, 16);
                radio.setText(Messages.CustomAttributesPart_REUSE_ATTRIBUTE);
                radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Control c;
                        AddEditCustomAttributeDialog.this.fIsReused = true;
                        AddEditCustomAttributeDialog.this.fNew.setEnabled(false);
                        Control[] controlArray = AddEditCustomAttributeDialog.this.fNew.getChildren();
                        int n = controlArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            c = controlArray[n2];
                            c.setEnabled(false);
                            ++n2;
                        }
                        AddEditCustomAttributeDialog.this.fReuse.setEnabled(true);
                        controlArray = AddEditCustomAttributeDialog.this.fReuse.getChildren();
                        n = controlArray.length;
                        n2 = 0;
                        while (n2 < n) {
                            c = controlArray[n2];
                            c.setEnabled(true);
                            ++n2;
                        }
                        AddEditCustomAttributeDialog.this.fReuseCombo.getCombo().setEnabled(true);
                        AddEditCustomAttributeDialog.this.validate();
                    }
                });
                this.fReuse = new Group(parent, 0);
                this.fReuse.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
                GridLayout layout = new GridLayout(2, false);
                this.fReuse.setLayout((Layout)layout);
                l = new Label((Composite)this.fReuse, 0);
                l.setText(Messages.CustomAttributesPart_ATTRIBUTE);
                l.setLayoutData((Object)new GridData());
                l.setEnabled(false);
                this.fReuseCombo = new DecoratedCombo((Composite)this.fReuse, 8, 4);
                AspectEditorUtil.adaptCombo(this.fReuseCombo.getCombo());
                this.fReuseCombo.getLayoutControl().setLayoutData((Object)new GridData(4, 4, true, false));
                this.fReuseCombo.getLayoutControl().setEnabled(false);
                this.fReuseCombo.getCombo().setEnabled(false);
                this.fReuseCombo.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public String getText(Object o) {
                        if (o instanceof String) {
                            return (String)o;
                        }
                        if (o instanceof TypeCategory.CustomAttribute) {
                            TypeCategory.CustomAttribute a = (TypeCategory.CustomAttribute)o;
                            return NLS.bind((String)Messages.CustomAttributesPart_CUSTOM_ATT_LABEL, (Object)a.getName(), (Object[])new Object[]{AttributeTypes.getDisplayName(null, (String)a.getAttributeType())});
                        }
                        return null;
                    }
                });
                this.fReuseCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        Object attribute = AddEditCustomAttributeDialog.this.fReuseCombo.getValue();
                        if (NONE.equals(attribute)) {
                            AddEditCustomAttributeDialog.this.fReused = null;
                        } else {
                            AddEditCustomAttributeDialog.this.fReused = (TypeCategory.CustomAttribute)attribute;
                        }
                        AddEditCustomAttributeDialog.this.validate();
                    }
                });
                Object[] valueSet = new Object[this.fOtherAttributes.size() + 1];
                ArrayList<TypeCategory.CustomAttribute> attrs = new ArrayList<TypeCategory.CustomAttribute>(this.fOtherAttributes);
                Collections.sort(attrs, new Comparator<TypeCategory.CustomAttribute>(){

                    @Override
                    public int compare(TypeCategory.CustomAttribute o1, TypeCategory.CustomAttribute o2) {
                        return Collator.getInstance().compare(o1.getName(), o2.getName());
                    }
                });
                valueSet[0] = NONE;
                int i = 0;
                while (i < attrs.size()) {
                    valueSet[i + 1] = attrs.get(i);
                    ++i;
                }
                this.fReuseCombo.setValueSet(valueSet);
                this.fReuseCombo.setValue((Object)NONE);
            }
        }

        @Override
        protected void createIconDialogPart(Composite parent) {
        }
    }
}

