/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.templates;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.foundation.common.util.XMLMemento;
import com.ibm.team.process.client.workingcopies.IProcessAttachmentsWorkingCopy;
import com.ibm.team.process.client.workingcopies.IProcessContainerWorkingCopy;
import com.ibm.team.process.common.IProcessAttachment;
import com.ibm.team.process.common.IProcessAttachmentHandle;
import com.ibm.team.process.common.IProcessItemHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.repository.client.IContentManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.template.ITemplateAttributeIdentifiers;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.templates.SharedTemplate;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedTemplateManager {
    public static final String WORKITEM_TEMPLATES_STORAGE_PATH = "/workitemtemplates/";
    private final ProcessAspect fAspect;
    private final String fProcessAspectId;
    private final List<IChangeListener> fListeners;
    private LinkedHashMap<String, SharedTemplate> fTemplates;

    public SharedTemplateManager(ProcessAspect aspect, String processAspectId) {
        Assert.isNotNull((Object)aspect);
        Assert.isNotNull((Object)processAspectId);
        this.fAspect = aspect;
        this.fProcessAspectId = processAspectId;
        this.fListeners = new LinkedList<IChangeListener>();
    }

    public List<SharedTemplate> getTemplates() {
        if (this.fTemplates == null) {
            this.fTemplates = this.readFromAspect();
        }
        return new ArrayList<SharedTemplate>(this.fTemplates.values());
    }

    public void applyChanges(Set<String> changedTemplates) {
        this.updateAspect();
        this.updateAttachments(changedTemplates);
        this.notifyDirtyStateChanged(false);
    }

    private void updateAttachments(final Set<String> changedTemplates) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IProcessContainerWorkingCopy container = SharedTemplateManager.this.fAspect.getProcessContainerWorkingCopy();
                    IProcessAttachmentsWorkingCopy processAttachments = container.getProcessAttachments();
                    if (processAttachments != null) {
                        HashSet<String> templates = new HashSet<String>();
                        for (SharedTemplate cur : SharedTemplateManager.this.fTemplates.values()) {
                            String curId = cur.getIdentifier();
                            if (curId.length() <= 0) continue;
                            templates.add(curId);
                        }
                        IProcessAttachmentHandle[] attachments = processAttachments.getAttachments();
                        try {
                            if (attachments != null) {
                                IProcessAttachmentHandle[] iProcessAttachmentHandleArray = attachments;
                                int n = attachments.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String curTmplId;
                                    IProcessAttachmentHandle curAttmnt = iProcessAttachmentHandleArray[n2];
                                    String curPath = ((IProcessAttachment)curAttmnt.getFullState()).getPath();
                                    if (curPath != null && curPath.startsWith(SharedTemplateManager.WORKITEM_TEMPLATES_STORAGE_PATH) && (curTmplId = curPath.substring(SharedTemplateManager.WORKITEM_TEMPLATES_STORAGE_PATH.length(), curPath.length() - 4)) != null) {
                                        if (!templates.contains(curTmplId)) {
                                            processAttachments.deleteAttachment(curAttmnt);
                                        } else if (changedTemplates.contains(curTmplId)) {
                                            SharedTemplateManager.this.updateTemplateInAttachment(curTmplId, curAttmnt, curPath, processAttachments, monitor);
                                        }
                                    }
                                    ++n2;
                                }
                            }
                            container.save(monitor);
                        }
                        catch (TeamRepositoryException ex) {
                            throw new InvocationTargetException(ex);
                        }
                    }
                }
            });
        }
        catch (InvocationTargetException ex) {
            WorkItemIDEUIPlugin.getDefault().log(ex.getMessage(), ex);
        }
        catch (InterruptedException ex) {
            WorkItemIDEUIPlugin.getDefault().log(ex.getMessage(), ex);
        }
    }

    private void updateTemplateInAttachment(String templateId, IProcessAttachmentHandle attachment, String attachmentPath, IProcessAttachmentsWorkingCopy processAttachments, IProgressMonitor monitor) throws TeamRepositoryException, InvocationTargetException {
        IContent curCont = processAttachments.getContent(attachment);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ITeamRepository repo = (ITeamRepository)attachment.getOrigin();
        IContentManager contentManager = repo.contentManager();
        contentManager.retrieveContent(curCont, (OutputStream)outStream, monitor);
        try {
            String updatedXML = this.updateTemplateContent(this.fTemplates.get(templateId), outStream.toString());
            File localFile = File.createTempFile("updatedTemplateTemporaryFile", ".xml");
            FileWriter writer = new FileWriter(localFile);
            try {
                writer.write(updatedXML);
            }
            finally {
                writer.close();
            }
            processAttachments.updateAttachmentProperties(attachment, attachmentPath, localFile);
        }
        catch (IOException ex) {
            throw new InvocationTargetException(ex);
        }
        catch (CoreException ex) {
            throw new InvocationTargetException(ex);
        }
    }

    private String updateTemplateContent(SharedTemplate template, String templateContent) throws IOException, CoreException {
        XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(templateContent));
        IMemento[] children = memento.getChildren();
        if (children != null) {
            IMemento[] iMementoArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento cur = iMementoArray[n2];
                if (cur.getType().endsWith(ITemplateAttributeIdentifiers.NAME.getStringIdentifier())) {
                    cur.putTextData(template.getName());
                } else if (cur.getType().endsWith(ITemplateAttributeIdentifiers.DESCRIPTION.getStringIdentifier())) {
                    cur.putTextData(template.getDescription());
                }
                ++n2;
            }
        }
        return memento.asXMLString();
    }

    public void revertChanges() {
        this.fTemplates = this.readFromAspect();
        this.notifyStructureChanged();
        this.notifyDirtyStateChanged(false);
    }

    private LinkedHashMap<String, SharedTemplate> readFromAspect() {
        LinkedHashMap<String, SharedTemplate> templates = new LinkedHashMap<String, SharedTemplate>();
        ModelElement templateRoot = this.fAspect.getConfigurationElement();
        if (templateRoot != null) {
            for (Object cur : templateRoot.getChildElements()) {
                ModelElement curElem = (ModelElement)cur;
                if (!curElem.getName().equals("template")) continue;
                String name = curElem.getAttribute("name");
                String id = curElem.getAttribute("identifier");
                String description = curElem.getAttribute("description");
                String path = curElem.getAttribute("content");
                templates.put(id, new SharedTemplate(id, name, description, path, this.getProjectArea()));
            }
        }
        return templates;
    }

    public void addTemplates(List<SharedTemplate> templates) {
        if (templates != null) {
            for (SharedTemplate cur : templates) {
                this.fTemplates.put(cur.getIdentifier(), cur);
            }
        }
        this.notifyStructureChanged();
    }

    public void removeTemplates(List<SharedTemplate> templates) {
        if (templates != null) {
            for (SharedTemplate cur : templates) {
                this.fTemplates.remove(cur.getIdentifier());
            }
            this.notifyStructureChanged();
        }
    }

    private void updateAspect() {
        StringWriter writer = new StringWriter(4096);
        String startElement = String.format("<%s id=\"%s\" xmlns=\"%s\">\n", this.fAspect.getXmlTag(), this.fProcessAspectId, this.fAspect.getSchemaNamespaceURI());
        writer.append(startElement);
        for (SharedTemplate cur : this.fTemplates.values()) {
            XMLMemento memento = XMLMemento.createWriteRoot((String)"template");
            memento.putString("identifier", cur.getIdentifier());
            memento.putString("name", cur.getName());
            memento.putString("description", cur.getDescription());
            memento.putString("content", cur.getPath());
            try {
                String xml = memento.asXMLString();
                xml = "\n" + xml.substring(xml.indexOf("<template"));
                writer.append(xml);
                writer.append("\n");
            }
            catch (IOException ex) {
                WorkItemIDEUIPlugin.getDefault().log(ex.getMessage(), ex);
            }
        }
        writer.append("</configuration-data>\n");
        this.fAspect.update(writer.toString(), true);
    }

    public IProcessItemHandle getProcessItem() {
        return (IProcessItemHandle)this.fAspect.getProcessContainerWorkingCopy().getUnderlyingProcessItem().getItemHandle();
    }

    private IProjectAreaHandle getProjectArea() {
        IProcessItemHandle processItemHandle = this.getProcessItem();
        if (processItemHandle instanceof IProjectAreaHandle) {
            return (IProjectAreaHandle)processItemHandle;
        }
        return null;
    }

    public void addListener(IChangeListener listener) {
        if (!this.fListeners.contains(listener)) {
            this.fListeners.add(listener);
        }
    }

    public void removeListener(IChangeListener listener) {
        this.fListeners.remove(listener);
    }

    private void notifyStructureChanged() {
        for (IChangeListener listener : this.fListeners) {
            listener.templateStructureChanged();
            listener.dirtyStateChanged(true);
        }
    }

    public void notifyChanged(SharedTemplate template, String[] properties) {
        for (IChangeListener listener : this.fListeners) {
            listener.templateChanged(template, properties);
        }
    }

    private void notifyDirtyStateChanged(boolean dirty) {
        for (IChangeListener listener : this.fListeners) {
            listener.dirtyStateChanged(dirty);
        }
    }

    public static interface IChangeListener {
        public void templateChanged(SharedTemplate var1, String[] var2);

        public void templateStructureChanged();

        public void dirtyStateChanged(boolean var1);
    }
}

