/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.templates;

import com.ibm.team.workitem.ide.ui.internal.aspecteditor.templates.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.templates.SharedTemplate;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.templates.SharedTemplateManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SharedTemplateDetailsSection
implements ISelectionChangedListener {
    private SharedTemplate fCurrentTemplate;
    private Text fNameText;
    private Text fDescriptionText;
    private Text fIdentifierText;
    private final SharedTemplateManager.IChangeListener fChangeListener;

    public SharedTemplateDetailsSection(SharedTemplateManager.IChangeListener changeListener) {
        this.fChangeListener = changeListener;
    }

    public void createContent(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 3, 0).applyTo(parent);
        toolkit.createLabel(parent, Messages.SharedTemplateDetailsSection_NAME_LABEL);
        this.fNameText = toolkit.createText(parent, "", 2048);
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                SharedTemplateDetailsSection.this.modelUpdateName();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fNameText);
        toolkit.createLabel(parent, Messages.SharedTemplateDetailsSection_IDENTIFIER_LABEL);
        this.fIdentifierText = toolkit.createText(parent, "", 2048);
        this.fIdentifierText.setEditable(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fIdentifierText);
        toolkit.createLabel(parent, Messages.SharedTemplateDetailsSection_DESCRIPTION_LABEL);
        this.fDescriptionText = toolkit.createText(parent, "", 2114);
        this.fDescriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                SharedTemplateDetailsSection.this.modelUpdateDescription();
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fDescriptionText);
        this.update();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object selected;
        this.fCurrentTemplate = null;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (!selection.isEmpty() && (selected = selection.getFirstElement()) instanceof SharedTemplate) {
            this.fCurrentTemplate = (SharedTemplate)selected;
        }
        this.update();
    }

    private void update() {
        if (this.fCurrentTemplate != null) {
            this.updateText(this.fNameText, this.fCurrentTemplate.getName(), true);
            this.updateText(this.fDescriptionText, this.fCurrentTemplate.getDescription(), true);
            this.updateText(this.fIdentifierText, this.fCurrentTemplate.getIdentifier(), true);
        } else {
            this.updateText(this.fNameText, "", false);
            this.updateText(this.fDescriptionText, "", false);
            this.updateText(this.fIdentifierText, "", false);
        }
    }

    private void updateText(Text text, String value, boolean enabled) {
        text.setText(value != null ? value : "");
        text.setEnabled(enabled);
    }

    private void modelUpdateName() {
        if (this.fCurrentTemplate != null && this.fNameText.getText() != null && this.isNotEqual(this.fCurrentTemplate.getName(), this.fNameText.getText()) && this.fNameText.getText().trim().length() > 0) {
            this.fCurrentTemplate.setName(this.fNameText.getText().trim());
            this.fChangeListener.templateChanged(this.fCurrentTemplate, null);
        }
    }

    private void modelUpdateDescription() {
        if (this.fCurrentTemplate != null && this.fDescriptionText.getText() != null && this.isNotEqual(this.fCurrentTemplate.getDescription(), this.fDescriptionText.getText())) {
            this.fCurrentTemplate.setDescription(this.fDescriptionText.getText().trim());
            this.fChangeListener.templateChanged(this.fCurrentTemplate, null);
        }
    }

    private boolean isNotEqual(String str1, String str2) {
        if (str1 == null || str2 == null) {
            return str1 != str2;
        }
        return !str1.equals(str2);
    }
}

